/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.utils.QueryByPage;
import cms.tmx.utils.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PositionApi
extends CallApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private MEventService es;
    @Inject
    protected MObjFactory of;
    @Inject
    protected PositionFactory fPosition;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    private static final Logger logger = LogManager.getLogger(PositionApi.class);

    public Set<Position> queryPositions(MEvent event) throws MException {
        Set<Position> setPosition = Collections.synchronizedSet(new HashSet());
        String portfolioId = event.getStr("portfolio_id");
        if (StringUtils.isEmpty((String)portfolioId)) {
            QueryByPage query = (QueryByPage)this.of.create(QueryByPage.class);
            query.queryByPage(page -> {
                this.queryPositionsInTurn((IPageInTurn<String, String, PPositionService.ExtPosition>)page, event);
                this.transferPosition(setPosition, (IPageInTurn<String, String, PPositionService.ExtPosition>)page);
            });
        } else {
            QueryByPage query = (QueryByPage)this.of.create(QueryByPage.class);
            query.queryByPage(page -> {
                this.querySubPositionsInTurn((IPageInTurn<String, String, PPositionService.SubPosition>)page, event);
                this.transferSubPosition(setPosition, (IPageInTurn<String, String, PPositionService.SubPosition>)page);
            });
        }
        return setPosition;
    }

    private void queryPositionsInTurn(IPageInTurn<String, String, PPositionService.ExtPosition> page, MEvent e) {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        try {
            MEvent event = new MEvent();
            e.getStr("file.manipulate.record.uuid");
            String investorId = e.getStr("fund_acct");
            ConvertUtils.getMarket(e.getStr("market_code"));
            e.getStr("holder_acc_no");
            int pageSize = e.getInt("query_count") > 150 ? 150 : e.getInt("query_count");
            pageSize = 150;
            PPositionService.GetExtPositionsReq.Builder builder = PPositionService.GetExtPositionsReq.newBuilder();
            builder.setOpUser(this.baseApi.getOpUser());
            builder.setMarketGrp("CCS");
            PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
            builder.setSettingType(set);
            CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
            if (fundAcc == null) {
                MEvent event1 = new MEvent();
                event1.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event1);
                e.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                return;
            }
            builder.setExtAccntId(fundAcc.getExtAccntId());
            page.setPageSize(pageSize);
            PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
            pageBuilder.setPageSize(page.getPageSize());
            pageBuilder.setStartRow(page.getStartRow());
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action((IServiceDefine)this.queryService, "256", event);
            PPositionService.GetExtPositionsResp resp = (PPositionService.GetExtPositionsResp)event.getObj(PPositionService.GetExtPositionsResp.class);
            this.checkStatus(resp.getStatus());
            page.getResList().addAll(resp.getPositionList());
            page.setTotalRow(resp.getPage().getTotalRow());
            e.setCode(resp.getStatus().getStatus());
            e.setDesc(resp.getStatus().getReason());
        }
        catch (MException e1) {
            logger.error("630004\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
    }

    private void transferPosition(Set<Position> setPosition, IPageInTurn<String, String, PPositionService.ExtPosition> page) {
        for (PPositionService.ExtPosition pPosition : page.getResList()) {
            Position position = this.fPosition.create(pPosition);
            if (position == null) continue;
            setPosition.add(position);
        }
    }

    public void querySubPositionsInTurn(IPageInTurn<String, String, PPositionService.SubPosition> page, MEvent e) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        try {
            MEvent event = new MEvent();
            String portfolioId = e.getStr("portfolio_id");
            String investorId = e.getStr("fund_acct");
            int pageSize = e.getInt("query_count") > 150 ? 150 : e.getInt("query_count");
            pageSize = 150;
            PPositionService.GetSubPositionsReq.Builder builder = PPositionService.GetSubPositionsReq.newBuilder();
            CcsSubFundAccount subAccount = null;
            if (this.portfolioModel.getMap(portfolioId) != null) {
                Set keySet = this.portfolioModel.getMap(portfolioId).keySet();
                for (CcsFundAccount sub : keySet) {
                    CcsSubFundAccount subFund = (CcsSubFundAccount)sub;
                    if (!investorId.equals(subFund.getInvestId()) || !portfolioId.equals(subFund.getPortfolioId())) continue;
                    subAccount = subFund;
                    break;
                }
            }
            if (subAccount == null) {
                MEvent event2 = new MEvent();
                event2.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                this.es.postEvent("message.log", event2);
                e.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                return;
            }
            builder.setSubAccntId(subAccount.getSubAccntId());
            builder.setOpUser(this.baseApi.getOpUser());
            builder.setMarketGrp("CCS");
            page.setPageSize(pageSize);
            builder.setPage(this.buildPage(page));
            PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
            builder.setSettingType(set);
            event.setObj((Object)builder.build());
            this.action((IServiceDefine)this.queryService, "257", event);
            PPositionService.GetSubPositionsResp resp = (PPositionService.GetSubPositionsResp)event.getObj(PPositionService.GetSubPositionsResp.class);
            page.setTotalRow(resp.getPage().getTotalRow());
            page.getResList().addAll(resp.getPositionList());
            e.setCode(resp.getStatus().getStatus());
            e.setDesc(resp.getStatus().getReason());
        }
        catch (MException e1) {
            logger.error("630004\u6301\u4ed3\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
    }

    private void transferSubPosition(Set<Position> setPosition, IPageInTurn<String, String, PPositionService.SubPosition> page) {
        for (PPositionService.SubPosition pSubPosition : page.getResList()) {
            CcsPortfPosition position = this.fPosition.create(pSubPosition);
            if (position == null) continue;
            setPosition.add((Position)position);
        }
    }
}

