/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OrderApi
extends CallApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private MEventService es;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    private static final Logger logger = LogManager.getLogger(OrderApi.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<POrderService.SingleOrder> queryOrders(MEvent e) {
        LinkedList<POrderService.SingleOrder> orderList = new LinkedList<POrderService.SingleOrder>();
        try {
            MEvent event = new MEvent();
            e.getStr("file.manipulate.record.uuid");
            String investorId = e.getStr("fund_acct");
            String market = ConvertUtils.getMarket(e.getStr("market_code"));
            String investorSecId = e.getStr("holder_acc_no");
            int pageSize = e.getInt("query_count") > 150 ? 150 : e.getInt("query_count");
            pageSize = pageSize == 0 ? 150 : pageSize;
            int withdrawFlag = e.getInt("withdraw_flag");
            String portfolioId = e.getStr("portfolio_id");
            POrderService.GetSingleOrdersReq.Builder builder = POrderService.GetSingleOrdersReq.newBuilder();
            builder.setOpUser(this.baseApi.getOpUser());
            builder.setMarketGrp("CCS");
            builder.setEndOrdStatus(withdrawFlag);
            PCcsExtra.CcsSingleOrdersReq.Builder extra = PCcsExtra.CcsSingleOrdersReq.newBuilder();
            if (StringUtils.isEmpty((String)portfolioId)) {
                CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc == null) {
                    MEvent event1 = new MEvent();
                    event1.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                    this.es.postEvent("message.log", event1);
                    e.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                    return orderList;
                }
                extra.setExtAccntId(fundAcc.getExtAccntId());
            } else {
                CcsSubFundAccount subAccount = null;
                if (this.portfolioModel.getMap(portfolioId) != null) {
                    Set keySet = this.portfolioModel.getMap(portfolioId).keySet();
                    for (CcsFundAccount sub : keySet) {
                        CcsSubFundAccount subFund = (CcsSubFundAccount)sub;
                        if (!investorId.equals(subFund.getInvestId()) || !portfolioId.equals(subFund.getPortfolioId())) continue;
                        subAccount = subFund;
                        break;
                    }
                }
                if (subAccount == null) {
                    MEvent event2 = new MEvent();
                    event2.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                    this.es.postEvent("message.log", event2);
                    e.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                    return orderList;
                }
                extra.setExtAccntId(subAccount.getExtAccntId());
                extra.setSubAccntId(subAccount.getSubAccntId());
            }
            SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
            if (secAcc != null) {
                builder.setExtSecAccntId(secAcc.getExtSecAccntId());
            } else if (secAcc == null && !StringUtils.isEmpty((String)investorSecId)) {
                MEvent event1 = new MEvent();
                event1.setDesc("\u80a1\u4e1c\u53f7:" + investorSecId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event1);
                e.setDesc("\u80a1\u4e1c\u53f7:" + investorSecId + " \u65e0\u6743\u9650");
                return orderList;
            }
            PCcsExtra.CcsSingleOrdersReq message = extra.build();
            builder.setObject(Any.pack((Message)message));
            PBase.Page.Builder pageBuilder = this.baseApi.getDefPage().toBuilder();
            pageBuilder.setPageSize(pageSize);
            boolean flag = false;
            do {
                builder.setPage(pageBuilder.build());
                event.setObj((Object)builder.build());
                this.action((IServiceDefine)this.queryService, "265", event);
                POrderService.GetSingleOrdersResp resp = (POrderService.GetSingleOrdersResp)event.getObj(POrderService.GetSingleOrdersResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getOrderList().isEmpty()) {
                    e.setCode(resp.getStatus().getStatus());
                    e.setDesc(resp.getStatus().getReason());
                    return orderList;
                }
                orderList.addAll(resp.getOrderList());
                boolean bl = flag = resp.getPage().getTotalRow() > pageBuilder.getStartRow() + resp.getPage().getPageSize() - 1;
                if (flag) {
                    pageBuilder.setStartRow(pageBuilder.getStartRow() + resp.getPage().getPageSize());
                }
                e.setCode(resp.getStatus().getStatus());
                e.setDesc(resp.getStatus().getReason());
            } while (flag);
            return orderList;
        }
        catch (MException e1) {
            logger.error("630005\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
        return orderList;
    }
}

