/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.query.current.models.MarginAccountMap;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginTransferApi {
    @Inject
    private MEventService es;
    @Inject
    private TradeServiceApi api;
    @Inject
    private MarginAccountMap map;
    @Inject
    private HttpBaseApi base;
    @Inject
    protected IRefDataMng refMng;
    private static final Logger logger = LogManager.getLogger(MarginTransferApi.class);
    private Map<String, RefItem> refMap = new HashMap<String, RefItem>();
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> {
        if (now.booleanValue()) {
            Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
            items.forEach(item -> this.refMap.put(String.valueOf(item.getCode()) + item.getMarket(), (RefItem)item));
        }
    };

    @PostConstruct
    private void init() {
        if (!this.refMng.doneProperty().get()) {
            this.refMng.doneProperty().addListener(this.refListener);
        } else {
            Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
            items.forEach(item -> this.refMap.put(String.valueOf(item.getCode()) + item.getMarket(), (RefItem)item));
        }
    }

    public void MarginTransfer(MEvent event) throws MException {
        String code = event.getStr("market_indicator");
        if (MarketIndicator.getValue((String)code).isEmpty()) {
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)"\u672a\u77e5\u7684\u4e1a\u52a1\u6807\u8bc6");
            event.put((Object)"invest_id", (Object)"");
            event.put((Object)"topic", (Object)"response_margin_transfer");
        }
        if (MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getCode().equals(code)) {
            this.MarginVoucherPayOff(event);
        } else if (MarketIndicator.KCREDIT_CASH_PAYOFF.getCode().equals(code)) {
            this.MarginCashPayOff(event);
        }
    }

    private void MarginCashPayOff(MEvent event) throws MException {
        String uuid = event.getStr("file.manipulate.record.uuid");
        long startTime = event.getLong("file.manipulate.record.start.time");
        String investorId = event.getStr("fund_acct");
        String cashAccountId = "";
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            MEvent e = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", e);
            return;
        }
        cashAccountId = fundAcc.getNewCashAccntId();
        Instrument inst = new Instrument();
        inst.setMarketIndicator(MarketIndicator.KCREDIT_CASH_PAYOFF.getValue());
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        NewOrderSingle req = new NewOrderSingle();
        req.setOpUser(this.base.getHttpOpUser());
        req.setInstrument(inst);
        String clientSeq = event.getStr("client_seq");
        double amount = event.getDouble("amount");
        clientSeq = "file|" + investorId + "|" + clientSeq;
        req.setClOrdId(clientSeq);
        req.setOrderAmount(amount);
        req.setExtCashAccntId(cashAccountId);
        req.setTradePlatformId(fundAcc.getCounterId());
        try {
            logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u76f4\u63a5\u9084\u6b3e  \u4ece\u5f00\u59cb\u89e3\u6790\u5230\u8abf\u7528\u63a5\u53e3\u8017\u6642\uff1a " + (System.currentTimeMillis() - startTime));
            OpStatus status = this.api.newOrderSingle(req);
            event.put((Object)"trans_seq", (Object)status.getData());
            logger.info("[" + uuid + "]" + "\u7d50\u675f\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u76f4\u63a5\u9084\u6b3e: " + event.entrySet());
        }
        catch (MException e2) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)String.valueOf(e2.getCode()));
            event.put((Object)"erroe_msg", (Object)e2.getMessage());
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            return;
        }
        event.put((Object)"error_code", (Object)"1");
        event.put((Object)"erroe_msg", (Object)"\u76f4\u63a5\u8fd8\u6b3e\u8bf7\u6c42\u6210\u529f");
        event.put((Object)"invest_id", (Object)investorId);
        event.put((Object)"topic", (Object)"response_margin_transfer");
        event.setOK();
    }

    private void MarginVoucherPayOff(MEvent event) throws MException {
        String uuid = event.getStr("file.manipulate.record.uuid");
        long startTime = event.getLong("file.manipulate.record.start.time");
        String investorId = event.getStr("fund_acct");
        String cashAccountId = "";
        String investorsecId = event.getStr("holder_acc_no");
        String secAccntId = "";
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            MEvent e = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", e);
            return;
        }
        cashAccountId = fundAcc.getNewCashAccntId();
        SecAccount secAccount = this.map.getSecAcc(investorsecId);
        if (secAccount == null) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u8b49\u5238\u8d26\u6237:" + investorsecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            MEvent e = new MEvent();
            event.setDesc("\u8b49\u5238\u8d26\u6237:" + investorsecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", e);
            return;
        }
        secAccntId = secAccount.getExtSecAccntId();
        String market = ConvertUtils.getMarket(event.getStr("market_code"));
        String secCode = event.getStr("sec_code");
        RefItem item = this.refMap.get(String.valueOf(secCode) + market);
        if (item == null) {
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("securityId:" + secCode + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5"));
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            return;
        }
        Instrument inst = new Instrument();
        inst.setSecurityId(secCode);
        inst.setMarket(market);
        inst.setMarketIndicator(MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue());
        if (item != null) {
            inst.setSymbol(item.getName());
            inst.setSecurityType(item.getType());
        }
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        NewOrderSingle req = new NewOrderSingle();
        req.setOpUser(this.base.getHttpOpUser());
        req.setInstrument(inst);
        String clientSeq = event.getStr("client_seq");
        double price = event.getDouble("price");
        int count = event.getInt("count");
        clientSeq = "file|" + investorId + "|" + clientSeq;
        req.setClOrdId(clientSeq);
        req.setOrderQty((double)count);
        req.setPrice(price);
        req.setExtCashAccntId(cashAccountId);
        req.setExtSecAccntId(secAccntId);
        req.setTradePlatformId(fundAcc.getCounterId());
        try {
            logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u73fe\u5238\u9084\u5238  \u4ece\u5f00\u59cb\u89e3\u6790\u5230\u8abf\u7528\u63a5\u53e3\u8017\u6642\uff1a " + (System.currentTimeMillis() - startTime));
            OpStatus status = this.api.newOrderSingle(req);
            event.put((Object)"trans_seq", (Object)status.getData());
            logger.info("[" + uuid + "]" + "\u7d50\u675f\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u73fe\u5238\u9084\u5238: " + event.entrySet());
        }
        catch (MException e2) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)String.valueOf(e2.getCode()));
            event.put((Object)"erroe_msg", (Object)e2.getMessage());
            event.put((Object)"invest_id", (Object)investorId);
            event.put((Object)"topic", (Object)"response_margin_transfer");
            return;
        }
        event.put((Object)"error_code", (Object)"1");
        event.put((Object)"erroe_msg", (Object)"\u73b0\u5238\u8fd8\u5238\u8bf7\u6c42\u6210\u529f");
        event.put((Object)"invest_id", (Object)investorId);
        event.put((Object)"topic", (Object)"response_margin_transfer");
        event.setOK();
    }

    public void CancelMarginVoucherPayOff(MEvent event) throws MException {
        String uuid = event.getStr("file.manipulate.record.uuid");
        long startTime = event.getLong("file.manipulate.record.start.time");
        String transSeq = event.getStr("trans_seq");
        String investorId = event.getStr("fund_acct");
        String cashAccountId = "";
        String investorsecId = event.getStr("holder_acc_no");
        String secAccntId = "";
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            event.put((Object)"topic", (Object)"response_margin_transfer_cancel");
            MEvent e = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", e);
            return;
        }
        cashAccountId = fundAcc.getNewCashAccntId();
        SecAccount secAccount = this.map.getSecAcc(investorsecId);
        if (secAccount == null) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u8bc1\u5238\u8d26\u6237:" + investorsecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            event.put((Object)"topic", (Object)"response_margin_transfer_cancel");
            MEvent e = new MEvent();
            event.setDesc("\u8bc1\u5238\u8d26\u6237:" + investorsecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", e);
            return;
        }
        secAccntId = secAccount.getExtSecAccntId();
        OrderCancelRequest req = new OrderCancelRequest();
        req.setOpUser(this.base.getHttpOpUser());
        Instrument inst = new Instrument();
        inst.setMarketIndicator(MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue());
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        req.setInstrument(inst);
        String clientSeq = event.getStr("client_seq");
        clientSeq = "file|" + investorId + "|" + clientSeq;
        req.setOrigClOrdId(clientSeq);
        req.setClOrdId(clientSeq);
        req.setOrderId(transSeq);
        req.setExtCashAccntId(cashAccountId);
        req.setExtSecAccntId(secAccntId);
        req.setTradePlatformId(fundAcc.getCounterId());
        try {
            logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u76f4\u63a5\u8fd8\u5238\u64a4\u5355  \u4ece\u5f00\u59cb\u89e3\u6790\u5230\u8abf\u7528\u63a5\u53e3\u8017\u6642\uff1a " + (System.currentTimeMillis() - startTime));
            this.api.orderCancel(req);
            logger.info("[" + uuid + "]" + "\u7d50\u675f\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u76f4\u63a5\u8fd8\u5238\u64a4\u5355: " + event.entrySet());
        }
        catch (MException e2) {
            event.setCode(-1);
            event.put((Object)"error_code", (Object)String.valueOf(e2.getCode()));
            event.put((Object)"erroe_msg", (Object)e2.getMessage());
            event.put((Object)"topic", (Object)"response_margin_transfer_cancel");
            return;
        }
        event.put((Object)"error_code", (Object)"1");
        event.put((Object)"erroe_msg", (Object)"\u73b0\u5238\u8fd8\u5238\u64a4\u5355\u8bf7\u6c42\u6210\u529f");
        event.put((Object)"topic", (Object)"response_margin_transfer_cancel");
        event.setOK();
    }
}

