/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginPositionApi
extends HttpService {
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MEventService es;
    private Gson gson = new Gson();
    private static final Logger logger = LogManager.getLogger(MarginPositionApi.class);

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/position/PositionService";
    }

    public List<Position> getExtPositionList(MEvent event) {
        LinkedList<Position> list = new LinkedList<Position>();
        LinkedList lists = new LinkedList();
        try {
            String investorSecId = event.getStr("holder_acc_no");
            int pageSize = event.getInt("query_count") > 150 ? 150 : event.getInt("query_count");
            pageSize = pageSize == 0 ? 150 : pageSize;
            GetPositionsReq req = new GetPositionsReq();
            req.setAccntType(AccntType.ACCNT_TYPE_SEC);
            req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
            Page httpDefPage = this.httpBase.getHttpDefPage();
            httpDefPage.setPageSize(pageSize);
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarketGroup("CCS");
            String extSecAccntId = this.accountMap.getExtSecAccntId(investorSecId);
            if (!StringUtils.isEmpty((String)extSecAccntId)) {
                req.setAccntId(Arrays.asList(extSecAccntId));
            } else if (!StringUtils.isEmpty((String)investorSecId) && StringUtils.isEmpty((String)extSecAccntId)) {
                MEvent event1 = new MEvent();
                event1.setDesc("\u80a1\u4e1c\u53f7:" + investorSecId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event1);
                event.setDesc("\u80a1\u4e1c\u53f7:" + investorSecId + " \u65e0\u6743\u9650");
                return list;
            }
            boolean flag = false;
            do {
                req.setPage(httpDefPage);
                String json = this.gson.toJson((Object)req);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6301\u4ed3\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
                String respBody = this.doPost("GetPositions", json);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6301\u4ed3\u67e5\u8be2\u54cd\u5e94\uff1a", (Object)respBody);
                GetExtPositionsResp resp = new GetExtPositionsResp();
                if (respBody == null) {
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                resp = (GetExtPositionsResp)this.gson.fromJson(respBody, GetExtPositionsResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getPositions() == null) {
                    event.setCode(resp.getStatus().getStatus());
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                lists.addAll(resp.getPositions());
                event.setCode(resp.getStatus().getStatus());
                event.setDesc(resp.getStatus().getReason());
                flag = resp.getPage().isLast();
                if (flag) continue;
                httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
            } while (!flag);
            for (Positions pos : lists) {
                List posStatistic = pos.getPosStatistic();
                Position position = new Position();
                position.setPosStatistic((PosStatistic)posStatistic.get(0));
                position.update((Object)pos);
                list.add(position);
            }
        }
        catch (MException e) {
            logger.error("630002\u67e5\u8be2\u878d\u8d44\u878d\u5238\u6301\u4ed3\u5931\u8d25\uff1a", (Throwable)e);
            event.setCode(e.getCode());
            event.setDesc(e.getDesc());
        }
        return list;
    }
}

