/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.query.GetExecutionsReq;
import cms.tmx.http.query.GetExecutionsResp;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginDealApi
extends HttpService {
    @Inject
    private MConfService cs;
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MEventService es;
    private Gson gson = new Gson();
    private static final Logger logger = LogManager.getLogger(MarginDealApi.class);

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/orderhub/OrderService";
    }

    public List<Execution> GetExecutionsList(MEvent event) {
        LinkedList<Execution> list = new LinkedList<Execution>();
        try {
            String investorId = event.getStr("fund_acct");
            event.getStr("holder_acc_no");
            int pageSize = event.getInt("query_count") > 150 ? 150 : event.getInt("query_count");
            pageSize = pageSize == 0 ? 150 : pageSize;
            GetExecutionsReq req = new GetExecutionsReq();
            Page httpDefPage = this.httpBase.getHttpDefPage();
            httpDefPage.setPageSize(pageSize);
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarketGrp("CCS");
            req.setApplId("750");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String date = LocalDate.now().format(formatter);
            req.setBeginDate(date);
            req.setEndDate(date);
            String extAccntId = this.fundMng.getNewCashAccntId(investorId);
            if (StringUtils.isEmpty((String)extAccntId)) {
                MEvent event1 = new MEvent();
                event1.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event1);
                event.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                return list;
            }
            req.setExtCashAccntId(Arrays.asList(extAccntId));
            boolean flag = false;
            do {
                req.setPage(httpDefPage);
                String json = this.gson.toJson((Object)req);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6210\u4ea4\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
                String respBody = this.doPost("GetExecutions", json);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6210\u4ea4\u67e5\u8be2\u54cd\u5e94\uff1a", (Object)respBody);
                GetExecutionsResp resp = new GetExecutionsResp();
                if (respBody == null) {
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                resp = (GetExecutionsResp)this.gson.fromJson(respBody, GetExecutionsResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getExecution() == null) {
                    event.setCode(resp.getStatus().getStatus());
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                list.addAll(resp.getExecution());
                event.setCode(resp.getStatus().getStatus());
                event.setDesc(resp.getStatus().getReason());
                boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
                if (!flag) continue;
                httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
            } while (flag);
        }
        catch (MException e) {
            logger.error("640006\u878d\u8d44\u878d\u5238\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
            event.setCode(e.getCode());
            event.setDesc(e.getDesc());
        }
        return list;
    }
}

