/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DealApi
extends CallApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private MEventService es;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    private static final Logger logger = LogManager.getLogger(DealApi.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<POrderService.Execution> queryDeals(MEvent e) {
        LinkedList<POrderService.Execution> dealList = new LinkedList<POrderService.Execution>();
        try {
            MEvent event = new MEvent();
            e.getStr("file.manipulate.record.uuid");
            String investorId = e.getStr("fund_acct");
            ConvertUtils.getMarket(e.getStr("market_code"));
            e.getStr("holder_acc_no");
            String portfolioId = e.getStr("portfolio_id");
            int pageSize = e.getInt("query_count") > 150 ? 150 : e.getInt("query_count");
            pageSize = pageSize == 0 ? 150 : pageSize;
            POrderService.GetExecutionsReq.Builder builder = POrderService.GetExecutionsReq.newBuilder();
            builder.setOpUser(this.baseApi.getOpUser());
            builder.setMarketGrp("CCS");
            PCcsExtra.CcsExecutionReq.Builder extra = PCcsExtra.CcsExecutionReq.newBuilder();
            if (StringUtils.isEmpty((String)portfolioId)) {
                CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc == null) {
                    MEvent event1 = new MEvent();
                    event1.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                    this.es.postEvent("message.log", event1);
                    e.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                    return dealList;
                }
                builder.setExtAccntId(fundAcc.getExtAccntId());
            } else {
                CcsSubFundAccount subAccount = null;
                if (this.portfolioModel.getMap(portfolioId) != null) {
                    Set keySet = this.portfolioModel.getMap(portfolioId).keySet();
                    for (CcsFundAccount sub : keySet) {
                        CcsSubFundAccount subFund = (CcsSubFundAccount)sub;
                        if (!investorId.equals(subFund.getInvestId()) || !portfolioId.equals(subFund.getPortfolioId())) continue;
                        subAccount = subFund;
                        break;
                    }
                }
                if (subAccount == null) {
                    MEvent event2 = new MEvent();
                    event2.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                    this.es.postEvent("message.log", event2);
                    e.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                    return dealList;
                }
                builder.setExtAccntId(subAccount.getExtAccntId());
                extra.setSubAccntId(subAccount.getSubAccntId());
            }
            PCcsExtra.CcsExecutionReq message = extra.build();
            if (message != null) {
                builder.setObject(Any.pack((Message)message));
            }
            PBase.Page.Builder pageBuilder = this.baseApi.getDefPage().toBuilder();
            pageBuilder.setPageSize(pageSize);
            boolean flag = false;
            do {
                builder.setPage(pageBuilder.build());
                event.setObj((Object)builder.build());
                this.action((IServiceDefine)this.queryService, "263", event);
                POrderService.GetExecutionsResp resp = (POrderService.GetExecutionsResp)event.getObj(POrderService.GetExecutionsResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getExecutionList().isEmpty()) {
                    e.setCode(resp.getStatus().getStatus());
                    e.setDesc(resp.getStatus().getReason());
                    return dealList;
                }
                dealList.addAll(resp.getExecutionList());
                boolean bl = flag = resp.getPage().getTotalRow() > pageBuilder.getStartRow() + resp.getPage().getPageSize() - 1;
                if (flag) {
                    pageBuilder.setStartRow(pageBuilder.getStartRow() + resp.getPage().getPageSize());
                }
                e.setCode(resp.getStatus().getStatus());
                e.setDesc(resp.getStatus().getReason());
            } while (flag);
            return dealList;
        }
        catch (MException e1) {
            logger.error("500004\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e.getDesc());
        }
        return dealList;
    }
}

