/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.query.GetBalanceSheetReq;
import cms.tmx.http.query.GetBalanceSheetResp;
import cms.tmx.http.query.Sofp;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BalanceSheetApi
extends HttpService {
    @Inject
    private MConfService cs;
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MEventService es;
    private static final Logger logger = LogManager.getLogger(BalanceSheetApi.class);

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/statement/StatementService";
    }

    public Sofp GetBalanceSheetReq(MEvent event) {
        Sofp sofp = null;
        try {
            String investorId = event.getStr("fund_acct");
            GetBalanceSheetReq req = new GetBalanceSheetReq();
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarketGrp("CCS");
            String extAccntId = this.fundMng.getNewCashAccntId(investorId);
            if (StringUtils.isEmpty((String)extAccntId)) {
                MEvent event1 = new MEvent();
                event1.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event1);
                event.setDesc("\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650");
                return sofp;
            }
            req.setCashAccntId(extAccntId);
            String json = this.gson.toJson((Object)req);
            logger.info("\u878d\u8d44\u878d\u5238\u5e74\u5229\u7387\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
            String respBody = this.doPost("GetBalanceSheet", json);
            logger.info("\u878d\u8d44\u878d\u5238\u5e74\u5229\u7387\u67e5\u8be2\u54cd\u5e94\uff1a", (Object)respBody);
            GetBalanceSheetResp resp = new GetBalanceSheetResp();
            if (respBody == null) {
                event.setDesc("\u6ca1\u6709\u6570\u636e");
                return sofp;
            }
            resp = (GetBalanceSheetResp)this.gson.fromJson(respBody, GetBalanceSheetResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getSofp() == null) {
                event.setCode(resp.getStatus().getStatus());
                event.setDesc("\u6ca1\u6709\u6570\u636e");
                return sofp;
            }
            sofp = resp.getSofp();
            event.setCode(resp.getStatus().getStatus());
            event.setDesc(resp.getStatus().getReason());
        }
        catch (MException e) {
            logger.error("640002\u878d\u8d44\u878d\u5238\u8d44\u91d1\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
            event.setCode(e.getCode());
            event.setDesc(e.getDesc());
        }
        return sofp;
    }
}

