/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PFundAccntService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.FundAccountFactory;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountApi
extends CallApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private MngServiceDefines.FundAccntServiceDefine fundService;
    @Inject
    private FundAccountFactory fAcc;
    private static final Logger logger = LogManager.getLogger(AccountApi.class);
    @Inject
    private IPortfolioApi portfolioApi;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private MngServiceDefines.FundAccntServiceDefine fundApi;
    @Inject
    private MObjFactory of;

    public List<FundAccount> queryAccounts(MEvent e) {
        List<Object> fundList = new LinkedList();
        String portfolioId = e.getStr("portfolio_id");
        fundList = StringUtils.isEmpty((String)portfolioId) ? this.queryExtFundAccnts(e) : this.querySubFundAccnts(e);
        return fundList;
    }

    private List<FundAccount> queryExtFundAccnts(MEvent e) {
        LinkedList<FundAccount> fundList = new LinkedList<FundAccount>();
        try {
            PAccount.ExtFundAccnt fund;
            MEvent event = new MEvent();
            String investorId = e.getStr("fund_acct");
            PBase.Page defPage = this.baseApi.getDefPage();
            PFundAccntService.GetExtFundAccntsReq.Builder hBuilder = PFundAccntService.GetExtFundAccntsReq.newBuilder();
            hBuilder.setOpUser(this.baseApi.getOpUser());
            hBuilder.setExtAccntId(String.valueOf(investorId) + "_" + "CNY");
            hBuilder.setMarketGrp("CCS");
            hBuilder.setPage(defPage);
            event.setObj((Object)hBuilder.build());
            this.action((IServiceDefine)this.fundService, "239", event);
            PFundAccntService.GetExtFundAccntsResp resp = (PFundAccntService.GetExtFundAccntsResp)event.getObj(PFundAccntService.GetExtFundAccntsResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getExtFundAccntList().size() > 0 && (fund = (PAccount.ExtFundAccnt)resp.getExtFundAccntList().get(0)) != null) {
                fundList.add(this.createFundAccount("CCS", fund));
            }
            e.setCode(resp.getStatus().getStatus());
            e.setDesc(resp.getStatus().getReason());
        }
        catch (MException e1) {
            logger.error("630002\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
        return fundList;
    }

    private FundAccount createFundAccount(String marketGroup, PAccount.ExtFundAccnt extFundAcc) {
        FundAccount fundAcc = this.fAcc.createFundAccount(marketGroup);
        if (fundAcc != null) {
            fundAcc.update((Object)extFundAcc);
        }
        return fundAcc;
    }

    private List<FundAccount> querySubFundAccnts(MEvent e) {
        LinkedList<FundAccount> fundList = new LinkedList<FundAccount>();
        try {
            String investorId = e.getStr("fund_acct");
            String portfolioId = e.getStr("portfolio_id");
            CcsSubFundAccount subAccount = null;
            if (this.portfolioModel.getMap(portfolioId) != null) {
                Set keySet = this.portfolioModel.getMap(portfolioId).keySet();
                for (CcsFundAccount sub : keySet) {
                    CcsSubFundAccount subFund = (CcsSubFundAccount)sub;
                    if (!investorId.equals(subFund.getInvestId()) || !portfolioId.equals(subFund.getPortfolioId())) continue;
                    subAccount = subFund;
                    break;
                }
            }
            if (subAccount == null) {
                MEvent event2 = new MEvent();
                event2.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                this.es.postEvent("message.log", event2);
                e.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u4e0e\u8d26\u53f7\uff1a" + investorId + "\u65e0\u6743\u9650");
                return fundList;
            }
            List assignDetails = this.portfolioApi.getAccntsByPortfolioIds(portfolioId);
            for (PPortfolio.PortAccntAssignDetails assignDetail : assignDetails) {
                if (assignDetail.getAssignStatus() == Integer.valueOf(PortfolioAccountModel.PortfolioStatus.ASSIGNSTATUS_DISABLED.status).intValue()) continue;
                PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
                newBuilder.setPortfolioId(portfolioId);
                newBuilder.setParentExtAccntId(assignDetail.getParentId());
                newBuilder.setParentSubAccntId(assignDetail.getAccountId());
                ArrayList subFundAccntListResult = new ArrayList();
                MEvent event = new MEvent();
                PFundAccntService.GetSubFundAccntsReq.Builder hBuilder = PFundAccntService.GetSubFundAccntsReq.newBuilder();
                hBuilder.setOpUser(this.baseApi.getOpUser());
                hBuilder.setMarketGrp("CCS");
                hBuilder.setSubFundAccnt(newBuilder.build());
                PBase.Page.Builder pageBuilder = this.baseApi.getDefPage().toBuilder();
                boolean flag = false;
                int i = 0;
                do {
                    hBuilder.setPage(pageBuilder.build());
                    event.setObj((Object)hBuilder.build());
                    this.action((IServiceDefine)this.fundApi, "249", event);
                    PFundAccntService.GetSubFundAccntsResp resp = (PFundAccntService.GetSubFundAccntsResp)event.getObj(PFundAccntService.GetSubFundAccntsResp.class);
                    this.checkStatus(resp.getStatus());
                    if (resp.getSubFundAccntList().isEmpty()) {
                        e.setCode(resp.getStatus().getStatus());
                        e.setDesc(resp.getStatus().getReason());
                        break;
                    }
                    subFundAccntListResult.addAll(resp.getSubFundAccntList());
                    boolean bl = flag = resp.getPage().getTotalRow() > pageBuilder.getPageSize() * ++i;
                    if (flag) {
                        pageBuilder.setStartRow(pageBuilder.getPageSize() * i + 1);
                    }
                    e.setCode(resp.getStatus().getStatus());
                    e.setDesc(resp.getStatus().getReason());
                } while (flag);
                for (PAccount.SubFundAccnt subFundAccnt : subFundAccntListResult) {
                    if (!investorId.equals(subFundAccnt.getInvestorId()) || subFundAccnt.getStatus() == Integer.valueOf(PortfolioAccountModel.PortfolioStatus.SUBFUNDACCNT_DISABLED.status).intValue()) continue;
                    CcsSubFundAccount subFundAccount = (CcsSubFundAccount)this.of.create(CcsSubFundAccount.class);
                    subFundAccount.update((Object)subFundAccnt);
                    fundList.add((FundAccount)subFundAccount);
                }
            }
        }
        catch (MException e1) {
            logger.error("630002\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
        return fundList;
    }
}

