/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.core.MEvent;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class FunctionMarket
extends MxTabContent {
    @FXML
    private Button btnOrder;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnOrdetToday;
    @FXML
    private Button btnStock;
    @FXML
    private Button btnDeal;
    @FXML
    private VBox ctMarket;
    @FXML
    private VBox functionMarket;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> indexSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> indexBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    private Label lbSecId;
    @FXML
    private Label lbSecName;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    protected MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected IRefDataMng refMng;
    @FXML
    private AnchorPane pane;

    @FXML
    public void initialize() {
        this.mktItem = this.mktMng.createItem(10);
        this.createMarketTable();
        this.es.subscribe("diskless_refchange", event -> this.onRefChange(event));
    }

    @PostConstruct
    public void init() {
        super.init();
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.lbUpLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbDownLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    private void onRefChange(MEvent event) {
        RefItem refItem = (RefItem)event.getObj(RefItem.class);
        this.mktItem.setRefItem(refItem);
        this.mktMng.dye(this.mktItem);
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        this.lbSecId.setText(this.mktItem.getRefItem().getCode());
        this.lbSecName.setText(this.mktItem.getRefItem().getName());
        this.changeUnit();
    }

    private void changeUnit() {
    }

    public void setPrice(double price) {
    }

    protected void onItemSelected(HandicapInfo now) {
    }

    public Button getBtnOrder() {
        return this.btnOrder;
    }

    public void setBtnOrder(Button btnOrder) {
        this.btnOrder = btnOrder;
    }

    public Parent getContent() {
        return this.content;
    }
}

