/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.diskless.ContentInterface;
import cms.tmx.diskless.view.SecIdCancelDialog;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.views.CcsUnfinishedOrderPart;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisklessUnfinishedOrderPart
extends CcsUnfinishedOrderPart
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(DisklessUnfinishedOrderPart.class);
    @FXML
    private Label lbGetPrice;
    @FXML
    private Label lbFloat;
    private ScrollBar horizontalBar;
    private Class<? extends ContentInterface> clazz;
    protected InvalidationListener lstnModel = ob -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableUnOrder.sort();
        });
    };

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
            this.resetFocus();
        }
        catch (IOException e) {
            logger.error("load diskless order fxml error", (Throwable)e);
            return;
        }
        this.initKeyPressHandler();
        this.hideControl();
        this.es.subscribe("close_menu", event -> {
            if (event.getBool("close_part")) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
    }

    protected void initCheckComboBox() {
    }

    private void hideControl() {
        this.selected.setVisible(false);
        this.colReference.setVisible(false);
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.tableUnOrder.getSelectionModel().clearSelection();
                    this.tableUnOrder.requestFocus();
                });
            }
        });
        this.tableUnOrder.setOnKeyPressed(event -> {
            if (KeyCode.F5 == event.getCode()) {
                this.refresh();
            } else if (KeyCode.TAB == event.getCode() || KeyCode.SHIFT == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            } else if (KeyCode.RIGHT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableUnOrder.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() + step < this.horizontalBar.getMax()) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() + step);
                    return;
                }
                this.horizontalBar.setValue(this.horizontalBar.getMax());
            } else if (KeyCode.LEFT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableUnOrder.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() - step > 0.0) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() - step);
                    return;
                }
                this.horizontalBar.setValue(0.0);
            } else if (KeyCode.ENTER == event.getCode() || KeyCode.DELETE == event.getCode() || KeyCode.F3 == event.getCode() || KeyCode.F4 == event.getCode() || KeyCode.F5 == event.getCode() || KeyCode.F7 == event.getCode() || KeyCode.F1 == event.getCode() || KeyCode.F2 == event.getCode()) {
                this.cancleByHotKey(event.getCode());
            }
        });
        this.tableUnOrder.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableUnOrder.getSelectionModel().getSelectedItem() == null && !this.tableUnOrder.getItems().isEmpty()) {
                this.tableUnOrder.getSelectionModel().select(0);
            }
        });
    }

    private void cancleByHotKey(KeyCode code) {
        if (KeyCode.F1 == code) {
            ArrayList orders = new ArrayList();
            orders.addAll(this.mxList.getList());
            this.ordersCancel(orders, "\u64a4\u5355\u786e\u8ba4", true, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55");
            return;
        }
        if (KeyCode.F4 == code) {
            ArrayList orders = new ArrayList();
            String secId = "";
            SecIdCancelDialog obj = (SecIdCancelDialog)((Object)this.of.create(SecIdCancelDialog.class));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u5408\u7ea6\u64a4\u5355");
            dialog.getButton(ButtonType.OK).setVisible(false);
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            obj.setOk(dialog.getButton(ButtonType.OK));
            obj.setCancel(dialog.getButton(ButtonType.CANCEL));
            if (dialog.launch() != ButtonType.OK) {
                return;
            }
            secId = obj.getSecId();
            String secIdFinal = secId;
            orders.addAll(this.mxList.getList().filtered(item -> item.getInstrument().getSecId().equals(secIdFinal)));
            this.ordersCancel(orders, String.valueOf(secId) + "\u64a4\u5355\u786e\u8ba4", true, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55");
            return;
        }
        CcsOrder order = (CcsOrder)this.tableUnOrder.getSelectionModel().getSelectedItem();
        if (order == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u59d4\u6258\u5355");
            return;
        }
        ArrayList<CcsOrder> orders = new ArrayList<CcsOrder>();
        if (KeyCode.ENTER == code || KeyCode.DELETE == code) {
            orders.add(order);
            this.ordersCancel(orders, "\u64a4\u5355\u786e\u8ba4", true, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55");
            return;
        }
        if (KeyCode.F2 == code) {
            orders.addAll((Collection<CcsOrder>)this.mxList.getList().filtered(item -> order.getOrdTime().compareTo(item.getOrdTime()) >= 0));
            this.ordersCancel(orders, "\u524d\u64a4\u786e\u8ba4", true, "\u5f53\u7b14\u59d4\u6258\u6ca1\u6709\u53ef\u524d\u64a4\u7684\u8bb0\u5f55");
            return;
        }
        if (KeyCode.F3 == code) {
            orders.addAll((Collection<CcsOrder>)this.mxList.getList().filtered(item -> order.getOrdTime().compareTo(item.getOrdTime()) < 0));
            this.ordersCancel(orders, "\u540e\u64a4\u786e\u8ba4", true, "\u5f53\u7b14\u59d4\u6258\u6ca1\u6709\u53ef\u540e\u64a4\u7684\u8bb0\u5f55");
            return;
        }
    }

    @Override
    public Parent getContent() {
        return this.content;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = DisklessUnfinishedOrderPart.class.getResource(String.valueOf(this.getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void resetFocus() {
        Platform.runLater(() -> {
            this.tableUnOrder.getSelectionModel().clearSelection();
            this.searchText.requestFocus();
            this.searchText.clear();
            this.lstnModel.invalidated(null);
        });
    }

    protected void initValues() {
    }

    protected void bind() {
    }

    @Override
    public String getName() {
        return "\u64a4\u5355";
    }

    @Override
    public String getHotKeyBook() {
        return "\u56de\u8f66/Del\uff1a\u64a4\u5355\uff0c F5\uff1a\u5237\u65b0\uff0cF1\uff1a\u5168\u64a4\uff0cF2\uff1a\u524d\u64a4\uff0cF3\uff1a\u540e\u64a4\uff0cF4\uff1a\u6309\u80a1\u7968\u4ee3\u7801\u64a4\u5355\uff0cTab\uff1a\u4ece\u8868\u683c\u56de\u5230\u641c\u7d22\u6846\uff0cBackspace\uff1a\u8fd4\u56de\uff0cEsc\uff1a\u9000\u51fa\u65e0\u76d8\u6a21\u5f0f";
    }

    @Override
    public void sendMsgToPart(Object obj) {
    }

    @Override
    public void setReturnClass(Class<? extends ContentInterface> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<? extends ContentInterface> getReturnClass() {
        return this.clazz;
    }

    @Override
    public void setP(BorderPane p) {
    }
}

