/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.IntegerFilterIncludeZero;
import cms.tmx.control.formatters.IntegerStrConverter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.diskless.ContentInterface;
import cms.tmx.diskless.UserPreCtrlDiskless;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.SceneService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisklessTradePart
extends MxPart
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(DisklessTradePart.class);
    private static final String ORD_TYPE_LIMIT = "0";
    private static final String ORD_TYPE_MARKET_DONE_CANCEL = "1";
    private static final String ORD_TYPE_MARKET_ALL_DONE = "2";
    private Class<? extends ContentInterface> clazz;
    @FXML
    private VBox functionTrade;
    @FXML
    private TextField ordType;
    @FXML
    private Spinner<Double> price;
    @FXML
    private TextField ordQty;
    @FXML
    private TextField secName;
    @FXML
    private TextField available;
    @FXML
    private TextField ordAmount;
    @FXML
    private TextField canBuy;
    @FXML
    private TextField canSell;
    @FXML
    private TextField sellBalance;
    @FXML
    private TextField buyBalance;
    @FXML
    private TextField cost;
    @FXML
    private TextField upLimitedPrice;
    @FXML
    private TextField downLimitedPrice;
    @FXML
    private TextField investorSecId;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    @FXML
    private Label qtyMag;
    @FXML
    private Label ordAmountMag;
    @FXML
    private Label availableMag;
    @FXML
    private Label canBuyMag;
    @FXML
    private Label canSellMag;
    @FXML
    private Label lbUnit;
    @FXML
    private Label lbTip;
    @FXML
    protected Label lbTitle;
    @FXML
    protected TextField txtCode;
    @Inject
    protected IRefDataMng refMng;
    private SecConverter secCvt;
    protected SecSuggest spCode = new SecSuggest();
    protected MarketItem mktItem;
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    @FXML
    protected VBox vboxComponent;
    @FXML
    private HBox hboxSecName;
    @FXML
    private HBox hboxAvailable;
    @FXML
    private HBox hboxOrdAmount;
    @FXML
    private HBox hboxCanBuy;
    @FXML
    private HBox hboxSellBalance;
    @FXML
    private HBox hboxUpLimitedPrice;
    @FXML
    private HBox hboxDownLimitedPrice;
    @FXML
    private HBox hboxInvestorSecId;
    @FXML
    private HBox hboxCanSell;
    @FXML
    private HBox hboxBuyBalance;
    @FXML
    private HBox hboxCost;
    private AutoCompletion<RefItem> autoComtion = null;
    private FundAccount fund;
    private SecAccount xsheSec = new SecAccount();
    private SecAccount xshgSec = new SecAccount();
    private SecAccount sec = new SecAccount();
    @Inject
    private MObjFactory of;
    @Inject
    protected MxAlert alert;
    @Inject
    protected SceneService sceneUtil;
    @Inject
    private UserPreCtrlDiskless userCtrl;
    @Inject
    private MScheduler scheduler;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private CcsAccountMap accntMap;
    @Inject
    protected CcsPositionModel posModel;
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected DialogFactory df;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    protected boolean isBuy = false;
    protected boolean isSell = false;
    private int MAX_QTY = 999999999;
    private MxNode priceStg;
    private MxNode priceTypeMktStg;
    protected List<Node> buyComponents;
    protected List<Node> sellComponents;
    private static final double DEFAULT_WIDTH = 1600.0;
    private static final double DEFAULT_HEIGHT = 1000.0;
    private InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(list);
        Map userCommonSuggesstionsMap = (Map)this.eCore.get((Object)"common_use_refitem_map");
        this.spCode.setCommonUseSuggestions((List)userCommonSuggesstionsMap.get("common_use_ccstrade"));
    };
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> indexSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> indexBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    private Label lbSecId;
    @FXML
    private Label lbSecName;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
        }
        catch (IOException e) {
            logger.error("load diskless trade fxml error", (Throwable)e);
            return;
        }
        this.es.subscribe("close_menu", event -> {
            if (event.getBool("close_part")) {
                Platform.runLater(() -> this.txtCode.requestFocus());
            }
        });
    }

    @FXML
    public void initialize() {
        this.mktItem = this.mktMng.createItem(10);
        this.scheduler.setInterval(400);
        this.createMarketTable();
        this.fxmlDone = true;
        this.posModel.initQuery();
        this.initComponent();
        this.initTextCode();
        this.initAccount();
        this.initControl();
        this.initListener();
        this.initBind();
        this.initValue();
        this.initHotKey();
        Platform.runLater(() -> this.txtCode.requestFocus());
    }

    protected void initValue() {
        this.priceStg = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type", "50");
        this.priceTypeMktStg = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", ORD_TYPE_LIMIT);
        this.ordType.setText(ORD_TYPE_LIMIT);
    }

    private void initComponent() {
        this.buyComponents = Arrays.asList(this.hboxSecName, this.hboxAvailable, this.hboxOrdAmount, this.hboxCanBuy, this.hboxDownLimitedPrice);
        this.sellComponents = Arrays.asList(this.hboxSecName, this.hboxAvailable, this.hboxCanSell, this.hboxCost, this.hboxDownLimitedPrice);
        this.vboxComponent.getChildren().setAll(this.buyComponents);
    }

    private void initControl() {
        this.secName.setDisable(true);
        this.available.setDisable(true);
        this.ordAmount.setDisable(true);
        this.canBuy.setDisable(true);
        this.canSell.setDisable(true);
        this.sellBalance.setDisable(true);
        this.upLimitedPrice.setDisable(true);
        this.downLimitedPrice.setDisable(true);
        this.investorSecId.setDisable(true);
        this.cost.setDisable(true);
        this.buyBalance.setDisable(true);
        this.ordType.setDisable(true);
        SpinnerUtils.arrowsStyle(this.price);
        this.ctrlPrice.ctrl(this.price);
        this.ordQty.setTextFormatter(new TextFormatter((StringConverter)new IntegerStrConverter(), null, (UnaryOperator)new IntegerFilterIncludeZero(true, 9)));
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.ordQty);
        TextFieldUtils.showMagnitude((Label)this.ordAmountMag, (TextField)this.ordAmount);
        TextFieldUtils.showMagnitude((Label)this.availableMag, (TextField)this.available);
        TextFieldUtils.showMagnitude((Label)this.canBuyMag, (TextField)this.canBuy);
        TextFieldUtils.showMagnitude((Label)this.canSellMag, (TextField)this.canSell);
    }

    private void initBind() {
        MxBindings.bindSD((Property)this.available.textProperty(), (ObservableNumberValue)this.fund.availableProperty(), (int)2);
        this.upLimitedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.downLimitedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
    }

    private void initListener() {
        this.price.getEditor().textProperty().addListener((ob, old, now) -> {
            this.calculateCanBuyOrSell();
            this.calculateOrdAmount();
        });
        this.available.textProperty().addListener(ob -> this.calculateCanBuyOrSell());
        this.ordQty.textProperty().addListener((ob, old, now) -> this.calculateOrdAmount());
        this.ordType.textProperty().addListener((ob, old, now) -> {
            this.changeOrdType((String)now);
            this.calculateOrdAmount();
            this.calculateCanBuyOrSell();
            this.fillBidPirce();
        });
        this.ordQty.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbTip.setText("\u8bf7\u8f93\u5165\u4e70\u5165/\u5356\u51fa\u6570\u91cf\uff0cF1\uff1a\u4ee5\u6700\u5927\u53ef\u4e70/\u53ef\u5356\u91cf\u8fdb\u884c\u4e70\u5165/\u5356\u51fa\uff0cF2\uff1a\u8f93\u5165\u9ed8\u8ba4\u6570\u91cf\uff0cEsc\uff1a\u9000\u51fa\u65e0\u76d8\u6a21\u5f0f");
            } else {
                this.lbTip.setText("");
            }
        });
        this.ordType.focusedProperty().addListener((ob, old, now) -> this.changeOrdTypeTip());
        this.p.widthProperty().addListener(ob -> this.calSize());
        this.p.heightProperty().addListener(ob -> this.calSize());
    }

    private void calSize() {
        this.scheduler.schedule(event -> {
            try {
                System.out.println(String.valueOf(this.isBuy) + " | " + this.isSell);
                double scale = 1.0;
                double widthScale = this.p.getWidth() / 1600.0;
                double heightScale = this.p.getHeight() / 1000.0;
                scale = Math.min(widthScale, heightScale);
                this.functionTrade.setScaleX(scale);
                this.functionTrade.setScaleY(scale);
                Platform.runLater(() -> this.p.layout());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void calculateOrdAmount() {
        double priceDb = this.getPrice();
        long orderQty = this.getOrdQty();
        if (priceDb > 0.0 && orderQty > 0L) {
            int multiplier = 1;
            if (this.mktItem.isSHbond()) {
                multiplier = 10;
            }
            this.ordAmount.setText(StringUtils.toThousands((Number)(priceDb * (double)orderQty * (double)multiplier), (int)2));
        } else {
            this.ordAmount.setText("");
        }
    }

    private void calculateCanBuyOrSell() {
        if (this.isBuy) {
            double priceDb = this.getPrice();
            if (priceDb == 0.0) {
                this.canBuy.setText("");
                this.ordAmount.setText("");
                return;
            }
            double availableDb = StringUtils.parseDouble((String)this.available.getText());
            if (priceDb != 0.0) {
                int unit = 1;
                if (this.mktItem.isSHbond()) {
                    unit = 10;
                }
                String txt = StringUtils.toThousands((String)new BigDecimal(availableDb / (priceDb * (double)unit)).setScale(0, 3).toPlainString());
                this.canBuy.setText(txt);
            }
        } else if (this.isSell) {
            CcsPosition position;
            this.canSell.textProperty().unbind();
            this.cost.textProperty().unbind();
            this.canSell.clear();
            this.cost.clear();
            if (this.mktItem.isValidRef() && (position = this.posModel.getPosition(this.sec.getExtSecAccntId(), this.mktItem.getRefItem().getCode())) != null) {
                MxBindings.bindSD((Property)this.canSell.textProperty(), (ObservableNumberValue)position.canVolProperty(), (int)0);
                TradeBindings.priceBinding((Property)this.cost.textProperty(), (ObservableNumberValue)position.buyCostProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
            }
        } else {
            this.canBuy.clear();
            this.ordAmount.clear();
            this.canSell.clear();
            this.cost.clear();
        }
    }

    private void initTextCode() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.refMng.changedProperty().addListener(this.listener);
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.getRefItems());
        Map userCommonSuggesstionsMap = (Map)this.eCore.get((Object)"common_use_refitem_map");
        this.spCode.setCommonUseSuggestions((List)userCommonSuggesstionsMap.get("common_use_ccstrade"));
        this.autoComtion = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoComtion.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> this.onSecurityChange(this.txtCode, (String)newV)));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.ordType.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[012]", 1)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
    }

    private void changeOrdType(String now) {
        if (ORD_TYPE_LIMIT.equals(now)) {
            this.price.setDisable(false);
            this.price.getEditor().setDisable(false);
            this.ordQty.setText("");
        } else if (ORD_TYPE_MARKET_DONE_CANCEL.equals(now)) {
            this.price.setDisable(true);
            this.price.getEditor().setDisable(true);
            this.ordQty.setText("");
            if (this.mktItem.isSHSec()) {
                this.priceTypeMktStg.setRaw("SH2");
            } else {
                this.priceTypeMktStg.setRaw("SZ4");
            }
        } else if (ORD_TYPE_MARKET_ALL_DONE.equals(now)) {
            this.price.setDisable(true);
            this.price.getEditor().setDisable(true);
            this.ordQty.setText("");
            if (this.mktItem.isSHSec()) {
                this.priceTypeMktStg.setRaw("SH1");
            } else {
                this.priceTypeMktStg.setRaw("SZ1");
            }
        } else {
            this.lbTip.setText("");
            this.ordQty.setText("");
        }
        this.changeOrdTypeTip();
        this.price.getEditor().setText(null);
    }

    private void changeOrdTypeTip() {
        String orderType = this.ordType.getText();
        if (ORD_TYPE_LIMIT.equals(orderType)) {
            this.lbTip.setText("\u62a5\u4ef7\u65b9\u5f0f 0\uff1a\u6807\u51c6\u59d4\u6258");
        } else if (ORD_TYPE_MARKET_DONE_CANCEL.equals(orderType)) {
            this.lbTip.setText("\u62a5\u4ef7\u65b9\u5f0f 1\uff1a\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
        } else if (ORD_TYPE_MARKET_ALL_DONE.equals(orderType)) {
            this.lbTip.setText("\u62a5\u4ef7\u65b9\u5f0f 2\uff1a\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u8f6c\u9650\u4ef7");
        } else {
            this.lbTip.setText("");
        }
    }

    private void clearPriceAndQty() {
        this.ordQty.setText(null);
        this.price.getEditor().setText(null);
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem, newText);
    }

    protected void doChange(RefItem refItem, String newText) {
        this.mktItem.setRefItem(refItem);
        this.mktItem.clear();
        if (refItem != null) {
            this.exe.execute(() -> {
                this.mktMng.getItem(this.mktItem.getRefItem());
                this.mktMng.queryMarket(this.mktItem);
                Platform.runLater(() -> this.mktMng.refreshMarketWithoutQuery(this.mktItem));
            });
            this.onRefChange(refItem);
            this.spCode.addCommonUseSuggestion((Object)refItem);
        }
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        this.checkLength(newText.length());
    }

    private void onRefChange(RefItem refItem) {
        if ("XSHG".equals(refItem.getMarket())) {
            this.sec = this.xshgSec;
        } else if ("XSHE".equals(refItem.getMarket())) {
            this.sec = this.xsheSec;
        }
        this.investorSecId.setText(this.sec.getInverstorSecId());
        this.calculateCanBuyOrSell();
        TradeBindings.priceBinding((Property)this.upLimitedPrice.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.downLimitedPrice.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        this.lbSecId.setText(this.mktItem.getRefItem().getCode());
        if (this.mktItem.getRefItem().isGem()) {
            if (this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                this.lbSecName.setText(String.valueOf(this.mktItem.getRefItem().getName()) + " " + "\u521d");
            } else {
                this.lbSecName.setText(this.mktItem.getRefItem().getName());
            }
            Tooltip tooltip = new Tooltip();
            StringBuilder builder = new StringBuilder();
            builder.append(this.mktItem.getRefItem().getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
            builder.append("\r\n");
            builder.append(this.mktItem.getRefItem().getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
            builder.append("\r\n");
            builder.append(this.mktItem.getRefItem().getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
            builder.append("\r\n");
            builder.append(this.mktItem.getRefItem().getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
            builder.append("\r\n");
            tooltip.setText(builder.toString());
            this.lbSecName.setTooltip(tooltip);
            this.lbSecName.setStyle("-fx-font-size: 15;");
        } else if ("FUND".equals(this.mktItem.getRefItem().getType())) {
            BigDecimal down = new BigDecimal(this.mktItem.getRefItem().getLimitDownRate());
            BigDecimal up = new BigDecimal(this.mktItem.getRefItem().getLimitUpRate());
            if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                this.lbSecName.setText(String.valueOf(this.mktItem.getRefItem().getName()) + "(\u6da8\u8dcc20%)");
                Tooltip tooltip = new Tooltip();
                tooltip.setText(this.lbSecName.getText());
                this.lbSecName.setTooltip(tooltip);
                this.lbSecName.setStyle("-fx-font-size: 12;");
            } else {
                this.lbSecName.setText(this.mktItem.getRefItem().getName());
                this.lbSecName.setStyle("-fx-font-size: 15;");
                this.lbSecName.setTooltip(null);
            }
        } else {
            this.lbSecName.setText(this.mktItem.getRefItem().getName());
            this.lbSecName.setTooltip(null);
            this.lbSecName.setStyle("-fx-font-size: 15;");
        }
        this.changeUnit();
        this.fillBidPirce();
    }

    private void fillBidPirce() {
        if (!ORD_TYPE_LIMIT.equals(this.ordType.getText()) || !this.mktItem.isValidRef()) {
            this.price.getEditor().setText(null);
            return;
        }
        Platform.runLater(() -> {
            if (this.isBuy) {
                this.price.getEditor().setText(String.valueOf(this.mktItem.getSellPrice(0)));
            } else if (this.isSell) {
                this.price.getEditor().setText(String.valueOf(this.mktItem.getBuyPrice(0)));
            }
        });
        if (this.mktItem.getSellPrice(0) < 0.0 || this.mktItem.getBuyPrice(0) < 0.0) {
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater(() -> {
                        if (DisklessTradePart.this.isBuy) {
                            DisklessTradePart.this.price.getEditor().setText(String.valueOf(DisklessTradePart.this.mktItem.getSellPrice(0)));
                        } else if (DisklessTradePart.this.isSell) {
                            DisklessTradePart.this.price.getEditor().setText(String.valueOf(DisklessTradePart.this.mktItem.getBuyPrice(0)));
                        }
                    });
                }
            };
            timer.schedule(task, 1000L);
        }
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        this.price.getEditor().setText(null);
        if (this.mktItem.isBond()) {
            if (this.mktItem.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.mktItem.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.mktItem.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
    }

    private void checkLength(int length) {
        if (length < 6) {
            this.secName.setText("");
            return;
        }
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || !this.mktItem.isValidRef()) {
            this.secName.setText(INVALID_CODE);
            this.price.getEditor().setText(null);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.secName.setText(this.mktItem.getStatus());
        } else {
            this.secName.setText(this.mktItem.getRefItem().getName());
            this.checkGemFirst(ref);
        }
    }

    private void checkGemFirst(RefItem ref) {
        if (ref.isGem()) {
            if (ref.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || ref.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                this.secName.setText(String.valueOf(ref.getName()) + " " + "\u521d");
            } else {
                this.secName.setText(ref.getName());
            }
            Tooltip tooltip = new Tooltip();
            StringBuilder builder = new StringBuilder();
            builder.append(ref.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
            builder.append("\r\n");
            builder.append(ref.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
            builder.append("\r\n");
            builder.append(ref.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
            builder.append("\r\n");
            builder.append(ref.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
            builder.append("\r\n");
            tooltip.setText(builder.toString());
            this.secName.setTooltip(tooltip);
            this.secName.setStyle("-fx-font-size: 15;");
        } else if ("FUND".equals(this.mktItem.getRefItem().getType())) {
            BigDecimal down = new BigDecimal(this.mktItem.getRefItem().getLimitDownRate());
            BigDecimal up = new BigDecimal(this.mktItem.getRefItem().getLimitUpRate());
            if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                this.secName.setText(String.valueOf(this.mktItem.getRefItem().getName()) + "(\u6da8\u8dcc20%)");
                this.secName.setTooltip(new Tooltip(this.secName.getText()));
                this.secName.setStyle("-fx-font-size: 12;");
            } else {
                this.secName.setStyle("-fx-font-size: 15;");
                this.secName.setText(this.mktItem.getRefItem().getName());
            }
        } else {
            this.secName.setTooltip(null);
            this.secName.setStyle("-fx-font-size: 15;");
        }
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.checkLength(this.txtCode.getText().length());
        } else if (val.booleanValue()) {
            Platform.runLater(() -> {
                if (this.txtCode.getText().length() > 0) {
                    this.txtCode.selectAll();
                } else if (this.autoComtion != null) {
                    this.autoComtion.setUserInput("");
                }
            });
        }
    }

    private void initAccount() {
        Map accountMap;
        try {
            accountMap = this.accntMap.getAccountMap();
        }
        catch (MException mException) {
            this.alert.alert(Alert.AlertType.ERROR, "\u521d\u59cb\u5316\u8d26\u53f7\u5931\u8d25");
            return;
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            if (((List)entry.getValue()).size() < 2) continue;
            this.fund = (FundAccount)entry.getKey();
        }
        if (this.fund == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u65e0\u53ef\u7528\u8d44\u91d1\u8d26\u53f7");
            return;
        }
        try {
            List secAccntsByFundAccnt = this.accntMap.getSecAccntsByFundAccnt(this.fund);
            boolean firstXshe = true;
            boolean firstXshg = true;
            for (SecAccount secAccount : secAccntsByFundAccnt) {
                if (firstXshe && "XSHE".equals(secAccount.getExchange().getRaw())) {
                    this.xsheSec = secAccount;
                    firstXshe = false;
                }
                if (!firstXshg || !"XSHG".equals(secAccount.getExchange().getRaw())) continue;
                this.xshgSec = secAccount;
                firstXshg = false;
            }
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u65e0\u76d8\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public Parent getContent() {
        return this.content;
    }

    @Override
    public void resetFocus() {
        Platform.runLater(() -> {
            this.calSize();
            this.txtCode.requestFocus();
            this.txtCode.clear();
            this.mktItem.setRefItem(null);
            this.secName.clear();
            this.price.getEditor().setText(null);
            this.ordQty.clear();
            this.ordType.setText(ORD_TYPE_LIMIT);
            this.tableMarketSell.refresh();
            this.tableMarketBuy.refresh();
        });
    }

    private double getPrice() {
        if (ORD_TYPE_LIMIT.equals(this.ordType.getText())) {
            return StringUtils.parseDouble((String)this.price.getEditor().getText());
        }
        if (ORD_TYPE_MARKET_DONE_CANCEL.equals(this.ordType.getText())) {
            return this.mktItem.getNowPrice();
        }
        if (ORD_TYPE_MARKET_ALL_DONE.equals(this.ordType.getText())) {
            return this.mktItem.getNowPrice();
        }
        return 0.0;
    }

    private long getOrdQty() {
        return StringUtils.parseLong((String)this.ordQty.getText());
    }

    private Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
    }

    private void doOrder() {
        try {
            this.check();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        List<CcsSingleEntrust> entrustList = this.getEntrustList();
        CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
        obj.setExecution(true);
        obj.setBuySymbol("\u4e70\u5165");
        obj.setSellSymbol("\u5356\u51fa");
        obj.setExecution(true);
        obj.setRefItem(this.mktItem.getRefItem());
        obj.setPriceStg(this.priceStg);
        obj.setPriceTypeMktStg(this.priceTypeMktStg);
        obj.setUnit(this.lbUnit.getText());
        obj.setList(entrustList);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            ObservableList<Boolean> resultList = this.submitOrder();
            if (resultList.filtered(each -> each == false).size() > 0) {
                this.alert.alert(Alert.AlertType.ERROR, "\u63d0\u4ea4\u6210\u529f" + resultList.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + resultList.filtered(each -> each == false).size() + "\u7b14");
            } else {
                this.alert.alert(Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + resultList.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + resultList.filtered(each -> each == false).size() + "\u7b14");
            }
            this.ordQty.setText(null);
        }
    }

    private ObservableList<Boolean> submitOrder() {
        ObservableList returnList = FxUtils.newList();
        for (CcsSingleEntrust en : this.getEntrustList()) {
            try {
                en.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    private List<CcsSingleEntrust> getEntrustList() {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        CcsSingleEntrust en = this.ef.createCcsSingle(this.fund.getExtAccntId(), this.sec.getExtSecAccntId());
        en.setFundAccount(this.fund);
        en.setSecAccount(this.sec);
        en.setInvestorId(this.fund.getInvestId());
        en.setInvestorSecId(this.sec.getInverstorSecId());
        if (this.mktItem.isReverseRepo()) {
            en.setSide(this.isBuy ? 71 : 70);
        } else {
            en.setSide(this.isBuy ? 49 : 50);
        }
        en.setQuantity(StringUtils.parseLong((String)this.ordQty.getText()));
        if (this.isSell) {
            en.setCanSell(StringUtils.parseLong((String)this.canSell.getText()));
        }
        en.setMarket(this.mktItem.getRefItem().getMarket());
        en.setSecType(this.mktItem.getRefItem().getType());
        en.setPrice(this.getPrice());
        if (ORD_TYPE_LIMIT.equals(this.ordType.getText())) {
            en.setOrderType(50);
            en.setPrice(this.getPrice());
        } else {
            en.setOrderType(49);
            if ("XSHG".equals(this.mktItem.getRefItem().getMarket())) {
                if (ORD_TYPE_MARKET_DONE_CANCEL.equals(this.ordType.getText())) {
                    en.setTif(51);
                    en.setMaxLevels(5);
                } else if (ORD_TYPE_MARKET_ALL_DONE.equals(this.ordType.getText())) {
                    en.setMaxLevels(5);
                    en.setTif(48);
                }
            } else if ("XSHE".equals(this.mktItem.getRefItem().getMarket())) {
                if (ORD_TYPE_MARKET_DONE_CANCEL.equals(this.ordType.getText())) {
                    en.setTif(51);
                    en.setMaxLevels(5);
                } else if (ORD_TYPE_MARKET_ALL_DONE.equals(this.ordType.getText())) {
                    en.setTif(48);
                    en.setMaxLevels(1);
                }
            }
        }
        en.setSec(this.mktItem.getRefItem().getCode());
        en.setSecName(this.mktItem.getRefItem().getName());
        en.setAppID(this.mktItem.isReverseRepo() ? "110" : "010");
        if (this.userCtrl.isAutoSlice() && this.userCtrl.getMaxSliceQty() > 0L) {
            this.entrustSplit.setRefItem(this.mktItem.getRefItem());
            List splitList = this.entrustSplit.split(en, this.userCtrl.getMaxSliceQty());
            enList.addAll(splitList);
        } else {
            enList.add(en);
        }
        return enList;
    }

    private void check() throws MException {
        if (this.fund == null) {
            throw new MException(1, "\u65e0\u6709\u6548\u8d44\u91d1\u8d26\u53f7");
        }
        if (!this.mktItem.isValidRef()) {
            throw new MException(1, "\u65e0\u6548\u5408\u7ea6\u4ee3\u7801");
        }
        if (StringUtils.isEmpty((String)this.investorSecId.getText())) {
            throw new MException(1, "\u65e0\u5bf9\u5e94\u5e02\u573a\u8bc1\u5238\u8d26\u53f7");
        }
        if (StringUtils.isEmpty((String)this.ordType.getText())) {
            throw new MException(1, "\u8bf7\u8f93\u5165\u62a5\u4ef7\u65b9\u5f0f");
        }
        if (StringUtils.parseDouble((String)this.canBuy.getText()) < 0.0 || StringUtils.parseDouble((String)this.ordQty.getText()) <= 0.0) {
            throw new MException(1, "\u65e0\u6548\u6570\u91cf");
        }
        if (ORD_TYPE_LIMIT.equals(this.ordType.getText()) && this.getPrice() == 0.0) {
            throw new MException(1, "\u8bf7\u8f93\u5165\u4ef7\u683c");
        }
        if (StringUtils.parseDouble((String)this.upLimitedPrice.getText()) > 0.0 && this.getPrice() > StringUtils.parseDouble((String)this.upLimitedPrice.getText())) {
            throw new MException(1, "\u4ef7\u683c\u8d85\u8fc7\u6da8\u505c\u4ef7");
        }
        if (StringUtils.parseDouble((String)this.downLimitedPrice.getText()) > 0.0 && this.getPrice() < StringUtils.parseDouble((String)this.downLimitedPrice.getText())) {
            throw new MException(1, "\u4ef7\u683c\u5c0f\u4e8e\u8dcc\u505c\u4ef7");
        }
    }

    @Override
    public String getName() {
        return "\u4e70\u5356\u59d4\u6258";
    }

    private void initHotKey() {
        this.txtCode.setOnKeyPressed(event -> {
            if (KeyCode.ENTER == event.getCode() && this.mktItem.isValidRef() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.price.getEditor().requestFocus();
                    this.price.getEditor().selectEnd();
                });
            }
        });
        this.ordType.setOnKeyPressed(event -> {
            if (KeyCode.ENTER == event.getCode() || KeyCode.DOWN == event.getCode()) {
                if (this.price.getEditor().isDisable()) {
                    Platform.runLater(() -> this.txtCode.requestFocus());
                } else {
                    Platform.runLater(() -> {
                        this.price.getEditor().requestFocus();
                        this.price.getEditor().selectEnd();
                    });
                }
            } else if (KeyCode.UP == event.getCode()) {
                Platform.runLater(() -> this.txtCode.requestFocus());
            }
        });
        this.price.getEditor().setOnKeyPressed(event -> {
            if (KeyCode.ENTER == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.ordQty.requestFocus();
                    this.ordQty.selectEnd();
                });
            } else if (KeyCode.UP == event.getCode()) {
                Platform.runLater(() -> this.txtCode.requestFocus());
            }
        });
        this.ordQty.setOnKeyPressed(event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.doOrder();
            } else if (!event.isShiftDown() && KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.txtCode.requestFocus());
            } else if (KeyCode.UP == event.getCode()) {
                if (this.price.getEditor().isDisable()) {
                    Platform.runLater(() -> this.txtCode.requestFocus());
                } else {
                    Platform.runLater(() -> {
                        this.price.getEditor().requestFocus();
                        this.price.getEditor().selectEnd();
                    });
                }
            } else if (KeyCode.F1 == event.getCode()) {
                this.fillMaxQty();
            } else if (KeyCode.F2 == event.getCode() && this.userCtrl.getCommonQty() > 0L) {
                this.ordQty.setText(StringUtils.toThousands((Number)this.userCtrl.getCommonQty()));
            }
        });
    }

    private void fillMaxQty() {
        if (!this.mktItem.isValidRef()) {
            return;
        }
        String qtyStr = "";
        if (this.isBuy) {
            qtyStr = StringUtils.toThousands((String)this.canBuy.getText());
            if (StringUtils.parseDouble((String)this.canBuy.getText()) > (double)this.MAX_QTY) {
                qtyStr = StringUtils.toThousands((String)String.valueOf(this.MAX_QTY));
            }
            int unit = 100;
            if (this.mktItem.isValidRef() && this.mktItem.getRefItem().getBuyUnit() > 0) {
                unit = this.mktItem.getRefItem().getBuyUnit();
            }
            int parseInt = StringUtils.parseInt((String)qtyStr);
            this.ordQty.setText(StringUtils.toThousands((Number)(parseInt / unit * unit)));
        } else if (this.isSell) {
            qtyStr = StringUtils.toThousands((String)this.canSell.getText());
            if (StringUtils.parseDouble((String)this.canSell.getText()) > (double)this.MAX_QTY) {
                qtyStr = StringUtils.toThousands((String)String.valueOf(this.MAX_QTY));
            }
            this.ordQty.setText(StringUtils.toThousands((String)qtyStr));
        }
    }

    @Override
    public String getHotKeyBook() {
        return "\u4e0a\u4e0b\u952e\u6216Tab\u952e\u5207\u6362\u63a7\u4ef6\uff0c\u56de\u8f66\u9009\u62e9\u3002Esc\uff1a\u8fd4\u56de\uff0cF10\uff1a\u9000\u51fa\u65e0\u76d8\u6a21\u5f0f";
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbSecId.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbSecName.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.lbUpLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbDownLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.mktItem.isBond() && this.mktItem.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.getClass().getResource(String.valueOf(this.getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void sendMsgToPart(Object obj) {
    }

    @Override
    public void setP(BorderPane p) {
        this.p = p;
    }

    @Override
    public void setReturnClass(Class<? extends ContentInterface> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<? extends ContentInterface> getReturnClass() {
        return this.clazz;
    }
}

