/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.core.MEvent;
import cms.tmx.diskless.ContentInterface;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.query.current.views.CcsPositionPart;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisklessPositionPart
extends CcsPositionPart
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(DisklessPositionPart.class);
    @FXML
    private Button refreshBtn;
    private ScrollBar horizontalBar;
    private Class<? extends ContentInterface> clazz;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
            this.resetFocus();
            this.initKeyPressHandler();
            this.hideControl();
        }
        catch (IOException e) {
            logger.error("load diskless order fxml error", (Throwable)e);
            return;
        }
        this.es.subscribe("close_menu", event -> {
            if (event.getBool("close_part")) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
    }

    private void hideControl() {
        this.refreshBtn.setVisible(false);
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.tablePosition.getSelectionModel().clearSelection();
                    this.tablePosition.requestFocus();
                });
            }
        });
        this.tablePosition.setOnKeyPressed(event -> {
            if (KeyCode.F5 == event.getCode()) {
                this.refresh();
            } else if (KeyCode.TAB == event.getCode() || KeyCode.SHIFT == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            } else if (KeyCode.LEFT == event.getCode()) {
                CcsPosition pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem();
                if (pos == null) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u9700\u8981\u5356\u51fa\u7684\u6301\u4ed3");
                    return;
                }
                MEvent mEvent = new MEvent();
                mEvent.put((Object)"diskless_side", (Object)"sell");
                mEvent.setObj((Object)pos);
                this.es.sendEvent("diskless_pos_trade", mEvent);
            } else if (KeyCode.RIGHT == event.getCode()) {
                CcsPosition pos = (CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem();
                if (pos == null) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u9700\u8981\u4e70\u5165\u7684\u6301\u4ed3");
                    return;
                }
                MEvent mEvent = new MEvent();
                mEvent.put((Object)"diskless_side", (Object)"buy");
                mEvent.setObj((Object)pos);
                this.es.sendEvent("diskless_pos_trade", mEvent);
            } else if (KeyCode.RIGHT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tablePosition.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() + step < this.horizontalBar.getMax()) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() + step);
                    return;
                }
                this.horizontalBar.setValue(this.horizontalBar.getMax());
            } else if (KeyCode.LEFT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tablePosition.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() - step > 0.0) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() - step);
                    return;
                }
                this.horizontalBar.setValue(0.0);
            }
        });
        this.tablePosition.focusedProperty().addListener((ob, old, now) -> Platform.runLater(() -> {
            if (now.booleanValue()) {
                if (this.tablePosition.getSelectionModel().getSelectedItem() != null) {
                    this.tablePosition.getSelectionModel().select((Object)((CcsPosition)this.tablePosition.getSelectionModel().getSelectedItem()));
                } else if (!this.tablePosition.getItems().isEmpty()) {
                    this.tablePosition.getSelectionModel().select(0);
                }
            }
        }));
    }

    @Override
    public Parent getContent() {
        return this.content;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = DisklessPositionPart.class.getResource(String.valueOf(this.getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void resetFocus() {
        Platform.runLater(() -> {
            this.tablePosition.getSelectionModel().clearSelection();
            this.searchText.requestFocus();
            this.searchText.clear();
        });
    }

    @Override
    public String getName() {
        return "\u80a1\u7968\u8d44\u91d1";
    }

    @Override
    public String getHotKeyBook() {
        return "F5\uff1a\u5237\u65b0\uff0cBackSpace\uff1a\u8fd4\u56de\uff0cTab\uff1a\u4ece\u8868\u683c\u56de\u5230\u641c\u7d22\u6846\uff0cEsc\uff1a\u9000\u51fa\u65e0\u76d8\u6a21\u5f0f";
    }

    @Override
    public void sendMsgToPart(Object obj) {
    }

    @Override
    public void setReturnClass(Class<? extends ContentInterface> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<? extends ContentInterface> getReturnClass() {
        return this.clazz;
    }

    @Override
    public void setP(BorderPane p) {
    }
}

