/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.diskless.ContentInterface;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsOrderPart;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisklessOrderPart
extends CcsOrderPart
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(DisklessOrderPart.class);
    @FXML
    private Button refreshBtn;
    private ScrollBar horizontalBar;
    private Class<? extends ContentInterface> clazz;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
            this.resetFocus();
            this.initKeyPressHandler();
        }
        catch (IOException e) {
            logger.error("load diskless order fxml error", (Throwable)e);
            return;
        }
        this.colReference.setVisible(false);
        this.refreshBtn.setVisible(false);
        this.es.subscribe("close_menu", event -> {
            if (event.getBool("close_part")) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.tableOrder.getSelectionModel().clearSelection();
                    this.tableOrder.requestFocus();
                });
            }
        });
        this.tableOrder.setOnKeyPressed(event -> {
            if (KeyCode.F5 == event.getCode()) {
                this.refresh();
            } else if (KeyCode.TAB == event.getCode() || KeyCode.SHIFT == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            } else if (KeyCode.RIGHT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableOrder.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() + step < this.horizontalBar.getMax()) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() + step);
                    return;
                }
                this.horizontalBar.setValue(this.horizontalBar.getMax());
            } else if (KeyCode.LEFT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableOrder.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() - step > 0.0) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() - step);
                    return;
                }
                this.horizontalBar.setValue(0.0);
            } else if (KeyCode.ENTER == event.getCode() || KeyCode.DELETE == event.getCode()) {
                CcsOrder order = (CcsOrder)this.tableOrder.getSelectionModel().getSelectedItem();
                if (order == null) {
                    return;
                }
                if ("48".equals(order.getOrdStatus().getRaw())) {
                    ArrayList<CcsOrder> orders = new ArrayList<CcsOrder>();
                    orders.add(order);
                    this.ordersCancel(orders, "\u64a4\u5355\u786e\u8ba4");
                } else {
                    this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u64a4\u5355");
                }
            }
        });
        this.tableOrder.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableOrder.getSelectionModel().getSelectedItem() == null && !this.tableOrder.getItems().isEmpty()) {
                this.tableOrder.getSelectionModel().select(0);
            }
        });
    }

    @Override
    public Parent getContent() {
        return this.content;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = DisklessOrderPart.class.getResource(String.valueOf(this.getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void resetFocus() {
        Platform.runLater(() -> {
            this.tableOrder.getSelectionModel().clearSelection();
            this.searchText.requestFocus();
            this.searchText.clear();
            this.lstnModel.invalidated(null);
        });
    }

    @Override
    public String getName() {
        return "\u5f53\u65e5\u59d4\u6258";
    }

    @Override
    public String getHotKeyBook() {
        return "ESC\uff1a\u9000\u51fa\u5168\u5c4f\u3002F12\u9000\u51fa\u7cfb\u7edf\u3002";
    }

    private void ordersCancel(List<CcsOrder> list, String dialogName) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, TIP)) {
            return;
        }
        if (this.createDialog(list, dialogName)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("ccs.cancel.order", event);
        this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14");
    }

    private boolean createDialog(List<CcsOrder> list, String dialogName) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)this.of.create(CcsCancelConfirmDialog.class);
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (CcsOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            if ("XSHG".equals(or.getInstrument().getMarket().getRaw()) && "BOND".equals(or.getInstrument().getSecType())) {
                en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
            } else {
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        obj.setIsDiskless(true);
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    @Override
    public void sendMsgToPart(Object obj) {
    }

    @Override
    public void setReturnClass(Class<? extends ContentInterface> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<? extends ContentInterface> getReturnClass() {
        return this.clazz;
    }

    @Override
    public void setP(BorderPane p) {
    }
}

