/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.diskless.ContentInterface;
import cms.tmx.query.current.views.CcsDealPart;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisklessDealPart
extends CcsDealPart
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(DisklessDealPart.class);
    @FXML
    private Button refreshBtn;
    private ScrollBar horizontalBar;
    private Class<? extends ContentInterface> clazz;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
            this.resetFocus();
            this.initKeyPressHandler();
            this.hideControl();
        }
        catch (IOException e) {
            logger.error("load diskless order fxml error", (Throwable)e);
            return;
        }
        this.es.subscribe("close_menu", event -> {
            if (event.getBool("close_part")) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
    }

    private void hideControl() {
        this.refreshBtn.setVisible(false);
        this.colReference.setVisible(false);
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.ENTER == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> {
                    this.tableDeal.getSelectionModel().clearSelection();
                    this.tableDeal.requestFocus();
                    this.tableDealCount.getSelectionModel().clearSelection();
                    this.tableDealCount.requestFocus();
                });
            }
        });
        this.tableDeal.setOnKeyPressed(event -> {
            if (KeyCode.F5 == event.getCode()) {
                this.refresh();
            } else if (KeyCode.TAB == event.getCode() || KeyCode.SHIFT == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            } else if (KeyCode.RIGHT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableDeal.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() + step < this.horizontalBar.getMax()) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() + step);
                    return;
                }
                this.horizontalBar.setValue(this.horizontalBar.getMax());
            } else if (KeyCode.LEFT == event.getCode()) {
                if (this.horizontalBar == null) {
                    Set allBar = this.tableDeal.lookupAll(".scroll-bar");
                    for (Node node : allBar) {
                        ScrollBar bar = (ScrollBar)ScrollBar.class.cast(node);
                        if (bar.getOrientation() != Orientation.HORIZONTAL) continue;
                        this.horizontalBar = bar;
                    }
                    if (this.horizontalBar == null) {
                        return;
                    }
                }
                double step = this.horizontalBar.getMax() / 10.0;
                if (this.horizontalBar.getValue() - step > 0.0) {
                    this.horizontalBar.setValue(this.horizontalBar.getValue() - step);
                    return;
                }
                this.horizontalBar.setValue(0.0);
            } else if (event.getCode() == KeyCode.F1) {
                this.detailSwitch();
            }
        });
        this.tableDealCount.setOnKeyPressed(event -> {
            if (KeyCode.F5 == event.getCode()) {
                this.refresh();
            } else if (KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            } else if (event.getCode() == KeyCode.F1) {
                this.detailSwitch();
            }
        });
        this.tableDeal.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableDeal.getSelectionModel().getSelectedItem() == null && !this.tableDeal.getItems().isEmpty()) {
                this.tableDeal.getSelectionModel().select(0);
            }
        });
        this.tableDealCount.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableDealCount.getSelectionModel().getSelectedItem() == null && !this.tableDealCount.getItems().isEmpty()) {
                this.tableDealCount.getSelectionModel().select(0);
            }
        });
    }

    private void detailSwitch() {
        Platform.runLater(() -> {
            if (this.detailRadio.isSelected()) {
                this.countRadio.setSelected(true);
                this.tableDealCount.requestFocus();
            } else {
                this.detailRadio.setSelected(true);
                this.tableDeal.requestFocus();
            }
        });
    }

    @Override
    public Parent getContent() {
        return this.content;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = DisklessDealPart.class.getResource(String.valueOf(this.getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void resetFocus() {
        Platform.runLater(() -> {
            this.tableDeal.getSelectionModel().clearSelection();
            this.tableDealCount.getSelectionModel().clearSelection();
            this.searchText.requestFocus();
            this.searchText.clear();
            this.lstnModel.invalidated(null);
        });
    }

    @Override
    public String getName() {
        return "\u6210\u4ea4\u67e5\u8be2";
    }

    @Override
    public String getHotKeyBook() {
        return "ESC\uff1a\u9000\u51fa\u65e0\u76d8\u6a21\u5f0f";
    }

    @Override
    public void sendMsgToPart(Object obj) {
    }

    @Override
    public void setReturnClass(Class<? extends ContentInterface> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<? extends ContentInterface> getReturnClass() {
        return this.clazz;
    }

    @Override
    public void setP(BorderPane p) {
    }
}

