/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MObjFactory;
import cms.tmx.diskless.ContentInterface;
import cms.tmx.diskless.view.DisklessDealPart;
import cms.tmx.diskless.view.DisklessOrderPart;
import cms.tmx.diskless.view.DisklessPositionPart;
import cms.tmx.diskless.view.DisklessTradeBuyPart;
import cms.tmx.diskless.view.DisklessTradeSellPart;
import cms.tmx.diskless.view.DisklessUnfinishedOrderPart;
import cms.tmx.diskless.view.FunctionSelectBasic;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.SceneService;
import cms.tmx.query.current.models.CcsAccountMap;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseMotionListener;

public class DiskLessModelPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(DiskLessModelPart.class);
    @FXML
    private AnchorPane pane;
    @Inject
    private MObjFactory of;
    @Inject
    private MConfService cs;
    private FunctionSelectBasic basic;
    @FXML
    private Label lbTitle;
    @FXML
    private Label lbHotKeyBook;
    @Inject
    private MxAlert alert;
    private Map<Class<? extends ContentInterface>, ContentInterface> partMap = new HashMap<Class<? extends ContentInterface>, ContentInterface>();
    private Robot robot;
    private ContentInterface currentContent;
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    private SceneService service;
    private NativeKeyListener nativeLis = new NativeKeyListener(){

        public void nativeKeyTyped(NativeKeyEvent nativeEvent) {
        }

        public void nativeKeyReleased(NativeKeyEvent nativeEvent) {
            Platform.runLater(() -> {
                if (nativeEvent.getKeyCode() == 88) {
                    Stage mainStage = DiskLessModelPart.this.of.getMainStage();
                    if (mainStage.isIconified()) {
                        mainStage.setIconified(false);
                    } else if (mainStage.isFocused()) {
                        mainStage.setIconified(true);
                    }
                }
            });
        }

        public void nativeKeyPressed(NativeKeyEvent nativeEvent) {
        }
    };
    NativeMouseMotionListener nativeMouseLis = new NativeMouseMotionListener(){

        public void nativeMouseMoved(NativeMouseEvent arg0) {
            DiskLessModelPart.this.checkRobot();
            if (!DiskLessModelPart.this.of.getMainStage().isIconified() && DiskLessModelPart.this.of.getMainStage().isFullScreen() && (arg0.getY() != 100 || arg0.getX() <= 3000)) {
                DiskLessModelPart.this.robot.mouseMove(3000, 100);
            }
        }

        public void nativeMouseDragged(NativeMouseEvent arg0) {
        }
    };
    MEventHandler posLisenter = event -> {
        try {
            Position pos = (Position)event.getObj(Position.class);
            if ("buy".equals(event.getStr("diskless_side"))) {
                this.setContent(DisklessTradeBuyPart.class, pos, DisklessPositionPart.class);
            } else if ("sell".equals(event.getStr("diskless_side"))) {
                this.setContent(DisklessTradeSellPart.class, pos, DisklessPositionPart.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    };

    @FXML
    public void initialize() {
        this.checkRobot();
        this.basic = (FunctionSelectBasic)this.of.create(FunctionSelectBasic.class);
        this.partMap.put(FunctionSelectBasic.class, this.basic);
        this.setContent(FunctionSelectBasic.class, null, FunctionSelectBasic.class);
        this.basic.content.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.selectCodeKeyPress((KeyEvent)event));
        this.p.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.es.subscribe("diskless_pos_trade", this.posLisenter);
    }

    private void initGlobalHotKey() {
        Platform.runLater(() -> {
            try {
                GlobalScreen.registerNativeHook();
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)GlobalScreen.class.getPackage().getName());
                logger.setLevel(Level.OFF);
                GlobalScreen.addNativeKeyListener((NativeKeyListener)this.nativeLis);
                GlobalScreen.addNativeMouseMotionListener((NativeMouseMotionListener)this.nativeMouseLis);
            }
            catch (NativeHookException e) {
                logger.error("\u65e0\u76d8\u6a21\u5f0f\u6ce8\u518c\u5168\u5c40\u5feb\u6377\u952e\u5931\u8d25", (Throwable)e);
            }
        });
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            this.startRecord();
        }
        catch (IOException iOException) {
            return;
        }
        this.p.setCenter((Node)this.content);
        if (this.cs.getValueAsBool("global.hotkey", false)) {
            this.initGlobalHotKey();
        }
    }

    @PreDestroy
    private void destroy() {
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.ESCAPE == key.getCode()) {
            if (this.currentContent != null && this.currentContent.getReturnClass() != null) {
                this.setContent(this.currentContent.getReturnClass(), null, FunctionSelectBasic.class);
            } else {
                this.setContent(FunctionSelectBasic.class, null, FunctionSelectBasic.class);
            }
        }
    }

    public void selectCodeKeyPress(KeyEvent key) {
        if (KeyCode.DIGIT1 == key.getCode()) {
            if (!this.checkFund()) {
                return;
            }
            this.setContent(DisklessTradeBuyPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.DIGIT2 == key.getCode()) {
            if (!this.checkFund()) {
                return;
            }
            this.setContent(DisklessTradeSellPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.DIGIT3 == key.getCode()) {
            this.setContent(DisklessUnfinishedOrderPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.DIGIT4 == key.getCode()) {
            this.setContent(DisklessOrderPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.DIGIT5 == key.getCode()) {
            this.setContent(DisklessPositionPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.DIGIT6 == key.getCode()) {
            this.setContent(DisklessDealPart.class, null, FunctionSelectBasic.class);
        } else if (KeyCode.F12 == key.getCode()) {
            this.of.getMainStage().fireEvent((Event)new WindowEvent((Window)this.stage, WindowEvent.WINDOW_CLOSE_REQUEST));
        } else if (KeyCode.UNDEFINED == key.getCode()) {
            this.checkRobot();
            if (this.robot == null) {
                return;
            }
            this.robot.keyPress(17);
            this.robot.keyPress(32);
            this.robot.keyRelease(32);
            this.robot.keyRelease(17);
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.showDiskLess();
        }
    }

    private void showDiskLess() {
        Stage stage = this.of.getMainStage();
        MEvent event = new MEvent();
        event.put((Object)"close_part", (Object)false);
        if (stage.isFullScreen()) {
            stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            stage.setFullScreenExitHint("\u6309Esc\u53ef\u9000\u51fa\u5168\u5c4f\u6a21\u5f0f");
            stage.setFullScreen(!stage.isFullScreen());
            this.es.sendEvent("close_menu", event);
            this.service.enableCursor(stage);
            this.service.showTopBottom(stage);
        }
    }

    private boolean checkFund() {
        if (this.accountMap.getFundAccList().size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u65e0\u53ef\u7528\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        return true;
    }

    private void checkRobot() {
        if (this.robot == null) {
            try {
                this.robot = new Robot();
            }
            catch (AWTException aWTException) {
                return;
            }
        }
    }

    private void setContent(Class<? extends ContentInterface> partClass, Object obj, Class<? extends ContentInterface> returnClass) {
        if (this.partMap.get(partClass) == null) {
            ContentInterface part = (ContentInterface)this.of.create(partClass);
            System.out.println("part create done");
            this.partMap.put(partClass, part);
        }
        ContentInterface cachePart = this.partMap.get(partClass);
        cachePart.setP(this.p);
        this.lbTitle.setText(cachePart.getName());
        this.lbHotKeyBook.setText(cachePart.getHotKeyBook());
        Platform.runLater(() -> {
            try {
                this.p.setCenter((Node)cachePart.getContent());
                System.out.println("setPart part done");
                this.currentContent = cachePart;
                cachePart.resetFocus();
                cachePart.setReturnClass(returnClass);
                if (obj != null) {
                    cachePart.sendMsgToPart(obj);
                }
                this.p.layout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

