/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.diskless;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.DisklessSettings;
import cms.tmx.web.service.IUserSettingsService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserPreCtrlDiskless {
    @Inject
    protected MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType = "5";
    private String menuId = "400001";
    private boolean autoSlice = false;
    private long maxSliceQty = 99999999L;
    private long commonQuantity = 0L;
    private static final Logger logger = LogManager.getLogger(UserPreCtrlDiskless.class);
    private MEventHandler reload = event -> this.doSet();

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.doSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    private void doSet() {
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof DisklessSettings) {
                DisklessSettings disklessSettings = (DisklessSettings)DisklessSettings.class.cast(settings);
                this.setAutoSlice(disklessSettings.isAutoSlice());
                this.setMaxSliceQty(disklessSettings.getSliceCountMax());
                this.setCommonQuantity(disklessSettings.getCommonQty());
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean isAutoSlice() {
        return this.autoSlice;
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSlice = autoSlice;
    }

    public long getMaxSliceQty() {
        return this.maxSliceQty;
    }

    public void setMaxSliceQty(long maxSliceQty) {
        this.maxSliceQty = maxSliceQty;
    }

    public long getCommonQty() {
        return this.commonQuantity;
    }

    public void setCommonQuantity(long commonQty) {
        this.commonQuantity = commonQty;
    }
}

