/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views.basket;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFilter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AvgQtyQueryParam;
import cms.tmx.entity.trade.DailyAvgQty;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.basket.BasketTrialCalAsset;
import cms.tmx.entity.trade.basket.BasketTrialCalQty;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.models.basket.TrialCalculateModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrialCalculateDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(TrialCalculateDialog.class);
    @FXML
    private TableView<BasketTrialCalAsset> tableAssetScale;
    @FXML
    private TableColumn<BasketTrialCalAsset, String> colAsSecId;
    @FXML
    private TableColumn<BasketTrialCalAsset, String> colAsSecName;
    @FXML
    private TableColumn<BasketTrialCalAsset, Number> colWeight;
    @FXML
    private TableColumn<BasketTrialCalAsset, Number> colNowPrice;
    @FXML
    private TableColumn<BasketTrialCalAsset, Number> colMinQty;
    @FXML
    private TableColumn<BasketTrialCalAsset, Number> colOrdAmt;
    @FXML
    private TableColumn<BasketTrialCalAsset, String> colUnit;
    @FXML
    private TableView<BasketTrialCalQty> tableAvgQty;
    @FXML
    private TableColumn<BasketTrialCalQty, String> colAvgSecId;
    @FXML
    private TableColumn<BasketTrialCalQty, String> colAvgSecName;
    @FXML
    private TableColumn<BasketTrialCalQty, Number> colBuyQty;
    @FXML
    private TableColumn<BasketTrialCalQty, Number> colSellQty;
    @FXML
    private TableColumn<BasketTrialCalQty, Number> colAvgCumQty;
    @FXML
    private TableColumn<BasketTrialCalQty, Number> colOrderScale;
    @FXML
    private ComboBox<String> comboStrategy;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private Button btnTrialAsset;
    @FXML
    private Button btnTrialQty;
    @FXML
    private Label lbTotalAmount;
    @FXML
    private Label trialExplain;
    @FXML
    private Label avgQtyTrialExplain;
    @FXML
    private TextField textDays;
    @FXML
    private CheckBox excludeSpecialDay;
    @FXML
    private ComboBox<MxNode> weightType;
    @FXML
    private TextField textDescPer;
    @Inject
    private TrialCalculateModel trialModel;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    private MxList<BasketTrialCalAsset> minAssetList = new MxList();
    private MxList<BasketTrialCalQty> minQtyList = new MxList();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.minAssetList.update(this.trialModel.getCalAssetBySide());
        this.minQtyList.update(this.trialModel.getMinQtyList());
        if (this.trialModel.isBuy()) {
            this.lbTotalAmount.setText(this.trialModel.getTotalBuyAmount() == 0.0 ? "" : BigDecimal.valueOf(Math.ceil(this.trialModel.getTotalBuyAmount())).toPlainString());
        } else {
            this.lbTotalAmount.setText(this.trialModel.getTotalSellAmount() == 0.0 ? "" : BigDecimal.valueOf(Math.ceil(this.trialModel.getTotalSellAmount())).toPlainString());
        }
        this.lbTotalAmount.setTooltip(new Tooltip(this.lbTotalAmount.getText()));
        this.tableAssetScale.refresh();
        this.tableAvgQty.refresh();
        this.tableAssetScale.sort();
        this.tableAvgQty.sort();
    });

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    @FXML
    public void initialize() {
        this.initCtrl();
        this.createAssetScaleTable();
        this.createAvgQtyTable();
        this.trialModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
    }

    private void initCtrl() {
        ObservableList strategyList = FxUtils.newList();
        strategyList.add((Object)"\u8d44\u91d1\u89c4\u6a21(\u6743\u91cd)");
        this.comboStrategy.setItems(strategyList);
        this.comboStrategy.getSelectionModel().select(0);
        this.comboStrategy.setDisable(true);
        ToggleGroup group = new ToggleGroup();
        this.radioBuy.setToggleGroup(group);
        this.radioSell.setToggleGroup(group);
        this.radioBuy.selectedProperty().addListener(this.lstnModel);
        this.radioSell.selectedProperty().addListener(this.lstnModel);
        this.radioBuy.setSelected(true);
        MxNode node = MxNodeFactory.create((String)"basket_desc_type");
        this.weightType.setItems(node.getNodes());
        this.weightType.getSelectionModel().select(1);
        this.weightType.setDisable(true);
        this.textDays.setTextFormatter(new TextFormatter((UnaryOperator)new MxFilter("[0-9]*", 2)));
        this.textDescPer.setTextFormatter(new TextFormatter((UnaryOperator)new MxFilter("[0-9]*", 2)));
        this.textDescPer.setText("0");
        this.trialModel.buyProperty().bindBidirectional((Property)this.radioBuy.selectedProperty());
        this.trialExplain.setTooltip(new Tooltip("\u8ba1\u7b97\u516c\u5f0f\u8bf4\u660e \uff1a\r\n \u83b7\u53d6\u6700\u5c0f\u59d4\u6258\u6570\u91cf\u54c1\u79cd\uff1a min\uff08\u6743\u91cd/\u6700\u65b0\u4ef7\uff09\r\n\u6700\u5c0f\u59d4\u6258\u8d44\u91d1\u89c4\u6a21=\u6700\u5c0f\u6570\u91cf\u54c1\u79cd\u6700\u65b0\u4ef7*100/\u8be5\u54c1\u79cd\u6743\u91cd\r\n \u5176\u4ed6\u54c1\u79cd\u59d4\u6258\u6570\u91cf=\u6700\u5c0f\u59d4\u6258\u8d44\u91d1\u89c4\u6a21*\u8be5\u54c1\u79cd\u6743\u91cd/\u6700\u65b0\u4ef7 (\u5411\u4e0b\u53d6\u6574\u624b)"));
        this.avgQtyTrialExplain.setTooltip(new Tooltip("\u8ba1\u7b97\u516c\u5f0f\u8bf4\u660e\uff1a\r\n \u65e5\u5747\u6210\u4ea4\u91cf= \u2211\u5f53\u65e5\u6743\u91cd*\u5f53\u65e5\u6210\u4ea4\u91cf / \u2211\u6bcf\u65e5\u6743\u91cd \uff1b\r\n\u6628\u65e5\u6743\u91cd\uff08T\u65e5\uff09=1 \uff1b T-1\u65e5\u6743\u91cd=T\u65e5\u6743\u91cd-\u9012\u51cf\u6bd4\u4f8b\uff1b\r\n \u9ed8\u8ba4\u503c0\uff0c\u8868\u793a\u6bcf\u65e5\u6743\u91cd\u76f8\u7b49"));
        this.btnTrialAsset.setOnMouseClicked(event -> this.trialAsset());
        this.btnTrialQty.setOnMouseClicked(event -> this.trialQty());
    }

    private void trialAsset() {
        this.trialModel.trialAsset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trialQty() {
        if (!this.checkAvgQty()) {
            return;
        }
        AvgQtyQueryParam avg = new AvgQtyQueryParam();
        avg.setDayNum(StringUtils.parseInt((String)this.textDays.getText()));
        avg.setWeight(StringUtils.parseInt((String)this.textDescPer.getText()));
        avg.setWeightType(2);
        avg.setMarketGrp("CCS");
        ArrayList refItems = new ArrayList();
        ObservableList observableList = this.minQtyList.getList();
        synchronized (observableList) {
            this.minQtyList.getList().forEach(item -> refItems.add(item.getRefItem()));
        }
        avg.setItems(refItems);
        Map<String, DailyAvgQty> trialQty = null;
        try {
            trialQty = this.trialModel.trialQty(avg);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bd5\u7b97\u51fa\u9519");
            logger.error("\u8bd5\u7b97\u51fa\u9519", (Throwable)e);
            return;
        }
        ObservableList observableList2 = this.minQtyList.getList();
        synchronized (observableList2) {
            for (BasketTrialCalQty item2 : this.minQtyList.getList()) {
                DailyAvgQty result = trialQty.get(String.valueOf(item2.getRefItem().getType()) + "," + item2.getRefItem().getMarket() + "," + item2.getRefItem().getCode());
                if (result == null) continue;
                item2.setAvgCumQty((double)result.getAvgQty());
                item2.setOrdScale(item2.getBuyQty() > 0.0 ? item2.getBuyQty() * 100.0 / item2.getAvgCumQty() : item2.getSellQty() / item2.getAvgCumQty());
            }
        }
        this.tableAvgQty.sort();
    }

    private boolean checkAvgQty() {
        if (StringUtils.isEmpty((String)this.textDays.getText()) || StringUtils.parseInt((String)this.textDays.getText()) <= 0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u586b\u5199\u9700\u8981\u8bd5\u7b97\u7684\u4ea4\u6613\u65e5\u6570");
            return false;
        }
        if (StringUtils.isEmpty((String)this.textDescPer.getText())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u586b\u5199\u8870\u51cf\u7cfb\u6570");
            return false;
        }
        return true;
    }

    public void create(List<BasketTradeItem> basketTradeItems) {
        this.trialModel.create(basketTradeItems);
    }

    @FXML
    public void copyAssetScale() {
        TableUtils.copyContentWithHead(this.tableAssetScale);
    }

    @FXML
    public void copyAvgQty() {
        TableUtils.copyContentWithHead(this.tableAvgQty);
    }

    @FXML
    public void refreshAssetScale() {
    }

    @FXML
    public void refreshAvgQty() {
    }

    @FXML
    public void exportAssetScale() {
        try {
            ExcelUtils.writeExcel(this.tableAssetScale, (String)"\u6700\u5c0f\u89c4\u6a21\u8bd5\u7b97");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void exportAvgQty() {
        try {
            ExcelUtils.writeExcel(this.tableAvgQty, (String)"\u5747\u91cf\u8bd5\u7b97");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createAssetScaleTable() {
        this.colAsSecId.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).secIdProperty());
        this.colAsSecName.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).secNameProperty());
        this.colWeight.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).weightProperty());
        this.colWeight.setCellFactory(p -> new DoubleTableCell());
        this.colNowPrice.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).nowPriceProperty());
        this.colNowPrice.setCellFactory(p -> new PriceCell());
        this.colMinQty.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).minQtyProperty());
        this.colMinQty.setCellFactory(p -> new ZeroCell());
        this.colOrdAmt.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).ordAmountProperty());
        this.colOrdAmt.setCellFactory(p -> new ZeroDoubleTableCell());
        this.colUnit.setCellValueFactory(data -> ((BasketTrialCalAsset)data.getValue()).unitProperty());
        this.tableAssetScale.setItems(this.minAssetList.getList());
        this.tableAssetScale.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAssetScale);
        this.colMinQty.setSortType(TableColumn.SortType.ASCENDING);
        this.tableAssetScale.getSortOrder().add(this.colMinQty);
        this.tableAssetScale.sort();
    }

    private void createAvgQtyTable() {
        this.colAvgSecId.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).secIdProperty());
        this.colAvgSecName.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).secNameProperty());
        this.colBuyQty.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).buyQtyProperty());
        this.colBuyQty.setCellFactory(cell -> new ZeroCell());
        this.colSellQty.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).sellQtyProperty());
        this.colSellQty.setCellFactory(cell -> new ZeroCell());
        this.colAvgCumQty.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).avgCumQtyProperty());
        this.colAvgCumQty.setCellFactory(cell -> new ZeroCell());
        this.colOrderScale.setCellValueFactory(data -> ((BasketTrialCalQty)data.getValue()).ordScaleProperty());
        this.colOrderScale.setCellFactory(p -> new OrderScaleTableCell());
        this.tableAvgQty.setItems(this.minQtyList.getList());
        this.tableAvgQty.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAvgQty);
        this.colOrderScale.setSortType(TableColumn.SortType.DESCENDING);
        this.tableAvgQty.getSortOrder().add(this.colOrderScale);
        this.tableAvgQty.sort();
    }

    public class OrderScaleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00000");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    if (item.doubleValue() == 0.0) {
                        this.setText(null);
                    } else {
                        this.setText(this.sDFPrice.format(item));
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class PriceCell
    extends EditTableCell<BasketTrialCalAsset> {
        double unit = 0.001;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                BasketTrialCalAsset bs = (BasketTrialCalAsset)BasketTrialCalAsset.class.cast(this.getTableRow().getItem());
                RefItem refItem = TrialCalculateDialog.this.refMng.getItem(bs.getSecType(), bs.getMarket(), bs.getSecId());
                if (refItem != null) {
                    this.unit = refItem.getPriceUnit();
                }
                this.setText(StringUtils.toPriceStr((double)item.doubleValue(), (double)this.unit));
            }
        }
    }

    private class ZeroCell<T>
    extends EditTableCell<T> {
        private ZeroCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null || item != null && item.longValue() == 0L) {
                    this.setText("");
                    return;
                }
                StringUtils.toThousands((String)String.valueOf(item), (int)0);
            }
        }
    }

    public class ZeroDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat("0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    if (item.doubleValue() == 0.0) {
                        this.setText(null);
                    } else {
                        this.setText(this.sDFPrice.format(item));
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }
}

