/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views.basket;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.IntegerStrConverter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.trade.models.basket.BasketInfo;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.trade.models.basket.BasketTradeModel;
import cms.tmx.trade.utils.BsCell;
import cms.tmx.trade.utils.ItemPriceCell;
import cms.tmx.trade.views.LoadPartModel;
import cms.tmx.trade.views.basket.BasketAccSetDialog;
import cms.tmx.trade.views.basket.BasketEntrustConfirmDialog;
import cms.tmx.trade.views.basket.TrialCalculateDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class BasketTradePart
extends MxPart {
    @Inject
    protected BasketTradeModel model;
    @Inject
    protected BasketMngModel basketMngModel;
    @FXML
    protected Button btnOrder;
    @FXML
    protected TableView<BasketTradeItem> tableItems;
    @FXML
    protected TableColumn<BasketTradeItem, Boolean> colSelected;
    @FXML
    protected TableColumn<BasketTradeItem, String> colCode;
    @FXML
    protected TableColumn<BasketTradeItem, String> colName;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colCount;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colAbWeight;
    @FXML
    protected TableColumn<BasketTradeItem, String> colUnit;
    @FXML
    protected TableColumn<BasketTradeItem, MxNode> colDirection;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colPct;
    @FXML
    protected TableColumn<BasketTradeItem, String> colState;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colBuyCount;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colBuyPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colSellCount;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colSellPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colPosition;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colCanSell;
    @FXML
    protected TableColumn<BasketTradeItem, CcsFundAccount> colAcc;
    @FXML
    protected TableColumn<BasketTradeItem, SecAccount> colSecAcc;
    @FXML
    protected TableColumn<BasketTradeItem, String> colBuy;
    @FXML
    protected TableColumn<BasketTradeItem, String> colSell;
    @FXML
    protected Label lbMoney;
    @FXML
    protected Tooltip tpAmt;
    @FXML
    protected Label lbAcc;
    @FXML
    protected Label lbCount;
    @FXML
    protected Label lbCountAll;
    @FXML
    protected Label lbCountUp;
    @FXML
    protected Label lbCountDown;
    @FXML
    protected Label lbCountStop;
    @FXML
    protected CheckBox cboxDown;
    @FXML
    protected CheckBox cboxUp;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Label lbAccContent;
    @FXML
    protected Label btnCalculate;
    @FXML
    protected CheckComboBox<CcsFundAccount> cmbAcc;
    @FXML
    protected ComboBox<Basket> cmbBasket;
    @FXML
    protected ComboBox<MxNode> cmbPrice;
    @FXML
    protected ComboBox<MxNode> cmbStg;
    @FXML
    protected RadioButton radioBuy;
    @FXML
    protected RadioButton radioSell;
    @FXML
    protected RadioButton radioBuySell;
    @FXML
    protected Spinner<Double> spinFloat;
    @FXML
    protected TextField txtCount;
    @FXML
    protected TextField txtMoney;
    @FXML
    protected TextField txtAssetPct;
    @FXML
    protected TextField txtCanBuyPct;
    @FXML
    protected TextField txtCanSellPct;
    @FXML
    protected TextField txtCountForAdj;
    @FXML
    protected HBox hboxMoney;
    @FXML
    protected HBox hboxAsset;
    @FXML
    protected HBox hboxCanBuy;
    @FXML
    protected HBox hboxCanSell;
    @FXML
    protected HBox hboxCount;
    @FXML
    protected HBox hboxCountForAdj;
    @FXML
    protected VBox vBoxAddition;
    @FXML
    protected CheckBox checkBoxUseInventory;
    @FXML
    protected CheckBox checkBoxSmartSell;
    @Inject
    private BasketInfo bi;
    @Inject
    protected CcsAccountMap accMng;
    private String accntSizeTip = "\u672a\u9009\u62e9\u8d26\u53f7";
    protected DoubleSpinnerCtrl ctrlFloat = new DoubleSpinnerCtrl(false, 6, 3);
    protected static final Logger logger = LogManager.getLogger(BasketTradePart.class);
    protected ObservableList<CcsFundAccount> listAccount = FxUtils.newList();
    private boolean hasRender = false;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected LoadPartModel load;
    @Inject
    private UserPreOrderTips setTips;
    private ListChangeListener<? super CcsFundAccount> lst = ob -> {
        this.lbAccContent.setText(this.cmbAcc.getCheckModel().getCheckedItems().toString().substring(1, this.cmbAcc.getCheckModel().getCheckedItems().toString().length() - 1));
        this.lbAccContent.setTooltip(new Tooltip(this.lbAccContent.getText()));
        this.onAccChange((ListChangeListener.Change<? extends CcsFundAccount>)ob);
    };
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;

    @Inject
    public BasketTradePart() {
    }

    @FXML
    public void initialize() {
        this.initCtrls();
        this.btnCalculate.setOnMouseClicked(event -> this.trialCalculate());
        this.tableItems.setPlaceholder((Node)new Label());
        this.renderBasket(this.refMng.doneProperty().get());
        this.refMng.doneProperty().addListener((ob, old, newV) -> Platform.runLater(() -> this.renderBasket((boolean)newV)));
        this.colSellCount.visibleProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.colSell.setVisible(true);
            }
        });
        this.colSellPrice.visibleProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.colSell.setVisible(true);
            }
        });
        this.colBuyPrice.visibleProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.colBuy.setVisible(true);
            }
        });
        this.colBuyCount.visibleProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.colBuy.setVisible(true);
            }
        });
    }

    private void trialCalculate() {
        if (!this.getAlert().check(this.model.getSelectedList().size() > 0, Alert.AlertType.WARNING, "\u6ca1\u6709\u6709\u6548\u7684\u6210\u5206\u80a1")) {
            return;
        }
        TrialCalculateDialog trialDialog = (TrialCalculateDialog)((Object)this.of.create(TrialCalculateDialog.class));
        MxDialog dialog = this.df.create((DialogObj)trialDialog, "\u7bee\u5b50\u8bd5\u7b97");
        trialDialog.create((List<BasketTradeItem>)this.model.getItems());
        dialog.launch();
    }

    protected void renderBasket(boolean done) {
        if (done && !this.hasRender) {
            this.hasRender = true;
            this.cmbBasket.getItems().setAll(this.basketMngModel.getList());
            this.getBi().basketProperty().bind((ObservableValue)this.cmbBasket.getSelectionModel().selectedItemProperty());
            if (!this.cmbBasket.getItems().isEmpty()) {
                this.cmbBasket.getSelectionModel().select(0);
            }
            this.cmbBasket.setOnMouseClicked(event -> {
                Basket lastBsk = (Basket)this.cmbBasket.getSelectionModel().getSelectedItem();
                this.cmbBasket.getItems().setAll(this.basketMngModel.getList());
                this.cmbBasket.getSelectionModel().select((Object)lastBsk);
            });
            this.createTable();
        }
    }

    protected void initCtrls() {
        this.initAcc();
        ToggleGroup group = new ToggleGroup();
        this.radioBuy.setToggleGroup(group);
        this.radioSell.setToggleGroup(group);
        this.radioBuySell.setToggleGroup(group);
        this.model.buyProperty().bindBidirectional((Property)this.radioBuy.selectedProperty());
        this.model.sellProperty().bindBidirectional((Property)this.radioSell.selectedProperty());
        this.model.buySellProperty().bindBidirectional((Property)this.radioBuySell.selectedProperty());
        this.bi.buyProperty().bind((ObservableValue)this.radioBuy.selectedProperty());
        this.bi.sellProperty().bind((ObservableValue)this.radioSell.selectedProperty());
        this.model.buyProperty().addListener((ob, oldV, newV) -> this.hideAndShow((boolean)newV));
        this.model.sellProperty().addListener((ob, oldV, newV) -> this.hideAndShow((boolean)newV));
        this.model.buySellProperty().addListener((ob, oldV, newV) -> this.hideAndShow((boolean)newV));
        group.selectedToggleProperty().addListener(ob -> this.onBsChange());
        this.radioBuy.setSelected(true);
        this.cmbPrice.setItems(this.model.getGear().getNodes());
        this.cmbPrice.getSelectionModel().select((Object)this.model.getGear());
        this.model.gearProperty().bind((ObservableValue)this.cmbPrice.getSelectionModel().selectedItemProperty());
        this.ctrlFloat.ctrl(this.spinFloat);
        SpinnerUtils.arrowsStyle(this.spinFloat);
        MxBindings.bindSDMinus((Property)this.spinFloat.getEditor().textProperty(), (Property)this.model.floatingProperty());
        this.spinFloat.getEditor().setText("");
        this.spinFloat.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            this.spinFloat.getEditor().setText("");
            return ((MxNode)this.cmbPrice.getSelectionModel().getSelectedItem()).getRaw().equals("11");
        }, (Observable[])new Observable[]{this.cmbPrice.getSelectionModel().selectedItemProperty()}));
        this.onUnit();
        this.model.pctUnitProperty().addListener(ob -> this.onUnit());
        this.lbUnit.getStyleClass().add((Object)"lbPercentYuan");
        this.cmbStg.setItems(this.model.getStg().getNodes());
        this.cmbStg.getSelectionModel().select((Object)this.model.getStg());
        this.cmbStg.valueProperty().bindBidirectional(this.model.stgProperty());
        this.hboxCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("1"), (Observable[])new Observable[]{this.model.stgProperty()}));
        MxBindings.bindSD((Property)this.txtCount.textProperty(), (Property)this.model.countBskProperty());
        this.txtCount.setTextFormatter(new TextFormatter((StringConverter)new IntegerStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 9, 2)));
        this.txtCount.setText(StringUtils.toPriceStr((String)this.txtCount.getText()));
        this.hboxCountForAdj.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("6"), (Observable[])new Observable[]{this.model.stgProperty()}));
        MxBindings.bindSD((Property)this.txtCountForAdj.textProperty(), (Property)this.model.countBskForAdgustProperty());
        this.txtCountForAdj.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 9, 2)));
        this.txtCountForAdj.setText(StringUtils.toPriceStr((String)this.txtCount.getText()));
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("2"), (Observable[])new Observable[]{this.model.stgProperty()}));
        MxBindings.bindSD((Property)this.txtMoney.textProperty(), (Property)this.model.moneyProperty());
        this.txtMoney.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtMoney.setText(StringUtils.toPriceStr((String)this.txtMoney.getText()));
        this.hboxAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("3"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.hboxCanBuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("4"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.hboxCanSell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("5"), (Observable[])new Observable[]{this.model.stgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtAssetPct);
        MxBindings.bindSD((Property)this.txtAssetPct.textProperty(), (Property)this.model.assetPctProperty());
        this.txtAssetPct.setText(StringUtils.toPriceStr((String)this.txtAssetPct.getText()));
        TextFieldUtils.setLess100((TextField)this.txtCanBuyPct);
        MxBindings.bindSD((Property)this.txtCanBuyPct.textProperty(), (Property)this.model.canBuyPctProperty());
        this.txtCanBuyPct.setText(StringUtils.toPriceStr((String)this.txtCanBuyPct.getText()));
        TextFieldUtils.setLess100((TextField)this.txtCanSellPct);
        MxBindings.bindSD((Property)this.txtCanSellPct.textProperty(), (Property)this.model.canSellPctProperty());
        this.txtCanSellPct.setText(StringUtils.toPriceStr((String)this.txtCanSellPct.getText()));
        this.checkBoxUseInventory.selectedProperty().bindBidirectional((Property)this.model.useInventoryProperty());
        this.checkBoxSmartSell.selectedProperty().bindBidirectional((Property)this.model.smartSellProperty());
        this.vBoxAddition.getChildren().remove((Object)this.checkBoxSmartSell);
        this.model.setBuy(true);
        MxBindings.bindSD((Property)this.lbMoney.textProperty(), (ObservableNumberValue)this.model.amountProperty(), (int)2);
        MxBindings.bindSD((Property)this.tpAmt.textProperty(), (ObservableNumberValue)this.model.amountProperty(), (int)2);
        MxBindings.bindSI((Property)this.lbCountAll.textProperty(), (Property)this.getBi().totalCountProperty());
        MxBindings.bindSI((Property)this.lbCount.textProperty(), (Property)this.model.numProperty());
        MxBindings.bindSI((Property)this.lbCountUp.textProperty(), (Property)this.getBi().upCountProperty());
        MxBindings.bindSI((Property)this.lbCountDown.textProperty(), (Property)this.getBi().downCountProperty());
        MxBindings.bindSI((Property)this.lbCountStop.textProperty(), (Property)this.getBi().stopCountProperty());
        Bindings.bindBidirectional((Property)this.cboxDown.selectedProperty(), (Property)this.model.filterDownProperty());
        Bindings.bindBidirectional((Property)this.cboxUp.selectedProperty(), (Property)this.model.filterUpProperty());
    }

    protected void initAcc() {
        this.getAccCheckBox().setVisible(true);
        this.getAccCheckLabel().setVisible(true);
        try {
            this.setListAccount((ObservableList<CcsFundAccount>)FXCollections.observableList(new LinkedList(this.accMng.getAccountMap().keySet())));
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.getAlert().alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u5931\u8d25");
        }
        this.cmbAcc.getItems().setAll(this.getListAccount());
        this.model.setAccList((ObservableList<CcsFundAccount>)this.cmbAcc.getCheckModel().getCheckedItems());
        this.cmbAcc.getCheckModel().getCheckedItems().addListener(this.lst);
        if (!this.cmbAcc.getItems().isEmpty()) {
            this.cmbAcc.getCheckModel().clearChecks();
        }
    }

    public void onAccChange(ListChangeListener.Change<? extends CcsFundAccount> change) {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(each -> this.model.addAccSecs((CcsFundAccount)each));
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(each -> this.model.removeAccSecs((CcsFundAccount)each));
        }
    }

    protected void onUnit() {
        if (this.model.isPctUnit()) {
            this.ctrlFloat.setScale(2);
            this.ctrlFloat.setLen(2);
            this.ctrlFloat.setMax(100.0);
            this.spinFloat.getEditor().setText("0.00");
            this.lbUnit.setText("%");
        } else {
            this.ctrlFloat.setScale(3);
            this.ctrlFloat.setLen(3);
            this.ctrlFloat.setMax(1000.0);
            this.ctrlFloat.ctrl(this.spinFloat);
            this.lbUnit.setText("\u5143");
            this.spinFloat.getEditor().setText("0.000");
        }
    }

    protected void onBsChange() {
        if (this.radioBuy.isSelected()) {
            this.btnOrder.setText("\u4e70\u5165");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else if (this.radioSell.isSelected()) {
            this.btnOrder.setText("\u5356\u51fa");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText("\u4e00\u952e\u4e70\u5356");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
    }

    @FXML
    protected void onFloatingUnit() {
        this.model.setPctUnit(!this.model.isPctUnit());
    }

    protected void createTable() {
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setEditable(true);
        this.colSelected.setEditable(true);
        this.colSelected.setCellFactory(m -> new BasketCheckBoxCell());
        this.colSelected.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).selectedProperty());
        this.colCode.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityIdProperty());
        this.colName.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityNameProperty());
        this.colCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().countProperty());
        this.colUnit.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().unitProperty());
        this.colAbWeight.setCellFactory(cell -> new ItemPriceCell(2, true));
        this.colAbWeight.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).abWeightProperty());
        this.colDirection.setCellFactory(cell -> new BsCell());
        this.colDirection.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).bsTradeProperty());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().nowPriceProperty() : new SimpleDoubleProperty(0.0));
        this.colPct.setCellFactory(cell -> new ItemFloatCell(2, true));
        this.colPct.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().pctProperty() : new SimpleDoubleProperty(0.0));
        this.colState.setCellFactory(cell -> new ItemStateCell());
        this.colState.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().statusProperty() : new SimpleStringProperty());
        this.colBuyCount.setCellFactory(cell -> new ItemCountCell(true));
        this.colBuyCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).buyCountProperty());
        this.colBuyPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colBuyPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).buyPriceProperty());
        this.colSellCount.setCellFactory(cell -> new ItemCountCell(false));
        this.colSellCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).sellCountProperty());
        this.colSellPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colSellPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).sellPriceProperty());
        this.colSell.setVisible(false);
        this.colPosition.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).positionProperty());
        this.colCanSell.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).canSellProperty());
        this.colAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).accProperty());
        this.colSecAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).secAccProperty());
        this.tableItems.setItems(this.model.getItems());
    }

    @FXML
    protected void order() {
        if (!this.getAlert().check(this.model.getAccList().size() > 0, Alert.AlertType.INFORMATION, this.getAccntSizeTip())) {
            return;
        }
        if (!this.getAlert().check(this.getBi().getBasket() != null, Alert.AlertType.WARNING, "\u672a\u9009\u62e9\u7bee\u5b50")) {
            return;
        }
        if (!this.getAlert().check(this.model.getSelectedList().size() > 0, Alert.AlertType.WARNING, "\u672a\u9009\u62e9\u6210\u4efd\u80a1")) {
            return;
        }
        if (!this.getAlert().check(this.model.getTotalQuantity() > 0L, Alert.AlertType.WARNING, "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5")) {
            return;
        }
        if (!this.getAlert().check(this.model.getAmount() > 0.0, Alert.AlertType.WARNING, "\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5")) {
            return;
        }
        BasketEntrustConfirmDialog obj = (BasketEntrustConfirmDialog)((Object)this.of.create(BasketEntrustConfirmDialog.class));
        obj.setList(this.model.getEntrustList());
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            try {
                this.model.entrust();
            }
            catch (MException e) {
                if (e.getCode() == 0) {
                    this.getAlert().check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, e.getMessage());
                } else {
                    this.getAlert().check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
                }
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    @FXML
    public void refresh() {
        this.getBi().refresh();
    }

    @FXML
    public void copy() {
        TableUtils.basketCopyContentWithTwoHead(this.tableItems, (int)0, (int)0, this.colAbWeight, this.colPct);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.basketWriteTwoHeadExcel(this.tableItems, (String)this.tableItems.getId(), (int)0, (int)0, this.colAbWeight, this.colPct);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void hideAndShow(boolean newV) {
        if (!newV) {
            return;
        }
        if (this.model.isBuy()) {
            this.colSell.visibleProperty().set(false);
            this.colBuy.visibleProperty().set(true);
            this.vBoxAddition.getChildren().remove((Object)this.checkBoxSmartSell);
            if (!this.vBoxAddition.getChildren().contains((Object)this.checkBoxUseInventory)) {
                this.vBoxAddition.getChildren().add((Object)this.checkBoxUseInventory);
            }
            this.tableItems.refresh();
            return;
        }
        if (this.model.isSell()) {
            this.colSell.visibleProperty().set(true);
            this.colBuy.visibleProperty().set(false);
            this.vBoxAddition.getChildren().remove((Object)this.checkBoxUseInventory);
            if (!this.vBoxAddition.getChildren().contains((Object)this.checkBoxSmartSell)) {
                this.vBoxAddition.getChildren().add((Object)this.checkBoxSmartSell);
            }
            return;
        }
        if (this.model.isBuySell()) {
            this.colSell.visibleProperty().set(true);
            this.colBuy.visibleProperty().set(true);
            if (!this.vBoxAddition.getChildren().contains((Object)this.checkBoxUseInventory)) {
                this.vBoxAddition.getChildren().add((Object)this.checkBoxUseInventory);
            }
            if (!this.vBoxAddition.getChildren().contains((Object)this.checkBoxSmartSell)) {
                this.vBoxAddition.getChildren().add((Object)this.checkBoxSmartSell);
            }
        }
    }

    @FXML
    public void setSecAcc() {
        BasketAccSetDialog obj = (BasketAccSetDialog)((Object)this.of.create(BasketAccSetDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9009\u62e9\u8bc1\u5238\u8d26\u53f7");
        obj.setFundList((List<CcsFundAccount>)this.getListAccount());
        obj.setSelectedFundList((List<CcsFundAccount>)this.cmbAcc.getCheckModel().getCheckedItems());
        obj.create();
        if (dialog.launch().equals(ButtonType.OK)) {
            this.cmbAcc.getCheckModel().clearChecks();
            this.model.getBasketAccSetModel().getSelectedMap().keySet().forEach(each -> this.cmbAcc.getCheckModel().check(each));
        }
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void setModel(BasketTradeModel basketTradeModel) {
        this.model = basketTradeModel;
    }

    public CheckComboBox<CcsFundAccount> getCmbAcc() {
        return this.cmbAcc;
    }

    public CheckComboBox<?> getAccCheckBox() {
        return this.cmbAcc;
    }

    public Label getAccCheckLabel() {
        return this.lbAcc;
    }

    public ObservableList<CcsFundAccount> getListAccount() {
        return this.listAccount;
    }

    public void setListAccount(ObservableList<CcsFundAccount> listAccount) {
        this.listAccount = listAccount;
    }

    public MxAlert getAlert() {
        return this.alert;
    }

    public void setAlert(MxAlert alert) {
        this.alert = alert;
    }

    public BasketInfo getBi() {
        return this.bi;
    }

    public void setBi(BasketInfo bi) {
        this.bi = bi;
    }

    public String getAccntSizeTip() {
        return this.accntSizeTip;
    }

    public void setAccntSizeTip(String accntSizeTip) {
        this.accntSizeTip = accntSizeTip;
    }

    protected class BasketCheckBoxCell
    extends TableCell<BasketTradeItem, Boolean> {
        protected BasketCheckBoxCell() {
        }

        public void updateItem(Boolean bFlag, boolean empty) {
            if (!empty) {
                CheckBox checkBox = new CheckBox();
                BasketTradeItem item = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
                if (item != null) {
                    checkBox.selectedProperty().bindBidirectional((Property)item.selectedProperty());
                    checkBox.disableProperty().bindBidirectional((Property)item.disabledProperty());
                    checkBox.setOnMouseClicked(event -> item.setManuallySelected(item.isSelected()));
                }
                this.setGraphic((Node)checkBox);
            } else {
                this.setGraphic(null);
            }
        }
    }

    protected class ItemCountCell
    extends TableCell<BasketTradeItem, Number> {
        protected boolean isBuy = true;

        ItemCountCell(boolean isBuy) {
            this.isBuy = isBuy;
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            BasketTradeItem item = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
            if (item != null && this.isBuy && !item.getBsTrade().getRaw().equals("49")) {
                this.setText(null);
                return;
            }
            if (item != null && !this.isBuy && item.getBsTrade().getRaw().equals("49")) {
                this.setText(null);
                return;
            }
            this.setText(value.toString());
        }
    }

    protected class ItemFloatCell
    extends TableCell<BasketTradeItem, Number> {
        protected int scale = 0;
        protected boolean isPercent = false;
        protected Label label = new Label();

        ItemFloatCell(int i, boolean isPercent) {
            this.scale = i;
            this.isPercent = isPercent;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty || value.doubleValue() == 0.0) {
                this.setGraphic(null);
                return;
            }
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
            this.label.setText(this.isPercent ? String.valueOf(text) + "%" : text);
            CssUtils.checkPct((Control)this.label, (double)value.doubleValue());
            this.setGraphic((Node)this.label);
        }
    }

    protected class ItemStateCell
    extends TableCell<BasketTradeItem, String> {
        private Label label = new Label();
        private static final String SEC_LIMIT_UP_STR = "\u6da8\u505c";
        private static final String SEC_LIMIT_DOWN_STR = "\u8dcc\u505c";

        public ItemStateCell() {
            CssUtils.priceTag((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty || value == null) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            if (value.equals(SEC_LIMIT_UP_STR)) {
                CssUtils.makeRise((Control)this.label);
            } else if (value.equals(SEC_LIMIT_DOWN_STR)) {
                CssUtils.makeFall((Control)this.label);
            } else {
                CssUtils.makeEven((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

