/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views.basket;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.utils.ImportExcel;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.models.basket.BasketItemModel;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.trade.utils.TradeUtils;
import cms.tmx.trade.views.basket.BasketInstructionsDialog;
import cms.tmx.trade.views.basket.BasketTempleteDownloadDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;

public class BasketMngPart
extends MxPart {
    @FXML
    private TableView<BasketItem> tableSecurity;
    @FXML
    private TableView<Basket> tableBasket;
    @FXML
    private TableColumn<String, String> colIndex;
    @FXML
    private TextField txtCode;
    @FXML
    private Button btnAddSec;
    @FXML
    private Button impBaskt;
    @FXML
    private Button expBaskt;
    @FXML
    private TableColumn<BasketItem, Number> colCount;
    @FXML
    private TableColumn<BasketItem, String> colUnit;
    @FXML
    private TableColumn<BasketItem, Number> colWeight;
    @FXML
    private TableColumn<BasketItem, Number> colAbsWeight;
    @FXML
    private TableColumn<BasketItem, Number> colPrice;
    @FXML
    private TableColumn<BasketItem, MxNode> colMarket;
    @FXML
    private TableColumn<BasketItem, String> colSecId;
    @FXML
    private TableColumn<BasketItem, String> colSecName;
    @FXML
    private TableColumn<Basket, Button> colDelBsk;
    @FXML
    private TableColumn<Basket, Button> colCopyBsk;
    @FXML
    private TableColumn<BasketItem, Button> colDel;
    @FXML
    private TableColumn<Basket, String> colBskName;
    @FXML
    private TableColumn<BasketItem, ComboBox<MxNode>> colBs;
    @FXML
    private Button btnSave;
    @Inject
    private BasketMngModel model;
    @Inject
    private BasketItemModel secModel;
    @Inject
    private MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    private static final Logger logger = LogManager.getLogger(BasketMngPart.class);
    private MxList<Basket> mxList = new MxList();
    private MxList<BasketItem> mxSecList = new MxList();
    private List<RefItem> refList = new LinkedList<RefItem>();
    private Map<String, RefItem> mapItem = new ConcurrentHashMap<String, RefItem>();
    private Basket newBsk = null;
    private boolean isNew = false;
    private SecConverter secCvt;
    private SecSuggest spCode = new SecSuggest();
    @Inject
    private IRefDataMng refMng;
    private double noWeight;
    private double buyWeight;
    private double sellWeight;
    private int addBasketNum = 1;
    private int copyBasketNum = 1;
    private boolean sameName;
    private final String UN_SAVED = "\u5f53\u524d\u7bee\u5b50\u6709\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58";
    private final String SAVE = "\u4fdd\u5b58";
    private final String UN_SAVE = "\u4e0d\u4fdd\u5b58";
    private final String CONFIRM_DELETE_BSK = "\u662f\u5426\u786e\u5b9a\u5220\u9664\u7bee\u5b50";
    private final String CONFIRM_DELETE_SEC = "\u662f\u5426\u786e\u5b9a\u5220\u9664\u6210\u4efd\u80a1";
    private final String XLSX = ".xlsx";
    private final String XLS = ".xls";
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private static final String DELIMITER = ",";
    @FXML
    private Label labName;
    @FXML
    private Label labSelectedBskName;
    @FXML
    private Label labSelectedBskCount;
    private long oldCount = 0L;
    private StringBuilder name;
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.update(this.model.getList());
        this.mxList.remove((MxObject)this.model.getTemporaryBasket());
        this.tableBasket.sort();
        this.tableBasket.refresh();
        if (this.isNew) {
            this.tableBasket.getSelectionModel().select((Object)this.newBsk);
            this.isNew = false;
        }
    });
    private InvalidationListener lstnSecModel = ob -> Platform.runLater(() -> {
        this.mxSecList.update(this.secModel.getSecList());
        this.labSelectedBskName.setText(this.getSelectedBasket().getName());
        this.labSelectedBskCount.setText("\u603b\u8ba1 " + this.getSelectedBasket().getList().size() + "\u6761");
        this.tableSecurity.sort();
        this.tableSecurity.refresh();
    });
    private InvalidationListener lstnRefItem = ob -> {
        this.refList.clear();
        this.mapItem.clear();
        this.spCode.clearSuggestions();
        this.initRefItem();
    };

    @FXML
    public void initialize() {
        this.btnSave.setDisable(true);
        this.model.changedProperty().addListener(this.lstnModel);
        this.secModel.changedProperty().addListener(this.lstnSecModel);
        this.createBasketTableView();
        this.createStockTableView();
        this.mxList.update(this.model.getList());
        this.mxList.remove((MxObject)this.model.getTemporaryBasket());
        this.initTxtCode();
        this.refMng.changedProperty().addListener(this.lstnRefItem);
        this.btnSave.setOnAction(event -> this.save(this.getSelectedBasket(), true));
        this.btnAddSec.setOnMouseClicked(event -> this.addStock(this.txtCode.getText()));
        ObservableList<Basket> bList = this.model.getList();
        if (!bList.isEmpty()) {
            this.tableBasket.getSelectionModel().select((Object)((Basket)bList.get(0)));
        }
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.lstnRefItem);
        this.model.changedProperty().removeListener(this.lstnModel);
        this.secModel.changedProperty().removeListener(this.lstnSecModel);
    }

    private Basket getSelectedBasket() {
        return (Basket)this.tableBasket.getSelectionModel().getSelectedItem();
    }

    private void initTxtCode() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.initRefItem();
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange((String)newV));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addStock(this.txtCode.getText());
            }
        });
    }

    private void initRefItem() {
        Collection items = this.refMng.getItems(new String[]{"STOCK", "FUND", "BOND", "STOCKSHSC", "STOCKSZSC"});
        this.refList.addAll(items);
        this.spCode.addPossibleSuggestions(this.refList);
        for (RefItem item : this.refList) {
            String key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode());
            RefItem ref = this.mapItem.get(key);
            if (ref != null) continue;
            this.mapItem.put(key, item);
        }
    }

    protected void onSecurityChange(String newText) {
        RefItem ref = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            ref = (RefItem)RefItem.class.cast(obj);
        }
        if (ref != null) {
            this.labName.setText(ref.getName());
        }
        if (newText.length() >= 6 && (ref == null || "".equals(ref.getName()))) {
            this.labName.setText(INVALID_CODE);
        }
        if (this.txtCode.getText().length() == 0) {
            this.labName.setText("");
        }
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            RefItem ref = null;
            Object obj = this.txtCode.getUserData();
            if (obj instanceof RefItem) {
                ref = (RefItem)RefItem.class.cast(obj);
            }
            if (ref == null || "".equals(ref.getName())) {
                this.labName.setText(INVALID_CODE);
            }
        }
    }

    private void addStock(String strStock) {
        if (this.getSelectedBasket() == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u7bee\u5b50");
            return;
        }
        if (strStock == null || "".equals(strStock.trim())) {
            return;
        }
        RefItem ref = null;
        BasketItem basketItem = new BasketItem();
        Object obj = this.txtCode.getUserData();
        basketItem.setSecurityId(strStock);
        if (obj instanceof RefItem) {
            ref = (RefItem)RefItem.class.cast(obj);
            if (this.txtCode.getText().equals(ref.getCode())) {
                basketItem.getMarket().setRaw(ref.getMarket());
                basketItem.setSecurityName(ref.getName());
                basketItem.setSecurityType(ref.getType());
                basketItem.setUnit(TradeUtils.getUnitBySecTypeAndMarket(basketItem.getSecurityType(), basketItem.getMarket().getRaw()));
            }
        }
        if (StringUtils.isEmpty((String)basketItem.getMarket().getValue()) || StringUtils.isEmpty((String)basketItem.getSecurityName())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bc1\u5238\u4ee3\u7801\u4e0d\u5408\u6cd5\u6216\u884c\u60c5\u4e0d\u6b63\u5e38");
            return;
        }
        if (this.getItem(strStock, basketItem.getMarket().getRaw(), basketItem.getSecurityType()) != null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u4e0d\u5141\u8bb8\u6dfb\u52a0\u91cd\u590d\u6210\u4efd\u80a1");
            this.txtCode.setText("");
            this.labName.setText("");
            return;
        }
        boolean isStar = ref != null && ref.getCode().startsWith("688");
        boolean isHk = ref != null && ("SHSC".equals(ref.getMarket()) || "SZSC".equals(ref.getMarket()));
        basketItem.setCount(100L);
        basketItem.getBs().setRaw("0");
        basketItem.setWeight(1.0);
        basketItem.setId(this.secModel.getSecList().size() + 1);
        this.secModel.getSecList().add(basketItem);
        this.changeWeight();
        this.secModel.changed();
        this.getSelectedBasket().setUnModified(false);
        this.txtCode.setText("");
        this.labName.setText("");
        if (isStar) {
            basketItem.setCount(200L);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u60a8\u6dfb\u52a0\u7684\u662f\u79d1\u521b\u677f\u80a1\u7968\uff0c\u6839\u636e\u79d1\u521b\u677f\u6700\u5c0f\u4ea4\u6613\u6570\u91cf\u4e3a200\u80a1\u7684\u89c4\u5b9a\uff0c\u9ed8\u8ba4\u6837\u672c\u6570\u91cf\u4e3a200\uff0c\u60a8\u53ef\u4ee5\u624b\u5de5\u8c03\u6574\u6837\u672c\u6570\u91cf");
        }
        if (isHk) {
            basketItem.setCount((long)ref.getBuyUnit());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u60a8\u6dfb\u52a0\u7684\u662f\u6e2f\u80a1\u901a\u80a1\u7968\uff0c\u6839\u636e\u5f53\u524d\u80a1\u7968\u6700\u5c0f\u4ea4\u6613\u6570\u91cf\u4e3a" + ref.getBuyUnit() + "\u80a1\u7684\u89c4\u5b9a\uff0c\u9ed8\u8ba4\u6837\u672c\u6570\u91cf\u4e3a" + ref.getBuyUnit() + "\uff0c\u60a8\u53ef\u4ee5\u624b\u5de5\u8c03\u6574\u6837\u672c\u6570\u91cf");
        }
    }

    public BasketItem getItem(String code, String market, String type) {
        for (BasketItem item : this.secModel.getSecList()) {
            if (!item.getSecurityId().equals(code) || !item.getMarket().getRaw().equals(market) || !type.equals(item.getSecurityType())) continue;
            return item;
        }
        return null;
    }

    public void changeWeight() {
        this.noWeight = 0.0;
        this.buyWeight = 0.0;
        this.sellWeight = 0.0;
        this.secModel.getSecList().forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    this.buyWeight += item.getWeight();
                    break;
                }
                case "50": {
                    this.sellWeight += item.getWeight();
                    break;
                }
                default: {
                    this.noWeight += item.getWeight();
                }
            }
        });
        this.secModel.getSecList().forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    if (this.buyWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.buyWeight * 100.0);
                    item.setAbsWeight(abs);
                    break;
                }
                case "50": {
                    if (this.sellWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.sellWeight * 100.0);
                    item.setAbsWeight(abs);
                    break;
                }
                default: {
                    if (this.noWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.noWeight * 100.0);
                    item.setAbsWeight(abs);
                }
            }
            item.weightProperty().addListener(ob -> this.listenWeight(this.secModel.getSecList()));
            item.bsProperty().addListener(ob -> this.listenWeight(this.secModel.getSecList()));
        });
    }

    private void listenWeight(List<BasketItem> list) {
        this.noWeight = 0.0;
        this.buyWeight = 0.0;
        this.sellWeight = 0.0;
        list.forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    this.buyWeight += item.getWeight();
                    break;
                }
                case "50": {
                    this.sellWeight += item.getWeight();
                    break;
                }
                default: {
                    this.noWeight += item.getWeight();
                }
            }
        });
        list.forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    if (this.buyWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.buyWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                    break;
                }
                case "50": {
                    if (this.sellWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.sellWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                    break;
                }
                default: {
                    if (this.noWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.noWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                }
            }
        });
    }

    @FXML
    public void newBasket() {
        try {
            Basket basket = new Basket();
            this.name = new StringBuilder("\u81ea\u5b9a\u4e49\u7bee\u5b50").append(this.addBasketNum++);
            ObservableList<Basket> bList = this.model.getList();
            bList.forEach(each -> {
                if (this.name.toString().equals(each.getName())) {
                    this.name = new StringBuilder("\u81ea\u5b9a\u4e49\u7bee\u5b50").append(this.addBasketNum++);
                }
            });
            basket.setName(this.name.toString());
            this.newBsk = this.model.createBasket(basket);
            this.isNew = true;
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u81ea\u5b9a\u4e49\u7bee\u5b50\u5931\u8d25");
                logger.error("\u81ea\u5b9a\u4e49\u7bee\u5b50\u7bee\u5b50\u5931\u8d25" + e.getMessage(), (Throwable)e);
            });
        }
    }

    private void createBasketTableView() {
        this.tableBasket.setEditable(true);
        this.colBskName.setCellFactory(pw -> new MxEditTableCell());
        this.colBskName.setCellValueFactory(data -> ((Basket)data.getValue()).nameProperty());
        this.colBskName.setEditable(true);
        this.colDelBsk.setCellValueFactory(data -> this.deleteBasket((TableColumn.CellDataFeatures<Basket, Button>)data));
        this.colCopyBsk.setCellValueFactory(data -> this.copyBsk((TableColumn.CellDataFeatures<Basket, Button>)data));
        this.tableBasket.setItems(this.mxList.getList());
        this.tableBasket.setPlaceholder((Node)new Label());
        this.tableBasket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onBskChange((Basket)old, (Basket)now));
        this.colBskName.addEventHandler(TableColumn.editCommitEvent(), handler -> {
            String newValue = handler.getNewValue().toString().trim();
            String oldValue = handler.getOldValue().toString();
            Basket bskt = (Basket)handler.getRowValue();
            if (newValue.chars().count() == 0L) {
                try {
                    throw new MException(0, "\u7bee\u5b50\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                catch (MException e) {
                    Platform.runLater(() -> {
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                    });
                    return;
                }
            }
            if (bskt != null && newValue.chars().count() > 0L && newValue.chars().count() < 20L) {
                ObservableList<Basket> bList = this.model.getList();
                this.sameName = false;
                bList.forEach(each -> {
                    if (newValue.equals(each.getName()) && bskt != each) {
                        try {
                            this.sameName = true;
                            throw new MException(0, "\u7bee\u5b50\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u7bee\u5b50\u540d\u79f0");
                        }
                        catch (MException e) {
                            Platform.runLater(() -> {
                                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                                logger.error(e.getMessage(), (Throwable)e);
                                try {
                                    bskt.setName(oldValue);
                                    this.newBsk = bskt;
                                    this.isNew = true;
                                    this.model.update(bskt);
                                }
                                catch (MException mException2) {
                                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                            });
                            return;
                        }
                    }
                });
                if (!this.sameName) {
                    try {
                        bskt.setName(newValue);
                        this.model.update(bskt);
                    }
                    catch (MException e) {
                        bskt.setName(oldValue);
                        Platform.runLater(() -> {
                            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                            logger.error(e.getMessage(), (Throwable)e);
                        });
                    }
                }
            }
        });
    }

    private void onBskChange(Basket oldBsk, Basket newBsk) {
        if (oldBsk != null && !oldBsk.isUnModified()) {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5f53\u524d\u7bee\u5b50\u6709\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58", "\u4fdd\u5b58", "\u4e0d\u4fdd\u5b58")) {
                this.save(oldBsk, false);
            }
            oldBsk.setUnModified(true);
        }
        if (newBsk != null) {
            this.exe.execute(() -> {
                try {
                    this.secModel.queryItems(newBsk);
                }
                catch (MException e) {
                    logger.error("\u67e5\u8be2\u6210\u4efd\u80a1\u5931\u8d25", (Throwable)e);
                }
            });
        }
        if (this.getSelectedBasket() == null) {
            this.tableSecurity.getItems().clear();
            this.mxSecList.clear();
            return;
        }
        if (oldBsk != null) {
            MxBindings.bindBidirectionalBoolean((Property)this.btnSave.disableProperty(), (Property)oldBsk.unModifiedProperty(), (Property)this.getSelectedBasket().unModifiedProperty());
        } else {
            this.btnSave.disableProperty().bindBidirectional((Property)this.getSelectedBasket().unModifiedProperty());
        }
    }

    private void createStockTableView() {
        this.tableSecurity.setPlaceholder((Node)new Label());
        this.tableSecurity.setItems(this.mxSecList.getList());
        this.colIndex.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(this.tableSecurity.getItems().indexOf(data.getValue()) + 1)));
        this.colSecId.setCellValueFactory(data -> ((BasketItem)data.getValue()).securityIdProperty());
        this.colMarket.setCellValueFactory(data -> ((BasketItem)data.getValue()).marketProperty());
        this.colSecName.setCellValueFactory(data -> ((BasketItem)data.getValue()).securityNameProperty());
        this.colBs.setCellValueFactory(data -> this.setCombobox((TableColumn.CellDataFeatures<BasketItem, ComboBox<MxNode>>)data));
        this.colPrice.setCellValueFactory(data -> ((BasketItem)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colUnit.setCellValueFactory(data -> ((BasketItem)data.getValue()).unitProperty());
        this.colAbsWeight.setCellValueFactory(data -> ((BasketItem)data.getValue()).absWeightProperty());
        this.colAbsWeight.setCellFactory(column -> new AbsWeightCell());
        this.colCount.setCellValueFactory(data -> ((BasketItem)data.getValue()).countProperty());
        this.colCount.setCellFactory(p -> new NumberCell(0));
        this.colWeight.setCellValueFactory(data -> ((BasketItem)data.getValue()).weightProperty());
        this.colWeight.setCellFactory(p -> new Weight(4));
        this.colDel.setCellValueFactory(data -> this.deleteBtn((TableColumn.CellDataFeatures<BasketItem, Button>)data));
        this.tableSecurity.setEditable(true);
        this.colWeight.addEventHandler(TableColumn.editCommitEvent(), event -> {
            double oldValue;
            double newValue = (Double)event.getNewValue();
            if (newValue != (oldValue = ((Double)event.getOldValue()).doubleValue())) {
                this.getSelectedBasket().setUnModified(false);
            }
        });
        this.colCount.addEventHandler(TableColumn.editCommitEvent(), event -> {
            long oldValue;
            long newValue = (long)Double.parseDouble(event.getNewValue().toString());
            if (newValue != (oldValue = (long)Double.parseDouble(event.getOldValue().toString()))) {
                this.getSelectedBasket().setUnModified(false);
            }
        });
        this.colPrice.addEventHandler(TableColumn.editCommitEvent(), event -> {
            double oldValue;
            double newValue = (Double)event.getNewValue();
            if (newValue != (oldValue = ((Double)event.getOldValue()).doubleValue())) {
                this.getSelectedBasket().setUnModified(false);
            }
        });
    }

    private void save(Basket bsk, boolean isOld) {
        try {
            if (bsk == null) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u7bee\u5b50");
                return;
            }
            int undefinedCount = 0;
            int priceCount = 0;
            for (BasketItem item : this.secModel.getSecList()) {
                if ("0".equals(item.getBs().getRaw())) {
                    ++undefinedCount;
                }
                if (item.getPrice() != 0.0) continue;
                ++priceCount;
            }
            if (undefinedCount > 0 && undefinedCount != this.secModel.getSecList().size()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u6210\u4efd\u80a1\u4e70\u5356\u65b9\u5411\u8bf7\u5168\u90e8\u9650\u5b9a\u6216\u5168\u90e8\u4e0d\u9650\u5b9a");
                return;
            }
            if (priceCount > 0 && priceCount != this.secModel.getSecList().size()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u6307\u5b9a\u4ef7\u683c\u4ea4\u6613\u6a21\u5f0f\u9700\u6307\u5b9a\u5168\u90e8\u54c1\u79cd\u4ef7\u683c");
                return;
            }
            this.secModel.updateItems(bsk, this.secModel.getSecList());
            this.model.changed();
            for (Basket basket : this.model.getList()) {
                if (!bsk.getId().equals(basket.getId())) continue;
                this.exe.execute(() -> {
                    try {
                        this.secModel.queryItems(basket);
                    }
                    catch (MException e) {
                        logger.error("\u67e5\u8be2\u6210\u4efd\u80a1\u5931\u8d25", (Throwable)e);
                    }
                });
            }
            bsk.setUnModified(true);
            if (isOld) {
                this.exe.execute(() -> {
                    try {
                        this.secModel.queryItems(bsk);
                    }
                    catch (MException e) {
                        logger.error("\u67e5\u8be2\u6210\u4efd\u80a1\u5931\u8d25", (Throwable)e);
                    }
                });
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            bsk.setUnModified(false);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void refreshBsk() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u7bee\u5b50\u5931\u8d25", (Throwable)e);
            }
        });
    }

    @FXML
    public void copySec() {
        if (this.tableSecurity.getItems() == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6210\u4efd\u80a1\u4e3a\u7a7a");
            return;
        }
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.colSecId.getText()) + "\t" + this.colSecName.getText() + "\t" + this.colMarket.getText() + "\t" + this.colCount.getText() + "\t" + this.colUnit.getText() + "\t" + this.colBs.getText() + "\t" + this.colWeight.getText() + "\t" + this.colAbsWeight.getText() + "\t" + this.colPrice.getText() + "\t" + '\n');
        for (BasketItem item : this.tableSecurity.getItems()) {
            String side = item.getBs().getRaw();
            if ("49".equals(side)) {
                side = "buy";
            } else if ("50".equals(side)) {
                side = "sell";
            } else if ("0".equals(side)) {
                side = "";
            }
            clipboardString.append(String.valueOf(item.getSecurityId()) + "\t" + item.getSecurityName() + "\t" + item.getMarket().getRaw() + "\t" + item.getCount() + "\t" + item.getUnit() + "\t" + side + "\t" + item.getWeight() + "\t" + item.getAbsWeight() + "\t" + item.getPrice() + "\t" + '\n');
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    @FXML
    public void refreshSec() {
        if (this.tableBasket.getItems().size() == 0) {
            logger.error("\u65e0\u7bee\u5b50\uff0c\u4e0d\u5237\u65b0\u6210\u5206\u80a1\u3002");
            return;
        }
        if (this.getSelectedBasket() == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u7bee\u5b50");
            return;
        }
        this.exe.execute(() -> {
            try {
                this.secModel.queryItems(this.getSelectedBasket());
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u6210\u4efd\u80a1\u5931\u8d25", (Throwable)e);
            }
        });
    }

    @FXML
    public void exportBasket() {
        if (!this.getSelectedBasket().isUnModified()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u5148\u4fdd\u5b58\u7bee\u5b50");
            return;
        }
        if (this.tableSecurity.getItems() == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6210\u4efd\u80a1\u4e3a\u7a7a");
            return;
        }
        try {
            boolean isSuccess = BasketMngPart.writeMxNodeExcel(this.tableSecurity, this.getSelectedBasket().getName(), 1, this.tableSecurity.getColumns().size() - 2);
            if (isSuccess) {
                this.alert.alert(Alert.AlertType.INFORMATION, "\u5bfc\u51fa\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public static <T> boolean writeMxNodeExcel(TableView<T> table, String name, int from, int to) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFRow row = null;
        row = spreadsheet.createRow(0);
        HSSFCellStyle cellStyleText = workbook.createCellStyle();
        HSSFDataFormat format = workbook.createDataFormat();
        cellStyleText.setDataFormat(format.getFormat("@"));
        int i = 0;
        while (i < to - from + 1) {
            spreadsheet.setDefaultColumnStyle(i, (CellStyle)cellStyleText);
            ++i;
        }
        int j = from;
        while (j < to + 1) {
            row.createCell(j - from).setCellValue(((TableColumn)table.getColumns().get(j)).getText());
            ++j;
        }
        i = 1;
        while (i < table.getItems().size() + 1) {
            row = spreadsheet.createRow(i);
            int j2 = from;
            while (j2 < to + 1) {
                Object ob = ((TableColumn)table.getColumns().get(j2)).getCellData(i - 1);
                if (ob == null) {
                    throw new Exception("\u8868\u683c\u4e0d\u80fd\u6709\u7a7a\u767d\u5217");
                }
                if (ob.getClass().equals(Button.class)) {
                    row.createCell(j2 - from).setCellValue(((Button)ob).getText());
                } else if (ob.getClass().equals(ComboBox.class)) {
                    String value = ((MxNode)((ComboBox)ob).getValue()).getRaw();
                    if ("49".equals(value)) {
                        value = "buy";
                    } else if ("50".equals(value)) {
                        value = "sell";
                    } else if ("0".equals(value)) {
                        value = "";
                    }
                    row.createCell(j2 - from).setCellValue(value);
                } else if (ob.getClass().equals(MxNode.class)) {
                    row.createCell(j2 - from).setCellValue(((MxNode)ob).getRaw());
                } else if (ob.getClass().equals(Double.class)) {
                    row.createCell(j2 - from).setCellValue(((Double)ob).doubleValue());
                } else {
                    row.createCell(j2 - from).setCellValue(ob.toString());
                }
                ++j2;
            }
            ++i;
        }
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{".xls"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName(name);
        File file = chooser.showSaveDialog(null);
        boolean isSuccess = false;
        FileOutputStream out = null;
        try {
            if (file != null) {
                out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
                isSuccess = true;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        return isSuccess;
    }

    @FXML
    public void basketInstructions() {
        BasketInstructionsDialog obj = (BasketInstructionsDialog)((Object)this.of.create(BasketInstructionsDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4f7f\u7528\u8bf4\u660e");
        dialog.launch();
    }

    private void copyBasket() {
        if (this.getSelectedBasket() == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u7bee\u5b50");
            return;
        }
        try {
            Basket baseBasket = this.getSelectedBasket();
            Basket subBasket = new Basket();
            this.copyBasketNum = 1;
            this.name = new StringBuilder(baseBasket.getName()).append(this.copyBasketNum++);
            ObservableList<Basket> bList = this.model.getList();
            bList.forEach(each -> {
                if (this.name.toString().equals(each.getName())) {
                    this.name = new StringBuilder(baseBasket.getName()).append(this.copyBasketNum++);
                }
            });
            subBasket.setName(this.name.toString());
            this.newBsk = this.model.createBasket(subBasket);
            this.isNew = true;
            this.secModel.updateItems(this.newBsk, (List<BasketItem>)baseBasket.getList());
            for (Basket basket1 : this.model.getList()) {
                if (!this.newBsk.getId().equals(basket1.getId())) continue;
                this.exe.execute(() -> {
                    try {
                        this.secModel.queryItems(basket1);
                    }
                    catch (MException e) {
                        logger.error("\u67e5\u8be2\u6210\u4efd\u80a1\u5931\u8d25", (Throwable)e);
                    }
                });
            }
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u62f7\u8d1d\u7bee\u5b50\u5931\u8d25");
                logger.error("\u62f7\u8d1d\u7bee\u5b50\u5931\u8d25" + e.getMessage(), (Throwable)e);
            });
        }
    }

    @FXML
    public void importBasket() {
        try {
            if (this.getSelectedBasket() == null) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u7bee\u5b50");
                return;
            }
            FileChooser chooser = new FileChooser();
            File file = chooser.showOpenDialog(null);
            if (file == null) {
                return;
            }
            this.checkAndImport(file);
            this.getSelectedBasket().setUnModified(false);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.tableSecurity.refresh();
    }

    private void checkAndImport(File file) throws Exception {
        if (!file.getPath().endsWith(".xlsx") && !file.getPath().endsWith(".xls")) {
            throw new Exception("\u7bee\u5b50\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List basketItemList = ImportExcel.read((String)file.getPath());
        if (basketItemList == null) {
            throw new Exception("\u7bee\u5b50\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
        }
        if (!basketItemList.isEmpty()) {
            basketItemList.remove(0);
        }
        HashSet<String> stkCodeSet = new HashSet<String>();
        Basket basket = (Basket)this.of.create(Basket.class);
        int nullRows = 0;
        int num = 1;
        int j = 0;
        while (j < basketItemList.size()) {
            int nullRow = 0;
            for (String str : (List)basketItemList.get(j)) {
                if (str != null && !"".equals(str.trim())) continue;
                ++nullRow;
            }
            if (nullRow == ((List)basketItemList.get(j)).size()) {
                ++nullRows;
            } else {
                BasketItem item = new BasketItem();
                item.getBs().setRaw("0");
                item.setId(num++);
                int i = 0;
                while (i < ((List)basketItemList.get(j)).size()) {
                    String value = (String)((List)basketItemList.get(j)).get(i);
                    switch (i) {
                        case 0: {
                            if ("".equals(value.trim())) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801\u4e3a\u7a7a");
                            }
                            if (!StringUtils.isNumeric((String)value)) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801 " + value + "\u9519\u8bef");
                            }
                            item.setSecurityId(value);
                            break;
                        }
                        case 2: {
                            boolean flag;
                            boolean bl = flag = "".equals(value) || !"XSHG".equals(value) && !"XSHE".equals(value) && !"SHSC".equals(value) && !"SZSC".equals(value);
                            if (flag) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u5e02\u573a\u4ee3\u7801\u9519\u8bef");
                            }
                            String key = String.join((CharSequence)DELIMITER, value, item.getSecurityId());
                            RefItem ref = this.mapItem.get(key);
                            if (ref == null) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + value + "\u8be5\u54c1\u79cd\u4e0d\u5b58\u5728");
                            }
                            item.getMarket().setRaw(value);
                            item.setSecurityType(ref.getType());
                            item.setUnit(TradeUtils.getUnitBySecTypeAndMarket(ref.getType(), ref.getMarket()));
                            item.setSecurityName(ref.getName());
                            stkCodeSet.add(String.valueOf(item.getSecurityId()) + "_" + value);
                            break;
                        }
                        case 3: {
                            boolean len;
                            BigDecimal b1;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b1 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u6210\u4efd\u80a1\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d");
                            }
                            value = b1.toString();
                            boolean isDouble = StringUtils.isDouble((String)value);
                            if (isDouble) {
                                if (Double.parseDouble(value) % 1.0 > 0.0) {
                                    isDouble = false;
                                }
                                value = String.valueOf(StringUtils.parseLong((String)value));
                            }
                            boolean ntn = StringUtils.isInt((String)value);
                            boolean bl = len = value.length() > 9;
                            if (!isDouble || len || !ntn) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u6210\u4efd\u80a1\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d");
                            }
                            item.setCount(StringUtils.parseLong((String)value));
                            break;
                        }
                        case 5: {
                            if ("".equals(value)) {
                                value = "0";
                            }
                            if ("buy".equals(value)) {
                                value = "49";
                            } else if ("sell".equals(value)) {
                                value = "50";
                            } else if ("0".equals(value)) {
                                value = "0";
                            } else {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u4e70\u5356\u65b9\u5411\u5fc5\u987b\u4e3a(buy)\u3001(sell)\u3001(\"\")");
                            }
                            item.getBs().setRaw(value);
                            break;
                        }
                        case 6: {
                            if ("".equals(value)) {
                                value = "0";
                            }
                            if (!StringUtils.isDouble((String)value)) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u6210\u4efd\u80a1\u76f8\u5bf9\u6743\u91cd\u5fc5\u987b\u4e3a\u6570\u503c");
                            }
                            if (StringUtils.getScale((String)value) > 4) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u6210\u4efd\u80a1\u76f8\u5bf9\u6743\u91cd\u8d85\u8fc74\u4f4d\u5c0f\u6570");
                            }
                            item.setWeight(StringUtils.parseDouble((String)StringUtils.toStr((double)Double.valueOf(value), (int)4)));
                            break;
                        }
                        case 8: {
                            if ("".equals(value)) {
                                value = "0";
                            }
                            if (!StringUtils.isDouble((String)value)) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + item.getSecurityId() + " \u6210\u4efd\u80a1\u4ef7\u683c\u5fc5\u987b\u4e3a\u6570\u5b57");
                            }
                            String key1 = String.join((CharSequence)DELIMITER, item.getMarket().getRaw(), item.getSecurityId());
                            RefItem ref1 = this.mapItem.get(key1);
                            item.setPrice(StringUtils.parseDouble((String)StringUtils.toStr((double)Double.valueOf(value), (int)ref1.getScale())));
                            break;
                        }
                    }
                    ++i;
                }
                basket.getList().add((Object)item);
            }
            ++j;
        }
        if (stkCodeSet.size() < basketItemList.size() - nullRows) {
            throw new Exception("\u7bee\u5b50\u5bfc\u5165\u5931\u8d25 \u6210\u4efd\u80a1\u91cd\u590d");
        }
        this.secModel.getSecList().clear();
        this.secModel.getSecList().addAll((Collection<BasketItem>)basket.getList());
        this.changeWeight();
        this.secModel.changed();
    }

    private ReadOnlyObjectWrapper<ComboBox<MxNode>> setCombobox(TableColumn.CellDataFeatures<BasketItem, ComboBox<MxNode>> data) {
        ComboBox cmbBs = new ComboBox();
        BasketItem basketItem = (BasketItem)data.getValue();
        cmbBs.setItems(((MxNode)basketItem.bsProperty().get()).getNodes());
        cmbBs.valueProperty().bindBidirectional((Property)basketItem.bsProperty());
        cmbBs.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                cmbBs.hide();
            }
        });
        cmbBs.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> this.getSelectedBasket().setUnModified(false));
        return new ReadOnlyObjectWrapper((Object)cmbBs);
    }

    private ReadOnlyObjectWrapper<Button> deleteBasket(final TableColumn.CellDataFeatures<Basket, Button> basketData) {
        Button delBskBtn = new Button();
        delBskBtn.setText("\u5220\u9664");
        delBskBtn.getStyleClass().add((Object)"btnOperation");
        delBskBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BasketMngPart.this.tableBasket.getSelectionModel().select((Object)((Basket)basketData.getValue()));
                if (BasketMngPart.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u5b9a\u5220\u9664\u7bee\u5b50") && basketData != null) {
                    try {
                        BasketMngPart.this.model.delete(((Basket)basketData.getValue()).getId());
                        ((Basket)basketData.getValue()).setUnModified(true);
                        BasketMngPart.this.exe.execute(() -> {
                            try {
                                BasketMngPart.this.model.query();
                            }
                            catch (MException e) {
                                logger.error("\u67e5\u8be2\u7bee\u5b50\u5931\u8d25", (Throwable)e);
                            }
                        });
                    }
                    catch (MException e) {
                        logger.error("\u5220\u9664\u7bee\u5b50\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        });
        return new ReadOnlyObjectWrapper((Object)delBskBtn);
    }

    private ReadOnlyObjectWrapper<Button> copyBsk(final TableColumn.CellDataFeatures<Basket, Button> basketData) {
        Button copyBskBtn = new Button();
        copyBskBtn.setText("\u62f7\u8d1d");
        copyBskBtn.getStyleClass().add((Object)"btnOperation");
        copyBskBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BasketMngPart.this.tableBasket.getSelectionModel().select((Object)((Basket)basketData.getValue()));
                if (basketData != null) {
                    BasketMngPart.this.copyBasket();
                }
            }
        });
        return new ReadOnlyObjectWrapper((Object)copyBskBtn);
    }

    private ReadOnlyObjectWrapper<Button> deleteBtn(final TableColumn.CellDataFeatures<BasketItem, Button> itemData) {
        Button delButton = new Button();
        delButton.setText("\u5220\u9664");
        delButton.getStyleClass().add((Object)"btnOperation");
        delButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){
            int i = 0;

            public void handle(ActionEvent actionEvent) {
                if (BasketMngPart.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u5b9a\u5220\u9664\u6210\u4efd\u80a1") && itemData != null) {
                    BasketMngPart.this.secModel.getSecList().remove(itemData.getValue());
                    BasketMngPart.this.changeWeight();
                    BasketMngPart.this.secModel.getSecList().forEach(item -> item.setId(++this.i));
                    BasketMngPart.this.secModel.changed();
                    BasketMngPart.this.getSelectedBasket().setUnModified(false);
                }
            }
        });
        return new ReadOnlyObjectWrapper((Object)delButton);
    }

    @FXML
    private void download() {
        BasketTempleteDownloadDialog obj = (BasketTempleteDownloadDialog)((Object)this.of.create(BasketTempleteDownloadDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6a21\u677f\u4e0b\u8f7d");
        dialog.launch();
    }

    private class AbsWeightCell
    extends DoubleTableCell<BasketItem> {
        int scale = 4;

        private AbsWeightCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class MxEditTableCell<S>
    extends TextFieldTableCell<S, String> {
        private TextField textField;
        private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
            if (!now.booleanValue() && this.textField != null) {
                this.commitEdit(this.textField.getText());
            }
        };

        public MxEditTableCell() {
            this.setConverter((StringConverter)new DefaultStringConverter());
        }

        public void startEdit() {
            super.startEdit();
            try {
                if (this.textField == null) {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("textField");
                    field.setAccessible(true);
                    this.textField = (TextField)field.get((Object)this);
                    if (this.textField != null) {
                        this.textField.focusedProperty().addListener(this.lstnFocus);
                        this.textField.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 19));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void commitEdit(String newValue) {
            TableView table;
            if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                TableColumn col = this.getTableColumn();
                TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
                Event.fireEvent((EventTarget)col, (Event)event);
            }
            super.commitEdit((Object)newValue);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                    this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : ((String)this.getItem()).toString();
        }
    }

    private class NumberCell
    extends EditTableCell<BasketItem> {
        NumberCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                BasketItem bskItem = (BasketItem)BasketItem.class.cast(this.getTableRow().getItem());
                RefItem ref = BasketMngPart.this.refMng.getItem(bskItem.getSecurityType(), bskItem.getMarket().getRaw(), bskItem.getSecurityId());
                if (ref != null) {
                    String value = Long.toString(item.longValue());
                    if (value.length() > 9) {
                        bskItem.setCount(BasketMngPart.this.oldCount);
                        super.commitEdit((Number)BasketMngPart.this.oldCount);
                        Platform.runLater(() -> BasketMngPart.this.alert.alert(Alert.AlertType.INFORMATION, "\u6210\u4efd\u80a1\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d"));
                        return;
                    }
                    BasketMngPart.this.oldCount = item.longValue();
                    super.commitEdit((Number)bskItem.getCount());
                }
            }
        }
    }

    private class PriceCell
    extends EditTableCell<BasketItem> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null || item.doubleValue() < 0.0) {
                    return;
                }
                BasketItem bskItem = (BasketItem)BasketItem.class.cast(this.getTableRow().getItem());
                RefItem refItem = BasketMngPart.this.refMng.getItem(bskItem.getSecurityType(), bskItem.getMarket().getRaw(), bskItem.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setNum(this.scale);
                this.setFormat("%1$,." + this.scale + "f");
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }

        public void startEdit() {
            super.startEdit();
            try {
                if (super.getTextField() != null) {
                    super.getTextField().textProperty().addListener((ob, old, now) -> {
                        if (!"".equals(now) && !StringUtils.isDouble((String)now, (int)this.scale)) {
                            ((StringProperty)ob).setValue(old);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Weight
    extends EditTableCell<BasketItem> {
        Weight(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

