/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views.basket;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.trade.models.basket.BasketAccSetModel;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasketAccSetDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(BasketAccSetDialog.class);
    @Inject
    private BasketAccSetModel accSetModel;
    private List<CcsFundAccount> fundList = new ArrayList<CcsFundAccount>();
    private List<CcsFundAccount> selectedFundList = new ArrayList<CcsFundAccount>();
    @FXML
    protected TreeTableView<CcsAccountDistribution> basketAcctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @Inject
    private MxAlert alert;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private TreeItem<CcsAccountDistribution> root;
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    if (treeItem.isLeaf()) {
                        this.disableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                                treeItem.getParent().getChildren().forEach(each -> {
                                    if (!each.equals(treeItem) && each.getValue() != null && ((CcsAccountDistribution)each.getValue()).getSecAcc().getExchange().getRaw().equals(((CcsAccountDistribution)treeItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                        ((CcsAccountDistribution)each.getValue()).setSelected(false);
                                    }
                                });
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                BasketAccSetDialog.this.basketAcctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> BasketAccSetDialog.this.basketAcctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> {
                            boolean xshg = true;
                            boolean xshe = true;
                            treeItem.getChildren();
                            for (TreeItem cadItem : treeItem.getChildren()) {
                                ((CcsAccountDistribution)cadItem.getValue()).setSelected(false);
                                if (!((CcsAccountDistribution)treeItem.getValue()).isSelected()) continue;
                                if (xshg && "XSHG".equals(((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                    ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                    xshg = false;
                                }
                                if (!xshe || !"XSHE".equals(((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                                ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                xshe = false;
                            }
                        });
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };

    @FXML
    public void initialize() {
        this.root = this.accSetModel.getRoot();
        this.createTree();
    }

    private void createTree() {
        this.basketAcctTreeTable.setRoot(this.root);
        this.basketAcctTreeTable.setShowRoot(false);
        this.basketAcctTreeTable.setPlaceholder((Node)new Label());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        TreeItem root = new TreeItem();
        root.setExpanded(true);
    }

    public BasketAccSetModel getAccSetModel() {
        return this.accSetModel;
    }

    public List<CcsFundAccount> getFundList() {
        return this.fundList;
    }

    public void setFundList(List<CcsFundAccount> fundList) {
        this.fundList = fundList;
    }

    protected boolean isOK(ButtonType bt) {
        for (TreeItem accItem : this.accSetModel.getRoot().getChildren()) {
            if (!((CcsAccountDistribution)accItem.getValue()).isSelected()) continue;
            boolean hasXshg = false;
            boolean hasXshe = false;
            int xshgSelected = 0;
            int xsheSelected = 0;
            for (TreeItem secItem : accItem.getChildren()) {
                if ("XSHG".equals(((CcsAccountDistribution)secItem.getValue()).getSecAcc().getExchange().getRaw())) {
                    hasXshg = true;
                    if (!((CcsAccountDistribution)secItem.getValue()).isSelected()) continue;
                    ++xshgSelected;
                    continue;
                }
                if (!"XSHE".equals(((CcsAccountDistribution)secItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                hasXshe = true;
                if (!((CcsAccountDistribution)secItem.getValue()).isSelected()) continue;
                ++xsheSelected;
            }
            if (hasXshg && xshgSelected < 1) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + ((CcsAccountDistribution)accItem.getValue()).getAcc().getInvestId() + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6caa\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                return false;
            }
            if (!hasXshe || xsheSelected >= true) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + ((CcsAccountDistribution)accItem.getValue()).getAcc().getInvestId() + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6df1\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
            return false;
        }
        return true;
    }

    public void create() {
        try {
            this.accSetModel.setFundList(this.getFundList());
            this.accSetModel.setSelectedFundList(this.getSelectedFundList());
            this.accSetModel.createTree();
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u7bee\u5b50\u8d26\u53f7\u9009\u62e9\u7a97\u53e3\u5931\u8d25", (Throwable)e);
        }
    }

    public List<CcsFundAccount> getSelectedFundList() {
        return this.selectedFundList;
    }

    public void setSelectedFundList(List<CcsFundAccount> selectedFundList) {
        this.selectedFundList = selectedFundList;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }
}

