/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.OpStatusReport;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.http.statement.api.RouterTransServiceApi;
import cms.tmx.http.statement.api.TransSecurityReq;
import cms.tmx.http.statement.api.TransSecurityResp;
import cms.tmx.query.current.models.MarginAccountMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferPosiDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(TransferPosiDialog.class);
    @FXML
    private Label lb;
    @FXML
    private TextField txtCanVol;
    @Inject
    private ITransferFundApi transApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private RouterTransServiceApi routerApi;
    @Inject
    private MxAlert mAlert;
    private CcsPosition posiInfo;
    @Inject
    protected MEventService es;
    @Inject
    private MarginAccountMap accountMap;
    private BooleanProperty status = new SimpleBooleanProperty(false);
    private int timeOut = 5000;
    private int posiId;
    private String reason = "";
    private boolean marginMark = false;
    private FundAccount accntInfo;
    private int direct;
    String marketGrp = "";
    String investorId = "";
    int volume;
    String secAccntId = "";
    boolean transferStatus = false;
    int operationType = 0;
    String marginSecAccntId;
    public boolean transferMark = false;
    public boolean fundMark = false;
    private String serialNo;
    private int respStatus = 0;

    @FXML
    private void initialize() {
        this.addCheck();
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    private void addCheck() {
        this.txtCanVol.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
    }

    private void onPush(MEvent event) {
        Object obj = event.getObj();
        if (!"404".equals(event.getStr("push_type"))) {
            return;
        }
        OpStatusReport report = (OpStatusReport)OpStatusReport.class.cast(obj);
        if (!String.valueOf(this.posiId).equals(report.getReport().getData())) {
            return;
        }
        int s = report.getReport().getStatus();
        this.reason = report.getReport().getReason();
        if (s == 1) {
            this.fundMark = true;
            logger.debug("transfer fund success->  status:" + s + " reason:" + this.reason);
        } else {
            this.fundMark = false;
            logger.debug("transfer fund faild->  status:" + s + " reason:" + this.reason);
        }
        this.transferMark = true;
    }

    public boolean isOK(ButtonType bt) {
        if (this.txtCanVol.getText().isEmpty()) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        long canVol = this.posiInfo.getCanVol();
        this.volume = Integer.valueOf(this.txtCanVol.getText());
        if (this.volume == 0) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e\u96f6");
            return false;
        }
        this.marketGrp = this.posiInfo.getMarketGrp();
        this.investorId = this.posiInfo.getInvestorId();
        this.secAccntId = this.posiInfo.getExtSecAccId();
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        if (this.posiInfo.getSecId() != null) {
            builder.setSecurityId(this.posiInfo.getSecId());
        }
        if (this.posiInfo.getSecName() != null) {
            builder.setSymbol(this.posiInfo.getSecName());
        }
        if (this.posiInfo.getMarket().getRaw() != null) {
            builder.setMarket(this.posiInfo.getMarket().getRaw());
        }
        builder.setSecurityType(this.posiInfo.getSecType());
        if (!"\u8f6c\u5165\u6570\u91cf".equals(this.lb.getText())) {
            if ((long)this.volume > canVol) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u6301\u4ed3\u6570\u91cf\u4e0d\u8db3");
                return false;
            }
            if (!this.isMarginMark()) {
                this.volume = -this.volume;
            }
        }
        if (this.isMarginMark()) {
            String market = this.posiInfo.getMarket().getRaw();
            String investorId = this.accntInfo.getInvestId();
            CcsFundAccount fundAccount = this.accountMap.getFundAcc(investorId);
            if (fundAccount != null) {
                try {
                    List secAccntList = (List)this.accountMap.getAccountMap().get(fundAccount);
                    if (!secAccntList.isEmpty()) {
                        secAccntList.forEach(e -> {
                            if (e.getExchange().getRaw().equals(market)) {
                                this.marginSecAccntId = e.getInverstorSecId();
                            }
                        });
                    }
                }
                catch (MException e2) {
                    e2.printStackTrace();
                }
            }
        }
        String tradePlatformId = this.accntInfo.getCounterId();
        this.posiId = new Random().nextInt(999999999);
        this.exe.execute(() -> {
            try {
                if (!this.isMarginMark()) {
                    this.transApi.TransferPosi(this.marketGrp, this.investorId, this.secAccntId, this.volume, this.posiId, this.operationType, builder.build());
                } else {
                    TransSecurityReq req = new TransSecurityReq();
                    req.setAccntId(this.investorId);
                    req.setCashAccntId(this.investorId);
                    req.setTradePlatformId(tradePlatformId);
                    req.setSecAccntId(this.marginSecAccntId);
                    req.setMarket(this.posiInfo.getMarket().getRaw());
                    req.setSecCode(this.posiInfo.getSecId());
                    req.setTransAmt(this.volume);
                    req.setDirect(this.direct);
                    TransSecurityResp resp = this.routerApi.doTransPosi(req);
                    if (resp.getCode() == 1) {
                        logger.info("\u8bc1\u5238\u5212\u8f6c\u6210\u529f\uff0c\u7f16\u53f7:" + resp.getSerialNo());
                        this.respStatus = resp.getCode();
                        this.serialNo = resp.getSerialNo();
                        this.reason = resp.getReason();
                    } else {
                        logger.error("\u8bc1\u5238\u5212\u8f6c\u5931\u8d25:" + resp.getReason());
                    }
                }
            }
            catch (MException | Exception e) {
                logger.error("\u8bc1\u5238\u5212\u8f6c\u5f02\u5e38", e);
                this.reason = e.getMessage();
                return;
            }
        });
        final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8f6c\u5165\u6570\u91cf".equals(this.lb.getText()) ? "\u8bc1\u5238\u6b63\u5728\u8f6c\u5165..." : "\u8bc1\u5238\u6b63\u5728\u8f6c\u51fa...");
        this.status.set(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!TransferPosiDialog.this.isMarginMark()) {
                    if (TransferPosiDialog.this.transferMark) {
                        if (TransferPosiDialog.this.fundMark) {
                            simpleStringProperty.set("\u8f6c\u5165\u6570\u91cf".equals(TransferPosiDialog.this.lb.getText()) ? "\u8bc1\u5238\u8f6c\u5165\u6210\u529f\u3002" : "\u8bc1\u5238\u8f6c\u51fa\u6210\u529f\u3002");
                        } else {
                            simpleStringProperty.set("\u8f6c\u5165\u6570\u91cf".equals(TransferPosiDialog.this.lb.getText()) ? "\u8bc1\u5238\u8f6c\u5165\u5931\u8d25:" + TransferPosiDialog.this.reason : "\u8bc1\u5238\u8f6c\u51fa\u5931\u8d25:" + TransferPosiDialog.this.reason);
                        }
                        TransferPosiDialog.this.status.set(false);
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6");
                        TransferPosiDialog.this.status.set(false);
                    }
                } else {
                    if (TransferPosiDialog.this.respStatus == 1) {
                        simpleStringProperty.set("\u5212\u8f6c\u6210\u529f.");
                        logger.info("\u8bc1\u5238\u5212\u8f6c\u6210\u529f\uff0c\u7f16\u53f7:" + TransferPosiDialog.this.serialNo);
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u5931\u8d25\uff0c" + TransferPosiDialog.this.reason);
                        logger.info("\u8bc1\u5238\u5212\u8f6c\u5931\u8d25\uff0c\u539f\u56e0:" + TransferPosiDialog.this.reason);
                    }
                    TransferPosiDialog.this.status.set(false);
                }
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeOut);
        this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
        this.status.set(false);
        return true;
    }

    public Label getLb() {
        return this.lb;
    }

    public void setLb(Label lb) {
        this.lb = lb;
    }

    public TextField getTxtCanVol() {
        return this.txtCanVol;
    }

    public void setTxtCanVol(TextField txtCanVol) {
        this.txtCanVol = txtCanVol;
    }

    public CcsPosition getPosiInfo() {
        return this.posiInfo;
    }

    public void setPosiInfo(CcsPosition order) {
        this.posiInfo = order;
    }

    public boolean isMarginMark() {
        return this.marginMark;
    }

    public void setMarginMark(boolean marginMark) {
        this.marginMark = marginMark;
    }

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }

    public FundAccount getAccntInfo() {
        return this.accntInfo;
    }

    public void setAccntInfo(FundAccount accntInfo) {
        this.accntInfo = accntInfo;
    }
}

