/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.api.trade.IQueryPositionsApi;
import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.control.combobox.ComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.notice.OpStatusReport;
import cms.tmx.entity.notice.TransferFundReport;
import cms.tmx.entity.notice.TransferPositionReport;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.http.statement.api.RouterTransServiceApi;
import cms.tmx.http.statement.api.TransFundReq;
import cms.tmx.http.statement.api.TransFundResp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.SyncFundAccntServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.query.margin.models.MarginPositionModel;
import cms.tmx.trade.views.DoTransferPosiDialog;
import cms.tmx.trade.views.TransferPosiDialog;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferFundPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(TransferFundPart.class);
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtFundOutAll;
    @FXML
    private TextField txtFundInAll;
    @FXML
    private TextField txtFundOut;
    @FXML
    private TextField txtFundIn;
    @FXML
    private Button btnOut;
    @FXML
    private Button btnOutAll;
    @FXML
    private Button btnIn;
    @FXML
    private Button btnInAll;
    @FXML
    private Button btnQuery;
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<TradeCounter> cmbbkn;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private TableView<CcsPosition> tablePosition;
    @FXML
    private TableColumn<CcsPosition, String> secCode;
    @FXML
    private TableColumn<CcsPosition, String> secName;
    @FXML
    private TableColumn<CcsPosition, Number> canSell;
    @FXML
    private TableColumn<CcsPosition, Object> operat;
    @Inject
    private FundAccountMngServiceImpl fundAccountMng;
    @Inject
    protected PositionFactory fPosition;
    @Inject
    private ExecutorService exe;
    @Inject
    protected MObjFactory of;
    @Inject
    protected PositionFactory ft;
    @Inject
    private DialogFactory df;
    @Inject
    protected IQueryPositionsApi apiPosition;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ITransferFundApi transApi;
    @Inject
    private SyncFundAccntServiceImpl syncFundAccntImpl;
    @Inject
    private TradeCounterServiceImpl tradeCSImp;
    @Inject
    private MarginPositionModel marginModel;
    @Inject
    private RouterTransServiceApi routerApi;
    private BooleanProperty status = new SimpleBooleanProperty(false);
    private String reason = "";
    private int avaId;
    private int posiAvaId;
    private int fundId;
    private int posiId;
    private int maxPush = 128;
    private MxList<CcsPosition> mxList = new MxList();
    private List<PMainTenance.TransferPosition> transferPosiList = new LinkedList<PMainTenance.TransferPosition>();
    private List<CcsPosition> posiList = new LinkedList<CcsPosition>();
    private int timeOut = 2500;
    private int timeGet = 500;
    private int timeAgainQuery = 3000;
    private int timeBtnCool = 20000;
    private double pushAvailable;
    public boolean transferMark = false;
    public boolean fundMark = false;
    private DoubleProperty jzAvailable = new SimpleDoubleProperty();
    private String available = "";
    private String investorId = "";
    private String marketGrp = "";
    private String brokerId = "";
    private String currencyId = "";
    private String fundTxtIn = "";
    private String fundTxtInAll = "";
    private String tradePlatformId = "";
    DecimalFormat fm = new DecimalFormat("0.00");
    private boolean marginMark = false;
    private List<ObPositionMargin> marginQuery = new ArrayList<ObPositionMargin>();
    private FundAccount fund = new FundAccount();
    private boolean coolMark = false;
    @Inject
    protected MxAlert alert;
    protected ComboBoxModel<FundAccount> accountModel;
    protected Predicate<FundAccount> accountPd = inst -> {
        String idName = this.cmbFund.getEditor().getText().trim();
        return inst.getAccountName().contains(idName) || inst.getInvestId().contains(idName);
    };
    protected Comparator<FundAccount> accountCp = (u, o) -> {
        if (u == o) {
            return 0;
        }
        if (u.getInvestId().isEmpty() && !o.getInvestId().isEmpty()) {
            return -1;
        }
        if (!u.getInvestId().isEmpty() && o.getInvestId().isEmpty()) {
            return 1;
        }
        return 1;
    };
    private Predicate<CcsPosition> pd = p -> {
        String secCode = this.txtCode.getText().trim();
        return p.getSecId().contains(secCode) || p.getSecName().contains(secCode);
    };
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        ArrayList<CcsPosition> newList = new ArrayList<CcsPosition>();
        List<CcsPosition> list = this.posiList;
        synchronized (list) {
            newList.addAll(this.posiList);
        }
        this.mxList.update(newList, this.pd);
    });
    private String title = "";
    private String lbText = "";
    Double amount;
    Double allAmount;
    int operationType;
    int volume = 0;
    private String rspReason = "";

    @FXML
    public void initialize() {
        this.txtCode.textProperty().addListener(this.lstnModel);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.queryTradeCounter();
        this.bind();
        this.addCheck();
        this.initCheckBoxAcc();
        this.requery();
        this.createTable();
        this.coolMark = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onPush(MEvent event) {
        Object obj = event.getObj();
        String type = event.getStr("push_type");
        if ("407".equals(type)) {
            TransferFundReport report = (TransferFundReport)TransferFundReport.class.cast(obj);
            int status = report.getReport().getStatus();
            this.reason = report.getReport().getErrorInfo();
            if (report.getReport().getSeq() == this.avaId && status == 1) {
                this.pushAvailable = report.getReport().getAvailable();
                this.jzAvailable.set(this.pushAvailable >= 0.0 ? this.pushAvailable : 0.0);
                logger.info("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u5165\u8d44\u91d1:" + this.jzAvailable);
                System.err.println("----------jzAvailable:" + this.jzAvailable);
            } else {
                logger.debug("get fund faild->  status:" + status + " reason:" + this.reason);
                this.jzAvailable.set(0.0);
                logger.error("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u5165\u8d44\u91d1\u5931\u8d25:" + this.reason);
            }
            return;
        }
        if ("408".equals(type)) {
            TransferPositionReport report = (TransferPositionReport)TransferPositionReport.class.cast(obj);
            int status = report.getReport().getStatus();
            this.reason = report.getReport().getErrorInfo();
            int totalCount = report.getReport().getPositionCount();
            boolean isLast = report.getReport().getIsLast();
            if (report.getReport().getSeq() == this.posiAvaId && status == 1) {
                this.transferPosiList = report.getReport().getPositionList();
                List<CcsPosition> list = this.posiList;
                synchronized (list) {
                    for (PMainTenance.TransferPosition pPosition : this.transferPosiList) {
                        CcsPosition position = (CcsPosition)this.ft.createCcs();
                        position.setInvestorId(report.getReport().getInvestorId());
                        position.setMarketGrp(report.getReport().getMarketGrp());
                        position.setSecId(pPosition.getInstrument().getSecurityId());
                        position.setSecName(pPosition.getInstrument().getSymbol());
                        position.setSecType(pPosition.getInstrument().getSecurityType());
                        position.setCanVol((long)pPosition.getTransferAvailable());
                        position.setCanVolDouble(pPosition.getTransferAvailable());
                        position.setExtSecAccId(pPosition.getSecAccntId());
                        position.getMarket().setRaw(pPosition.getInstrument().getMarket());
                        this.posiList.add(position);
                    }
                    if (totalCount < this.maxPush && isLast) {
                        Collections.sort(this.posiList, (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
                        this.mxList.updatePart(this.posiList);
                        this.tablePosition.refresh();
                    }
                }
            } else {
                logger.debug("get positionList faild->  status:" + status + " reason:" + this.reason);
            }
            return;
        }
        if (!"403".equals(type) && !"404".equals(type)) {
            return;
        }
        OpStatusReport report = (OpStatusReport)OpStatusReport.class.cast(obj);
        if (!String.valueOf(this.fundId).equals(report.getReport().getData()) && !String.valueOf(this.posiId).equals(report.getReport().getData())) {
            return;
        }
        int status = report.getReport().getStatus();
        this.reason = report.getReport().getReason();
        if (status == 1) {
            this.fundMark = true;
            logger.debug("transfer success->  status:" + status + " reason:" + this.reason);
            logger.info("transfer success->  status:" + status + " reason:" + this.reason);
        } else {
            this.fundMark = false;
            logger.debug("transfer faild->  status:" + status + " reason:" + this.reason);
            logger.error("transfer faild->  status:" + status + " reason:" + this.reason);
        }
        this.transferMark = true;
    }

    private void addCheck() {
        this.txtFundOutAll.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundInAll.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundIn.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundOut.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
    }

    private void initCheckBoxAcc() {
        ObservableList listFund = this.fundAccountMng.getCcsFundAccountList();
        List collect = listFund.stream().distinct().collect(Collectors.toList());
        this.accountModel = new ComboBoxModel(this.cmbFund);
        this.accountModel.initCellFactroy();
        this.accountModel.initData(collect, this.accountPd, this.accountCp);
    }

    public void initValues(FundAccount accnt) {
        ObservableList listCur = FxUtils.newList();
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)"CNY");
        listCur.add((Object)node);
        if (!("99999-02-01".equals(accnt.getCounterId()) || "99999-02-02".equals(accnt.getCounterId()) || "99999-02-03".equals(accnt.getCounterId()))) {
            this.available = this.fm.format(accnt.getAvailable());
            this.marginMark = false;
            this.btnOutAll.setText("\u8d44\u5238\u5168\u90e8\u8f6c\u51fa");
            this.btnInAll.setText("\u8d44\u5238\u5168\u90e8\u8f6c\u5165");
            this.operat.setVisible(true);
        } else {
            this.available = this.fm.format(accnt.getAvailableNew());
            this.marginMark = true;
            this.btnOutAll.setText("\u8bc1\u5238\u8f6c\u51fa");
            this.btnInAll.setText("\u8bc1\u5238\u8f6c\u5165");
            this.operat.setVisible(true);
        }
        if (this.available.contains("-")) {
            this.txtFundOutAll.setText("0.00");
        } else {
            this.setFundOutAllText();
        }
        node.setRaw(accnt.getCurrencyId());
        if (!listCur.contains((Object)node)) {
            listCur.add((Object)node);
        }
        this.investorId = accnt.getInvestId();
        this.brokerId = accnt.getBrokerId();
        this.marketGrp = accnt.getMarketGrp();
        this.currencyId = accnt.getCurrencyId();
        this.cmbCurrency.setItems(listCur);
        this.cmbCurrency.getSelectionModel().select((Object)node);
        this.tradePlatformId = accnt.getCounterId();
        if (!accnt.getCounterId().isEmpty()) {
            ObservableList listBork = this.tradeCSImp.getTradeCounterIdList(accnt.getCounterId());
            this.cmbbkn.setItems(listBork);
            this.cmbbkn.getSelectionModel().select(0);
        }
        this.fund = accnt;
        this.cmbFund.getEditor().setText(accnt.getInvestId());
        this.cmbFund.hide();
        this.getJzAvailable(accnt);
    }

    private void marginPositionQuery() {
        this.mxList.clear();
        this.marginModel.query();
        this.marginQuery = this.marginModel.getList();
    }

    private synchronized void setFundOutAllText() {
        try {
            logger.info("txtFundOutAll \u8bbe\u503c :" + this.available);
            this.txtFundOutAll.setText(this.available);
        }
        catch (Exception e) {
            logger.error("txtFundOutAll \u8bbe\u503c\u51fa\u9519 " + this.available, (Throwable)e);
        }
    }

    public void queryTradeCounter() {
        try {
            this.tradeCSImp.getTradeCounterList();
        }
        catch (MException e) {
            logger.error("queryTradeCounter error", (Throwable)e);
        }
    }

    private void btnCool(boolean cool) {
        this.btnQuery.setDisable(cool);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                TransferFundPart.this.btnQuery.setDisable(false);
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeBtnCool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requery() {
        List checkItems = this.accountModel.getCheckItems();
        if (checkItems.size() == 0) {
            return;
        }
        final FundAccount acct = (FundAccount)checkItems.get(0);
        if (acct == null) {
            return;
        }
        this.initValues(acct);
        this.btnCool(this.coolMark);
        this.txtCode.clear();
        List<CcsPosition> list = this.posiList;
        synchronized (list) {
            this.posiList.clear();
        }
        this.fundRequery(acct);
        this.posiAvaId = new Random().nextInt(999999999);
        if (!this.marginMark) {
            this.queryPosiList(this.investorId, this.marketGrp, this.posiAvaId);
        } else {
            this.marginPositionQuery();
            for (ObPositionMargin mPosition : this.marginQuery) {
                if (!this.investorId.equals(mPosition.getInvestorId())) continue;
                CcsPosition position = (CcsPosition)this.ft.createCcs();
                position.setInvestorId(mPosition.getInvestorId());
                position.setSecId(mPosition.getInstrument().getSecId());
                position.setSecName(mPosition.getInstrument().getSymbol());
                position.setSecType(mPosition.getInstrument().getSecType());
                position.setCanVol((long)mPosition.getSecAvail());
                position.setExtSecAccId(mPosition.getPosAccnt().getSecAccntId());
                position.setMarket(mPosition.getInstrument().getMarket());
                this.posiList.add(position);
            }
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (acct != null) {
                    if (!TransferFundPart.this.marginMark) {
                        TransferFundPart.this.available = TransferFundPart.this.fm.format(acct.getAvailable());
                    } else {
                        TransferFundPart.this.available = TransferFundPart.this.fm.format(acct.getAvailableNew());
                    }
                    TransferFundPart.this.setFundOutAllText();
                }
                TransferFundPart.this.tablePosition.refresh();
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeGet);
    }

    private void fundRequery(final FundAccount acct) {
        this.doSyncRequest(this.investorId, this.marketGrp);
        if (!this.marginMark) {
            this.doSyncAccount(this.brokerId, this.investorId, this.marketGrp);
        }
        if (acct != null && !acct.getCounterId().isEmpty()) {
            ObservableList listBork = this.tradeCSImp.getTradeCounterIdList(acct.getCounterId());
            this.cmbbkn.setItems(listBork);
            this.investorId = acct.getInvestId();
            this.available = !this.marginMark ? this.fm.format(acct.getAvailable()) : this.fm.format(acct.getAvailableNew());
            this.currencyId = acct.getCurrencyId();
            this.marketGrp = acct.getMarketGrp();
            this.getJzAvailable(acct);
            this.cmbbkn.getSelectionModel().select(0);
            if (this.available.contains("-")) {
                this.txtFundOutAll.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        } else {
            this.txtFundOutAll.setText("0.00");
        }
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)"CNY");
        this.cmbCurrency.setItems(node.getNodes());
        this.cmbCurrency.getSelectionModel().select(0);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (acct != null) {
                    if (!TransferFundPart.this.marginMark) {
                        TransferFundPart.this.available = TransferFundPart.this.fm.format(acct.getAvailable());
                    } else {
                        TransferFundPart.this.available = TransferFundPart.this.fm.format(acct.getAvailableNew());
                    }
                    if (TransferFundPart.this.available.contains("-")) {
                        TransferFundPart.this.txtFundOutAll.setText("0.00");
                    } else {
                        TransferFundPart.this.setFundOutAllText();
                    }
                }
                TransferFundPart.this.againFundRequery(acct);
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeAgainQuery);
    }

    private void againFundRequery(FundAccount acct) {
        this.doSyncRequest(this.investorId, this.marketGrp);
        this.doSyncAccount(this.brokerId, this.investorId, this.marketGrp);
        this.available = !this.marginMark ? this.fm.format(acct.getAvailable()) : this.fm.format(acct.getAvailableNew());
        if (this.available.contains("-")) {
            this.txtFundOutAll.setText("0.00");
        } else {
            this.setFundOutAllText();
        }
    }

    public void getJzAvailable(FundAccount item) {
        this.avaId = new Random().nextInt(999999999);
        this.marketGrp = item.getMarketGrp();
        this.investorId = item.getInvestId();
        this.currencyId = item.getCurrencyId();
        try {
            this.transApi.getTransferFund(this.marketGrp, this.investorId, this.currencyId, this.avaId);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u53ef\u8f6c\u5165\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    public void queryPosiList(String investorId, String marketGrp, int posiAvaId) {
        this.mxList.clear();
        try {
            this.transApi.getTransferPosi(investorId, marketGrp, posiAvaId);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u8d26\u53f7\u6301\u4ed3\u5f02\u5e38", (Throwable)e);
        }
    }

    private void bind() {
        MxBindings.bindSDTwoScale((Property)this.txtFundInAll.textProperty(), (Property)this.jzAvailable);
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tablePosition);
        this.secCode.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.secName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.canSell.setCellValueFactory(data -> ((CcsPosition)data.getValue()).canVolProperty());
        this.operat.setCellValueFactory(data -> this.setOperate((CcsPosition)data.getValue()));
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    private ReadOnlyObjectWrapper<Object> setOperate(CcsPosition order) {
        HBox box = new HBox();
        box.setSpacing(20.0);
        box.setAlignment(Pos.CENTER);
        Button posiIn = new Button("\u8f6c\u5165");
        Button posiOut = new Button("\u8f6c\u51fa");
        posiIn.getStyleClass().add((Object)"btnOperation");
        posiOut.getStyleClass().add((Object)"btnOperation");
        posiIn.setOnAction(event -> {
            Object object = this.transDialog(order, 1);
        });
        posiOut.setOnAction(event -> {
            Object object = this.transDialog(order, 2);
        });
        box.getChildren().addAll((Object[])new Node[]{posiIn, posiOut});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private Object transDialog(CcsPosition order, int i) {
        block7: {
            this.tablePosition.getSelectionModel().select((Object)order);
            TransferPosiDialog obj = (TransferPosiDialog)((Object)this.of.create(TransferPosiDialog.class));
            if (i == 1) {
                this.title = "\u8bc1\u5238\u8f6c\u5165";
                this.lbText = "\u8f6c\u5165\u6570\u91cf";
                obj.setDirect(1);
            } else {
                this.title = "\u8bc1\u5238\u8f6c\u51fa";
                this.lbText = "\u8f6c\u51fa\u6570\u91cf";
                obj.setDirect(2);
            }
            obj.setAccntInfo(this.fund);
            obj.setPosiInfo(order);
            obj.setMarginMark(this.marginMark);
            MxDialog dialog = this.df.create((DialogObj)obj, this.title);
            obj.getLb().setText(this.lbText);
            HBox box = new HBox();
            Button btnOK = dialog.getButton(ButtonType.OK);
            Button btnCancel = dialog.getButton(ButtonType.CANCEL);
            if (btnOK != null) {
                HBox.setMargin((Node)btnOK, (Insets)new Insets(0.0, 20.0, 20.0, 0.0));
            }
            if (btnCancel != null) {
                HBox.setMargin((Node)btnCancel, (Insets)new Insets(0.0, 40.0, 20.0, 0.0));
            }
            if (dialog.launch() == ButtonType.OK) break block7;
            return null;
        }
        try {
            this.requery();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5212\u8f6c\u8bc1\u5238\u6301\u4ed3error", (Throwable)e);
        }
        return null;
    }

    public boolean fundIn() throws Exception {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u5165\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            if (!this.checkFund(this.txtFundIn.getText())) {
                return false;
            }
            this.fundTxtIn = this.txtFundIn.getText().replace(",", "");
            this.fundTxtInAll = this.txtFundInAll.getText().replace(",", "");
            this.amount = Double.valueOf(this.fundTxtIn);
            if (!this.fundTxtInAll.isEmpty()) {
                this.allAmount = Double.valueOf(this.fundTxtInAll);
            }
            if (!this.checkValid(this.amount)) {
                return false;
            }
            if (this.amount > this.allAmount && !this.marginMark) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u53ef\u8f6c\u5165\u8d44\u91d1\u4e0d\u8db3");
                return false;
            }
            this.fundId = new Random().nextInt(999999999);
            this.operationType = 0;
            this.exe.execute(() -> {
                try {
                    if (!this.marginMark) {
                        this.transApi.TransferFund(this.marketGrp, this.investorId, this.currencyId, this.amount.doubleValue(), this.fundId, this.operationType);
                    } else {
                        TransFundReq req = new TransFundReq();
                        req.setAccntId(this.investorId);
                        req.setCashAccntId(this.investorId);
                        req.setTradePlatformId(this.tradePlatformId);
                        req.setFundAmt(this.amount.doubleValue());
                        req.setDirect(1);
                        TransFundResp resp = this.routerApi.doTransFund(req);
                        if (resp.getCode() == 1) {
                            this.rspReason = "\u8d44\u91d1\u8f6c\u5165\u6210\u529f.";
                            logger.info("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\uff0c\u7f16\u53f7:" + resp.getSerialNo());
                        } else {
                            this.rspReason = "\u8d44\u91d1\u8f6c\u5165\u5931\u8d25\uff0c\u539f\u56e0:" + resp.getReason();
                            logger.error("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25\uff0c\u539f\u56e0:" + resp.getReason());
                        }
                    }
                }
                catch (MException | Exception e) {
                    this.rspReason = "\u8d44\u91d1\u8f6c\u5165\u5f02\u5e38\uff0c\u539f\u56e0:" + e.getMessage();
                    logger.error("\u8d44\u91d1\u8f6c\u5165\u5f02\u5e38", e);
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u91d1\u6b63\u5728\u8f6c\u5165...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (!TransferFundPart.this.marginMark) {
                        if (TransferFundPart.this.transferMark) {
                            if (TransferFundPart.this.fundMark) {
                                simpleStringProperty.set("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\u3002");
                                logger.info("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\uff0c\u91d1\u989d:" + TransferFundPart.this.amount);
                            } else {
                                simpleStringProperty.set("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + TransferFundPart.this.reason);
                                logger.info("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + TransferFundPart.this.reason);
                            }
                        } else {
                            simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                        }
                    } else {
                        simpleStringProperty.set(TransferFundPart.this.rspReason);
                    }
                    TransferFundPart.this.status.set(false);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
            this.requery();
        }
        return false;
    }

    public boolean fundOut() throws Exception {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u51fa\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            if (!this.checkFund(this.txtFundOut.getText())) {
                return false;
            }
            this.amount = Double.valueOf(this.txtFundOut.getText());
            this.allAmount = Double.valueOf(this.txtFundOutAll.getText());
            if (!this.checkValid(this.amount)) {
                return false;
            }
            if (this.amount > this.allAmount) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u53ef\u8f6c\u51fa\u8d44\u91d1\u4e0d\u8db3");
                return false;
            }
            this.fundId = new Random().nextInt(999999999);
            this.operationType = 0;
            this.exe.execute(() -> {
                try {
                    if (!this.marginMark) {
                        this.transApi.TransferFund(this.marketGrp, this.investorId, this.currencyId, -this.amount.doubleValue(), this.fundId, this.operationType);
                    } else {
                        TransFundReq req = new TransFundReq();
                        req.setAccntId(this.investorId);
                        req.setCashAccntId(this.investorId);
                        req.setTradePlatformId(this.tradePlatformId);
                        req.setFundAmt(this.amount.doubleValue());
                        req.setDirect(2);
                        TransFundResp resp = this.routerApi.doTransFund(req);
                        if (resp.getCode() == 1) {
                            this.rspReason = "\u8d44\u91d1\u8f6c\u51fa\u6210\u529f.";
                            logger.info("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\uff0c\u7f16\u53f7:" + resp.getSerialNo());
                        } else {
                            this.rspReason = "\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25\uff0c\u539f\u56e0:" + resp.getReason();
                            logger.error("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25\uff0c\u539f\u56e0:" + resp.getReason());
                        }
                    }
                }
                catch (MException | Exception e) {
                    this.rspReason = "\u8d44\u91d1\u8f6c\u51fa\u5f02\u5e38\uff0c\u539f\u56e0:" + e.getMessage();
                    logger.error("\u8d44\u91d1\u8f6c\u51fa\u5f02\u5e38", e);
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u91d1\u6b63\u5728\u8f6c\u51fa...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (!TransferFundPart.this.marginMark) {
                        if (TransferFundPart.this.transferMark) {
                            if (TransferFundPart.this.fundMark) {
                                simpleStringProperty.set("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\u3002");
                                logger.info("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\uff0c\u91d1\u989d:" + TransferFundPart.this.amount);
                            } else {
                                simpleStringProperty.set("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + TransferFundPart.this.reason);
                                logger.info("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + TransferFundPart.this.reason);
                            }
                        } else {
                            simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                        }
                    } else {
                        simpleStringProperty.set(TransferFundPart.this.rspReason);
                    }
                    TransferFundPart.this.status.set(false);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
            this.requery();
        }
        return false;
    }

    public boolean posiInAll() throws Exception {
        if (!this.marginMark) {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u5238\u5168\u90e8\u8f6c\u5165\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
                this.fundTxtInAll = this.txtFundInAll.getText().replace(",", "");
                if (!this.fundTxtInAll.isEmpty()) {
                    this.allAmount = Double.valueOf(this.fundTxtInAll);
                }
                this.fundId = new Random().nextInt(999999999);
                this.operationType = 1;
                this.exe.execute(() -> {
                    try {
                        if (this.allAmount != 0.0) {
                            this.transApi.TransferFund(this.marketGrp, this.investorId, this.currencyId, this.allAmount.doubleValue(), this.fundId, this.operationType);
                        }
                        this.transApi.TransferAllPosi(this.marketGrp, this.investorId, this.volume, this.posiId, this.operationType);
                    }
                    catch (MException e) {
                        logger.error("\u8d44\u5238\u5168\u90e8\u8f6c\u5165\u5f02\u5e38", (Throwable)e);
                    }
                });
                final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u5238\u6b63\u5728\u8f6c\u5165...");
                this.status.set(true);
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (TransferFundPart.this.transferMark) {
                            if (TransferFundPart.this.fundMark) {
                                simpleStringProperty.set("\u5212\u8f6c\u6210\u529f\u3002");
                                logger.info("\u8d44\u5238\u5168\u90e8\u8f6c\u5165\u6210\u529f\uff0c\u91d1\u989d:" + TransferFundPart.this.allAmount);
                            } else {
                                simpleStringProperty.set("\u5212\u8f6c\u5931\u8d25:" + TransferFundPart.this.reason);
                                logger.info("\u8d44\u5238\u8f6c\u5165\u5212\u8f6c\u5931\u8d25:" + TransferFundPart.this.reason);
                            }
                        } else {
                            simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                            logger.info("\u8d44\u5238\u8f6c\u5165\u5212\u8f6c\u5931\u8d25:" + TransferFundPart.this.reason);
                        }
                        TransferFundPart.this.status.set(false);
                    }
                };
                Timer t = new Timer();
                t.schedule(task, this.timeOut);
                this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
                this.status.set(false);
                this.requery();
            }
        } else {
            DoTransferPosiDialog obj = (DoTransferPosiDialog)((Object)this.of.create(DoTransferPosiDialog.class));
            obj.setAccntInfo(this.fund);
            obj.setDirect(1);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u8bc1\u5238\u8f6c\u5165");
            HBox box = new HBox();
            Button btnOK = dialog.getButton(ButtonType.OK);
            Button btnCancel = dialog.getButton(ButtonType.CANCEL);
            if (btnOK != null) {
                HBox.setMargin((Node)btnOK, (Insets)new Insets(0.0, 20.0, 20.0, 0.0));
            }
            if (btnCancel != null) {
                HBox.setMargin((Node)btnCancel, (Insets)new Insets(0.0, 40.0, 20.0, 0.0));
            }
            if (dialog.launch() != ButtonType.OK) {
                return false;
            }
            this.requery();
        }
        return false;
    }

    public boolean posiOutAll() {
        if (!this.marginMark) {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u5238\u5168\u90e8\u8f6c\u51fa\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
                this.amount = Double.valueOf(this.txtFundOutAll.getText());
                this.fundId = new Random().nextInt(999999999);
                this.posiId = new Random().nextInt(999999999);
                this.operationType = 2;
                this.exe.execute(() -> {
                    try {
                        if (this.amount != 0.0) {
                            this.transApi.TransferFund(this.marketGrp, this.investorId, this.currencyId, -this.amount.doubleValue(), this.fundId, this.operationType);
                        }
                        this.transApi.TransferAllPosi(this.marketGrp, this.investorId, this.volume, this.posiId, this.operationType);
                    }
                    catch (MException e) {
                        logger.error("\u8d44\u5238\u5168\u90e8\u8f6c\u51fa\u5f02\u5e38", (Throwable)e);
                    }
                });
                this.status.set(true);
                final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u5238\u6b63\u5728\u8f6c\u51fa...");
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (TransferFundPart.this.transferMark) {
                            if (TransferFundPart.this.fundMark) {
                                simpleStringProperty.set("\u5212\u8f6c\u6210\u529f\u3002");
                                logger.info("\u8d44\u5238\u5168\u90e8\u8f6c\u51fa\u6210\u529f\uff0c\u91d1\u989d:" + TransferFundPart.this.allAmount);
                            } else {
                                simpleStringProperty.set("\u5212\u8f6c\u5931\u8d25:" + TransferFundPart.this.reason);
                                logger.info("\u8d44\u5238\u8f6c\u51fa\u5212\u8f6c\u5931\u8d25:" + TransferFundPart.this.reason);
                            }
                        } else {
                            simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                            logger.info("\u8d44\u5238\u8f6c\u51fa\u5212\u8f6c\u8d85\u65f6");
                        }
                        TransferFundPart.this.status.set(false);
                    }
                };
                Timer t = new Timer();
                t.schedule(task, this.timeOut);
                this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
                this.status.set(false);
                this.requery();
            }
        } else {
            DoTransferPosiDialog obj = (DoTransferPosiDialog)((Object)this.of.create(DoTransferPosiDialog.class));
            obj.setAccntInfo(this.fund);
            obj.setDirect(2);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u8bc1\u5238\u8f6c\u51fa");
            HBox box = new HBox();
            Button btnOK = dialog.getButton(ButtonType.OK);
            Button btnCancel = dialog.getButton(ButtonType.CANCEL);
            if (btnOK != null) {
                HBox.setMargin((Node)btnOK, (Insets)new Insets(0.0, 20.0, 20.0, 0.0));
            }
            if (btnCancel != null) {
                HBox.setMargin((Node)btnCancel, (Insets)new Insets(0.0, 40.0, 20.0, 0.0));
            }
            if (dialog.launch() != ButtonType.OK) {
                return false;
            }
            this.requery();
        }
        return false;
    }

    private void doSyncRequest(String investorId, String marketGrp) {
        try {
            this.transApi.getTransferResult(investorId, marketGrp);
        }
        catch (MException e) {
            logger.error("\u5f3a\u5236\u67e5\u8be2\u5212\u8f6c\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void doSyncAccount(String brokerId, String investorId, String marketGrp) {
        try {
            double accountAvailable = this.syncFundAccntImpl.syncAccount(brokerId, investorId, "", marketGrp);
            this.available = this.fm.format(accountAvailable);
            if (this.available.contains("-")) {
                this.txtFundOutAll.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u67dc\u53f0\u53ef\u8f6c\u51fa\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean checkFund(String textFund) {
        if (textFund.isEmpty()) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private boolean checkValid(Double amount) {
        if (amount == 0.0) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e\u96f6");
            return false;
        }
        return true;
    }

    public final DoubleProperty jzAvailableProperty() {
        return this.jzAvailable;
    }

    public final double getJzAvailable() {
        return this.jzAvailableProperty().get();
    }

    public final void setJzAvailable(double jzAvailable) {
        this.jzAvailableProperty().set(jzAvailable);
    }

    public List<CcsPosition> getList() {
        return this.posiList;
    }
}

