/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.StrSuggest;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.Result;
import cms.tmx.entity.SubSecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.PositionServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.Delta;
import cms.tmx.http.api.strategy.dto.DstPosAccnt;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetTransferPosReq;
import cms.tmx.http.api.strategy.dto.SrcPosAccnt;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.models.PositionOtcTransferModel;
import cms.tmx.trade.views.PositionTransferProgress;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.INewRefMng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class PositionOtcTransferDialog
extends DialogObj {
    @FXML
    private TableView<CcsPortfPosition> tableSrc;
    @FXML
    private TableView<CcsPortfPosition> tableDst;
    @FXML
    private TableColumn<CcsPortfPosition, Boolean> selected;
    @FXML
    private TableColumn<CcsPortfPosition, String> secAcct;
    @FXML
    private TableColumn<CcsPortfPosition, String> code;
    @FXML
    private TableColumn<CcsPortfPosition, String> name;
    @FXML
    private TableColumn<CcsPortfPosition, Number> canSell;
    @FXML
    private TableColumn<CcsPortfPosition, Number> canTransfer;
    @FXML
    private TableColumn<CcsPortfPosition, Number> count;
    @FXML
    private TableColumn<CcsPortfPosition, Number> costPrice;
    @FXML
    private TableColumn<CcsPortfPosition, Number> total;
    @FXML
    private TableColumn<CcsPortfPosition, String> flag;
    @FXML
    private TableColumn<CcsPortfPosition, String> market;
    @FXML
    private TableColumn<CcsPortfPosition, String> fundAcct;
    @FXML
    private TableColumn<CcsPortfPosition, String> subFundAcct;
    @FXML
    private TableColumn<CcsPortfPosition, String> subSecAcct;
    @FXML
    private TableColumn<CcsPortfPosition, String> dstSecAcct;
    @FXML
    private TableColumn<CcsPortfPosition, String> dstCode;
    @FXML
    private TableColumn<CcsPortfPosition, String> dstName;
    @FXML
    private TableColumn<CcsPortfPosition, Number> dstCanSell;
    @FXML
    private TableColumn<CcsPortfPosition, Number> dstTotal;
    @FXML
    private TableColumn<CcsPortfPosition, String> dstMarket;
    @FXML
    private VBox vbox;
    @FXML
    private HBox hboxSrc;
    @FXML
    private HBox hboxDest;
    @FXML
    private HBox hboxFund;
    @FXML
    private HBox hboxCurrency;
    @FXML
    private HBox hboxSec;
    @FXML
    private VBox vboxCode;
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private ComboBox<String> cmbFund;
    @FXML
    private CheckComboBox<SubSecAccount> checkSecAccnt;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private ComboBox<String> cmbSrc;
    @FXML
    private ComboBox<String> cmbDest;
    @FXML
    private Label lbDestErr;
    @FXML
    private Label lbDestErr1;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private GridPane gridTop;
    @FXML
    private GridPane gridBottom;
    @FXML
    private RadioButton radioOut;
    @FXML
    private RadioButton radioIn;
    @FXML
    private RadioButton radioOutIn;
    @Inject
    private IPortfolioApi portApi;
    @Inject
    private HttpBaseApi httpApi;
    @Inject
    private INewRefMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private PositionServiceApi transferApi;
    @Inject
    private PositionOtcTransferModel model;
    protected StrSuggest spSrc = new StrSuggest();
    protected StrSuggest spAcc = new StrSuggest();
    protected StrSuggest spDest = new StrSuggest();
    private ToggleGroup group = new ToggleGroup();
    private SecSuggest spCode = new SecSuggest();
    private static final Logger logger = LogManager.getLogger(PositionOtcTransferDialog.class);
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    public static final String SECURITY_SUB_TYPE_PUBLIC = "PUBLIC";
    @Inject
    @Named(value="fixed.query.pool")
    protected ExecutorService exe;
    private List<CcsPortfPosition> listSrc = new ArrayList<CcsPortfPosition>();
    private List<CcsPortfPosition> listDst = new ArrayList<CcsPortfPosition>();
    private MxList<CcsPortfPosition> mxListSrc = new MxList();
    private MxList<CcsPortfPosition> mxListDst = new MxList();
    private AtomicInteger cfmPacks = new AtomicInteger(0);
    private ObservableList<MxNode> listCur = FxUtils.newList();
    private static MxNode nodeMarket = MxNodeFactory.create((String)"market_code", (String)"");
    private Predicate<CcsPortfPosition> pdSrc = p -> {
        String code = this.txtCode.getText().trim();
        if (!p.getSecId().contains(code)) {
            return false;
        }
        return p.getCanVol() > 0L;
    };
    private Predicate<CcsPortfPosition> pdDst = p -> {
        String code = this.txtCode.getText().trim();
        if (!p.getSecId().contains(code)) {
            return false;
        }
        return p.getCanVol() > 0L;
    };
    protected InvalidationListener lstnModelBoth = ob -> {
        Platform.runLater(() -> {
            this.mxListSrc.update(this.listSrc, this.pdSrc);
            Collections.sort(this.mxListSrc.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
            this.tableSrc.sort();
        });
        Platform.runLater(() -> {
            this.mxListDst.update(this.listDst, this.pdDst);
            Collections.sort(this.mxListDst.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
            this.tableDst.sort();
        });
    };
    protected InvalidationListener lstnModelDst = ob -> Platform.runLater(() -> {
        this.mxListDst.update(this.listDst, this.pdDst);
        Collections.sort(this.mxListDst.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
        this.tableDst.sort();
    });
    private CheckBox checkBox = new CheckBox();
    InvalidationListener listener = ob -> {
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUND"}));
    };
    private int totalNum = 0;
    private boolean informed = false;
    private int curNum = 0;
    private Portfolio src;
    private Portfolio dst;
    @Inject
    private DialogFactory df;
    boolean srcflag = false;
    boolean dstflag = false;

    public void setParty(Party party) {
        this.model.setParty(party);
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{new ButtonType("\u5212\u8f6c", ButtonBar.ButtonData.OK_DONE)};
    }

    @FXML
    public void initialize() {
        this.model.queryPortfolio();
        this.model.queryAccnt();
        this.txtCode.textProperty().addListener(this.lstnModelBoth);
        this.createTable();
        this.cmbParty.setValue((Object)this.model.getParty());
        this.initValues();
        this.checkDest();
        this.onFocus();
    }

    @Focus
    public void onFocus() {
        this.tableSrc.refresh();
        this.tableDst.refresh();
    }

    private void createTable() {
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxListSrc.getList();
            synchronized (observableList) {
                this.mxListSrc.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.code.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secIdProperty());
        this.name.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secNameProperty());
        this.market.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).otcMarketProperty());
        this.total.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).totalDoubleOTCProperty());
        this.canSell.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).canVolDoubleOTCProperty());
        this.canTransfer.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).canVolDoubleOTCProperty());
        this.costPrice.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).priceNowProperty());
        this.costPrice.setCellFactory(data -> new EditTableCell(4));
        this.flag.setCellValueFactory(data -> new SimpleStringProperty("\u591a"));
        this.count.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).transferCountProperty());
        this.count.setCellFactory(p -> new WeightCell(2));
        this.canTransfer.setCellFactory(p -> new WeightCell(2));
        this.canTransfer.setEditable(false);
        this.canSell.setCellFactory(p -> new WeightCell(2));
        this.canSell.setEditable(false);
        this.total.setCellFactory(p -> new WeightCell(2));
        this.total.setEditable(false);
        this.secAcct.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).inverstorSecIdProperty());
        this.fundAcct.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).extAccIdProperty());
        this.subFundAcct.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).subAccntIdProperty());
        this.subSecAcct.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).subSecAccntIdProperty());
        this.tableSrc.setPlaceholder((Node)new Label());
        this.tableSrc.setItems(this.mxListSrc.getList());
        this.dstSecAcct.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).inverstorSecIdProperty());
        this.dstCode.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secIdProperty());
        this.dstName.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secNameProperty());
        this.dstMarket.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).otcMarketProperty());
        this.dstTotal.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).totalDoubleOTCProperty());
        this.dstCanSell.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).canVolDoubleOTCProperty());
        this.dstTotal.setCellFactory(p -> new WeightCell(2));
        this.dstTotal.setEditable(false);
        this.dstCanSell.setCellFactory(p -> new WeightCell(2));
        this.dstCanSell.setEditable(false);
        this.tableDst.setPlaceholder((Node)new Label());
        this.tableDst.setItems(this.mxListDst.getList());
    }

    private void getPortfoliosByFundAndSetDest() {
        String investorId = (String)this.cmbFund.getSelectionModel().getSelectedItem();
        Account acc = this.model.getMapAcc().get(investorId);
        if (acc == null) {
            return;
        }
        try {
            ObservableList listRelate = FxUtils.newList();
            List details = this.portApi.getPortfolioIdsByAccntId(acc.getId());
            for (PPortfolio.PortAccntAssignDetails detail : details) {
                if (detail.getAssignStatus() != 1) continue;
                listRelate.add((Object)detail.getPortfolioId());
            }
            this.cmbDest.getItems().clear();
            this.spDest.clearSuggestions();
            for (String src : this.model.getPortfolios()) {
                Portfolio po;
                String nowSrc = (String)this.cmbSrc.getSelectionModel().getSelectedItem();
                if (this.radioOutIn.isSelected() && src.equals(nowSrc) || !listRelate.contains((Object)(po = this.model.getMapPort().get(src)).getId())) continue;
                this.cmbDest.getItems().add((Object)src);
            }
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u8d26\u6237\u67e5\u6295\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void checkDest() {
        this.registerCheck((Node)this.lbDestErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> true, (Observable[])new Observable[]{this.cmbFund.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbDestErr1, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            this.lbDestErr1.setText("\u8bf7\u9009\u62e9\u76ee\u6807\u6295\u7ec4");
            if (this.cmbDest.getSelectionModel().getSelectedItem() == null && this.cmbFund.getSelectionModel().getSelectedItem() != null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbDest.getSelectionModel().selectedItemProperty()}));
    }

    private void initValues() {
        this.radioIn.setToggleGroup(this.group);
        this.radioOut.setToggleGroup(this.group);
        this.radioOutIn.setToggleGroup(this.group);
        this.radioOutIn.setSelected(true);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> this.onRadioChange());
        this.refMng.changedProperty().addListener(this.listener);
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 20)));
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUND"}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            RefItem refItem = (RefItem)this.txtCode.getUserData();
            if (refItem != null) {
                this.lbName.setText(refItem.getName());
            } else if ("".equals(this.txtCode.getText())) {
                this.lbName.setText("");
            } else {
                this.lbName.setText(INVALID_CODE);
            }
        });
        this.cmbSrc.setItems(this.model.getPortfolios());
        this.spSrc.addPossibleSuggestions(this.model.getPortfolios());
        Search.bindAutoCompletion((TextField)this.cmbSrc.getEditor(), (Callback)this.spSrc).setPrefWidth(150.0);
        this.cmbSrc.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSrc.getSelectionModel().select(now);
            this.cmbSrc.hide();
        });
        this.cmbSrc.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.onSrcChange((String)now);
        });
        Search.bindAutoCompletion((TextField)this.cmbFund.getEditor(), (Callback)this.spAcc).setPrefWidth(150.0);
        this.cmbFund.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbFund.getSelectionModel().select(now);
            this.cmbFund.hide();
        });
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onFundChange((String)now));
        this.cmbFund.setItems(this.model.getAccountList());
        this.checkSecAccnt.getCheckModel().getCheckedItems().addListener(ob -> this.onSecAccntChange());
        this.checkSecAccnt.setConverter((StringConverter)new StringConverter<SubSecAccount>(){

            public String toString(SubSecAccount object) {
                if (object != null) {
                    if (MarketUtils.getMarketNameById((String)object.getMarket()) == null) {
                        return object.getInvestorSecId();
                    }
                    return String.valueOf(object.getInvestorSecId()) + "__" + MarketUtils.getMarketNameById((String)object.getMarket());
                }
                return "";
            }

            public SubSecAccount fromString(String string) {
                return null;
            }
        });
        Search.bindAutoCompletion((TextField)this.cmbDest.getEditor(), (Callback)this.spDest).setPrefWidth(150.0);
        this.cmbDest.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbDest.getSelectionModel().select(now);
            this.cmbDest.hide();
        });
        this.cmbDest.setItems(this.model.getPortfoliosDest());
        this.spDest.addPossibleSuggestions(this.model.getPortfoliosDest());
        this.cmbDest.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onDestChange((String)now));
    }

    private void onRadioChange() {
        this.lbName.setText("");
        if (!this.checkSecAccnt.getItems().isEmpty()) {
            this.checkSecAccnt.getCheckModel().clearChecks();
        }
        this.txtCode.setText("");
        this.vbox.getChildren().clear();
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.radioIn.isSelected()) {
            list.add(this.gridTop);
            list.add(this.hboxFund);
            list.add(this.hboxDest);
            list.add(this.hboxSec);
            list.add(this.vboxCode);
            this.cmbFund.getEditor().clear();
            this.cmbDest.getEditor().clear();
            this.model.getAccountList().clear();
            this.model.getAccountList().addAll(this.model.getAccounts());
            this.spAcc.setAllSuggestions(this.model.getAccountList());
        } else {
            this.model.getPortfoliosDest().setAll(this.model.getPortfolios());
            this.spDest.setAllSuggestions(this.model.getPortfoliosDest());
        }
        if (this.radioOut.isSelected()) {
            list.add(this.gridTop);
            list.add(this.hboxSrc);
            list.add(this.hboxFund);
            list.add(this.hboxSec);
            list.add(this.vboxCode);
            this.cmbSrc.getEditor().clear();
            this.cmbFund.getEditor().clear();
        }
        if (this.radioOutIn.isSelected()) {
            list.add(this.gridTop);
            list.add(this.hboxSrc);
            list.add(this.hboxDest);
            list.add(this.hboxFund);
            list.add(this.hboxSec);
            list.add(this.vboxCode);
            this.cmbSrc.getEditor().clear();
            this.cmbDest.getEditor().clear();
        }
        this.vbox.getChildren().addAll(list);
        this.mapValid.clear();
        if (!this.radioOut.isSelected()) {
            this.checkDest();
        }
        this.lbDestErr.setOpacity(0.0);
        this.lbDestErr1.setOpacity(0.0);
    }

    private void onSrcChange(String now) {
        if (now == null) {
            this.mxListSrc.clear();
            this.listSrc.clear();
        }
        try {
            if (this.radioOut.isSelected()) {
                this.model.setFund(now, "");
            }
            if (this.radioOutIn.isSelected()) {
                this.model.setFund(now, (String)this.cmbDest.getSelectionModel().getSelectedItem());
            }
            this.spAcc.setAllSuggestions(this.model.getAccountList());
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u4e00\u7ea7\u8d26\u6237\u5931\u8d25\uff1a", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void onDestChange(String now) {
        if (now == null || now.isEmpty()) {
            this.mxListDst.clear();
            this.listDst.clear();
            if (!this.checkSecAccnt.getItems().isEmpty()) {
                this.checkSecAccnt.getCheckModel().clearChecks();
            }
            return;
        }
        if (this.radioIn.isSelected()) {
            List<SubSecAccount> listBoth = this.model.getSubSecAccounts(this.model.getAccntSelected(), now, ((MxNode)this.listCur.get(0)).getRaw());
            this.resetCheckCombobox(listBoth);
        } else if (this.radioOutIn.isSelected()) {
            this.srcflag = false;
            this.dstflag = false;
            try {
                this.model.setFund((String)this.cmbSrc.getSelectionModel().getSelectedItem(), now);
                this.spAcc.setAllSuggestions(this.model.getAccountList());
            }
            catch (MException e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u4e00\u7ea7\u8d26\u6237\u5931\u8d25\uff1a", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }

    private void onFundChange(String now) {
        List<SubSecAccount> listBoth;
        if (!this.checkSecAccnt.getItems().isEmpty()) {
            this.checkSecAccnt.getCheckModel().clearChecks();
        }
        this.checkSecAccnt.getItems().clear();
        this.model.setAccntSelected(this.model.getMapAcc().get(now));
        if (this.model.getAccntSelected() == null) {
            this.mxListSrc.clear();
            this.mxListDst.clear();
            this.listSrc.clear();
            this.listDst.clear();
            return;
        }
        String mktGrp = MarketUtils.getMarketGroup((String)((String)this.model.getAccntSelected().getSecExc().get(0)));
        this.model.setMktGrp(mktGrp);
        this.listCur.clear();
        for (String str : this.model.getAccntSelected().getCurrency()) {
            MxNode node1 = MxNodeFactory.create((String)"currency_type", (String)"CNY");
            node1.setRaw(str);
            this.listCur.add((Object)node1);
        }
        if (this.radioOut.isSelected()) {
            listBoth = this.model.getSubSecAccounts(this.model.getAccntSelected(), (String)this.cmbSrc.getSelectionModel().getSelectedItem(), ((MxNode)this.listCur.get(0)).getRaw());
            this.resetCheckCombobox(listBoth);
        }
        if (this.radioOutIn.isSelected()) {
            listBoth = this.model.getSubSecAccounts((String)this.cmbSrc.getSelectionModel().getSelectedItem(), (String)this.cmbDest.getSelectionModel().getSelectedItem(), ((MxNode)this.listCur.get(0)).getRaw());
            this.resetCheckCombobox(listBoth);
        }
        if (this.radioIn.isSelected()) {
            this.getPortfoliosByFundAndSetDest();
        }
    }

    public void onFinished(ButtonType bt) {
        if (bt.getButtonData().isCancelButton()) {
            this.refMng.changedProperty().removeListener(this.listener);
        }
    }

    public boolean isOK(ButtonType bt) {
        if (!this.checkValid()) {
            return false;
        }
        Result result = new Result();
        PositionTransferProgress obj = (PositionTransferProgress)((Object)this.of.create(PositionTransferProgress.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u5212\u8f6c\u4efb\u52a1");
        dialog.getCtrl().getBtnClose().setVisible(false);
        dialog.getButton(ButtonType.CLOSE).setDisable(true);
        dialog.getButton(ButtonType.CLOSE).setVisible(false);
        String srcName = (String)this.cmbSrc.getSelectionModel().getSelectedItem();
        this.src = this.model.getMapPort().get(srcName);
        String dstName = (String)this.cmbDest.getSelectionModel().getSelectedItem();
        this.dst = this.model.getMapPort().get(dstName);
        if (this.src == null) {
            this.src = (Portfolio)this.of.create(Portfolio.class);
            this.src.setPartyId(this.dst.getPartyId());
        }
        if (this.dst == null && !this.radioOut.isSelected()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u672a\u627e\u5230\u76ee\u6807\u6295\u7ec4");
            return false;
        }
        ObservableList checkedItems = this.checkSecAccnt.getCheckModel().getCheckedItems();
        ArrayList<PAccount.SubSecAccnt> subZeroSecs = new ArrayList<PAccount.SubSecAccnt>();
        ArrayList<PAccount.SubSecAccnt> subSecs = new ArrayList<PAccount.SubSecAccnt>();
        if (this.radioOut.isSelected()) {
            subZeroSecs.addAll(this.model.getSubSecs(true, (ObservableList<SubSecAccount>)checkedItems));
        } else {
            subSecs.addAll(this.model.getSubSecs(false, (ObservableList<SubSecAccount>)checkedItems));
        }
        Platform.runLater(() -> dialog.launch());
        this.exe.execute(() -> {
            this.informed = false;
            this.cfmPacks.set(0);
            this.totalNum = 0;
            this.curNum = 0;
            this.totalNum = this.tableSrc.getItems().stream().filter(pos -> pos.isSelected() && pos.getTransferCount() > 0.0).collect(Collectors.toList()).size();
            CountDownLatch latch = new CountDownLatch(this.totalNum);
            for (CcsPortfPosition posi : this.tableSrc.getItems()) {
                if (!posi.isSelected() || !(posi.getTransferCount() > 0.0)) continue;
                ++this.curNum;
                GetTransferPosReq req = new GetTransferPosReq();
                req.setOpUser(this.httpApi.getHttpOpUser());
                req.setMarketGroup("CCS");
                Delta delta = new Delta();
                Instrument inst = new Instrument();
                inst.setSecurityId(posi.getSecId());
                inst.setSymbol(posi.getSecName());
                inst.setMarket("XOTC");
                inst.setMarketGroup("CCS");
                inst.setCurrencyId("CNY");
                inst.setSecurityType(posi.getSecType());
                inst.setSecuritySubType(SECURITY_SUB_TYPE_PUBLIC);
                delta.setInstrument(inst);
                delta.setQty(posi.getTransferCount());
                delta.setCost(posi.getPriceNow());
                delta.setAmt(delta.getCost() * posi.getTransferCount());
                req.setDelta(delta);
                SrcPosAccnt srcPos = new SrcPosAccnt();
                srcPos.setAccntType(AccntType.ACCNT_TYPE_SEC);
                srcPos.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
                srcPos.setAccntId(posi.getExtAccId());
                srcPos.setLinkSubAccntId(posi.getLinkSubAccntId());
                srcPos.setSecAccntId(posi.getSubSecAccntId());
                if ((this.radioOut.isSelected() || this.radioOutIn.isSelected()) && this.src != null) {
                    srcPos.setPortfolioId(this.src.getId());
                }
                req.setSrcPosAccnt(srcPos);
                DstPosAccnt dstPos = new DstPosAccnt();
                dstPos.setAccntType(AccntType.ACCNT_TYPE_SEC);
                dstPos.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
                dstPos.setAccntId(posi.getExtAccId());
                if ((this.radioIn.isSelected() || this.radioOutIn.isSelected()) && this.dst != null) {
                    dstPos.setPortfolioId(this.dst.getId());
                }
                if (this.radioOut.isSelected()) {
                    for (PAccount.SubSecAccnt subSecAccnt : subZeroSecs) {
                        if (!subSecAccnt.getInvestorSecId().equals(this.model.getInvestorSecId(posi.getSubSecAccntId()))) continue;
                        dstPos.setSecAccntId(subSecAccnt.getSubSecAccntId());
                    }
                } else {
                    for (PAccount.SubSecAccnt subSecAccnt : subSecs) {
                        if (!subSecAccnt.getInvestorSecId().equals(this.model.getInvestorSecId(posi.getSubSecAccntId()))) continue;
                        dstPos.setSecAccntId(subSecAccnt.getSubSecAccntId());
                    }
                }
                req.setDstPosAccnt(dstPos);
                this.exe.execute(() -> {
                    block10: {
                        try {
                            try {
                                GetExtPositionsResp resp = this.transferApi.TransferPosition(req);
                                resp.getStatus();
                                result.operate(true);
                                this.cfmPacks.getAndIncrement();
                            }
                            catch (MException | IOException e) {
                                logger.error("\u8bc1\u5238\u5212\u8f6c\u5931\u8d25\uff1a", e);
                                if (posi.getExtSecAccId() != null && posi.getExtSecAccId().indexOf("_") > 0) {
                                    result.getReason().append("\n" + posi.getExtSecAccId().substring(0, posi.getExtSecAccId().indexOf("_")) + " " + posi.getSecId() + ": " + e.getMessage());
                                } else {
                                    result.getReason().append("\n" + posi.getExtSecAccId() + " " + posi.getSecId() + ": " + e.getMessage());
                                }
                                result.operate(false);
                                this.cfmPacks.getAndIncrement();
                                Platform.runLater(() -> {
                                    positionTransferProgress.progressBar.setProgress((double)this.cfmPacks.intValue() / (double)this.totalNum);
                                    positionTransferProgress.label.setText("\u6b63\u5728\u4e3a\u60a8\u5212\u8f6c\u2026(" + this.cfmPacks.intValue() + "/" + this.totalNum + ")");
                                });
                                if (this.cfmPacks.intValue() == this.totalNum && !this.informed) {
                                    this.informed = true;
                                    Platform.runLater(() -> dialog.close());
                                    Platform.runLater(() -> {
                                        if (result.failed > 0) {
                                            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                        } else {
                                            this.alert.alert(Alert.AlertType.INFORMATION, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                        }
                                        this.checkBox.setSelected(false);
                                    });
                                }
                                latch.countDown();
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            Platform.runLater(() -> {
                                positionTransferProgress.progressBar.setProgress((double)this.cfmPacks.intValue() / (double)this.totalNum);
                                positionTransferProgress.label.setText("\u6b63\u5728\u4e3a\u60a8\u5212\u8f6c\u2026(" + this.cfmPacks.intValue() + "/" + this.totalNum + ")");
                            });
                            if (this.cfmPacks.intValue() == this.totalNum && !this.informed) {
                                this.informed = true;
                                Platform.runLater(() -> dialog.close());
                                Platform.runLater(() -> {
                                    if (result.failed > 0) {
                                        this.alert.alert(Alert.AlertType.ERROR, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                    } else {
                                        this.alert.alert(Alert.AlertType.INFORMATION, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                    }
                                    this.checkBox.setSelected(false);
                                });
                            }
                            latch.countDown();
                            throw throwable;
                        }
                        Platform.runLater(() -> {
                            positionTransferProgress.progressBar.setProgress((double)this.cfmPacks.intValue() / (double)this.totalNum);
                            positionTransferProgress.label.setText("\u6b63\u5728\u4e3a\u60a8\u5212\u8f6c\u2026(" + this.cfmPacks.intValue() + "/" + this.totalNum + ")");
                        });
                        if (this.cfmPacks.intValue() == this.totalNum && !this.informed) {
                            this.informed = true;
                            Platform.runLater(() -> dialog.close());
                            Platform.runLater(() -> {
                                if (result.failed > 0) {
                                    this.alert.alert(Alert.AlertType.ERROR, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                } else {
                                    this.alert.alert(Alert.AlertType.INFORMATION, String.valueOf(result.getDesc("\u5212\u8f6c")) + result.getReason());
                                }
                                this.checkBox.setSelected(false);
                            });
                        }
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.onSecAccntChange();
        });
        return false;
    }

    private boolean checkValid() {
        if (this.radioOutIn.isSelected() || this.radioOut.isSelected()) {
            String srcName = this.cmbSrc.getEditor().getText();
            Portfolio src = this.model.getMapPort().get(srcName);
            if (src == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6e90\u6295\u7ec4");
                return false;
            }
        }
        String investorId = this.cmbFund.getEditor().getText();
        Account acc = this.model.getMapAcc().get(investorId);
        if (acc == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        if (this.radioOutIn.isSelected() || this.radioIn.isSelected()) {
            String destName = this.cmbDest.getEditor().getText();
            if (!this.cmbDest.getItems().contains((Object)destName)) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u76ee\u6807\u6295\u7ec4");
                return false;
            }
        }
        int selectedNum = 0;
        int validNum = 0;
        for (CcsPortfPosition posi : this.tableSrc.getItems()) {
            if (!posi.isSelected()) continue;
            ++selectedNum;
            if (!(posi.getTransferCount() > 0.0)) continue;
            ++validNum;
        }
        if (selectedNum == 0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u52fe\u9009\u8981\u5212\u8f6c\u7684\u6301\u4ed3");
            return false;
        }
        if (validNum == 0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u6570\u91cf\u5168\u90e8\u4e3a\u96f6");
            return false;
        }
        return true;
    }

    private void resetCheckCombobox(List<SubSecAccount> secAccs) {
        if (!this.checkSecAccnt.getItems().isEmpty()) {
            this.checkSecAccnt.getCheckModel().clearChecks();
        }
        this.checkSecAccnt.getItems().clear();
        for (SubSecAccount se : secAccs) {
            nodeMarket.setRaw(se.getMarket());
        }
        SubSecAccount sec = new SubSecAccount();
        sec.setMarket("ALL_CHECK");
        sec.setInvestorSecId("\u5168\u9009");
        secAccs.add(0, sec);
        secAccs = secAccs.stream().filter(item -> "XOTC".equals(item.getMarket()) || "ALL_CHECK".equals(item.getMarket())).distinct().collect(Collectors.toList());
        this.checkSecAccnt.getItems().setAll(secAccs);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.checkSecAccnt);
        checkComboBoxModel.init();
    }

    private void onSecAccntChange() {
        this.exe.execute(() -> {
            Object id;
            String portName;
            ObservableList checkedItems = this.checkSecAccnt.getCheckModel().getCheckedItems();
            if (checkedItems.size() == 0) {
                return;
            }
            if (this.radioIn.isSelected()) {
                this.listSrc = this.model.getPosition("", (List<SubSecAccount>)checkedItems);
            } else {
                portName = (String)this.cmbSrc.getSelectionModel().getSelectedItem();
                if (this.model.getMapPort().get(portName) != null) {
                    id = this.model.getMapPort().get(portName).getId();
                    this.listSrc = this.model.getPosition((String)id, (List<SubSecAccount>)checkedItems);
                }
            }
            for (CcsPortfPosition po : this.listSrc) {
                po.setTransferCount(po.getCanVolDouble());
            }
            Platform.runLater(() -> {
                this.mxListSrc.update(this.listSrc, this.pdSrc);
                for (CcsPortfPosition po : this.mxListSrc.getList()) {
                    po.setTransferCount(po.getCanVolDouble());
                    po.setSelected(false);
                }
                this.tableSrc.sort();
            });
            if (this.radioOut.isSelected()) {
                this.dstflag = false;
                this.listDst = this.model.getPosition("", (List<SubSecAccount>)checkedItems);
            } else {
                this.dstflag = true;
                portName = (String)this.cmbDest.getSelectionModel().getSelectedItem();
                if (portName == null || this.model.getMapPort().get(portName) == null) {
                    return;
                }
                id = this.model.getMapPort().get(portName).getId();
                this.listDst = this.model.getPosition((String)id, (List<SubSecAccount>)checkedItems);
            }
            Platform.runLater(() -> {
                this.mxListDst.update(this.listDst, this.pdDst);
                Collections.sort(this.mxListDst.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
                this.tableDst.sort();
                this.tableDst.refresh();
            });
        });
    }

    private class WeightCell
    extends EditTableCell<CcsPortfPosition> {
        WeightCell(int i) {
            super(i);
        }

        public void commitEdit(Number newValue) {
            TableView table;
            CcsPortfPosition po = (CcsPortfPosition)this.getTableRow().getItem();
            if (po == null) {
                PositionOtcTransferDialog.this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u884c\u8bb0\u5f55\u4e3a\u7a7a");
                return;
            }
            long newVal = po.getCanVol();
            if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                TableColumn col = this.getTableColumn();
                if ((long)newValue.intValue() > newVal) {
                    TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newVal);
                    Event.fireEvent((EventTarget)col, (Event)event);
                } else {
                    TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
                    Event.fireEvent((EventTarget)col, (Event)event);
                }
            }
            if ((long)newValue.intValue() > newVal) {
                super.commitEdit((Number)newVal);
            } else {
                super.commitEdit(newValue);
            }
        }
    }
}

