/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.trade.entrust.SingleEntrust;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;

public class EntrustConfirmDialog<T extends SingleEntrust>
extends DialogObj {
    @FXML
    private TableView<T> tableItems;
    @FXML
    private TableColumn<T, String> index;
    @FXML
    private TableColumn<T, String> colCode;
    @FXML
    private TableColumn<T, String> colName;
    @FXML
    private TableColumn<T, String> colMkt;
    @FXML
    private TableColumn<T, Number> colDirection;
    @FXML
    private TableColumn<T, Number> colCount;
    @FXML
    private TableColumn<T, Number> colPrice;
    @FXML
    private TableColumn<T, Number> colAmt;
    @FXML
    private TableColumn<T, String> colAcc;
    @FXML
    private TableColumn<T, String> colSecAcc;
    @FXML
    private TableColumn<T, String> colPorfolio;
    @FXML
    private TableColumn<T, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @Inject
    private MObjFactory of;
    private ObservableList<T> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    private long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    private boolean triggered = false;
    private RefItem refItem;
    private MxNode priceStg;
    private String type = "";
    private String custom = "";
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeMktStg;
    private MxNode priceTypeBidAskStg;
    private static int PAR_VALUE = 100;
    private boolean isInstruction = false;
    private String instructionType = "";
    private boolean isExecution = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String approveSymbol = "\u5ba1\u6279\u901a\u8fc7";

    public EntrustConfirmDialog() {
        this.fxml = "CcsEntrustConfirmDialog.fxml";
    }

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
    }

    private void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        if (!this.AmtIsEmpty()) {
            this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        }
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void calTotalInfo() {
        for (SingleEntrust item : this.list) {
            double money = this.getMoney(item);
            if (this.isBuy(item)) {
                Double num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            this.totalCount += item.getQuantity().longValue();
            this.totalAmt += money;
            if (!this.checkSufficient(item)) continue;
            this.triggered = true;
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        for (FundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getAvailable() < this.accBuyMap.get(acc))) continue;
            this.strTip = String.valueOf(this.strTip) + acc.getInvestId() + "\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t";
        }
    }

    private boolean checkSufficient(T item) {
        switch (((SingleEntrust)((Object)item)).getSide()) {
            case 49: 
            case 70: {
                ((SingleEntrust)((Object)item)).setInsufficient(this.getMoney(item) > ((SingleEntrust)((Object)item)).getFundAccount().getAvailable());
                ((SingleEntrust)((Object)item)).setTip(((SingleEntrust)((Object)item)).isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case 50: {
                ((SingleEntrust)((Object)item)).setInsufficient(((SingleEntrust)((Object)item)).getQuantity() > ((SingleEntrust)((Object)item)).getCanSell());
                ((SingleEntrust)((Object)item)).setTip(((SingleEntrust)((Object)item)).isInsufficient() ? "\u53ef\u5356\u6570\u4e0d\u8db3" : "");
                break;
            }
            case 71: {
                ((SingleEntrust)((Object)item)).setInsufficient(((SingleEntrust)((Object)item)).getQuantity() > ((SingleEntrust)((Object)item)).getCanBuy());
                ((SingleEntrust)((Object)item)).setTip(((SingleEntrust)((Object)item)).isInsufficient() ? "\u6807\u51c6\u5238\u4e0d\u8db3" : "");
                if (this.instructionType.isEmpty()) break;
                ((SingleEntrust)((Object)item)).setInsufficient(false);
                ((SingleEntrust)((Object)item)).setTip("");
                break;
            }
            case 83: {
                ((SingleEntrust)((Object)item)).setInsufficient(((SingleEntrust)((Object)item)).getQuantity() > ((SingleEntrust)((Object)item)).getCanSell());
                ((SingleEntrust)((Object)item)).setTip(((SingleEntrust)((Object)item)).isInsufficient() ? "\u53ef\u51fa\u5e93\u6570\u91cf\u4e0d\u8db3" : "");
                break;
            }
            case 82: {
                ((SingleEntrust)((Object)item)).setInsufficient(((SingleEntrust)((Object)item)).getQuantity() > ((SingleEntrust)((Object)item)).getCanBuy());
                ((SingleEntrust)((Object)item)).setTip(((SingleEntrust)((Object)item)).isInsufficient() ? "\u53ef\u5165\u5e93\u6570\u91cf\u4e0d\u8db3" : "");
            }
        }
        return ((SingleEntrust)((Object)item)).isInsufficient();
    }

    private void createTable() {
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("market_code", "");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).secProperty());
        this.colName.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((SingleEntrust)((Object)((Object)m.getValue()))).getMarket()).getValue()));
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).sideProperty());
        this.colCount.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        if (this.isAlgo()) {
            this.colPrice.setCellValueFactory(data -> new SimpleObjectProperty((Object)this.custom));
            this.colPrice.setText("\u7b97\u6cd5\u540d\u79f0");
        } else if (!this.priceIsEmpty()) {
            this.colPrice.setCellFactory(cell -> new ItemPriceCell());
            this.colPrice.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).priceProperty());
        }
        if (!this.AmtIsEmpty()) {
            this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
            this.colAmt.setCellValueFactory(m -> new SimpleDoubleProperty(this.getMoney((SingleEntrust)((Object)((Object)m.getValue())))));
        }
        this.colAcc.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).investorSecIdProperty());
        this.colPorfolio.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).portfolioNameProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((SingleEntrust)((Object)((Object)m.getValue()))).tipProperty());
        this.tableItems.setItems(this.list);
    }

    private boolean isBuy(T item) {
        return ((SingleEntrust)((Object)item)).getSide() == 49 || ((SingleEntrust)((Object)item)).getSide() == 71;
    }

    private boolean isSell(T item) {
        return ((SingleEntrust)((Object)item)).getSide() == 50;
    }

    private int getParValue(T item) {
        return ((SingleEntrust)((Object)item)).getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(T item) {
        switch (((SingleEntrust)((Object)item)).getSide()) {
            case 70: 
            case 71: {
                return ((SingleEntrust)((Object)item)).getQuantity() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(((SingleEntrust)((Object)item)).getMarket()) && "BOND".equals(((SingleEntrust)((Object)item)).getSecType())) {
            return (double)((SingleEntrust)((Object)item)).getQuantity().longValue() * ((SingleEntrust)((Object)item)).getPrice() * 10.0;
        }
        return (double)((SingleEntrust)((Object)item)).getQuantity().longValue() * ((SingleEntrust)((Object)item)).getPrice();
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    private MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setList(List<T> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setIsInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeMktStg() {
        return this.priceTypeMktStg;
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStg = priceTypeMktStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<T, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            SingleEntrust item = (SingleEntrust)((Object)this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            if (EntrustConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 49) {
                    this.setText(EntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + EntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else if (item.getOrderType() == 50) {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = EntrustConfirmDialog.this.getRefItem() != null ? EntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        text = "-" + StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    }
                    this.setText(String.valueOf(EntrustConfirmDialog.this.getPriceTypeLimitedStg() != null ? EntrustConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 0) {
                    this.setText(EntrustConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + EntrustConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = EntrustConfirmDialog.this.getRefItem() != null ? EntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    this.setText(text);
                }
            } else if (item.getOrderType() == 49) {
                if (EntrustConfirmDialog.this.isExecution) {
                    this.setText(EntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + EntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.setText(EntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + EntrustConfirmDialog.this.getPriceStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                }
            } else {
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                double unit = EntrustConfirmDialog.this.getRefItem() != null ? EntrustConfirmDialog.this.getRefItem().getPriceUnit() : 0.01;
                String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                this.setText(text);
            }
        }
    }

    private class SideCell
    extends TableCell<T, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = ((MxNode)EntrustConfirmDialog.this.of.create(MxNode.class)).load("side", "");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            if (EntrustConfirmDialog.this.isInstruction) {
                if (49 == side) {
                    this.label.setText(EntrustConfirmDialog.this.buySymbol);
                } else if (50 == side) {
                    this.label.setText(EntrustConfirmDialog.this.sellSymbol);
                } else if ("3".equals(EntrustConfirmDialog.this.instructionType)) {
                    this.label.setText(EntrustConfirmDialog.this.approveSymbol);
                } else {
                    this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
                }
            } else {
                this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
            }
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<T, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

