/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.api.trade.IQueryPositionsApi;
import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.notice.OpStatusReport;
import cms.tmx.entity.notice.TransferFundReport;
import cms.tmx.entity.notice.TransferPositionReport;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.SyncFundAccntServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class DoubleCenterTransferPart
extends MxPart {
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<FundAccount> cmbFundIn;
    @FXML
    private ComboBox<TradeCounter> cmbInCount;
    @FXML
    private ComboBox<TradeCounter> cmbOutCount;
    @FXML
    private ComboBox<TradeCounter> cmbSecInCount;
    @FXML
    private ComboBox<TradeCounter> cmbSecOutCount;
    @FXML
    private TextField txtAvaFund;
    @FXML
    private TextField txtAvaFundIn;
    @FXML
    private TextField txtFundOutAll;
    @FXML
    private TextField txtFundInAll;
    @FXML
    private TextField txtFundOut;
    @FXML
    private TextField txtFundIn;
    @FXML
    private TextField txtOutCode;
    @FXML
    private TextField txtInCode;
    @FXML
    private TextField txtOutQty;
    @FXML
    private TextField txtInQty;
    @FXML
    private TextField txtAvaOutQty;
    @FXML
    private TextField txtAvaInQty;
    @FXML
    private Button btnFundOut;
    @FXML
    private Button btnPosiOut;
    @FXML
    private Button btnFundIn;
    @FXML
    private Button btnPosiIn;
    @FXML
    private Label lbOutCodeName;
    @FXML
    private Label lbInCodeName;
    @Inject
    private FundAccountMngServiceImpl fundAccountMng;
    @Inject
    private ExecutorService exe;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IQueryPositionsApi apiPosition;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ITransferFundApi transApi;
    @Inject
    private SyncFundAccntServiceImpl syncFundAccntImpl;
    @Inject
    private TradeCounterServiceImpl tradeCSImp;
    private BooleanProperty status = new SimpleBooleanProperty(false);
    private String reason = "";
    private int avaId;
    private int avaIdIn;
    private int posiAvaId;
    private int posiAvaIdIn;
    private int fundId;
    private int posiId;
    private int timeOut = 2500;
    private int timeGet = 300;
    private DoubleProperty jzAvailable = new SimpleDoubleProperty();
    private DoubleProperty jzInAvailable = new SimpleDoubleProperty();
    private String brokerId;
    private String brokerIdIn;
    private String available;
    private String availableIn;
    private String investorId;
    private String marketGrp;
    private String currencyId;
    private String investorIdIn;
    private String marketGrpIn;
    private String currencyIdIn;
    private String fundTxt;
    private String fundTxtAll;
    DecimalFormat fm = new DecimalFormat("0.00");
    private double pushAvailable;
    private double pushAvailableIn;
    private boolean transferMark = false;
    private boolean fundMark = false;
    @Inject
    protected PositionFactory ft;
    private List<PMainTenance.TransferPosition> transferPosiList = new LinkedList<PMainTenance.TransferPosition>();
    private List<CcsPosition> posiList = new LinkedList<CcsPosition>();
    private List<PMainTenance.TransferPosition> transferPosiListIn = new LinkedList<PMainTenance.TransferPosition>();
    private List<CcsPosition> posiListIn = new LinkedList<CcsPosition>();
    protected AutoCompletion<RefItem> autoCompletionOut;
    protected AutoCompletion<RefItem> autoCompletionIn;
    protected SecSuggest spCode = new SecSuggest();
    private SecConverter secCvt;
    @Inject
    protected IRefDataMng refMng;
    private boolean flag = false;
    private InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private String codeOut;
    private String codeIn;
    private String codeNameOut;
    private String codeNameIn;
    private String codeMarketOut;
    private String codeMarketIn;
    private String secTypeOut;
    private String secTypeIn;
    private String secAccntIdOut;
    private String secAccntIdIn;
    private double amount;
    private double allAmount;
    private int operationType;
    int volume = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onPush(MEvent event) {
        Object obj = event.getObj();
        String type = event.getStr("push_type");
        if ("407".equals(type)) {
            Platform.runLater(() -> {
                TransferFundReport report = (TransferFundReport)TransferFundReport.class.cast(obj);
                int status = report.getReport().getStatus();
                this.reason = report.getReport().getErrorInfo();
                if (report.getReport().getSeq() == this.avaId && status == 1 && report.getReport().getInvestorId().equals(((FundAccount)this.cmbFund.getValue()).getInvestId())) {
                    this.pushAvailable = report.getReport().getAvailable();
                    this.jzAvailable.set(this.pushAvailable >= 0.0 ? this.pushAvailable : 0.0);
                    this.logger.info("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u51fa\u8d44\u91d1:" + this.jzAvailable);
                } else if (report.getReport().getSeq() == this.avaIdIn && status == 1 && report.getReport().getInvestorId().equals(((FundAccount)this.cmbFundIn.getValue()).getInvestId())) {
                    this.pushAvailableIn = report.getReport().getAvailable();
                    this.jzInAvailable.set(this.pushAvailableIn >= 0.0 ? this.pushAvailableIn : 0.0);
                    this.logger.info("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u5165\u8d44\u91d1:" + this.jzInAvailable);
                } else {
                    if (report.getReport().getSeq() == this.avaId) {
                        this.pushAvailable = 0.0;
                        this.jzAvailable.set(this.pushAvailable);
                    }
                    if (report.getReport().getSeq() == this.avaIdIn) {
                        this.pushAvailableIn = 0.0;
                        this.jzInAvailable.set(this.pushAvailableIn);
                    }
                    this.logger.debug("get push fund available faild->  status:" + status + " reason:" + this.reason);
                    this.logger.error("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u51fa\u8f6c\u5165\u8d44\u91d1\u5931\u8d25:" + this.reason);
                }
            });
        }
        if ("408".equals(type)) {
            TransferPositionReport report = (TransferPositionReport)TransferPositionReport.class.cast(obj);
            int status = report.getReport().getStatus();
            this.reason = report.getReport().getErrorInfo();
            if (report.getReport().getSeq() == this.posiAvaId && status == 1) {
                this.transferPosiList = report.getReport().getPositionList();
                List<CcsPosition> list = this.posiList;
                synchronized (list) {
                    for (PMainTenance.TransferPosition pPosition : this.transferPosiList) {
                        CcsPosition position = (CcsPosition)this.ft.createCcs();
                        position.setInvestorId(report.getReport().getInvestorId());
                        position.setMarketGrp(report.getReport().getMarketGrp());
                        position.setSecId(pPosition.getInstrument().getSecurityId());
                        position.setSecName(pPosition.getInstrument().getSymbol());
                        position.setSecType(pPosition.getInstrument().getSecurityType());
                        position.setCanVol((long)((int)pPosition.getTransferAvailable()));
                        position.setCanVolDouble(pPosition.getTransferAvailable());
                        position.setExtSecAccId(pPosition.getSecAccntId());
                        position.getMarket().setRaw(pPosition.getInstrument().getMarket());
                        if (this.txtOutCode.getText().equals(position.getSecId())) {
                            this.txtAvaOutQty.setText(String.valueOf(position.getCanVol()));
                            this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + position.getSecId() + " \u6301\u4ed3\u6570\u91cf\uff1a" + position.getCanVol());
                            this.secAccntIdOut = pPosition.getSecAccntId();
                        }
                        this.posiList.add(position);
                    }
                }
            } else if (report.getReport().getSeq() == this.posiAvaIdIn && status == 1) {
                this.transferPosiListIn = report.getReport().getPositionList();
                List<CcsPosition> list = this.posiListIn;
                synchronized (list) {
                    for (PMainTenance.TransferPosition pPosition : this.transferPosiListIn) {
                        CcsPosition position = (CcsPosition)this.ft.createCcs();
                        position.setInvestorId(report.getReport().getInvestorId());
                        position.setMarketGrp(report.getReport().getMarketGrp());
                        position.setSecId(pPosition.getInstrument().getSecurityId());
                        position.setSecName(pPosition.getInstrument().getSymbol());
                        position.setSecType(pPosition.getInstrument().getSecurityType());
                        position.setCanVol((long)((int)pPosition.getTransferAvailable()));
                        position.setCanVolDouble(pPosition.getTransferAvailable());
                        position.setExtSecAccId(pPosition.getSecAccntId());
                        position.getMarket().setRaw(pPosition.getInstrument().getMarket());
                        if (this.txtOutCode.getText().equals(position.getSecId())) {
                            this.txtAvaOutQty.setText(String.valueOf(position.getCanVol()));
                            this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + position.getSecId() + " \u6301\u4ed3\u6570\u91cf\uff1a" + position.getCanVol());
                            this.secAccntIdIn = pPosition.getSecAccntId();
                        }
                        this.posiListIn.add(position);
                    }
                }
            } else {
                this.logger.debug("get position faild->  status:" + status + " reason:" + this.reason);
                this.logger.error("get position faild->  status:" + status + " reason:" + this.reason);
            }
            return;
        }
        if (!"403".equals(type) && !"404".equals(type)) {
            return;
        }
        OpStatusReport report = (OpStatusReport)OpStatusReport.class.cast(obj);
        if (!String.valueOf(this.fundId).equals(report.getReport().getData()) && !String.valueOf(this.posiId).equals(report.getReport().getData())) {
            return;
        }
        int status = report.getReport().getStatus();
        this.reason = report.getReport().getReason();
        if (status == 1) {
            this.fundMark = true;
            this.logger.debug("transfer success->  status:" + status + " reason:" + this.reason);
            this.logger.info("transfer success->  status:" + status + " reason:" + this.reason);
        } else {
            this.fundMark = false;
            this.logger.debug("transfer faild->  status:" + status + " reason:" + this.reason);
            this.logger.error("transfer faild->  status:" + status + " reason:" + this.reason);
        }
        this.transferMark = true;
    }

    @FXML
    public void initialize() {
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.refMng.changedProperty().addListener(this.listener);
        this.queryTradeCounter();
        this.addCheck();
        this.initBind();
        this.initListenner();
        this.initValues();
    }

    private void initBind() {
        MxBindings.bindSDTwoScale((Property)this.txtAvaFund.textProperty(), (Property)this.jzAvailable);
        MxBindings.bindSDTwoScale((Property)this.txtFundInAll.textProperty(), (Property)this.jzInAvailable);
    }

    private void initListenner() {
        ObservableList listCounter = FxUtils.newList();
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.cmbFund.hide();
            this.txtOutCode.clear();
            listCounter.clear();
            this.available = this.fm.format(now.getAvailable());
            this.investorId = now.getInvestId();
            this.brokerId = now.getBrokerId();
            this.marketGrp = now.getMarketGrp();
            this.currencyId = now.getCurrencyId();
            if (!now.getCounterId().isEmpty()) {
                ObservableList listBork = this.tradeCSImp.getTradeCounterIdList(now.getCounterId());
                this.cmbOutCount.setItems(listBork);
                this.cmbOutCount.getSelectionModel().select(0);
            }
            this.avaId = new Random().nextInt(999999999);
            this.getJzAvailable((FundAccount)now, this.avaId);
            this.requery();
        });
        this.cmbFundIn.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.cmbFundIn.hide();
            this.txtInCode.clear();
            listCounter.clear();
            this.availableIn = this.fm.format(now.getAvailable());
            this.investorIdIn = now.getInvestId();
            this.brokerIdIn = now.getBrokerId();
            this.marketGrpIn = now.getMarketGrp();
            this.currencyIdIn = now.getCurrencyId();
            if (!now.getCounterId().isEmpty()) {
                ObservableList listBork = this.tradeCSImp.getTradeCounterIdList(now.getCounterId());
                this.cmbSecInCount.setItems(listBork);
                this.cmbSecInCount.getSelectionModel().select(0);
            }
            this.avaIdIn = new Random().nextInt(999999999);
            this.getJzAvailable((FundAccount)now, this.avaIdIn);
            this.requeryIn();
        });
        this.txtOutCode.textProperty().addListener((change, old, now) -> {
            if (now.isEmpty()) {
                this.txtAvaOutQty.setText("");
                this.lbOutCodeName.setText("");
            }
        });
    }

    private void addCheck() {
        this.txtFundOutAll.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundInAll.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundIn.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtFundOut.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtAvaFundIn.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 15, 2)));
        this.txtOutCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtInCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtOutQty.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.txtInQty.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
    }

    @FXML
    public void initValues() {
        ObservableList listCssFund = this.fundAccountMng.getCcsFundAccountList();
        ObservableList listDoubleFund = FxUtils.newList();
        listCssFund.forEach(ob -> {
            if ("77777-01-01".equals(ob.getCounterId()) || "77777-01-02".equals(ob.getCounterId())) {
                listDoubleFund.add(ob);
            }
        });
        this.cmbFund.setItems(listDoubleFund);
        this.cmbFund.getSelectionModel().select(0);
        this.cmbFundIn.setItems(listDoubleFund);
        this.cmbFundIn.getSelectionModel().select(0);
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionOut = Search.bindAutoCompletion((TextField)this.txtOutCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionOut.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> this.onSecurityChangeOut(this.txtOutCode, (String)newV)));
        this.autoCompletionIn = Search.bindAutoCompletion((TextField)this.txtInCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionIn.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> this.onSecurityChangeIn(this.txtInCode, (String)newV)));
        this.txtOutCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
    }

    protected void loseFocus(Boolean val) {
    }

    protected void onSecurityChangeOut(TextField txtCode, String newText) {
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.txtAvaOutQty.clear();
        this.lbOutCodeName.setText("");
        this.doChangeOut(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void onSecurityChangeIn(TextField txtCode, String newText) {
        this.txtInCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.lbInCodeName.setText("");
        this.doChangeIn(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    public void doChangeOut(RefItem refItem, String newText) {
        if (refItem != null) {
            this.txtOutCode.setText(refItem.getCode());
            this.lbOutCodeName.setText(refItem.getName());
            this.codeOut = refItem.getCode();
            this.codeNameOut = refItem.getName();
            this.codeMarketOut = refItem.getMarket();
            this.secTypeOut = refItem.getType();
            this.txtAvaOutQty.setText("0");
            this.queryPosiOut(this.codeOut, this.codeMarketOut, this.investorId, this.marketGrp);
        }
        this.txtOutCode.selectEnd();
        this.txtOutCode.deselect();
    }

    public void doChangeIn(RefItem refItem, String newText) {
        if (refItem != null) {
            this.txtInCode.setText(refItem.getCode());
            this.lbInCodeName.setText(refItem.getName());
            this.codeIn = refItem.getCode();
            this.codeNameIn = refItem.getName();
            this.codeMarketIn = refItem.getMarket();
            this.secTypeIn = refItem.getType();
            this.queryPosiIn(this.codeOut, this.codeMarketOut, this.investorId, this.marketGrp);
        }
        this.txtInCode.selectEnd();
        this.txtInCode.deselect();
    }

    private void queryPosiOut(String code, String market, String investorId, String marketGrp) {
        this.posiAvaId = new Random().nextInt(999999999);
        try {
            this.transApi.getTransferPosition(code, market, investorId, marketGrp, this.posiAvaId);
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u8d26\u53f7\u6301\u4ed3\u5f02\u5e38", (Throwable)e);
        }
    }

    protected Collection<RefItem> getRefItems() {
        Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
        return items;
    }

    public void queryTradeCounter() {
        try {
            this.tradeCSImp.getTradeCounterList();
        }
        catch (MException e) {
            this.logger.error("queryTradeCounter error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requery() {
        List<CcsPosition> list = this.posiList;
        synchronized (list) {
            this.posiList.clear();
        }
        this.fundRequery();
        this.onSecurityChangeOut(this.txtOutCode, "");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FundAccount itemFund = (FundAccount)DoubleCenterTransferPart.this.cmbFund.getSelectionModel().getSelectedItem();
                if (itemFund != null) {
                    DoubleCenterTransferPart.this.available = DoubleCenterTransferPart.this.fm.format(itemFund.getAvailable());
                }
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requeryIn() {
        List<CcsPosition> list = this.posiListIn;
        synchronized (list) {
            this.posiListIn.clear();
        }
        this.fundRequeryIn();
        this.onSecurityChangeIn(this.txtInCode, "");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FundAccount itemFund = (FundAccount)DoubleCenterTransferPart.this.cmbFundIn.getSelectionModel().getSelectedItem();
                if (itemFund != null) {
                    DoubleCenterTransferPart.this.availableIn = DoubleCenterTransferPart.this.fm.format(itemFund.getAvailable());
                }
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeGet);
    }

    private void queryPosiIn(String code, String market, String investorId, String marketGrp) {
        this.posiAvaIdIn = new Random().nextInt(999999999);
        try {
            this.transApi.getTransferPosition(code, market, this.investorIdIn, this.marketGrpIn, this.posiAvaIdIn);
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u5212\u5165\u8bc1\u5238\u6301\u4ed3\u5f02\u5e38", (Throwable)e);
        }
    }

    private void fundRequery() {
        this.doSyncRequest(this.investorId, this.marketGrp);
        FundAccount itemFund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
        this.doSyncAccount(this.brokerId, this.investorId, this.marketGrp);
        if (itemFund != null && !itemFund.getCounterId().isEmpty()) {
            this.investorId = itemFund.getInvestId();
            this.available = this.fm.format(itemFund.getAvailable());
            this.currencyId = itemFund.getCurrencyId();
            this.marketGrp = itemFund.getMarketGrp();
            this.avaId = new Random().nextInt(999999999);
            this.getJzAvailable(itemFund, this.avaId);
            if (this.available.contains("-")) {
                this.txtFundOutAll.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        } else {
            this.txtFundOutAll.setText("0.00");
        }
    }

    private void fundRequeryIn() {
        this.doSyncRequest(this.investorIdIn, this.marketGrpIn);
        FundAccount itemFund = (FundAccount)this.cmbFundIn.getSelectionModel().getSelectedItem();
        this.doSyncAccountIn(this.brokerIdIn, this.investorIdIn, this.marketGrpIn);
        if (itemFund != null && !itemFund.getCounterId().isEmpty()) {
            this.investorIdIn = itemFund.getInvestId();
            this.availableIn = this.fm.format(itemFund.getAvailable());
            this.currencyId = itemFund.getCurrencyId();
            this.marketGrpIn = itemFund.getMarketGrp();
            this.avaIdIn = new Random().nextInt(999999999);
            this.getJzAvailable(itemFund, this.avaIdIn);
            if (this.availableIn.contains("-")) {
                this.txtAvaFundIn.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        } else {
            this.txtAvaFundIn.setText("0.00");
        }
    }

    public void getJzAvailable(FundAccount item, int avaId) {
        this.marketGrp = item.getMarketGrp();
        this.investorId = item.getInvestId();
        this.currencyId = item.getCurrencyId();
        try {
            this.transApi.getTransferFund(this.marketGrp, this.investorId, this.currencyId, avaId);
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u53ef\u8f6c\u5165\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    private void doSyncRequest(String investorId, String marketGrp) {
        try {
            if (!StringUtils.isEmpty((String)investorId) && !StringUtils.isEmpty((String)marketGrp)) {
                this.transApi.getTransferResult(investorId, marketGrp);
            }
        }
        catch (MException e) {
            this.logger.error("\u5f3a\u5236\u67e5\u8be2\u5212\u8f6c\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void doSyncAccount(String brokerId, String investorId, String marketGrp) {
        try {
            double accountAvailable = this.syncFundAccntImpl.syncAccount(brokerId, investorId, "", marketGrp);
            this.available = this.fm.format(accountAvailable);
            if (this.available.contains("-")) {
                this.txtFundOutAll.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u67dc\u53f0\u53ef\u8f6c\u51fa\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    private void doSyncAccountIn(String brokerId, String investorId, String marketGrp) {
        try {
            double accountAvailable = this.syncFundAccntImpl.syncAccount(brokerId, investorId, "", marketGrp);
            this.availableIn = this.fm.format(accountAvailable);
            if (this.availableIn.contains("-")) {
                this.txtAvaFundIn.setText("0.00");
            } else {
                this.setFundOutAllText();
            }
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u67dc\u53f0\u53ef\u8f6c\u51fa\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    public void queryPosiList(String investorId, String marketGrp, int posiAvaId) {
        try {
            this.transApi.getTransferPosi(investorId, marketGrp, posiAvaId);
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u8d26\u53f7\u6301\u4ed3\u5f02\u5e38", (Throwable)e);
        }
    }

    private synchronized void setFundOutAllText() {
        try {
            this.logger.info("txtFundOutAll \u53ef\u8f6c\u51fa\u91d1\u989d\u8bbe\u503c :" + this.available);
            this.logger.info("txtAvaFundIn \u8f6c\u5165\u53ef\u7528\u91d1\u989d\u8bbe\u503c :" + this.availableIn);
            this.txtFundOutAll.setText(this.available);
            this.txtAvaFundIn.setText(this.availableIn);
        }
        catch (Exception e) {
            this.logger.error("txtFundOutAll \u8bbe\u503c\u51fa\u9519 " + this.available, (Throwable)e);
            this.logger.error("txtAvaFundIn \u8bbe\u503c\u51fa\u9519 " + this.availableIn, (Throwable)e);
        }
    }

    public boolean fundIn() throws Exception {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u5165\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            if (!this.checkFund(this.txtFundIn.getText())) {
                return false;
            }
            this.fundTxt = this.txtFundIn.getText().replace(",", "");
            this.fundTxtAll = this.txtFundInAll.getText().replace(",", "");
            this.amount = Double.valueOf(this.fundTxt);
            if (!this.fundTxtAll.isEmpty()) {
                this.allAmount = Double.valueOf(this.fundTxtAll);
            }
            if (!this.checkValid(this.amount)) {
                return false;
            }
            if (this.amount > this.allAmount) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u53ef\u8f6c\u5165\u8d44\u91d1\u4e0d\u8db3");
                return false;
            }
            this.fundId = new Random().nextInt(999999999);
            this.operationType = 0;
            this.exe.execute(() -> {
                try {
                    this.transApi.TransferFund(this.marketGrpIn, this.investorIdIn, this.currencyIdIn, this.amount, this.fundId, this.operationType);
                    this.logger.info("\u8d44\u91d1\u5f00\u59cb\u8f6c\u5165\uff0c\u8f6c\u5165\u91d1\u989d:" + this.amount);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8d44\u91d1\u8f6c\u5165\u5f02\u5e38", e);
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u91d1\u6b63\u5728\u8f6c\u5165...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (DoubleCenterTransferPart.this.transferMark) {
                        if (DoubleCenterTransferPart.this.fundMark) {
                            simpleStringProperty.set("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\u3002");
                            DoubleCenterTransferPart.this.logger.info("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\uff0c\u91d1\u989d:" + DoubleCenterTransferPart.this.amount);
                        } else {
                            simpleStringProperty.set("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                            DoubleCenterTransferPart.this.logger.error("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                        }
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                    }
                    DoubleCenterTransferPart.this.status.set(false);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
            this.requery();
            this.requeryIn();
        }
        return false;
    }

    public boolean fundOut() throws Exception {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u51fa\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            if (!this.checkFund(this.txtFundOut.getText())) {
                return false;
            }
            this.fundTxt = this.txtFundOut.getText().replace(",", "");
            this.fundTxtAll = this.txtFundOutAll.getText().replace(",", "");
            this.amount = Double.valueOf(this.fundTxt);
            if (!this.fundTxtAll.isEmpty()) {
                this.allAmount = Double.valueOf(this.fundTxtAll);
            }
            if (!this.checkValid(this.amount)) {
                return false;
            }
            if (this.amount > this.allAmount) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u53ef\u8f6c\u51fa\u91d1\u989d\u4e0d\u8db3");
                return false;
            }
            this.fundId = new Random().nextInt(999999999);
            this.operationType = 0;
            this.exe.execute(() -> {
                try {
                    this.transApi.TransferFund(this.marketGrp, this.investorId, this.currencyId, -this.amount, this.fundId, this.operationType);
                    this.logger.info("\u8d44\u91d1\u5f00\u59cb\u8f6c\u51fa\uff0c\u8f6c\u51fa\u91d1\u989d:" + this.amount);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8d44\u91d1\u8f6c\u51fa\u5f02\u5e38", e);
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8d44\u91d1\u6b63\u5728\u8f6c\u51fa...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (DoubleCenterTransferPart.this.transferMark) {
                        if (DoubleCenterTransferPart.this.fundMark) {
                            simpleStringProperty.set("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\u3002");
                            DoubleCenterTransferPart.this.logger.info("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\uff0c\u91d1\u989d:" + DoubleCenterTransferPart.this.amount);
                        } else {
                            simpleStringProperty.set("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                            DoubleCenterTransferPart.this.logger.info("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                        }
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6\u3002");
                    }
                    DoubleCenterTransferPart.this.status.set(false);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
            this.requery();
            this.requeryIn();
        }
        return false;
    }

    public void posiOut() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8bc1\u5238\u8f6c\u51fa\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            this.flag = false;
            if (StringUtils.isEmpty((String)this.txtOutCode.getText())) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u8f6c\u51fa\u7684\u8bc1\u5238\u4ee3\u7801");
                return;
            }
            this.posiList.forEach(ob -> {
                if (ob.getSecId().equals(this.codeOut)) {
                    this.flag = true;
                }
            });
            if (!this.flag) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u65e0\u6b64\u8bc1\u5238\u4ee3\u7801\u6301\u4ed3,\u65e0\u6cd5\u8f6c\u51fa");
                return;
            }
            int canVol = Integer.valueOf(this.txtAvaOutQty.getText());
            this.volume = Integer.valueOf(this.txtOutQty.getText());
            if (this.volume == 0) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e\u96f6");
                return;
            }
            if (this.volume > canVol) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u53ef\u8f6c\u51fa\u6570\u91cf\u4e0d\u8db3");
                return;
            }
            PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
            builder.setSecurityId(this.codeOut);
            builder.setSymbol(this.codeNameOut);
            builder.setMarket(this.codeMarketOut);
            builder.setSecurityType(this.secTypeOut);
            this.posiId = new Random().nextInt(999999999);
            this.exe.execute(() -> {
                try {
                    this.transApi.TransferPosi(this.marketGrp, this.investorId, this.secAccntIdOut, -this.volume, this.posiId, this.operationType, builder.build());
                    this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + this.codeOut + "\uff0c\u5f00\u59cb\u8f6c\u51fa\uff0c\u8f6c\u51fa\u6570\u91cf:" + this.volume);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8bc1\u5238\u4ee3\u7801:" + this.codeOut + "\u8bc1\u5238\u8f6c\u51fa\u5f02\u5e38", e);
                    this.reason = e.getMessage();
                    return;
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8bc1\u5238\u6b63\u5728\u8f6c\u51fa...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (DoubleCenterTransferPart.this.transferMark) {
                        if (DoubleCenterTransferPart.this.fundMark) {
                            simpleStringProperty.set("\u8bc1\u5238\u8f6c\u51fa\u6210\u529f\u3002");
                            DoubleCenterTransferPart.this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + DoubleCenterTransferPart.this.codeOut + "\uff0c\u8f6c\u51fa\u6570\u91cf:" + DoubleCenterTransferPart.this.volume + "\uff0c\u8f6c\u51fa\u6210\u529f");
                        } else {
                            simpleStringProperty.set("\u8bc1\u5238\u8f6c\u51fa\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                            DoubleCenterTransferPart.this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + DoubleCenterTransferPart.this.codeOut + "\uff0c\u8f6c\u51fa\u5931\u8d25\uff1a" + DoubleCenterTransferPart.this.reason);
                        }
                        DoubleCenterTransferPart.this.status.set(false);
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6");
                        DoubleCenterTransferPart.this.status.set(false);
                    }
                    DoubleCenterTransferPart.this.queryPosiOut(DoubleCenterTransferPart.this.codeOut, DoubleCenterTransferPart.this.codeMarketOut, DoubleCenterTransferPart.this.investorId, DoubleCenterTransferPart.this.marketGrp);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
        }
    }

    public void posiIn() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8bc1\u5238\u8f6c\u5165\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            if (StringUtils.isEmpty((String)this.txtInCode.getText())) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u8f6c\u5165\u7684\u8bc1\u5238\u4ee3\u7801");
                return;
            }
            if (!this.txtInCode.getText().equals(this.codeIn)) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8bc1\u5238\u4ee3\u7801");
                return;
            }
            this.volume = Integer.valueOf(this.txtInQty.getText());
            if (this.volume == 0) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e\u96f6");
                return;
            }
            if (StringUtils.isEmpty((String)this.secAccntIdIn)) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u53ef\u8f6c\u5165\u6570\u91cf");
                return;
            }
            PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
            builder.setSecurityId(this.codeIn);
            builder.setSymbol(this.codeNameIn);
            builder.setMarket(this.codeMarketIn);
            builder.setSecurityType(this.secTypeIn);
            this.posiId = new Random().nextInt(999999999);
            this.exe.execute(() -> {
                try {
                    this.transApi.TransferPosi(this.marketGrp, this.investorIdIn, this.secAccntIdIn, this.volume, this.posiId, this.operationType, builder.build());
                    this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + this.codeIn + "\uff0c\u5f00\u59cb\u8f6c\u5165\uff0c\u8f6c\u5165\u6570\u91cf:" + this.volume);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8bc1\u5238\u4ee3\u7801:" + this.codeIn + "\u8bc1\u5238\u8f6c\u5165\u5f02\u5e38", e);
                    this.reason = e.getMessage();
                    return;
                }
            });
            final SimpleStringProperty simpleStringProperty = new SimpleStringProperty("\u8bc1\u5238\u6b63\u5728\u8f6c\u5165...");
            this.status.set(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (DoubleCenterTransferPart.this.transferMark) {
                        if (DoubleCenterTransferPart.this.fundMark) {
                            simpleStringProperty.set("\u8bc1\u5238\u8f6c\u5165\u6210\u529f\u3002");
                            DoubleCenterTransferPart.this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + DoubleCenterTransferPart.this.codeIn + "\uff0c\u8f6c\u5165\u6570\u91cf:" + DoubleCenterTransferPart.this.volume + "\uff0c\u8f6c\u5165\u6210\u529f");
                            DoubleCenterTransferPart.this.posiAvaIdIn = new Random().nextInt(999999999);
                            DoubleCenterTransferPart.this.queryPosiList(DoubleCenterTransferPart.this.investorIdIn, DoubleCenterTransferPart.this.marketGrpIn, DoubleCenterTransferPart.this.posiAvaIdIn);
                        } else {
                            simpleStringProperty.set("\u8bc1\u5238\u8f6c\u5165\u5931\u8d25:" + DoubleCenterTransferPart.this.reason);
                            DoubleCenterTransferPart.this.logger.info("\u8bc1\u5238\u4ee3\u7801\uff1a" + DoubleCenterTransferPart.this.codeIn + "\uff0c\u8f6c\u5165\u5931\u8d25\uff1a" + DoubleCenterTransferPart.this.reason);
                        }
                        DoubleCenterTransferPart.this.status.set(false);
                    } else {
                        simpleStringProperty.set("\u5212\u8f6c\u8d85\u65f6");
                        DoubleCenterTransferPart.this.status.set(false);
                    }
                    DoubleCenterTransferPart.this.queryPosiIn(DoubleCenterTransferPart.this.codeIn, DoubleCenterTransferPart.this.codeMarketIn, DoubleCenterTransferPart.this.investorId, DoubleCenterTransferPart.this.marketGrp);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
            this.mAlert.alert(Alert.AlertType.INFORMATION, (StringProperty)simpleStringProperty, "\u63d0\u793a", this.status);
            this.status.set(false);
        }
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("server.sub", event -> this.onPush(event));
    }

    private boolean checkFund(String textFund) {
        if (textFund.isEmpty()) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private boolean checkValid(Double amount) {
        if (amount == 0.0) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e\u96f6");
            return false;
        }
        return true;
    }

    public void inClear() {
        this.txtFundIn.clear();
    }

    public void outClear() {
        this.txtFundOut.clear();
    }

    public void outQtyclear() {
        this.txtOutQty.clear();
    }

    public void inQtyclear() {
        this.txtInQty.clear();
    }

    public final DoubleProperty jzAvailableProperty() {
        return this.jzAvailable;
    }

    public final double getJzAvailable() {
        return this.jzAvailableProperty().get();
    }

    public final void setJzAvailable(double jzAvailable) {
        this.jzAvailableProperty().set(jzAvailable);
    }
}

