/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.statement.api.RouterTransServiceApi;
import cms.tmx.http.statement.api.TransSecurityReq;
import cms.tmx.http.statement.api.TransSecurityResp;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.trade.views.TransferPosiDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DoTransferPosiDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(TransferPosiDialog.class);
    @FXML
    private Label lb;
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtQty;
    @Inject
    private RouterTransServiceApi routerApi;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MxAlert mAlert;
    private FundAccount accntInfo;
    private int direct;
    @Inject
    protected MEventService es;
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected SecSuggest spCode = new SecSuggest();
    private SecConverter secCvt;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    private String codeMarket;
    private String secAccntId;

    protected Collection<RefItem> getRefItems() {
        Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
        return items;
    }

    @FXML
    private void initialize() {
        this.txtQty.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> this.onSecurityChange(this.txtCode, (String)newV)));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    public void doChange(RefItem refItem, String newText) {
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.codeMarket = refItem.getMarket();
        }
        this.txtCode.selectEnd();
        this.txtCode.deselect();
    }

    protected void loseFocus(Boolean val) {
    }

    public boolean isOK(ButtonType bt) {
        TransSecurityReq req;
        block11: {
            if (this.txtQty.getText().isEmpty()) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u5212\u8f6c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            String secCode = this.txtCode.getText();
            int amt = Integer.valueOf(this.txtQty.getText());
            if (StringUtils.isEmpty((String)secCode)) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u8bc1\u5238\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (amt <= 0) {
                this.mAlert.alert(Alert.AlertType.WARNING, "\u5212\u8f6c\u6570\u91cf\u5e94\u5927\u4e8e\u96f6");
                return false;
            }
            String investorId = this.accntInfo.getInvestId();
            CcsFundAccount fundAccount = this.accountMap.getFundAcc(investorId);
            if (fundAccount != null) {
                try {
                    List secAccntList = (List)this.accountMap.getAccountMap().get(fundAccount);
                    if (!secAccntList.isEmpty()) {
                        secAccntList.forEach(e -> {
                            if (e.getExchange().getRaw().equals(this.codeMarket)) {
                                this.secAccntId = e.getInverstorSecId();
                            }
                        });
                    }
                }
                catch (MException e2) {
                    e2.printStackTrace();
                }
            }
            String tradePlatformId = this.accntInfo.getCounterId();
            req = new TransSecurityReq();
            req.setAccntId(investorId);
            req.setCashAccntId(investorId);
            req.setTradePlatformId(tradePlatformId);
            req.setSecAccntId(this.secAccntId);
            req.setMarket(this.codeMarket);
            req.setSecCode(secCode);
            req.setTransAmt(amt);
            req.setDirect(this.direct);
            if (!StringUtils.isEmpty((String)this.codeMarket)) break block11;
            this.mAlert.alert(Alert.AlertType.WARNING, "\u884c\u60c5\u5e02\u573a\u4e3a\u7a7a\uff0c\u8bf7\u5230\u4e0b\u65b9\u6301\u4ed3\u4e2d\u8fdb\u884c\u5212\u8f6c\u64cd\u4f5c");
            return false;
        }
        try {
            TransSecurityResp resp = this.routerApi.doTransPosi(req);
            if (resp.getCode() == 1) {
                this.mAlert.alert(Alert.AlertType.INFORMATION, "\u5212\u8f6c\u6210\u529f\uff0c\u7f16\u53f7\uff1a" + resp.getSerialNo());
                logger.info("\u8bc1\u5238\u5212\u8f6c\u6210\u529f\uff0c\u7f16\u53f7:" + resp.getSerialNo());
                this.txtCode.clear();
                this.txtQty.clear();
            }
        }
        catch (MException | Exception e3) {
            logger.error("\u8bc1\u5238\u5212\u8f6c\u5f02\u5e38", e3);
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u5931\u8d25\uff0c" + e3.getMessage());
            logger.info("\u8bc1\u5238\u5212\u8f6c\u5931\u8d25\uff0c\u539f\u56e0:" + e3.getMessage());
        }
        return false;
    }

    public Label getLb() {
        return this.lb;
    }

    public void setLb(Label lb) {
        this.lb = lb;
    }

    public FundAccount getAccntInfo() {
        return this.accntInfo;
    }

    public void setAccntInfo(FundAccount accntInfo) {
        this.accntInfo = accntInfo;
    }

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }
}

