/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.api.ITradePart;
import cms.tmx.trade.models.CcsTradeModel;
import cms.tmx.trade.models.UserPreCtrl;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.trade.views.LoadPartModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class CcsTradePart
extends MxPart
implements ITradePart {
    @FXML
    protected VBox ctTradePanel;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> accNameCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    protected Button btnOrder;
    @FXML
    protected ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    protected TextField txtSearch;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    protected CcsTradeModel ccsModel;
    @Inject
    protected UserPreCtrl preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    protected AutoCompletion<RefItem> autoCompletionNormal;
    private MEvent pstEvent = new MEvent();
    private boolean isPstEvent = false;
    protected boolean priceSettle = false;
    public static final Logger logger = LogManager.getLogger(CcsTradePart.class);
    @Inject
    private CcsUnfinishedOrderModel unfinishedModel;
    @Inject
    protected ExecutorService exe;
    @Inject
    private EPartService ps;
    private Map<String, List<CcsOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
        this.tableMarketBuy.layout();
        this.tableMarketSell.layout();
    });
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    protected SecSuggest spCode = new SecSuggest();
    private MEventHandler hSetCode = event -> {
        if (event.getStr("parent_id").toUpperCase().contains(this.ccsModel.getTradeType()) && event.getStr("sec_type").equals(this.ccsModel.getTradeType())) {
            String market = event.getStr("tMarket");
            String secCode = event.getStr("sec_code");
            String secType = event.getStr("sec_type");
            this.txtCode.setText(secCode);
            RefItem item = this.refMng.getItem(secType, market, secCode);
            this.txtCode.setUserData((Object)item);
            this.autoCompletionNormal.setChange(secCode);
            this.onSecurityChange(secCode);
            this.pstEvent = event;
            this.isPstEvent = true;
            if (this.txtCode.getText().equals(secCode)) {
                this.ccsModel.setCount(this.pstEvent.getLong("count"));
                this.ccsModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
                this.ccsModel.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
                this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
            }
        }
    };
    private InvalidationListener lstnRefItem = ob -> Platform.runLater(() -> this.onRefChange());
    private InvalidationListener lstnRefMng = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private InvalidationListener lstnMarketItem = ob -> this.setPrePrice();
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    checkBox.setDisable(CcsTradePart.this.getCheckBoxDisable());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(CcsTradePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> CcsTradePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        CcsTradePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                CcsTradePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> CcsTradePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    private LoadPartModel load;

    @Inject
    public CcsTradePart() {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.exe.execute(() -> this.unfinishedModel.query());
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    public void onShowEvent(MEvent event) {
    }

    private void setPrePrice() {
        if (this.ccsModel.getPrice() > 0.0 || this.priceSettle) {
            return;
        }
        this.ccsModel.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
        if (this.preModel.getDefPrice(this.buyRadio.isSelected()) != 0.0) {
            this.priceSettle = true;
        }
    }

    @FXML
    public void initialize() {
        this.ccsModel = this.createModel();
        this.mktItem = this.ccsModel.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefItem));
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code", this.hSetCode);
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnMarketItem));
    }

    @PreDestroy
    protected void close() {
        this.es.unSubscribe("trade.panel.set.code", this.hSetCode);
    }

    protected Collection<RefItem> getRefItems() {
        if (this.ccsModel.getTradeType().equals("CCS")) {
            return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
        }
        return this.refMng.getItems(new String[]{this.ccsModel.getTradeType()});
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange((String)newV);
            this.acctTreeTable.refresh();
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.ccsModel.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.ccsModel.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.ccsModel.buyProperty());
        this.cmbPriceType.setItems(this.ccsModel.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.ccsModel.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isLimitPrice(), (Observable[])new Observable[]{this.ccsModel.priceStgProperty()}));
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.ccsModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().setText("");
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((MxNode)this.cmbPriceType.getValue()).getRaw().equals("50"), (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.ccsModel.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.ccsModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.countStg.setItems(this.ccsModel.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange());
        this.countStg.valueProperty().bindBidirectional(this.ccsModel.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("3") || this.ccsModel.getCountStg().is("2") || this.ccsModel.getCountStg().is("4"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.ccsModel.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.ccsModel.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%1$,.2f", this.ccsModel.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.ccsModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.ccsModel.distStgProperty());
        this.cmbAccFilter.setItems(this.ccsModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.ccsModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.ccsModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.ccsModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.ccsModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.accNameCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accntNameProperty());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.acctTreeTable.setRoot(this.ccsModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.ccsModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.ccsModel.countStgProperty().addListener(ob -> {
            String stg = this.ccsModel.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onRefChange() {
        TradeBindings.priceBinding((Property<String>)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property<String>)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property<String>)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
    }

    protected void onBSChange(Boolean old, Boolean now) {
        Platform.runLater(() -> {
            Date time = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            logger.info(String.valueOf(df.format(time)) + "\u5f00\u59cb\u4e70\u5356\u5207\u6362");
            if (now.booleanValue()) {
                this.btnOrder.setText("\u4e70\u5165");
                this.lbCan.setText("\u53ef\u4e70");
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u6267\u884c\u4e70");
            } else {
                this.btnOrder.setText("\u5356\u51fa");
                this.lbCan.setText("\u53ef\u5356");
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u6267\u884c\u5356");
            }
            logger.info("\u6700\u7ec8\u7ed3\u679c\u663e\u793a" + this.btnOrder.getText());
            this.preModel.onBsChange(now);
            this.ctTradePanel.layout();
            this.layout();
        });
    }

    private void onPriceTypeChange() {
        this.priceSpn.getEditor().setText("");
    }

    private void onCountStgChange() {
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(String newText) {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.ccsModel.getMI().setRefItem(refItem);
        if (this.ccsModel.isValidRef()) {
            this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
        }
        this.ccsModel.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (newText.length() >= 6) {
            this.check();
        }
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.ccsModel.setCount(this.pstEvent.getLong("count"));
            this.ccsModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.ccsModel.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
            this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
        }
        if (this.ccsModel.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    protected void check() {
        if (this.txtCode.getText().length() < 6) {
            return;
        }
        RefItem ref = this.mktItem.getRefItem();
        if (!this.txtCode.isFocused() && (ref == null || ref.getName().equals("") || this.ccsModel.getValidRef() == null)) {
            this.lbName.setText(INVALID_CODE);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        }
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.ccsModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.ccsModel.isLimitPrice() || this.ccsModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.ccsModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        return this.alert.check(this.ccsModel.getCount() >= 0L && this.ccsModel.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.ccsModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.ccsModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            if (this.preModel.isPopBeforeOrder()) {
                CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)((Object)this.of.create(CcsEntrustConfirmDialog.class));
                obj.setRefItem(this.mktItem.getRefItem());
                obj.setPriceStg(this.ccsModel.getPriceStg());
                obj.setUnit(this.lbUnit.getText());
                obj.setList(this.ccsModel.getEntrustList());
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                if (dialog.launch() == ButtonType.OK) {
                    this.submitOrder();
                }
            } else {
                this.submitOrder();
            }
        }
    }

    protected void submitOrder() {
        ObservableList<Boolean> listCont = this.ccsModel.submit(this.ccsModel.getAccDisModel().getRoot());
        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
        this.clearCountCheck();
        this.unfinishedAfterOrder();
    }

    protected void unfinishedAfterOrder() {
        if (!this.preModel.isUnfinishedAfterOrder()) {
            return;
        }
        String partId = "";
        switch (this.ccsModel.getTradeType()) {
            case "STOCK": {
                partId = "cms.tmx.stock.part.unfinishedorder";
                break;
            }
            case "FUND": {
                partId = "cms.tmx.fund.part.unfinishedorder";
                break;
            }
            case "BOND": {
                partId = "cms.tmx.bond.part.unfinishedorder";
                break;
            }
        }
        if (partId.isEmpty()) {
            return;
        }
        MPart part = this.ps.findPart(partId);
        if (part != null) {
            part.setVisible(true);
            part.setToBeRendered(true);
            this.ps.showPart(part, EPartService.PartState.ACTIVATE);
        }
    }

    protected void clearCountCheck() {
        block10: {
            if (!this.preModel.isClearAfterOrder()) break block10;
            switch (this.ccsModel.getCountStg().getRaw()) {
                case "5": {
                    this.ccsModel.setMoney(0.0);
                    break;
                }
                case "1": {
                    this.ccsModel.setCount(0L);
                    break;
                }
                default: {
                    this.ccsModel.setCountPer(0.0);
                }
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            if (this.ccsModel.isLimitPrice()) {
                this.priceSpn.requestFocus();
                this.preModel.selectTwoOrAllPriceDecimal();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    public void setPrice(double price) {
        if (this.ccsModel.isLimitPrice() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.ccsModel.setPrice(price);
        } else {
            this.priceSpn.getEditor().setText("");
        }
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(this.accountCol.getText()).append("\t");
        clipboardString.append(this.accNameCol.getText()).append("\t");
        clipboardString.append(this.secAcctCol.getText()).append("\t");
        clipboardString.append(this.availableCol.getText()).append("\t");
        clipboardString.append(this.assetCol.getText()).append("\t");
        clipboardString.append(this.weightCol.getText()).append("\t");
        clipboardString.append(this.amountCol.getText()).append("\t");
        clipboardString.append(this.canBuyCol.getText()).append("\t");
        clipboardString.append(this.canSellCol.getText()).append("\t");
        clipboardString.append(this.productCol.getText()).append("\n");
        for (TreeItem item : this.ccsModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc()).append("\t");
            clipboardString.append(accDis.getAccntName()).append("\t");
            clipboardString.append("\t");
            clipboardString.append(accDis.getAcc().getAvailable()).append("\t");
            clipboardString.append(accDis.getAcc().getAssetAmt()).append("\t");
            clipboardString.append(accDis.getWeight()).append("\t");
            clipboardString.append(accDis.getCount()).append("\t");
            clipboardString.append(accDis.getCanBuy()).append("\t");
            clipboardString.append(accDis.getCanSell()).append("\t");
            clipboardString.append(accDis.getAcc().getProductName()).append("\n");
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getSecAcc()).append("\t");
                clipboardString.append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getWeight()).append("\t");
                clipboardString.append(secAccDis.getCount()).append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getCanSell()).append("\t");
                clipboardString.append("\n");
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    protected boolean getCheckBoxDisable() {
        return false;
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    @Override
    public ITradeModel getModel() {
        return this.ccsModel;
    }

    @Override
    public CcsTradeModel createModel() {
        return (CcsTradeModel)this.of.create(CcsTradeModel.class);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(this.getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        try {
            this.preModel.doSet();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.ccsModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.ccsModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.ccsModel.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.ccsModel.setAutoSlice(slice);
        this.ccsModel.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.ccsModel.getValidRef();
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

