/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.DlgCtrl;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.web.settings.FastTradeSettings;
import cms.tmx.entity.web.settings.OrderTipsSettings;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsTradeDialogMng;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IRefDataMng;
import com.sun.javafx.scene.input.KeyCodeMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsTradeDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(CcsTradeDialog.class);
    @Inject
    protected IFundAccountService fundAccMng;
    @FXML
    private ComboBox<String> cmbAcct;
    @FXML
    private ComboBox<String> cmbSecAcct;
    private DlgCtrl ctrl;
    @FXML
    private Label lbNameBuy;
    @FXML
    private Label lbNameSell;
    @FXML
    private Label lbCanCapital;
    @FXML
    private TextField txtCodeBuy;
    @FXML
    private TextField txtCodeSell;
    @FXML
    private Spinner<Double> priceSpnBuy;
    @FXML
    private Spinner<Double> priceSpnSell;
    @FXML
    private Spinner<Integer> quantitySpnBuy;
    @FXML
    private Spinner<Integer> quantitySpnSell;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbF1;
    @FXML
    private Label lbF2;
    @FXML
    private Label lbDownLimit;
    @FXML
    private Label lbCanBuy;
    @FXML
    private Label lbCanSell;
    @FXML
    private Label lbUnitBuy;
    @FXML
    private Label lbUnitSell;
    @FXML
    private CheckBox checkSame;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private HBox hboxPane;
    @FXML
    private Button btnOrderBuy;
    @FXML
    private Button btnOrderSell;
    @FXML
    private VBox ccsTradePart;
    @FXML
    private VBox tradePanelSell;
    @FXML
    private VBox tradePanelBuyFather;
    @FXML
    private VBox tradePanelSellFather;
    @FXML
    private VBox tradePanelBuy;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private CcsAccountMap accMng;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private ExecutorService exe;
    private Map<CcsFundAccount, List<SecAccount>> accountMap = FxUtils.newMap();
    @Inject
    private CcsPositionModel posModel;
    @Inject
    private CcsTradeDialogMng ccsModel;
    @Inject
    private MEventService es;
    private ObservableList<String> secList = FxUtils.newList();
    private String oldSec;
    private String oldSH;
    private String oldSZ;
    private SecSuggest spCode = new SecSuggest();
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private MarketItem mktItem;
    private RefItem refItem = null;
    private FastTradeSettings set = new FastTradeSettings();
    private OrderTipsSettings tipSet = new OrderTipsSettings();
    private SecSuggest.StrSuggest suggestFund = SecSuggest.getStrSuggest();
    private SecSuggest.StrSuggest suggestSec = SecSuggest.getStrSuggest();
    @Inject
    private IUserSettingsService usService;
    private double canCapital = 0.0;
    private ChangeListener<? super Boolean> listener = (ob, old, now) -> Platform.runLater(() -> this.setCanSell());
    private InvalidationListener invalidListener = ob -> {
        this.spCode.clearSuggestions();
        Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
        this.spCode.addPossibleSuggestions(items);
    };
    private MEventHandler handlerSet = event -> this.reset(event);
    @Inject
    private CcsUnfinishedOrderModel unfinishedModel;
    private Map<String, List<CcsOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        if (this.mktItem.getRefItem() == null) {
            return;
        }
        if (this.ccsModel.isBuy() && !this.mktItem.getRefItem().getCode().equals(this.txtCodeBuy.getText())) {
            return;
        }
        if (!this.ccsModel.isBuy() && !this.mktItem.getRefItem().getCode().equals(this.txtCodeSell.getText())) {
            return;
        }
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    private InvalidationListener lstFund = ob -> Platform.runLater(() -> {
        try {
            this.onFundChange();
        }
        catch (Exception e) {
            logger.error("\u53cc\u5411\u5feb\u6377\u4ea4\u6613\u5237\u65b0\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
    });
    private boolean popBeforeOrder = true;
    private boolean clearAfterOrder = true;
    private int buyPriceGear = 0;
    private double buyPriceFloat = 0.0;
    private String buyPriceUnit = "1";
    private int sellPriceGear = 0;
    private double sellPriceFloat = 0.0;
    private String sellPriceUnit = "1";
    private double upDownPriceFloat = 0.0;
    private double leftRightPriceFloat = 0.0;
    private long buyQuantity = 100L;
    private long sellQuantity = 100L;
    private long upDownQuantityFloat = 0L;
    private long leftRightQuantityFloat = 0L;
    private int toBuyAreaKey = 112;
    private int toSellAreaKey = 113;
    private int buyOrderKey = 66;
    private int sellOrderKey = 83;
    private boolean autoSlice = false;
    private long sliceCountMax = 83L;
    private KeyCode keyBuyArea = KeyCode.F1;
    private KeyCode keySellArea = KeyCode.F2;
    private KeyCode keyBuyBtn = KeyCode.B;
    private KeyCode keySellBtn = KeyCode.S;
    protected DoubleSpinnerCtrl ctrlPriceBuy = new DoubleSpinnerCtrl(true, 6, 3);
    protected DoubleSpinnerCtrl ctrlPriceSell = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 100);
    protected IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 100);
    private int priceChoose = 1;
    private double priceBuy = 0.0;
    private double priceSell = 0.0;
    @Inject
    protected CcsEntrustFactory ef;
    private long left = 0L;
    private int successed = 0;
    private int failed = 0;

    public void setCtrl(DlgCtrl ctrl) {
        this.ctrl = ctrl;
    }

    public void onFinished(ButtonType bt) {
        if (bt.getButtonData().isCancelButton()) {
            this.posModel.changedProperty().removeListener(this.listener);
            this.refMng.changedProperty().removeListener(this.invalidListener);
            this.es.unSubscribe("settingsRefresh", this.handlerSet);
        }
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.exe.execute(() -> this.unfinishedModel.query());
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    @FXML
    public void initialize() {
        this.es.subscribe("settingsRefresh", this.handlerSet);
        if (this.posModel.getList().size() == 0) {
            this.posModel.query();
        }
        this.posModel.changedProperty().addListener(this.listener);
        this.reset(null);
        try {
            this.accountMap = this.accMng.getAccountMap();
        }
        catch (MException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> this.txtCodeBuy.requestFocus());
        this.mktItem = this.ccsModel.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.refMng.changedProperty().addListener(this.invalidListener);
        this.initControls();
        this.createMarketTable();
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
    }

    public void onFundChange() {
        CcsFundAccount fund = this.accMng.getFundAcc(this.cmbAcct.getEditor().getText());
        if (fund == null) {
            this.lbCanCapital.setText("0");
            this.canCapital = 0.0;
            this.cmbSecAcct.getItems().clear();
            this.cmbSecAcct.getEditor().clear();
            return;
        }
        this.canCapital = fund.getAvailable();
        this.lbCanCapital.setText(String.format("%1$,.2f", fund.getAvailable()));
        this.secList.clear();
        if (this.refItem == null) {
            this.accountMap.get(fund).forEach(each -> {
                boolean bl = this.secList.add((Object)each.getInverstorSecId());
            });
        } else {
            for (SecAccount sec : this.accountMap.get(fund)) {
                if (!sec.getExchange().getRaw().equals(this.refItem.getMarket())) continue;
                this.secList.add((Object)sec.getInverstorSecId());
            }
        }
        this.cmbSecAcct.setItems(this.secList);
        this.cmbSecAcct.getSelectionModel().select((Object)((String)this.secList.get(0)));
        this.suggestSec.setAllSuggestions(this.secList);
    }

    private void reset(MEvent event) {
        try {
            this.set = (FastTradeSettings)this.usService.getSettingsDetail("5", "200050");
            this.tipSet = (OrderTipsSettings)this.usService.getSettingsDetail("0", "000001");
            this.getSetupValue();
            this.resetPriceSpn(true, true);
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void getSetupValue() {
        if (this.set == null) {
            return;
        }
        if (this.set.getPopBeforeOrder() != null) {
            boolean bl = this.popBeforeOrder = this.set.getPopBeforeOrder().equals("1");
        }
        if (this.set.getClearAfterOrder() != null) {
            boolean bl = this.clearAfterOrder = this.set.getClearAfterOrder().equals("1");
        }
        if (this.set.getBuyPriceGear() != null) {
            this.buyPriceGear = Integer.valueOf(this.set.getBuyPriceGear());
        }
        if (this.set.getBuyPriceFloat() != null) {
            this.buyPriceFloat = this.set.getBuyPriceFloat();
        }
        if (this.set.getBuyPriceUnit() != null) {
            this.buyPriceUnit = this.set.getBuyPriceUnit();
        }
        if (this.set.getSellPriceGear() != null) {
            this.sellPriceGear = Integer.valueOf(this.set.getSellPriceGear());
        }
        if (this.set.getSellPriceFloat() != null) {
            this.sellPriceFloat = this.set.getSellPriceFloat();
        }
        if (this.set.getSellPriceUnit() != null) {
            this.sellPriceUnit = this.set.getSellPriceUnit();
        }
        if (this.set.getUpDownPriceFloat() != null) {
            this.upDownPriceFloat = this.set.getUpDownPriceFloat();
        }
        if (this.set.getLeftRightPriceFloat() != null) {
            this.leftRightPriceFloat = this.set.getLeftRightPriceFloat();
        }
        if (this.set.getBuyQuantity() != null) {
            this.buyQuantity = this.set.getBuyQuantity();
        }
        if (this.set.getSellQuantity() != null) {
            this.sellQuantity = this.set.getSellQuantity();
        }
        if (this.set.getUpDownQuantityFloat() != null) {
            this.upDownQuantityFloat = this.set.getUpDownQuantityFloat();
        }
        if (this.set.getLeftRightQuantityFloat() != null) {
            this.leftRightQuantityFloat = this.set.getLeftRightQuantityFloat();
        }
        if (this.set.getToBuyAreaKey() != null) {
            this.toBuyAreaKey = this.set.getToBuyAreaKey();
        }
        if (KeyCodeMap.valueOf((int)this.toBuyAreaKey) != null) {
            this.keyBuyArea = KeyCodeMap.valueOf((int)this.toBuyAreaKey);
            this.lbF1.setText(KeyCodeMap.valueOf((int)this.toBuyAreaKey).getName());
        }
        if (this.set.getToSellAreaKey() != null) {
            this.toSellAreaKey = this.set.getToSellAreaKey();
        }
        if (KeyCodeMap.valueOf((int)this.toSellAreaKey) != null) {
            this.keySellArea = KeyCodeMap.valueOf((int)this.toSellAreaKey);
            this.lbF2.setText(KeyCodeMap.valueOf((int)this.toSellAreaKey).getName());
        }
        if (this.set.getBuyOrderKey() != null) {
            this.buyOrderKey = this.set.getBuyOrderKey();
        }
        if (KeyCodeMap.valueOf((int)this.buyOrderKey) != null) {
            this.keyBuyBtn = KeyCodeMap.valueOf((int)this.buyOrderKey);
            this.btnOrderBuy.setText("\u4e70\u5165 " + KeyCodeMap.valueOf((int)this.buyOrderKey).getName());
        }
        if (this.set.getSellOrderKey() != null) {
            this.sellOrderKey = this.set.getSellOrderKey();
        }
        if (KeyCodeMap.valueOf((int)this.sellOrderKey) != null) {
            this.keySellBtn = KeyCodeMap.valueOf((int)this.sellOrderKey);
            this.btnOrderSell.setText("\u5356\u51fa " + KeyCodeMap.valueOf((int)this.sellOrderKey).getName());
        }
        if (this.set.getAutoSlice() != null) {
            boolean bl = this.autoSlice = this.set.getAutoSlice().equals("1");
        }
        if (this.set.getSliceCountMax() != null) {
            this.sliceCountMax = this.set.getSliceCountMax();
        }
        this.priceChoose = this.set.getPriceChoose();
        this.ctrlCountBuy.setUnit((int)this.upDownQuantityFloat);
        this.ctrlCountSell.setUnit((int)this.upDownQuantityFloat);
        SpinnerUtils.addIntArrowKeyHandler(this.quantitySpnBuy, (int)((int)this.upDownQuantityFloat), (int)((int)this.leftRightQuantityFloat));
        SpinnerUtils.addIntArrowKeyHandler(this.quantitySpnSell, (int)((int)this.upDownQuantityFloat), (int)((int)this.leftRightQuantityFloat));
    }

    private void onRefChange() {
        TradeBindings.priceBinding((Property<String>)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property<String>)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property<String>)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        if (this.ccsModel.isBuy() || this.checkSame.isSelected()) {
            this.ctrlPriceBuy.setScale(this.mktItem.getRefItem().getScale());
        }
        if (!this.ccsModel.isBuy() || this.checkSame.isSelected()) {
            this.ctrlPriceSell.setScale(this.mktItem.getRefItem().getScale());
        }
    }

    private void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketBuy.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                if (this.ccsModel.isBuy()) {
                    this.orderBuy();
                } else {
                    this.orderSell();
                }
            }
        });
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        Tooltip t = new Tooltip();
        t.textProperty().bind((ObservableValue)this.lbUpLimit.textProperty());
        this.lbUpLimit.setTooltip(t);
        Tooltip t1 = new Tooltip();
        t1.textProperty().bind((ObservableValue)this.lbDownLimit.textProperty());
        this.lbDownLimit.setTooltip(t1);
        this.tableMarketSell.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                if (this.ccsModel.isBuy()) {
                    this.orderBuy();
                } else {
                    this.orderSell();
                }
            }
        });
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbRate.textProperty());
        this.lbRate.setTooltip(tooltip);
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.lbUpLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.ccsModel.isBond() && this.ccsModel.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbDownLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.ccsModel.isBond() && this.ccsModel.isValidRef(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    private void initControls() {
        this.cmbAcct.getItems().addAll((Collection)this.accMng.getFundAccList());
        this.cmbAcct.getSelectionModel().select(0);
        this.ccsModel.setFundAcct(this.accMng.getFundAcc((String)this.cmbAcct.getSelectionModel().getSelectedItem()));
        this.suggestFund.addPossibleSuggestions((Collection)this.accMng.getFundAccList());
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.suggestFund);
        Search.bindAutoCompletion((TextField)this.cmbSecAcct.getEditor(), (Callback)this.suggestSec);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
            this.onFundChange();
        });
        this.cmbSecAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.cmbSecAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSecAcct.getSelectionModel().select(now);
            this.cmbSecAcct.hide();
            if (this.secList.contains(this.cmbSecAcct.getSelectionModel().getSelectedItem())) {
                SecAccount sec = this.accMng.getSecAcc((String)this.cmbSecAcct.getSelectionModel().getSelectedItem(), "");
                if (sec.getExchange().getRaw().equals("XSHE")) {
                    this.oldSec = this.oldSZ = sec.getInverstorSecId();
                } else if (sec.getExchange().getRaw().equals("XSHG")) {
                    this.oldSec = this.oldSH = sec.getInverstorSecId();
                }
            }
            if (!this.ccsModel.isBuy()) {
                this.setCanSell();
            }
        });
        this.checkSame.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.ccsModel.isBuy()) {
                this.txtCodeSell.setText(this.txtCodeBuy.getText());
                this.lbNameSell.setText(this.lbNameBuy.getText());
                this.ctrlPriceSell.setScale(this.ctrlPriceBuy.getScale());
                this.lbUnitSell.setText(this.lbUnitBuy.getText());
                if (this.refItem.isGem()) {
                    if (this.refItem.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.refItem.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                        this.lbNameSell.setText(String.valueOf(this.refItem.getName()) + " " + "\u521d");
                    } else {
                        this.lbNameSell.setText(this.refItem.getName());
                    }
                    Tooltip tooltip = new Tooltip();
                    StringBuilder builder = new StringBuilder();
                    builder.append(this.refItem.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
                    builder.append("\r\n");
                    builder.append(this.refItem.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
                    builder.append("\r\n");
                    builder.append(this.refItem.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
                    builder.append("\r\n");
                    builder.append(this.refItem.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
                    builder.append("\r\n");
                    tooltip.setText(builder.toString());
                    this.lbNameSell.setTooltip(tooltip);
                    this.lbNameSell.setStyle("-fx-font-size: 12;");
                } else if ("FUND".equals(this.refItem.getType())) {
                    BigDecimal down = new BigDecimal(this.refItem.getLimitDownRate());
                    BigDecimal up = new BigDecimal(this.refItem.getLimitUpRate());
                    if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                        this.lbNameSell.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                        this.lbNameSell.setStyle("-fx-font-size: 10;");
                        Tooltip tooltip = new Tooltip();
                        tooltip.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                        this.lbNameSell.setTooltip(tooltip);
                    } else {
                        this.lbNameSell.setText(this.refItem.getName());
                        this.lbNameSell.setTooltip(null);
                        this.lbNameSell.setStyle("-fx-font-size: 12;");
                    }
                } else {
                    this.lbNameSell.setText(this.refItem.getName());
                    this.lbNameSell.setTooltip(null);
                    this.lbNameSell.setStyle("-fx-font-size: 12;");
                }
            } else if (now.booleanValue() && !this.ccsModel.isBuy()) {
                this.txtCodeBuy.setText(this.txtCodeSell.getText());
                this.lbNameBuy.setText(this.lbNameSell.getText());
                this.ctrlPriceBuy.setScale(this.ctrlPriceSell.getScale());
                this.lbUnitBuy.setText(this.lbUnitSell.getText());
                if (this.refItem.isGem()) {
                    if (this.refItem.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.refItem.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                        this.lbNameBuy.setText(String.valueOf(this.refItem.getName()) + " " + "\u521d");
                    } else {
                        this.lbNameBuy.setText(this.refItem.getName());
                    }
                    Tooltip tooltip = new Tooltip();
                    StringBuilder builder = new StringBuilder();
                    builder.append(this.refItem.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
                    builder.append("\r\n");
                    builder.append(this.refItem.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
                    builder.append("\r\n");
                    builder.append(this.refItem.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
                    builder.append("\r\n");
                    builder.append(this.refItem.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
                    builder.append("\r\n");
                    tooltip.setText(builder.toString());
                    this.lbNameBuy.setTooltip(tooltip);
                    this.lbNameSell.setStyle("-fx-font-size: 12;");
                } else if ("FUND".equals(this.refItem.getType())) {
                    BigDecimal down = new BigDecimal(this.refItem.getLimitDownRate());
                    BigDecimal up = new BigDecimal(this.refItem.getLimitUpRate());
                    if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                        this.lbNameBuy.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                        this.lbNameBuy.setStyle("-fx-font-size: 10;");
                        Tooltip tooltip = new Tooltip();
                        tooltip.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                        this.lbNameBuy.setTooltip(tooltip);
                    } else {
                        this.lbNameBuy.setText(this.refItem.getName());
                        this.lbNameBuy.setTooltip(null);
                        this.lbNameBuy.setStyle("-fx-font-size: 12;");
                    }
                } else {
                    this.lbNameBuy.setText(this.refItem.getName());
                    this.lbNameBuy.setTooltip(null);
                    this.lbNameBuy.setStyle("-fx-font-size: 12;");
                }
            }
        });
        this.lbNameBuy.textProperty().bindBidirectional((Property)this.ccsModel.nameBuyProperty());
        this.lbNameSell.textProperty().bindBidirectional((Property)this.ccsModel.nameSellProperty());
        this.txtCodeBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress(this.txtCodeBuy, (KeyEvent)event));
        this.txtCodeBuy.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCodeBuy.textProperty().bindBidirectional((Property)this.ccsModel.securityBuyProperty());
        this.txtCodeBuy.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
        this.spCode.addPossibleSuggestions(items);
        Search.bindAutoCompletion((TextField)this.txtCodeBuy, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItem = (RefItem)this.txtCodeBuy.getUserData();
            this.onSecurityChangeBuy();
            if (this.refItem != null) {
                this.ccsModel.setCountBuy(this.buyQuantity);
            }
        });
        this.txtCodeBuy.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCodeBuy.selectAll());
        this.txtCodeSell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress(this.txtCodeSell, (KeyEvent)event));
        this.txtCodeSell.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCodeSell.textProperty().bindBidirectional((Property)this.ccsModel.securitySellProperty());
        this.txtCodeSell.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Search.bindAutoCompletion((TextField)this.txtCodeSell, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItem = (RefItem)this.txtCodeBuy.getUserData();
            this.onSecurityChangeSell();
            if (this.refItem != null) {
                this.ccsModel.setCountSell(this.sellQuantity);
            }
        });
        this.txtCodeSell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCodeSell.selectAll());
        this.tradePanelBuy.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isBuy(), (Observable[])new Observable[]{this.ccsModel.buyProperty()}));
        this.tradePanelSell.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.isBuy(), (Observable[])new Observable[]{this.ccsModel.buyProperty()}));
        this.tradePanelBuyFather.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.buyActived());
        this.tradePanelSellFather.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.sellActived());
        this.ctrlPriceBuy.ctrl(this.priceSpnBuy);
        MxBindings.bindSD((Property)this.priceSpnBuy.getEditor().textProperty(), (Property)this.ccsModel.priceBuyProperty());
        this.priceSpnBuy.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpnBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnBuy.getEditor()));
        this.priceSpnBuy.getEditor().setText("");
        SpinnerUtils.addDoubleArrowKeyHandler(this.priceSpnBuy, (double)this.upDownPriceFloat, (double)this.leftRightPriceFloat);
        SpinnerUtils.addIntArrowKeyHandler(this.quantitySpnBuy, (int)((int)this.upDownQuantityFloat), (int)((int)this.leftRightQuantityFloat));
        this.ctrlPriceSell.ctrl(this.priceSpnSell);
        MxBindings.bindSD((Property)this.priceSpnSell.getEditor().textProperty(), (Property)this.ccsModel.priceSellProperty());
        this.priceSpnSell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpnSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnSell.getEditor()));
        this.priceSpnSell.getEditor().setText("");
        SpinnerUtils.addDoubleArrowKeyHandler(this.priceSpnSell, (double)this.upDownPriceFloat, (double)this.leftRightPriceFloat);
        SpinnerUtils.addIntArrowKeyHandler(this.quantitySpnSell, (int)((int)this.upDownQuantityFloat), (int)((int)this.leftRightQuantityFloat));
        this.mktItem.changedProperty().addListener(obs -> {
            if (this.ccsModel.isBuy()) {
                if (this.txtCodeBuy.getUserData() == null) {
                    return;
                }
                if (this.ccsModel.getPriceBuy() > 0.0) {
                    return;
                }
                if (this.buyPriceGear == 0) {
                    this.priceBuy = this.ccsModel.getMI().getNowPrice();
                } else if (this.buyPriceGear == 100) {
                    this.priceBuy = this.ccsModel.getMI().getUpLimitPrice();
                } else if (this.buyPriceGear == -100) {
                    this.priceBuy = this.ccsModel.getMI().getDownLimitPrice();
                } else if (this.buyPriceGear >= 1 && this.buyPriceGear <= 10) {
                    this.priceBuy = this.mktItem.getBuyPrice(this.buyPriceGear - 1);
                } else if (this.buyPriceGear >= -10 && this.buyPriceGear <= -1) {
                    this.priceBuy = this.mktItem.getSellPrice(Math.abs(this.buyPriceGear) - 1);
                }
                if (this.priceBuy == -1.0) {
                    return;
                }
                if (this.buyPriceUnit.equals("1")) {
                    this.priceBuy += this.buyPriceFloat;
                } else if (this.buyPriceUnit.equals("2")) {
                    this.priceBuy *= 1.0 + this.buyPriceFloat / 100.0;
                }
                this.priceBuy /= this.refItem.getPriceUnit();
                this.priceBuy = Math.floor(this.priceBuy);
                this.priceBuy *= this.refItem.getPriceUnit();
                if (!this.refItem.getType().equals("BOND")) {
                    this.refItem.getPriceUnit();
                    if (this.priceBuy > this.ccsModel.getMI().getUpLimitPrice() && this.priceBuy > 0.0) {
                        this.priceBuy = this.ccsModel.getMI().getUpLimitPrice();
                    }
                    if (this.priceBuy < this.ccsModel.getMI().getDownLimitPrice() && this.priceBuy > 0.0) {
                        this.priceBuy = this.ccsModel.getMI().getDownLimitPrice();
                    }
                    if (this.priceBuy < 0.0) {
                        this.priceSpnBuy.getEditor().clear();
                    }
                }
                if (this.mktItem.getRefItem() != null) {
                    this.ccsModel.setPriceBuy(Double.valueOf(StringUtils.toStr((double)this.priceBuy, (int)this.mktItem.getRefItem().getScale()).replaceAll(",", "")));
                    Platform.runLater(() -> {
                        this.ctrlPriceBuy.setUnit(this.mktItem.getRefItem().getPriceUnit());
                        if (this.priceBuy >= 0.0) {
                            this.priceSpnBuy.increment();
                            this.priceSpnBuy.decrement();
                        }
                    });
                }
            } else {
                if (this.txtCodeSell.getUserData() == null) {
                    return;
                }
                if (this.ccsModel.getPriceSell() > 0.0) {
                    return;
                }
                if (this.sellPriceGear == 0) {
                    this.priceSell = this.ccsModel.getMI().getNowPrice();
                } else if (this.sellPriceGear == 100) {
                    this.priceSell = this.ccsModel.getMI().getUpLimitPrice();
                } else if (this.sellPriceGear == -100) {
                    this.priceSell = this.ccsModel.getMI().getDownLimitPrice();
                } else if (this.sellPriceGear >= 1 && this.sellPriceGear <= 10) {
                    this.priceSell = this.mktItem.getBuyPrice(this.sellPriceGear - 1);
                } else if (this.sellPriceGear >= -10 && this.sellPriceGear <= -1) {
                    this.priceSell = this.mktItem.getSellPrice(Math.abs(this.sellPriceGear) - 1);
                }
                if (this.priceSell == -1.0) {
                    return;
                }
                if (this.sellPriceUnit.equals("1")) {
                    this.priceSell += this.sellPriceFloat;
                } else if (this.sellPriceUnit.equals("2")) {
                    this.priceSell *= 1.0 + this.sellPriceFloat / 100.0;
                }
                this.priceSell /= this.refItem.getPriceUnit();
                this.priceSell = Math.ceil(this.priceSell);
                this.priceSell *= this.refItem.getPriceUnit();
                if (!this.refItem.getType().equals("BOND")) {
                    if (this.priceSell > this.ccsModel.getMI().getUpLimitPrice() && this.priceSell > 0.0) {
                        this.priceSell = this.ccsModel.getMI().getUpLimitPrice();
                    }
                    if (this.priceSell < this.ccsModel.getMI().getDownLimitPrice() && this.priceSell > 0.0) {
                        this.priceSell = this.ccsModel.getMI().getDownLimitPrice();
                    }
                    if (this.priceSell < 0.0) {
                        this.priceSpnSell.getEditor().clear();
                    }
                }
                if (this.mktItem.getRefItem() != null) {
                    this.ccsModel.setPriceSell(Double.valueOf(StringUtils.toStr((double)this.priceSell, (int)this.mktItem.getRefItem().getScale())));
                    this.ctrlPriceSell.setUnit(this.mktItem.getRefItem().getPriceUnit());
                    if (this.priceSell >= 0.0) {
                        this.priceSpnSell.increment();
                        this.priceSpnSell.decrement();
                    }
                }
            }
        });
        MxBindings.bindSD((Property)this.lbCanBuy.textProperty(), (Property)this.ccsModel.canBuyProperty());
        this.lbCanCapital.textProperty().addListener((ob, old, now) -> {
            if ("".equals(this.priceSpnBuy.getEditor().getText().replaceAll(",", ""))) {
                this.ccsModel.setCanBuy(0L);
                return;
            }
            if (this.ccsModel.getPriceBuy() != 0.0) {
                this.ccsModel.setCanBuy((long)(this.canCapital / this.ccsModel.getPriceBuy() / 100.0) * 100L);
            }
        });
        this.ctrlCountBuy.ctrl(this.quantitySpnBuy);
        MxBindings.bindSI((Property)this.quantitySpnBuy.getEditor().textProperty(), (Property)this.ccsModel.countBuyProperty());
        this.quantitySpnBuy.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpnBuy.getEditor().setOnMouseClicked(event -> this.quantitySpnBuy.getEditor().selectAll());
        this.quantitySpnBuy.getEditor().setText("");
        this.quantitySpnBuy.getEditor().textProperty().addListener((ob, old, now) -> this.quantitySpnBuy.getValueFactory().setValue((Object)((int)this.ccsModel.getCountBuy())));
        this.ctrlCountSell.ctrl(this.quantitySpnSell);
        MxBindings.bindSI((Property)this.quantitySpnSell.getEditor().textProperty(), (Property)this.ccsModel.countSellProperty());
        this.quantitySpnSell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpnSell.getEditor().setOnMouseClicked(event -> this.quantitySpnSell.getEditor().selectAll());
        this.quantitySpnSell.getEditor().setText("");
        this.quantitySpnSell.getEditor().textProperty().addListener((ob, old, now) -> this.quantitySpnSell.getValueFactory().setValue((Object)((int)this.ccsModel.getCountSell())));
        this.ccsTradePart.addEventHandler(KeyEvent.KEY_RELEASED, event -> this.keyPress((KeyEvent)event));
        SpinnerUtils.arrowsStyle(this.priceSpnBuy);
        SpinnerUtils.arrowsStyle(this.priceSpnSell);
        SpinnerUtils.arrowsStyle(this.quantitySpnBuy);
        SpinnerUtils.arrowsStyle(this.quantitySpnSell);
    }

    private void keyPress(KeyEvent key) {
        if ((this.txtCodeBuy.isFocused() || this.txtCodeSell.isFocused()) && key.getCode() != this.keyBuyArea && key.getCode() != this.keySellArea) {
            return;
        }
        if (key.getCode() == this.keyBuyArea) {
            this.buyActived();
        } else if (key.getCode() == this.keySellArea) {
            this.sellActived();
        }
        if (key.getCode() == this.keyBuyBtn && this.ccsModel.isBuy()) {
            this.orderBuy();
        }
        if (key.getCode() == this.keySellBtn && !this.ccsModel.isBuy()) {
            this.orderSell();
        }
        key.consume();
    }

    private void buyActived() {
        if (this.ccsModel.isBuy()) {
            return;
        }
        this.ccsModel.setBuy(true);
        this.txtCodeBuy.requestFocus();
        if (!this.ccsModel.getSecurityBuy().equals(this.ccsModel.getSecuritySell())) {
            this.onSecurityChangeBuy();
        }
    }

    private void sellActived() {
        if (!this.ccsModel.isBuy()) {
            return;
        }
        this.ccsModel.setBuy(false);
        this.txtCodeSell.requestFocus();
        if (!this.ccsModel.getSecurityBuy().equals(this.ccsModel.getSecuritySell())) {
            this.onSecurityChangeSell();
        } else {
            this.setCanSell();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            if (this.ccsModel.isBuy()) {
                this.txtCodeBuy.requestFocus();
                this.txtCodeBuy.selectAll();
            } else {
                this.txtCodeSell.requestFocus();
                this.txtCodeSell.selectAll();
            }
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            if (this.ccsModel.isBuy()) {
                this.orderBuy();
                this.priceSpnBuy.requestFocus();
                TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnBuy.getEditor());
            } else {
                this.orderSell();
                this.priceSpnSell.requestFocus();
                TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnSell.getEditor());
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.ccsModel.isBuy()) {
                this.quantitySpnBuy.requestFocus();
                this.quantitySpnBuy.getEditor().selectAll();
            } else {
                this.quantitySpnSell.requestFocus();
                this.quantitySpnSell.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    private void setPrice(double price) {
        if (price > 0.0) {
            if (this.ccsModel.isBuy()) {
                this.priceSpnBuy.getValueFactory().setValue((Object)price);
                this.ccsModel.setPriceBuy(price);
            } else {
                this.priceSpnSell.getValueFactory().setValue((Object)price);
                this.ccsModel.setPriceSell(price);
            }
        }
    }

    public void codeKeyPress(TextField ctrl, KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (ctrl == this.txtCodeBuy) {
                this.priceSpnBuy.requestFocus();
                TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnBuy.getEditor());
            }
            if (ctrl == this.txtCodeSell) {
                this.priceSpnSell.requestFocus();
                TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.priceSpnSell.getEditor());
            }
            key.consume();
        }
    }

    private void loseFocus(Boolean val) {
        RefItem ref;
        if (!val.booleanValue() && this.txtCodeBuy.getText().length() == 6 && this.ccsModel.isBuy()) {
            ref = this.mktItem.getRefItem();
            if (ref == null || "".equals(ref.getName()) || this.ccsModel.getValidRef() == null) {
                this.lbNameBuy.setText(INVALID_CODE);
            }
            if (this.mktItem.getStop().getValue().booleanValue()) {
                this.lbNameBuy.setText(this.mktItem.getStatus());
            }
        }
        if (!val.booleanValue() && this.txtCodeSell.getText().length() == 6 && !this.ccsModel.isBuy()) {
            ref = this.mktItem.getRefItem();
            if (ref == null || ref.getName().equals("") || this.ccsModel.getValidRef() == null) {
                this.lbNameSell.setText(INVALID_CODE);
            }
            if (this.mktItem.getStop().getValue().booleanValue()) {
                this.lbNameSell.setText(this.mktItem.getStatus());
            }
        }
    }

    private void updateSecAcctList() {
        CcsFundAccount fund = this.accMng.getFundAcc(this.cmbAcct.getEditor().getText());
        if (fund == null) {
            return;
        }
        if (this.refItem == null || "".equals(this.refItem.getName())) {
            this.secList.clear();
            this.accountMap.get(fund).forEach(each -> {
                boolean bl = this.secList.add((Object)each.getInverstorSecId());
            });
            if (this.secList.contains((Object)this.oldSec)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSec);
            }
        } else {
            ArrayList<String> listTemp = new ArrayList<String>();
            for (SecAccount sec : this.accountMap.get(fund)) {
                if (!sec.getExchange().getRaw().equals(this.refItem.getMarket())) continue;
                listTemp.add(sec.getInverstorSecId());
            }
            this.secList.clear();
            this.secList.addAll(listTemp);
            if (this.secList.contains((Object)this.oldSH)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSH);
                this.oldSec = this.oldSH;
            } else if (this.secList.contains((Object)this.oldSZ)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSZ);
                this.oldSec = this.oldSZ;
            } else {
                this.cmbSecAcct.getSelectionModel().select(0);
            }
        }
        this.suggestSec.setAllSuggestions(this.secList);
    }

    private void resetPriceSpn(boolean buy, boolean sell) {
        if (this.set.getUpDownPriceFloat() != null) {
            this.upDownPriceFloat = this.set.getUpDownPriceFloat();
            if (this.refItem != null && this.upDownPriceFloat < this.refItem.getPriceUnit()) {
                this.upDownPriceFloat = this.refItem.getPriceUnit();
            }
        }
        if (this.set.getLeftRightPriceFloat() != null) {
            this.leftRightPriceFloat = this.set.getLeftRightPriceFloat();
            if (this.refItem != null && this.leftRightPriceFloat < this.refItem.getPriceUnit()) {
                this.leftRightPriceFloat = this.refItem.getPriceUnit();
            }
        }
        if (this.refItem != null) {
            this.ctrlPriceBuy.setUnit(this.refItem.getPriceUnit());
            this.ctrlPriceSell.setUnit(this.refItem.getPriceUnit());
        }
        SpinnerUtils.addDoubleArrowKeyHandler(this.priceSpnBuy, (double)this.upDownPriceFloat, (double)this.leftRightPriceFloat);
        SpinnerUtils.addDoubleArrowKeyHandler(this.priceSpnSell, (double)this.upDownPriceFloat, (double)this.leftRightPriceFloat);
    }

    private void onSecurityChangeBuy() {
        this.priceSpnBuy.getEditor().setText("");
        this.refItem = (RefItem)this.txtCodeBuy.getUserData();
        this.ccsModel.getMI().setRefItem(this.refItem);
        this.ccsModel.onSecChange();
        if (this.refItem == null || this.refItem.getName().equals("")) {
            this.ctrl.setTitle("\u53cc\u5411\u5feb\u6377\u4ea4\u6613");
            this.lbCanBuy.setText("0");
            if (this.txtCodeBuy.getText().length() == 6) {
                this.lbNameBuy.setText(INVALID_CODE);
            } else {
                this.lbNameBuy.setText("");
            }
        } else {
            if (this.checkSame.isSelected()) {
                this.resetPriceSpn(true, true);
            } else {
                this.resetPriceSpn(true, false);
            }
            this.lbNameBuy.setText(this.refItem.getName());
            this.ctrl.setTitle(String.valueOf(this.refItem.getCode()) + " - " + this.refItem.getName());
            if (this.refItem.getType().equals("BOND")) {
                if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                    this.lbUnitBuy.setText("\u624b");
                } else {
                    this.lbUnitBuy.setText("\u5f20");
                }
            } else if (this.refItem.getType().equals("FUND")) {
                this.lbUnitBuy.setText("\u4efd");
            } else {
                this.lbUnitBuy.setText("\u80a1");
            }
        }
        if (this.txtCodeBuy.getText().isEmpty()) {
            this.lbNameBuy.setText("");
        }
        if (this.checkSame.isSelected()) {
            this.txtCodeSell.setText(this.txtCodeBuy.getText());
            this.lbNameSell.setText(this.lbNameBuy.getText());
            this.ctrlPriceSell.setScale(this.ctrlPriceBuy.getScale());
            this.lbUnitSell.setText(this.lbUnitBuy.getText());
        }
        this.updateSecAcctList();
        if (this.refItem.isGem()) {
            if (this.refItem.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.refItem.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                this.lbNameBuy.setText(String.valueOf(this.refItem.getName()) + " " + "\u521d");
            } else {
                this.lbNameBuy.setText(this.refItem.getName());
            }
            Tooltip tooltip = new Tooltip();
            StringBuilder builder = new StringBuilder();
            builder.append(this.refItem.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
            builder.append("\r\n");
            builder.append(this.refItem.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
            builder.append("\r\n");
            builder.append(this.refItem.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
            builder.append("\r\n");
            builder.append(this.refItem.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
            builder.append("\r\n");
            tooltip.setText(builder.toString());
            this.lbNameBuy.setTooltip(tooltip);
            this.lbNameSell.setStyle("-fx-font-size: 12;");
        } else if ("FUND".equals(this.refItem.getType())) {
            BigDecimal down = new BigDecimal(this.refItem.getLimitDownRate());
            BigDecimal up = new BigDecimal(this.refItem.getLimitUpRate());
            if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                this.lbNameBuy.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                this.lbNameBuy.setStyle("-fx-font-size: 10;");
                Tooltip tooltip = new Tooltip();
                tooltip.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                this.lbNameBuy.setTooltip(tooltip);
            } else {
                this.lbNameBuy.setText(this.refItem.getName());
                this.lbNameBuy.setTooltip(null);
                this.lbNameBuy.setStyle("-fx-font-size: 12;");
            }
        } else {
            this.lbNameBuy.setText(this.refItem.getName());
            this.lbNameBuy.setTooltip(null);
            this.lbNameBuy.setStyle("-fx-font-size: 12;");
        }
    }

    private void onSecurityChangeSell() {
        this.priceSpnSell.getEditor().setText("");
        this.refItem = (RefItem)this.txtCodeSell.getUserData();
        this.ccsModel.getMI().setRefItem(this.refItem);
        this.ccsModel.onSecChange();
        if (this.refItem == null || this.refItem.getName().equals("")) {
            this.ctrl.setTitle("\u53cc\u5411\u5feb\u6377\u4ea4\u6613");
            this.lbCanBuy.setText("0");
            if (this.txtCodeSell.getText().length() == 6) {
                this.lbNameSell.setText(INVALID_CODE);
            } else {
                this.lbNameSell.setText("");
            }
        } else {
            if (this.checkSame.isSelected()) {
                this.resetPriceSpn(true, true);
            } else {
                this.resetPriceSpn(false, true);
            }
            this.lbNameSell.setText(this.refItem.getName());
            this.ctrl.setTitle(String.valueOf(this.refItem.getCode()) + " - " + this.refItem.getName());
            if (this.refItem.getType().equals("BOND")) {
                if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                    this.lbUnitSell.setText("\u624b");
                } else {
                    this.lbUnitSell.setText("\u5f20");
                }
            } else if (this.refItem.getType().equals("FUND")) {
                this.lbUnitSell.setText("\u4efd");
            } else {
                this.lbUnitSell.setText("\u80a1");
            }
        }
        if (this.txtCodeSell.getText().isEmpty()) {
            this.lbNameSell.setText("");
        }
        if (this.checkSame.isSelected()) {
            this.txtCodeBuy.setText(this.txtCodeSell.getText());
            this.lbNameBuy.setText(this.lbNameSell.getText());
            this.ctrlPriceBuy.setScale(this.ctrlPriceSell.getScale());
            this.lbUnitBuy.setText(this.lbUnitSell.getText());
        }
        this.updateSecAcctList();
        this.setCanSell();
        if (this.refItem.isGem()) {
            if (this.refItem.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.refItem.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                this.lbNameSell.setText(String.valueOf(this.refItem.getName()) + " " + "\u521d");
            } else {
                this.lbNameSell.setText(this.refItem.getName());
            }
            Tooltip tooltip = new Tooltip();
            StringBuilder builder = new StringBuilder();
            builder.append(this.refItem.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
            builder.append("\r\n");
            builder.append(this.refItem.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
            builder.append("\r\n");
            builder.append(this.refItem.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
            builder.append("\r\n");
            builder.append(this.refItem.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
            builder.append("\r\n");
            tooltip.setText(builder.toString());
            this.lbNameSell.setTooltip(tooltip);
            this.lbNameSell.setStyle("-fx-font-size: 12;");
        } else if ("FUND".equals(this.refItem.getType())) {
            BigDecimal down = new BigDecimal(this.refItem.getLimitDownRate());
            BigDecimal up = new BigDecimal(this.refItem.getLimitUpRate());
            if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                this.lbNameSell.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                this.lbNameSell.setStyle("-fx-font-size: 10;");
                Tooltip tooltip = new Tooltip();
                tooltip.setText(String.valueOf(this.refItem.getName()) + "(\u6da8\u8dcc20%)");
                this.lbNameSell.setTooltip(tooltip);
            } else {
                this.lbNameSell.setText(this.refItem.getName());
                this.lbNameSell.setTooltip(null);
                this.lbNameSell.setStyle("-fx-font-size: 12;");
            }
        } else {
            this.lbNameSell.setText(this.refItem.getName());
            this.lbNameSell.setTooltip(null);
            this.lbNameSell.setStyle("-fx-font-size: 12;");
        }
    }

    private void setCanSell() {
        if (this.refItem == null) {
            this.lbCanSell.setText("0");
            return;
        }
        SecAccount secAcct = this.accMng.getSecAcc(this.cmbSecAcct.getEditor().getText(), "");
        if (secAcct == null) {
            this.lbCanSell.setText("0");
            return;
        }
        CcsPosition posi = this.posModel.getPosition(secAcct, this.refItem.getCode());
        if (posi == null) {
            this.lbCanSell.setText("0");
            return;
        }
        this.lbCanSell.setText(String.valueOf(posi.getCanVol()));
    }

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    public boolean validBuy() {
        String tip1;
        if (!this.alert.check(this.refItem != null, Alert.AlertType.WARNING, tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801")) {
            return false;
        }
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(this.ccsModel.getPriceBuy() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(!this.cmbSecAcct.getEditor().getText().equals(""), Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.ccsModel.getCountBuy() > 0L, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        if (this.autoSlice) {
            int base = 100;
            if (this.refItem.getType().equals("BOND")) {
                base = this.mktItem.getRefItem().getMarket().equals("XSHG") ? 1 : 10;
            }
            if (!this.alert.check(this.ccsModel.getCountBuy() / this.sliceCountMax > 0L ? this.sliceCountMax % (long)base == 0L && this.ccsModel.getCountBuy() % this.sliceCountMax % (long)base == 0L : this.ccsModel.getCountBuy() % this.sliceCountMax % (long)base == 0L, Alert.AlertType.CONFIRMATION, "\u672c\u6b21\u81ea\u52a8\u62c6\u5355\u4f1a\u5bfc\u81f4\u975e\u6574\u624b\u59d4\u6258, \u662f\u5426\u7ee7\u7eed\uff1f")) {
                return false;
            }
        }
        return this.alert.check(!this.popBeforeOrder, Alert.AlertType.CONFIRMATION, "\u8bf7\u786e\u8ba4\u59d4\u6258\u4fe1\u606f\uff1a\t\u8bc1\u5238\u4ee3\u7801  " + this.txtCodeBuy.getText() + "  " + this.lbNameBuy.getText() + "\n" + "\u4e70\u5356\u6807\u5fd7  " + this.ccsModel.getDirection() + "\t\t" + "\u4ef7\u683c\u7c7b\u578b  " + "\u9650\u4ef7\u59d4\u6258" + "\n" + "\u59d4\u6258\u6570\u91cf  " + this.ccsModel.getCountBuy() + "\t\t" + "\u59d4\u6258\u4ef7\u683c  " + this.ccsModel.getPriceBuy() + "\n" + "\u8bc1\u5238\u8d26\u53f7  " + this.cmbSecAcct.getEditor().getText());
    }

    public boolean validSell() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(!this.lbNameSell.getText().equals(""), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.alert.check(!this.lbNameSell.getText().contains(INVALID_CODE), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(this.ccsModel.getPriceSell() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(!this.cmbSecAcct.getEditor().getText().equals(""), Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.ccsModel.getCountSell() > 0L, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        if (this.autoSlice) {
            int base = 100;
            if (this.refItem.getType().equals("BOND")) {
                base = this.mktItem.getRefItem().getMarket().equals("XSHG") ? 1 : 10;
            }
            if (!this.alert.check(this.ccsModel.getCountSell() / this.sliceCountMax > 0L ? this.sliceCountMax % (long)base == 0L : this.ccsModel.getCountSell() % this.sliceCountMax % (long)base == 0L, Alert.AlertType.CONFIRMATION, "\u672c\u6b21\u81ea\u52a8\u62c6\u5355\u4f1a\u5bfc\u81f4\u975e\u6574\u624b\u59d4\u6258, \u662f\u5426\u7ee7\u7eed\uff1f")) {
                return false;
            }
        }
        return this.alert.check(!this.popBeforeOrder, Alert.AlertType.CONFIRMATION, "\u8bf7\u786e\u8ba4\u59d4\u6258\u4fe1\u606f\uff1a\t\u8bc1\u5238\u4ee3\u7801  " + this.txtCodeSell.getText() + "  " + this.lbNameSell.getText() + "\n" + "\u4e70\u5356\u6807\u5fd7  " + this.ccsModel.getDirection() + "\t\t" + "\u4ef7\u683c\u7c7b\u578b  " + "\u9650\u4ef7\u59d4\u6258" + "\n" + "\u59d4\u6258\u6570\u91cf  " + this.ccsModel.getCountSell() + "\t\t" + "\u59d4\u6258\u4ef7\u683c  " + this.ccsModel.getPriceSell() + "\n" + "\u8bc1\u5238\u8d26\u53f7  " + this.cmbSecAcct.getEditor().getText());
    }

    @FXML
    public void orderBuy() {
        this.left = this.ccsModel.getCountBuy();
        if (!this.validBuy()) {
            return;
        }
        CcsSingleEntrust en = this.ef.createCcsSingle(this.accMng.getFundAcc(this.cmbAcct.getEditor().getText()).getExtAccntId(), this.accMng.getSecAcc(this.cmbSecAcct.getEditor().getText(), "").getExtSecAccntId());
        en.setSide(49);
        en.setQuantity(this.ccsModel.getCountBuy());
        en.setMarket(this.mktItem.getRefItem().getMarket());
        en.setSecType(this.mktItem.getRefItem().getType());
        en.setOrderType(50);
        en.setPrice(this.ccsModel.getPriceBuy());
        en.setSec(this.mktItem.getRefItem().getCode());
        en.setAppID("010");
        if (this.autoSlice) {
            this.exe.execute(() -> {
                while (this.left > 0L) {
                    try {
                        if (this.left > this.sliceCountMax) {
                            en.setQuantity(this.sliceCountMax);
                            this.left -= this.sliceCountMax;
                            en.submit();
                        } else {
                            en.setQuantity(this.left);
                            this.left = 0L;
                            en.submit();
                        }
                    }
                    catch (MException e) {
                        e.printStackTrace();
                        ++this.failed;
                        continue;
                    }
                    ++this.successed;
                }
                Platform.runLater(() -> this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f " + this.successed + "\u7b14\uff0c\u5931\u8d25 " + this.failed + "\u7b14"));
            });
        } else {
            try {
                en.submit();
            }
            catch (MException e) {
                e.printStackTrace();
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u4e0b\u5355\u63d0\u4ea4\u5931\u8d25: " + e.getMessage());
                return;
            }
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f");
        }
        if (this.clearAfterOrder) {
            this.quantitySpnBuy.getEditor().setText("");
        }
        Platform.runLater(() -> {
            this.txtCodeBuy.requestFocus();
            this.txtCodeBuy.selectAll();
        });
    }

    @FXML
    public void orderSell() {
        if (!this.validSell()) {
            return;
        }
        CcsSingleEntrust en = this.ef.createCcsSingle(this.accMng.getFundAcc(this.cmbAcct.getEditor().getText()).getExtAccntId(), this.accMng.getSecAcc(this.cmbSecAcct.getEditor().getText(), "").getExtSecAccntId());
        en.setSide(50);
        en.setQuantity(this.ccsModel.getCountSell());
        en.setMarket(this.mktItem.getRefItem().getMarket());
        en.setSecType(this.mktItem.getRefItem().getType());
        en.setOrderType(50);
        en.setPrice(this.ccsModel.getPriceSell());
        en.setSec(this.mktItem.getRefItem().getCode());
        en.setAppID("010");
        long left = this.ccsModel.getCountSell();
        int successed = 0;
        int failed = 0;
        if (this.autoSlice) {
            while (left > 0L) {
                try {
                    if (left > this.sliceCountMax) {
                        en.setQuantity(this.sliceCountMax);
                        left -= this.sliceCountMax;
                        en.submit();
                    } else {
                        en.setQuantity(left);
                        left = 0L;
                        en.submit();
                    }
                }
                catch (MException e) {
                    e.printStackTrace();
                    ++failed;
                    continue;
                }
                ++successed;
            }
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f " + successed + "\u7b14\uff0c\u5931\u8d25 " + failed + "\u7b14");
        } else {
            try {
                en.submit();
            }
            catch (MException e) {
                e.printStackTrace();
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u4e0b\u5355\u63d0\u4ea4\u5931\u8d25: " + e.getMessage());
                return;
            }
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f");
        }
        if (this.clearAfterOrder) {
            this.quantitySpnSell.getEditor().setText("");
        }
    }
}

