/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.define.BsDict;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.User;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class CcsEntrustConfirmDialog
extends DialogObj {
    @FXML
    private TableView<CcsSingleEntrust> tableItems;
    @FXML
    private TableColumn<CcsSingleEntrust, String> index;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colCode;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colName;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colMkt;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colDirection;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colCount;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colUnit;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colPrice;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colAmt;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colAcc;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colSecAcc;
    @FXML
    private TableColumn<CcsSingleEntrust, Object> colTrader;
    @FXML
    private TableColumn<CcsSingleEntrust, Object> colExpiredDate;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colPorfolio;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label lbRmbAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @FXML
    private HBox hboxPostil;
    @FXML
    private TextArea txtaPostil;
    @FXML
    private Label labInfo;
    @Inject
    private MxAlert alert;
    private ObservableList<CcsSingleEntrust> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    public long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    public boolean triggered = false;
    private RefItem refItem;
    private MxNode priceStg;
    private String type = "";
    private String custom = "";
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeMktStg;
    private MxNode priceTypeBidAskStg;
    private static int PAR_VALUE = 100;
    private boolean isInstruction = false;
    private String instructionPanelType = "";
    private boolean isExecution = false;
    private boolean isHkwolun = false;
    private boolean isHk = false;
    private boolean isBuy = false;
    private boolean isBlock = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String approveSymbol = "\u5ba1\u6279\u901a\u8fc7";
    private String unit = "";
    private boolean showWarning = true;
    private boolean mail = false;
    private Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    private Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    private static final String GEM_BUY_TIP = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u60a8\u7684\u4e70\u5165\u7533\u62a5\u82e5\u4ef7\u683c\u9ad8\u4e8e\u57fa\u51c6\u4ef7\u7684102%,\u5c06\u4f1a\u88ab\u6682\u5b58,\u5f53\u80a1\u4ef7\u8fdb\u5165\u6709\u6548\u7ade\u4ef7\u8303\u56f4\u65b9\u53ef\u53c2\u4e0e\u7ade\u4ef7\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u72b6\u6001.";
    private static final String GEM_SELL_TIP = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u60a8\u7684\u5356\u51fa\u7533\u62a5\u82e5\u4ef7\u683c\u4f4e\u4e8e\u57fa\u51c6\u4ef7\u768498%,\u5c06\u4f1a\u88ab\u6682\u5b58,\u5f53\u80a1\u4ef7\u8fdb\u5165\u6709\u6548\u7ade\u4ef7\u8303\u56f4\u65b9\u53ef\u53c2\u4e0e\u7ade\u4ef7\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u72b6\u6001.";

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
        this.showGemTip();
    }

    private void showGemTip() {
        for (CcsSingleEntrust ccsSingleEntrust : this.list) {
            if (!this.isGem(ccsSingleEntrust) || !this.isExecution()) continue;
            if (this.isBuy(ccsSingleEntrust)) {
                this.labInfo.setText(GEM_BUY_TIP);
                break;
            }
            if (!this.isSell(ccsSingleEntrust)) continue;
            this.labInfo.setText(GEM_SELL_TIP);
            break;
        }
    }

    protected void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        if (!this.AmtIsEmpty()) {
            this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
            if (this.isHkwolun && this.totalAmt != 0.0) {
                String rate = this.isBuy ? RefItem.getAskRate() : RefItem.getBidRate();
                double rmb = this.totalAmt * (rate.isEmpty() ? 1.0 : Double.parseDouble(rate));
                this.lbRmbAmt.setText(String.valueOf(StringUtils.toPriceStr((double)rmb, (int)2)) + "(RMB)");
            }
        }
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
        if (!"0".equals(this.instructionPanelType)) {
            this.hboxPostil.setVisible(true);
            this.txtaPostil.setTextFormatter((TextFormatter)new MxFormatter("[\\s\\S]*", 100));
        }
        if (this.fundTraderMap == null || this.fundTraderMap.isEmpty()) {
            this.colTrader.setVisible(false);
        }
        if (!"2".equals(this.instructionPanelType) && !"1".equals(this.instructionPanelType)) {
            this.colExpiredDate.setVisible(false);
        }
        if (this.isMail()) {
            this.colExpiredDate.setVisible(false);
        }
        if ("30".equals(this.instructionPanelType)) {
            this.tableItems.getColumns().remove(this.colExpiredDate);
        }
        if (this.isHk) {
            this.lbRmbAmt.setVisible(false);
        }
    }

    private void calTotalInfo() {
        for (CcsSingleEntrust item : this.list) {
            double money = this.getMoney(item);
            if (this.isBuy(item)) {
                Double num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            this.totalCount += item.getQuantity().longValue();
            this.totalAmt += money;
            if (!this.showWarning || !this.checkSufficient(item)) continue;
            this.triggered = true;
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        StringBuilder bld = new StringBuilder();
        if (!this.showWarning) {
            return;
        }
        for (FundAccount acc : this.accBuyMap.keySet()) {
            double money = this.accBuyMap.get(acc);
            double d = money = this.isHkwolun ? this.getRmbBuyMoneyByHK(money) : money;
            if (!(acc.getAvailable() < money)) continue;
            if (acc.getInvestmarkets().contains("XHKG")) break;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t");
        }
        this.strTip = bld.toString();
    }

    private boolean checkSufficient(CcsSingleEntrust item) {
        if (BsDict.HKUSA_MARKET.contains(item.getMarket())) {
            return item.isInsufficient();
        }
        switch (item.getSide()) {
            case 49: 
            case 70: 
            case 84: {
                double money = this.getMoney(item);
                money = this.isHkwolun ? this.getRmbBuyMoneyByHK(money) : money;
                item.setInsufficient(money > item.getFundAccount().getAvailable());
                item.setTip(item.isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case 50: {
                item.setInsufficient(item.getQuantity() > item.getCanSell());
                item.setTip(item.isInsufficient() ? "\u53ef\u5356\u6570\u4e0d\u8db3" : "");
                break;
            }
            case 71: {
                item.setInsufficient(item.getQuantity() > item.getCanBuy());
                item.setTip(item.isInsufficient() ? "\u6807\u51c6\u5238\u4e0d\u8db3" : "");
                if (this.instructionPanelType.isEmpty()) break;
                item.setInsufficient(false);
                item.setTip("");
                break;
            }
            case 83: {
                item.setInsufficient(item.getQuantity() > item.getCanSell());
                item.setTip(item.isInsufficient() ? "\u53ef\u51fa\u5e93\u6570\u91cf\u4e0d\u8db3" : "");
                break;
            }
            case 82: {
                item.setInsufficient(item.getQuantity() > item.getCanBuy());
                item.setTip(item.isInsufficient() ? "\u53ef\u5165\u5e93\u6570\u91cf\u4e0d\u8db3" : "");
            }
        }
        return item.isInsufficient();
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).secProperty());
        this.colName.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((CcsSingleEntrust)((Object)((Object)m.getValue()))).getMarket()).getValue()));
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).sideProperty());
        this.colCount.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(m -> {
            ((CcsSingleEntrust)((Object)((Object)m.getValue()))).setUnit(this.unit);
            return ((CcsSingleEntrust)((Object)((Object)m.getValue()))).unitProperty();
        });
        if (this.isAlgo()) {
            this.colPrice.setCellValueFactory(data -> new SimpleObjectProperty((Object)this.custom));
            this.colPrice.setText("\u7b97\u6cd5\u540d\u79f0");
        } else if (!this.priceIsEmpty()) {
            this.colPrice.setCellFactory(cell -> new ItemPriceCell());
            this.colPrice.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).priceProperty());
        }
        if (!this.AmtIsEmpty()) {
            this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
            this.colAmt.setCellValueFactory(m -> new SimpleDoubleProperty(this.getMoney((CcsSingleEntrust)((Object)((Object)m.getValue())))));
        }
        if (this.isHkwolun) {
            this.colPrice.setText(String.valueOf(this.colPrice.getText()) + "(HKD)");
            this.colAmt.setText(String.valueOf(this.colAmt.getText()) + "(HKD)");
        }
        if (this.isHk) {
            this.colPrice.setCellFactory(cell -> new DoubleTableCell());
            this.colAmt.setCellFactory(cell -> new DoubleTableCell());
        }
        this.colAcc.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).investorSecIdProperty());
        this.colPorfolio.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).portfolioNameProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((CcsSingleEntrust)((Object)((Object)m.getValue()))).tipProperty());
        this.colTrader.setCellValueFactory(m -> this.setTraderChooser((TableColumn.CellDataFeatures<CcsSingleEntrust, Object>)m));
        this.colExpiredDate.setCellValueFactory(m -> this.setExpiredDateChooser((TableColumn.CellDataFeatures<CcsSingleEntrust, Object>)m));
        this.tableItems.setItems(this.list);
    }

    private ObservableObjectValue<Object> setTraderChooser(TableColumn.CellDataFeatures<CcsSingleEntrust, Object> m) {
        CcsSingleEntrust en = (CcsSingleEntrust)((Object)m.getValue());
        if (en == null || en.getFundAccount() == null) {
            return null;
        }
        AppointedTraderSetting setting = this.fundTraderMap.get(en.getFundAccount());
        if (setting == null) {
            return null;
        }
        HBox box = new HBox();
        CheckComboBox comboBox = new CheckComboBox();
        comboBox.getItems().setAll((Collection)setting.getUsers());
        comboBox.getCheckModel().checkAll();
        ListChangeListener tradersLis = ob -> {
            setting.getAppointedTraderIds().clear();
            ObservableList checkedItems = comboBox.getCheckModel().getCheckedItems();
            for (User checkUser : checkedItems) {
                setting.getAppointedTraderIds().add(checkUser.getId());
            }
        };
        comboBox.getCheckModel().getCheckedItems().addListener(tradersLis);
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        box.getChildren().add((Object)comboBox);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private ObservableObjectValue<Object> setExpiredDateChooser(TableColumn.CellDataFeatures<CcsSingleEntrust, Object> m) {
        HBox box = new HBox();
        DatePicker dp = new DatePicker();
        DatePickerUtils.setDaysLaterLimit((DatePicker)dp, (int)30);
        dp.setEditable(false);
        dp.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        dp.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null || StringUtils.isEmpty((String)newV.toString())) {
                ((CcsSingleEntrust)((Object)((Object)m.getValue()))).setInsExpiredDate("");
                this.insExpiredMap.put(((CcsSingleEntrust)((Object)((Object)m.getValue()))).getFundAccount(), "");
            } else {
                this.insExpiredMap.put(((CcsSingleEntrust)((Object)((Object)m.getValue()))).getFundAccount(), newV.toString().replace("-", ""));
            }
        });
        box.setSpacing(10.0);
        dp.setValue((Object)LocalDate.now());
        box.setAlignment(Pos.CENTER);
        box.getChildren().add((Object)dp);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private int getRefScale() {
        if (this.isBlock) {
            return 3;
        }
        int scale = this.getRefItem() != null ? this.getRefItem().getScale() : 2;
        return scale == 0 ? 3 : scale;
    }

    protected boolean isOK(ButtonType bt) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<FundAccount, String> entry : this.insExpiredMap.entrySet()) {
            if (!(entry.getKey() instanceof CcsSubFundAccount)) break;
            CcsSubFundAccount subFund = (CcsSubFundAccount)CcsSubFundAccount.class.cast(entry.getKey());
            if (!StringUtils.isEmpty((String)entry.getValue()) && hashMap.get(subFund.getPortfolioId()) != null && !entry.getValue().equals(hashMap.get(subFund.getPortfolioId()))) {
                this.alert.alert(Alert.AlertType.ERROR, "\u540c\u4e00\u4e2a\u6295\u7ec4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u6307\u4ee4\u7ec8\u6b62\u65e5\u671f\u3002");
                return false;
            }
            hashMap.put(subFund.getPortfolioId(), entry.getValue());
        }
        for (AppointedTraderSetting appointedTraderSetting : this.fundTraderMap.values()) {
            if (WorkflowTemplete.THREE_STEP_RISK != appointedTraderSetting.getWt() || !appointedTraderSetting.getAppointedTraderIds().isEmpty()) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u4e09\u8282\u70b9\u98ce\u63a7\u6307\u4ee4\uff0c\u8bf7\u6307\u5b9a\u4ea4\u6613\u5458");
            return false;
        }
        return true;
    }

    private boolean isBuy(CcsSingleEntrust item) {
        return item.getSide() == 49 || item.getSide() == 71 || item.getSide() == 84;
    }

    private boolean isSell(CcsSingleEntrust item) {
        return item.getSide() == 50;
    }

    private boolean isGem(CcsSingleEntrust item) {
        return item.getSec().startsWith("30") && "XSHE".equals(item.getMarket());
    }

    private int getParValue(CcsSingleEntrust item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(CcsSingleEntrust item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getQuantity() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && ("BOND".equals(item.getSecType()) || "\u53ef\u8f6c\u503a\u7533\u8d2d".equals(item.getSubSecType()))) {
            return (double)item.getQuantity().longValue() * item.getPrice() * 10.0;
        }
        if ("FORWARD".equals(item.getSecType())) {
            return (double)item.getQuantity().longValue() * item.getPrice() / 100.0;
        }
        return (double)item.getQuantity().longValue() * item.getPrice();
    }

    private double getRmbBuyMoneyByHK(double money) {
        String rate = RefItem.getAskRate();
        return money *= rate.isEmpty() ? 1.0 : Double.parseDouble(rate);
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    private MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setList(List<CcsSingleEntrust> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setIsInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeMktStg() {
        return this.priceTypeMktStg;
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStg = priceTypeMktStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public void setInstructionPanelType(String instructionType) {
        this.instructionPanelType = instructionType;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getPostil() {
        return this.txtaPostil.getText();
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public void setHkwolun(boolean isHkwolun) {
        this.isHkwolun = isHkwolun;
    }

    public void setHk(boolean isHk) {
        this.isHk = isHk;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public void setBuy(boolean isBuy) {
        this.isBuy = isBuy;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public void setBlock(boolean isBlock) {
        this.isBlock = isBlock;
    }

    public boolean isMail() {
        return this.mail;
    }

    public void setMail(boolean mail) {
        this.mail = mail;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    public class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private int scale = 3;

        public DoubleTableCell() {
        }

        public DoubleTableCell(int scale) {
            this.scale = scale;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(StringUtils.toThousands((String)String.valueOf(item), (int)this.scale));
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<CcsSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            CcsSingleEntrust item = (CcsSingleEntrust)((Object)CcsSingleEntrust.class.cast(this.getTableRow().getItem()));
            if (item == null) {
                this.setText(null);
                return;
            }
            if (CcsEntrustConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 49) {
                    this.setText(CcsEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + CcsEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else if (item.getOrderType() == 50) {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        if (CcsEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null) {
                            text = "-";
                        }
                        text = String.valueOf(text) + StringUtils.toStr((double)value.doubleValue(), (int)CcsEntrustConfirmDialog.this.getRefScale());
                    }
                    if (CcsEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null && "3".equals(CcsEntrustConfirmDialog.this.getPriceTypeLimitedStg().getRaw())) {
                        text = "";
                    }
                    this.setText(String.valueOf(CcsEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null ? CcsEntrustConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 0) {
                    this.setText(CcsEntrustConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + CcsEntrustConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    String text = StringUtils.toStr((double)value.doubleValue(), (int)CcsEntrustConfirmDialog.this.getRefScale());
                    this.setText(text);
                }
            } else if (item.getOrderType() == 49) {
                if (CcsEntrustConfirmDialog.this.isExecution) {
                    this.setText(CcsEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + CcsEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.setText(CcsEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + CcsEntrustConfirmDialog.this.getPriceStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                }
            } else if (item.getSecType().equals("SBFWD") || CcsEntrustConfirmDialog.this.refItem.getType().equals("FORWARD")) {
                String text = StringUtils.toStr((double)value.doubleValue(), (int)3);
                this.setText(text);
            } else if (BsDict.HKUSA_MARKET.contains(item.getMarket())) {
                String text = StringUtils.toStr((double)value.doubleValue(), (int)3);
                this.setText(text);
            } else {
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                String text = StringUtils.toStr((double)value.doubleValue(), (int)CcsEntrustConfirmDialog.this.getRefScale());
                this.setText(text);
            }
        }
    }

    private class SideCell
    extends TableCell<CcsSingleEntrust, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = MxNodeFactory.create((String)"side", (String)"");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            if (CcsEntrustConfirmDialog.this.isInstruction) {
                if (49 == side || 201 == side) {
                    this.label.setText(CcsEntrustConfirmDialog.this.buySymbol);
                } else if (50 == side) {
                    this.label.setText(CcsEntrustConfirmDialog.this.sellSymbol);
                } else if ("3".equals(CcsEntrustConfirmDialog.this.instructionPanelType)) {
                    this.label.setText(CcsEntrustConfirmDialog.this.approveSymbol);
                } else {
                    this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
                }
            } else {
                this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
            }
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<CcsSingleEntrust, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

