/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.TransferFundAccount;
import cms.tmx.entity.notice.OpStatusReport;
import cms.tmx.entity.notice.TransferFundReport;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.SyncFundAccntServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatchTransferPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BatchTransferPart.class);
    @FXML
    protected TableView<TransferFundAccount> tableAccount;
    @FXML
    protected TableColumn<TransferFundAccount, Boolean> selected;
    @FXML
    private TableColumn<TransferFundAccount, String> colAcc;
    @FXML
    private TableColumn<TransferFundAccount, String> colReason;
    @FXML
    private TableColumn<TransferFundAccount, ComboBox<TradeCounter>> colOutCounterOut;
    @FXML
    private TableColumn<TransferFundAccount, ComboBox<TradeCounter>> colOutCounterIn;
    @FXML
    private TableColumn<TransferFundAccount, Number> colFundAllOut;
    @FXML
    private TableColumn<TransferFundAccount, Number> colFundOut;
    @FXML
    private TableColumn<TransferFundAccount, ComboBox<TradeCounter>> colInCounterIn;
    @FXML
    private TableColumn<TransferFundAccount, ComboBox<TradeCounter>> colInCounterOut;
    @FXML
    private TableColumn<TransferFundAccount, Number> colFundAllIn;
    @FXML
    private TableColumn<TransferFundAccount, Number> colFundIn;
    @Inject
    private IFundAccountService fundService;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    protected MxList<TransferFundAccount> mxList = new MxList();
    protected CheckBox checkBox = new CheckBox();
    @Inject
    protected MEventService es;
    @Inject
    private TradeCounterServiceImpl tradeCSImp;
    @Inject
    private FundAccountMngServiceImpl fundAccountMng;
    @Inject
    private ITransferFundApi transApi;
    @Inject
    private SyncFundAccntServiceImpl syncFundAccntImpl;
    @Inject
    private MxAlert mAlert;
    private ToggleGroup group = new ToggleGroup();
    @FXML
    protected RadioButton outRadio;
    @FXML
    protected RadioButton inRadio;
    private MxNode nodeStatus;
    private Map<Integer, TransferFundAccount> availId = new HashMap<Integer, TransferFundAccount>();
    private Map<Integer, TransferFundAccount> fundId = new HashMap<Integer, TransferFundAccount>();
    public Map<Integer, Boolean> transferMark = new HashMap<Integer, Boolean>();
    public Map<Integer, Boolean> fundMark = new HashMap<Integer, Boolean>();
    DecimalFormat fm = new DecimalFormat("0.00");
    private int timeGet = 500;
    private int timeOut = 2500;
    private int timeAgainQuery = 4000;
    int operationType;
    boolean fundFlag = false;
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    protected InvalidationListener lstFund = ob -> this.mxList.getList().forEach(each -> {
        FundAccount acc = this.fundAccountMng.getFundAccount(each.getExtAccntId(), "CCS");
        if (acc == null) {
            return;
        }
        each.update((Object)acc);
        each.setFundOutAll(each.getAvailable());
    });
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
        }
    };

    @FXML
    public void initialize() {
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.queryTradeCounter();
        this.initAcc();
        this.requery();
        this.createTableView();
        this.listener();
        this.outRadio.setToggleGroup(this.group);
        this.inRadio.setToggleGroup(this.group);
        this.outRadio.selectedProperty().addListener((ob, old, now) -> this.onTransChange((Boolean)old, (Boolean)now));
        this.outRadio.setSelected(true);
    }

    protected void onTransChange(Boolean old, Boolean now) {
        this.mxList.getList().forEach(acc -> acc.setReason(""));
        this.checkCol(this.tableAccount, now);
        this.layout();
    }

    @FXML
    public void fastFill() {
        if (this.outRadio.isSelected()) {
            this.mxList.getList().forEach(acc -> acc.setFundOut(acc.getFundOutAll()));
        } else {
            this.mxList.getList().forEach(acc -> acc.setFundIn(acc.getJzAvailable()));
        }
    }

    @FXML
    public void transfer() {
        try {
            if (this.outRadio.isSelected()) {
                this.fundOut();
            } else {
                this.fundIn();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <E> void checkCol(TableView<E> tableBase, boolean out) {
        ObservableList columns = tableBase.getColumns();
        if (out) {
            if (columns.contains(this.colInCounterIn)) {
                columns.remove(this.colInCounterIn);
            }
            if (columns.contains(this.colInCounterOut)) {
                columns.remove(this.colInCounterOut);
            }
            if (columns.contains(this.colFundAllIn)) {
                columns.remove(this.colFundAllIn);
            }
            if (columns.contains(this.colFundIn)) {
                columns.remove(this.colFundIn);
            }
            if (columns.contains(this.colReason)) {
                columns.remove(this.colReason);
            }
            if (!columns.contains(this.colOutCounterOut)) {
                columns.add(this.colOutCounterOut);
            }
            if (!columns.contains(this.colOutCounterIn)) {
                columns.add(this.colOutCounterIn);
            }
            if (!columns.contains(this.colFundAllOut)) {
                columns.add(this.colFundAllOut);
            }
            if (!columns.contains(this.colFundOut)) {
                columns.add(this.colFundOut);
            }
            if (!columns.contains(this.colReason)) {
                columns.add(this.colReason);
            }
        } else {
            if (columns.contains(this.colOutCounterOut)) {
                columns.remove(this.colOutCounterOut);
            }
            if (columns.contains(this.colOutCounterIn)) {
                columns.remove(this.colOutCounterIn);
            }
            if (columns.contains(this.colFundAllOut)) {
                columns.remove(this.colFundAllOut);
            }
            if (columns.contains(this.colFundOut)) {
                columns.remove(this.colFundOut);
            }
            if (columns.contains(this.colReason)) {
                columns.remove(this.colReason);
            }
            if (!columns.contains(this.colInCounterIn)) {
                columns.add(this.colInCounterIn);
            }
            if (!columns.contains(this.colInCounterOut)) {
                columns.add(this.colInCounterOut);
            }
            if (!columns.contains(this.colFundAllIn)) {
                columns.add(this.colFundAllIn);
            }
            if (!columns.contains(this.colFundIn)) {
                columns.add(this.colFundIn);
            }
            if (!columns.contains(this.colReason)) {
                columns.add(this.colReason);
            }
        }
    }

    public void queryTradeCounter() {
        try {
            this.tradeCSImp.getTradeCounterList();
        }
        catch (MException e) {
            logger.error("queryTradeCounter error", (Throwable)e);
        }
    }

    private synchronized void onPush(MEvent event) {
        Object obj = event.getObj();
        String type = event.getStr("push_type");
        String reason = "";
        if ("407".equals(type)) {
            TransferFundReport report = (TransferFundReport)TransferFundReport.class.cast(obj);
            int status = report.getReport().getStatus();
            reason = report.getReport().getErrorInfo();
            if (this.availId.containsKey(report.getReport().getSeq()) && status == 1) {
                double pushAvailable;
                this.availId.get(report.getReport().getSeq()).setJzAvailable((pushAvailable = report.getReport().getAvailable()) >= 0.0 ? pushAvailable : 0.0);
                logger.info("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u5165\u8d44\u91d1:" + pushAvailable);
            } else {
                logger.error("get fund faild->  status:" + status + " reason:" + reason);
                if (this.availId.containsKey(report.getReport().getSeq())) {
                    this.availId.get(report.getReport().getSeq()).setPush(reason);
                    this.availId.get(report.getReport().getSeq()).setJzAvailable(0.0);
                }
                logger.error("\u83b7\u53d6\u63a8\u9001\u53ef\u8f6c\u5165\u8d44\u91d1\u5931\u8d25:" + reason);
            }
            return;
        }
        if (!"403".equals(type) && !"404".equals(type)) {
            return;
        }
        OpStatusReport report = (OpStatusReport)OpStatusReport.class.cast(obj);
        this.fundFlag = false;
        for (Integer fundAccId : this.fundId.keySet()) {
            this.fundFlag = String.valueOf(fundAccId).equals(report.getReport().getData());
            if (this.fundFlag) break;
        }
        if (!this.fundFlag) {
            return;
        }
        int status = report.getReport().getStatus();
        reason = report.getReport().getReason();
        this.fundId.get(Integer.parseInt(report.getReport().getData())).setPush(reason);
        if (status == 1) {
            this.fundMark.put(Integer.parseInt(report.getReport().getData()), true);
            logger.info("transfer success->  status:" + status + " reason:" + reason);
        } else {
            this.fundMark.put(Integer.parseInt(report.getReport().getData()), false);
            logger.error("transfer faild->  status:" + status + " reason:" + reason);
        }
        this.transferMark.put(Integer.parseInt(report.getReport().getData()), true);
    }

    private List<Integer> getDiffNO(int n) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Random random = new Random();
        int num = 0;
        int i = 0;
        while (i < n) {
            while (list.contains(num = random.nextInt(999999999))) {
            }
            list.add(num);
            ++i;
        }
        return list;
    }

    private void initAcc() {
        ObservableList listFund = this.fundAccountMng.getCcsTransferFundAccountList();
        List collect = listFund.stream().distinct().collect(Collectors.toList());
        ArrayList<TransferFundAccount> list = new ArrayList<TransferFundAccount>();
        List<Integer> no = this.getDiffNO(collect.size());
        this.nodeStatus = MxNodeFactory.create((String)"accnt_status", (String)"1");
        int i = 0;
        while (i < collect.size()) {
            TransferFundAccount trans = new TransferFundAccount();
            trans.setStatus(this.nodeStatus.clone());
            trans.update(collect.get(i));
            trans.setAvailId(no.get(i));
            trans.setFundId(no.get(i));
            list.add(trans);
            ++i;
        }
        this.mxList.updatePart(list);
        this.tableAccount.refresh();
    }

    public void requery() {
        ObservableList checkItems = this.mxList.getList();
        if (checkItems.size() == 0) {
            return;
        }
        checkItems.forEach(acct -> {
            if (acct == null) {
                return;
            }
            this.initValues((TransferFundAccount)acct);
            this.fundRequery((TransferFundAccount)acct);
            TimerTask task = new TimerTask((TransferFundAccount)acct){
                private final /* synthetic */ TransferFundAccount val$acct;
                {
                    this.val$acct = transferFundAccount;
                }

                @Override
                public void run() {
                    if (this.val$acct != null) {
                        this.val$acct.setFundOutAll(this.val$acct.getAvailable());
                    }
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeGet);
        });
    }

    public void initValues(TransferFundAccount accnt) {
        accnt.setFundOutAll(accnt.getAvailable());
        if (!accnt.getCounterId().isEmpty()) {
            ObservableList listCounter = this.tradeCSImp.getTradeCounterIdList(accnt.getCounterId());
            accnt.setListCounter(listCounter);
        }
        this.getJzAvailable(accnt);
    }

    private void fundRequery(final TransferFundAccount acct) {
        this.doSyncRequest(acct.getInvestId(), acct.getMarketGrp());
        this.doSyncAccount(acct);
        if (acct != null && !acct.getCounterId().isEmpty()) {
            ObservableList listCounter = this.tradeCSImp.getTradeCounterIdList(acct.getCounterId());
            acct.setListCounter(listCounter);
            acct.setFundOutAll(acct.getAvailable());
            this.getJzAvailable(acct);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (acct != null) {
                    acct.setFundOutAll(acct.getAvailable());
                }
                BatchTransferPart.this.againFundRequery(acct);
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeAgainQuery);
    }

    private void againFundRequery(TransferFundAccount acct) {
        this.doSyncRequest(acct.getInvestId(), acct.getMarketGrp());
        this.doSyncAccount(acct);
        acct.setFundOutAll(acct.getAvailable());
    }

    public void getJzAvailable(TransferFundAccount item) {
        try {
            this.availId.put(item.getAvailId(), item);
            this.transApi.getTransferFund(item.getMarketGrp(), item.getInvestId(), item.getCurrencyId(), item.getAvailId().intValue());
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u53ef\u8f6c\u5165\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean checkFund(List<TransferFundAccount> filterList) {
        if (filterList.size() > 0) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e\u96f6");
            return false;
        }
        return true;
    }

    public boolean fundIn() throws Exception {
        FilteredList transList = this.mxList.getList().filtered(each -> each.isSelected());
        if (!this.alert.check(!transList.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return false;
        }
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u5165\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            FilteredList filterList = this.mxList.getList().filtered(each -> each.isSelected() && each.getFundIn() == 0.0);
            if (!this.checkFund((List<TransferFundAccount>)filterList)) {
                return false;
            }
            this.operationType = 0;
            this.exe.execute(() -> this.lambda$10((List)transList));
            this.requery();
        }
        return false;
    }

    public boolean fundOut() throws Exception {
        FilteredList transList = this.mxList.getList().filtered(each -> each.isSelected());
        if (!this.alert.check(!transList.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return false;
        }
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8d44\u91d1\u8f6c\u51fa\uff1f", "\u786e\u8ba4", "\u53d6\u6d88")) {
            FilteredList filterList = this.mxList.getList().filtered(each -> each.isSelected() && each.getFundOut() == 0.0);
            if (!this.checkFund((List<TransferFundAccount>)filterList)) {
                return false;
            }
            this.operationType = 0;
            transList.forEach(acc -> {
                this.exe.execute(() -> {
                    try {
                        this.fundId.put(acc.getFundId(), (TransferFundAccount)acc);
                        this.transApi.TransferFund(acc.getMarketGrp(), acc.getInvestId(), acc.getCurrencyId(), -acc.getFundOut(), acc.getFundId().intValue(), this.operationType);
                    }
                    catch (MException | Exception e) {
                        logger.error("\u8d44\u91d1\u8f6c\u51fa\u5f02\u5e38", e);
                    }
                });
                acc.setReason("\u8d44\u91d1\u6b63\u5728\u8f6c\u51fa...");
                TimerTask task = new TimerTask((TransferFundAccount)acc){
                    private final /* synthetic */ TransferFundAccount val$acc;
                    {
                        this.val$acc = transferFundAccount;
                    }

                    @Override
                    public void run() {
                        if (BatchTransferPart.this.transferMark.get(this.val$acc.getFundId()) != null && BatchTransferPart.this.transferMark.get(this.val$acc.getFundId()).booleanValue()) {
                            if (BatchTransferPart.this.fundMark.get(this.val$acc.getFundId()) != null && BatchTransferPart.this.fundMark.get(this.val$acc.getFundId()).booleanValue()) {
                                this.val$acc.setReason("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\u3002");
                                logger.info("\u8d44\u91d1\u8f6c\u51fa\u6210\u529f\uff0c\u91d1\u989d:" + this.val$acc.getFundOut());
                            } else {
                                this.val$acc.setReason("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + this.val$acc.getPush());
                                logger.info("\u8d44\u91d1\u8f6c\u51fa\u5931\u8d25:" + this.val$acc.getReason());
                            }
                        } else {
                            this.val$acc.setReason("\u5212\u8f6c\u8d85\u65f6\u3002");
                        }
                        this.val$acc.setFundOut(0.0);
                    }
                };
                Timer t = new Timer();
                t.schedule(task, this.timeOut);
            });
            this.requery();
        }
        return false;
    }

    private void doSyncRequest(String investorId, String marketGrp) {
        try {
            this.transApi.getTransferResult(investorId, marketGrp);
        }
        catch (MException e) {
            logger.error("\u5f3a\u5236\u67e5\u8be2\u5212\u8f6c\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void doSyncAccount(TransferFundAccount acc) {
        try {
            double accountAvailable = this.syncFundAccntImpl.syncAccount(acc.getBrokerId(), acc.getInvestId(), "", acc.getMarketGrp());
            acc.setFundOutAll(accountAvailable);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u67dc\u53f0\u53ef\u8f6c\u51fa\u8d44\u91d1\u5f02\u5e38", (Throwable)e);
        }
    }

    protected void listener() {
        this.fundAccountMng.changedProperty().addListener(this.lstFund);
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
    }

    @PreDestroy
    protected void close() {
        this.fundAccountMng.changedProperty().removeListener(this.lstFund);
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
    }

    protected void createTableView() {
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.colAcc.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).investIdProperty());
        this.colReason.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).reasonProperty());
        this.colFundAllOut.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).fundOutAllProperty());
        this.colFundAllOut.setCellFactory(column -> new DoubleTableCell());
        this.colFundOut.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).fundOutProperty());
        this.colFundOut.setCellFactory(p -> new PriceCell());
        this.colFundAllIn.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).jzAvailableProperty());
        this.colFundAllIn.setCellFactory(column -> new DoubleTableCell());
        this.colFundIn.setCellValueFactory(data -> ((TransferFundAccount)data.getValue()).fundInProperty());
        this.colFundIn.setCellFactory(p -> new PriceCell());
        this.colOutCounterIn.setCellValueFactory(data -> this.setJzCombobox((TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>>)data));
        this.colInCounterOut.setCellValueFactory(data -> this.setJzCombobox((TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>>)data));
        this.colOutCounterOut.setCellValueFactory(data -> this.setTransCombobox((TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>>)data));
        this.colInCounterIn.setCellValueFactory(data -> this.setTransCombobox((TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>>)data));
        this.tableAccount.setItems(this.mxList.getList());
        this.tableAccount.setPlaceholder((Node)new Label());
        this.tableAccount.setEditable(true);
        TableUtils.orgnizeClmWidth(this.tableAccount);
    }

    private ReadOnlyObjectWrapper<ComboBox<TradeCounter>> setJzCombobox(TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>> data) {
        ComboBox cmbBs = new ComboBox();
        cmbBs.setDisable(true);
        cmbBs.setPromptText("\u96c6\u4e2d\u4ea4\u6613\u67dc\u53f0");
        cmbBs.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                cmbBs.hide();
            }
        });
        return new ReadOnlyObjectWrapper((Object)cmbBs);
    }

    private ReadOnlyObjectWrapper<ComboBox<TradeCounter>> setTransCombobox(TableColumn.CellDataFeatures<TransferFundAccount, ComboBox<TradeCounter>> data) {
        ComboBox cmbBs = new ComboBox();
        cmbBs.setPrefWidth(150.0);
        TransferFundAccount acc = (TransferFundAccount)data.getValue();
        cmbBs.setItems(acc.getListCounter());
        cmbBs.getSelectionModel().select(0);
        cmbBs.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                cmbBs.hide();
            }
        });
        return new ReadOnlyObjectWrapper((Object)cmbBs);
    }

    private /* synthetic */ void lambda$10(List list) {
        list.forEach(acc -> {
            try {
                this.fundId.put(acc.getFundId(), (TransferFundAccount)acc);
                this.transApi.TransferFund(acc.getMarketGrp(), acc.getInvestId(), acc.getCurrencyId(), acc.getFundIn(), acc.getFundId().intValue(), this.operationType);
            }
            catch (MException | Exception e) {
                logger.error("\u8d44\u91d1\u8f6c\u5165\u5f02\u5e38", e);
            }
            acc.setReason("\u8d44\u91d1\u6b63\u5728\u8f6c\u5165...");
            TimerTask task = new TimerTask((TransferFundAccount)acc){
                private final /* synthetic */ TransferFundAccount val$acc;
                {
                    this.val$acc = transferFundAccount;
                }

                @Override
                public void run() {
                    if (BatchTransferPart.this.transferMark.get(this.val$acc.getFundId()) != null && BatchTransferPart.this.transferMark.get(this.val$acc.getFundId()).booleanValue()) {
                        if (BatchTransferPart.this.fundMark.get(this.val$acc.getFundId()) != null && BatchTransferPart.this.fundMark.get(this.val$acc.getFundId()).booleanValue()) {
                            this.val$acc.setReason("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\u3002");
                            logger.info("\u8d44\u91d1\u8f6c\u5165\u6210\u529f\uff0c\u91d1\u989d:" + this.val$acc.getFundIn());
                        } else {
                            this.val$acc.setReason("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + this.val$acc.getPush());
                            logger.info("\u8d44\u91d1\u8f6c\u5165\u5931\u8d25:" + this.val$acc.getReason());
                        }
                    } else {
                        this.val$acc.setReason("\u5212\u8f6c\u8d85\u65f6\u3002");
                    }
                    this.val$acc.setFundIn(0.0);
                }
            };
            Timer t = new Timer();
            t.schedule(task, this.timeOut);
        });
    }

    private class PriceCell
    extends EditTableCell<TransferFundAccount> {
        int scale = 2;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null || item.doubleValue() < 0.0) {
                    return;
                }
                this.setNum(this.scale);
                this.setFormat("%1$,." + this.scale + "f");
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }

        public void startEdit() {
            super.startEdit();
            try {
                if (super.getTextField() != null) {
                    super.getTextField().textProperty().addListener((ob, old, now) -> {
                        if (!"".equals(now) && !StringUtils.isDouble((String)now, (int)this.scale)) {
                            ((StringProperty)ob).setValue(old);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

