/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.Bank;
import cms.tmx.entity.trade.BankQueryParam;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.trade.models.BankStockTransferModel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BankStockTransferQueryBasic
extends MxTabContent {
    private static final Logger logger = LogManager.getLogger(BankStockTransferQueryBasic.class);
    private static final String FORMAT = "yyyy-MM-dd";
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MxAlert alert;
    @FXML
    private ComboBox<Bank> cmbBank;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private Button btnQuery;
    @FXML
    private TableView<BankQueryParam> tableTransferRecord;
    @FXML
    private TableColumn<BankQueryParam, String> colTransferDate;
    @FXML
    private TableColumn<BankQueryParam, String> colTransferTime;
    @FXML
    private TableColumn<BankQueryParam, Number> colAmount;
    @FXML
    private TableColumn<BankQueryParam, String> colTransferType;
    @FXML
    private TableColumn<BankQueryParam, String> colTransferSeq;
    @FXML
    private TableColumn<BankQueryParam, String> colTransferStatus;
    @FXML
    private TableColumn<BankQueryParam, String> colSummary;
    @Inject
    private BankStockTransferModel model;
    private ObservableList<Bank> listBank = FxUtils.newList();
    private ObservableList<BankQueryParam> listRecord = FxUtils.newList();
    private ObservableList<BankQueryParam> listNowRecord = FxUtils.newList();
    private Map<String, String> reactMap = new HashMap<String, String>();
    private int seqBank = 0;
    private int seqRecord = 0;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> Collections.sort(this.model.getListAllRecord(), (o1, o2) -> o1.getTransferDate().compareTo(o2.getTransferDate())));
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem recordExcel;

    @FXML
    public void initialize() {
        this.initValue();
    }

    private void initValue() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.setDate();
        this.listBank.addListener(ob -> this.cmbBank.getSelectionModel().select(0));
        ObservableList listCssFund = this.fundMng.getCcsFocusAccountList();
        this.queryBankList((ObservableList<FundAccount>)listCssFund);
        this.cmbBank.setItems(this.listBank);
        this.createTable();
        this.query();
    }

    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now();
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
    }

    private void queryBankList(ObservableList<FundAccount> listCssFund) {
        this.listBank.clear();
        listCssFund.forEach(fund -> {
            this.seqBank = new Random().nextInt(999999999);
            try {
                this.model.queryBanks(this.seqBank, this.listBank, (FundAccount)fund, true);
            }
            catch (MException e) {
                logger.error("get bank list faild", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "get bank list faild");
            }
        });
    }

    @FXML
    public void query() {
        this.listRecord.clear();
        this.listNowRecord.clear();
        this.model.getListAllRecord().clear();
        Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
        if (bank != null) {
            Date dt;
            String nowDate;
            this.seqRecord = new Random().nextInt(999999999);
            String begDate = ((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", "");
            String endDate = ((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", "");
            if (endDate.equals(nowDate = this.sdf.format(dt = new Date()).replaceAll("-", "")) && begDate.equals(nowDate)) {
                try {
                    this.model.getTransferBankAccountFundRecord(bank, this.seqRecord, this.listRecord, nowDate, nowDate);
                }
                catch (MException | Exception e) {
                    logger.error("get transfer record faild", e);
                    this.alert.alert(Alert.AlertType.ERROR, "get transfer record faild");
                }
            } else if (endDate.equals(nowDate)) {
                try {
                    this.seqRecord = new Random().nextInt(999999999);
                    String lastDate = this.sdf.format(BankStockTransferQueryBasic.getLastDay(dt)).replaceAll("-", "");
                    this.model.getTransferBankAccountFundRecord(bank, this.seqRecord, this.listRecord, begDate, lastDate);
                    this.model.getTransferBankAccountFundRecord(bank, this.seqRecord, this.listNowRecord, nowDate, nowDate);
                }
                catch (MException | Exception e) {
                    logger.error("get transfer record faild", e);
                    this.alert.alert(Alert.AlertType.ERROR, "get transfer record faild");
                }
            } else {
                try {
                    this.model.getTransferBankAccountFundRecord(bank, this.seqRecord, this.listRecord, begDate, endDate);
                }
                catch (MException | Exception e) {
                    logger.error("get transfer record faild", e);
                    this.alert.alert(Alert.AlertType.ERROR, "get transfer record faild");
                }
            }
        }
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableTransferRecord);
        this.colTransferDate.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).transferDateProperty());
        this.reactMap.put(this.colTransferDate.getId(), "TransferDate");
        this.colTransferTime.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).transferTimeProperty());
        this.reactMap.put(this.colTransferTime.getId(), "TransferTime");
        this.colAmount.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).amountProperty());
        this.reactMap.put(this.colAmount.getId(), "Amount");
        this.colTransferType.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).transferTypeProperty());
        this.reactMap.put(this.colTransferType.getId(), "TransferType");
        this.colTransferSeq.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).transferSeqProperty());
        this.reactMap.put(this.colTransferSeq.getId(), "TransferSeq");
        this.colTransferStatus.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).transferStatusProperty());
        this.reactMap.put(this.colTransferStatus.getId(), "TransferStatus");
        this.colSummary.setCellValueFactory(data -> ((BankQueryParam)data.getValue()).summaryProperty());
        this.reactMap.put(this.colSummary.getId(), "Summary");
        this.tableTransferRecord.setItems(this.model.getListAllRecord());
        this.tableTransferRecord.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableTransferRecord);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithTwoHead(this.tableTransferRecord, (int)0, (int)0);
    }

    @FXML
    private void refresh() {
        this.query();
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u94f6\u884c\u8f6c\u8d26\u8bb0\u5f55");
            if (file == null) {
                return;
            }
            this.exe.execute(() -> {
                this.recordExcel.setDisable(true);
                try {
                    ExcelUtils.writeHisTwoHeadExcel(this.tableTransferRecord, this.model.getListAllRecord(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.recordExcel.setDisable(false));
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                    Platform.runLater(() -> {
                        this.recordExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private static Date getLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }
}

