/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.Bank;
import cms.tmx.entity.trade.BankTransferRecord;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.trade.models.BankStockTransferModel;
import cms.tmx.utils.NumToCN;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.Random;
import java.util.function.UnaryOperator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BankStockTransferOutBasic
extends MxTabContent {
    private static final Logger logger = LogManager.getLogger(BankStockTransferOutBasic.class);
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<Bank> cmbBank;
    @FXML
    private Label lbBalance;
    @FXML
    private Button btnQuery;
    @FXML
    private TextField txtMoney;
    @FXML
    private Label lbChinese;
    @FXML
    private PasswordField pfPwd;
    @FXML
    private PasswordField bankPwd;
    @FXML
    private Button btnTransfer;
    @FXML
    private Label lbBankErr;
    @FXML
    private Label lbMoneyErr;
    @FXML
    private Label lbPwdErr;
    @FXML
    private Label lbBankPwdErr;
    @FXML
    private Label lbBankPwd;
    @Inject
    private BankStockTransferModel model;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    private BankTransferRecord transRecord = new BankTransferRecord();
    private ObservableList<Bank> listBank = FxUtils.newList();
    private int seqBank = 0;
    private static final String BALANCE_PWD_FLAG = "0123";
    private static final String TRANSFER_OUT_PWD_FLAG = "2367";
    private String bankPwdFlag = "";
    public boolean transferMark = false;
    public boolean fundMark = false;
    private BooleanProperty status = new SimpleBooleanProperty(false);
    private SimpleStringProperty transferOutResult = new SimpleStringProperty("");
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10000.0), e -> {
        this.transferOutResult.set("\u8bf7\u6c42\u6682\u65e0\u5e94\u7b54\uff0c\u8bf7\u5728\u8f6c\u8d26\u67e5\u8be2\u4e2d\u786e\u8ba4\u7ed3\u679c");
        this.status.set(false);
    }, new KeyValue[0])});
    private InvalidationListener lstBank = ob -> Platform.runLater(() -> this.cmbBank.getSelectionModel().select(0));
    private InvalidationListener lstTransfer = ob -> Platform.runLater(() -> {
        this.transferOutResult.set(this.transRecord.getStatus() == 1 ? "\u8f6c\u8d26\u6210\u529f\uff01" : this.transRecord.getErrorInfo());
        this.timeline.stop();
        this.status.set(false);
    });

    @FXML
    public void initialize() {
        this.transRecord.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstTransfer));
        this.model.changedBankProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstBank));
        this.initValue();
        this.addCheck();
    }

    private void initValue() {
        ObservableList listCcs = FxUtils.newList();
        ObservableList listAll = this.fundMng.getCcsFocusAccountList();
        if (!listAll.isEmpty()) {
            listAll.forEach(fund -> {
                if ("99999-01-01".equals(fund.getCounterId())) {
                    listCcs.add(fund);
                }
            });
        }
        this.cmbFund.setItems(listCcs);
        this.cmbBank.setItems(this.listBank);
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.queryBankList((FundAccount)now));
        this.cmbFund.getSelectionModel().select(0);
        this.cmbBank.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
                this.bankPwdFlag = bank.getPasswordFlag().getRaw();
                if (!TRANSFER_OUT_PWD_FLAG.contains(this.bankPwdFlag)) {
                    this.bankPwd.clear();
                    this.bankPwd.setDisable(true);
                    this.lbBankPwd.setVisible(false);
                    this.bankPwd.setVisible(false);
                } else {
                    this.bankPwd.setDisable(false);
                    this.lbBankPwd.setVisible(true);
                    this.bankPwd.setVisible(true);
                }
            }
        });
        this.cmbBank.getSelectionModel().select(0);
        this.btnQuery.setVisible(false);
        this.txtMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.txtMoney.textProperty().addListener((ob, old, now) -> {
            if (now.isEmpty()) {
                this.lbChinese.setText("");
                return;
            }
            BigDecimal numberOfMoney = new BigDecimal(StringUtils.parseDouble((String)now));
            String cn = NumToCN.number2CNMontrayUnit((BigDecimal)numberOfMoney);
            this.lbChinese.setText(cn);
        });
        this.btnTransfer.setOnAction(event -> this.transfer());
        this.pfPwd.setTextFormatter((TextFormatter)new MxFormatter(10));
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbBankErr, (ObservableBooleanValue)this.cmbBank.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbMoneyErr, (ObservableBooleanValue)this.txtMoney.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)this.pfPwd.textProperty().isNotEmpty());
    }

    private void queryBankList(FundAccount now) {
        MxBindings.bindSD((Property)this.lbBalance.textProperty(), (ObservableNumberValue)now.withdrawQuotaProperty(), (int)2);
        try {
            FundAccount fund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
            this.seqBank = new Random().nextInt(999999999);
            this.listBank.clear();
            this.model.queryBanks(this.seqBank, this.listBank, fund, false);
        }
        catch (MException e) {
            String faild = "query bank list faild";
            logger.error(faild, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(faild) + ":" + e.getMessage());
        }
    }

    private void transfer() {
        String info;
        if (!this.valid()) {
            return;
        }
        if (!this.bankPwd.isDisable() && this.bankPwd.getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u94f6\u884c\u5bc6\u7801\u3002");
            return;
        }
        Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
        this.bankPwdFlag = bank.getPasswordFlag().getRaw();
        if (TRANSFER_OUT_PWD_FLAG.contains(this.bankPwdFlag)) {
            bank.setBankPwd(this.bankPwd.getText());
        }
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, info = String.valueOf(bank.toString()) + "   \u8fdb\u884c\u8bc1\u5238\u8f6c\u94f6\u884c\uff0c\u8f6c\u51fa" + this.txtMoney.getText() + "\u5143")) {
            try {
                FundAccount fund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
                double amount = -StringUtils.parseDouble((String)this.txtMoney.getText());
                String pwd = this.pfPwd.getText();
                int seq = new Random().nextInt(999999999);
                this.transRecord.setSeq(seq);
                this.model.transferBankAccountFund(fund, bank, false, amount, pwd, this.transRecord);
                this.timeline.setCycleCount(1);
                this.timeline.setAutoReverse(false);
                this.timeline.play();
                this.status.set(true);
                this.transferOutResult.set("\u8d44\u91d1\u6b63\u5728\u8f6c\u51fa..");
                this.alert.alert(Alert.AlertType.INFORMATION, (StringProperty)this.transferOutResult, "\u63d0\u793a", this.status);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }
}

