/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.Bank;
import cms.tmx.entity.trade.BankTransferRecord;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.trade.models.BankStockTransferModel;
import cms.tmx.trade.views.BankPwdDialog;
import cms.tmx.utils.NumToCN;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.Random;
import java.util.function.UnaryOperator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BankStockTransferInBasic
extends MxTabContent {
    private static final Logger logger = LogManager.getLogger(BankStockTransferInBasic.class);
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<Bank> cmbBank;
    @FXML
    private Label lbBalance;
    @FXML
    private Button btnQuery;
    @FXML
    private TextField txtMoney;
    @FXML
    private Label lbChinese;
    @FXML
    private PasswordField pfPwd;
    @FXML
    private Button btnTransfer;
    @FXML
    private Label lbBankErr;
    @FXML
    private Label lbMoneyErr;
    @FXML
    private Label lbPwdErr;
    @FXML
    private Label lbBankPwd;
    @Inject
    private BankStockTransferModel model;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    private BankTransferRecord transRecord = new BankTransferRecord();
    private ObservableList<Bank> listBankIn = FxUtils.newList();
    private int seqBank = 0;
    private static final String BALANCE_PWD_FLAG = "0123";
    private static final String TRANSFER_IN_PWD_FLAG = "1357";
    private String bankPwdFlag = "";
    public boolean transferMark = false;
    public boolean fundMark = false;
    private BooleanProperty status = new SimpleBooleanProperty(false);
    private SimpleStringProperty transferResult = new SimpleStringProperty();
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10000.0), e -> {
        this.transferResult.set("\u8bf7\u6c42\u6682\u65e0\u5e94\u7b54\uff0c\u8bf7\u5728\u8f6c\u8d26\u67e5\u8be2\u4e2d\u786e\u8ba4\u7ed3\u679c");
        this.status.set(false);
    }, new KeyValue[0])});
    private InvalidationListener lstBank = ob -> Platform.runLater(() -> this.cmbBank.getSelectionModel().select(0));
    private InvalidationListener lstTransfer = ob -> Platform.runLater(() -> {
        this.transferResult.set(this.transRecord.getStatus() == 1 ? "\u8f6c\u8d26\u6210\u529f\uff01" : this.transRecord.getErrorInfo());
        this.timeline.stop();
        this.status.set(false);
    });

    @FXML
    public void initialize() {
        this.transRecord.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstTransfer));
        this.model.changedBankProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstBank));
        this.initValue();
        this.addCheck();
    }

    private void initValue() {
        ObservableList listCcs = FxUtils.newList();
        ObservableList listAll = this.fundMng.getCcsFocusAccountList();
        if (!listAll.isEmpty()) {
            listAll.forEach(fund -> {
                if ("99999-01-01".equals(fund.getCounterId())) {
                    listCcs.add(fund);
                }
            });
        }
        this.cmbFund.setItems(listCcs);
        this.cmbBank.setItems(this.listBankIn);
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener(ob -> this.queryBankList(this.listBankIn));
        this.cmbFund.getSelectionModel().select(0);
        this.cmbBank.getSelectionModel().select(0);
        this.btnQuery.setOnAction(event -> this.queryBankBalance());
        this.txtMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.txtMoney.textProperty().addListener((ob, old, now) -> {
            if (now.isEmpty()) {
                this.lbChinese.setText("");
                return;
            }
            BigDecimal numberOfMoney = new BigDecimal(StringUtils.parseDouble((String)now));
            String cn = NumToCN.number2CNMontrayUnit((BigDecimal)numberOfMoney);
            this.lbChinese.setText(cn);
        });
        this.btnTransfer.setOnAction(event -> this.transfer());
        this.pfPwd.setTextFormatter((TextFormatter)new MxFormatter(10));
        this.cmbBank.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
                this.bankPwdFlag = bank.getPasswordFlag().getRaw();
                if (!TRANSFER_IN_PWD_FLAG.contains(this.bankPwdFlag)) {
                    this.pfPwd.clear();
                    this.pfPwd.setDisable(true);
                    this.lbBankPwd.setVisible(false);
                    this.pfPwd.setVisible(false);
                } else {
                    this.pfPwd.setDisable(false);
                    this.lbBankPwd.setVisible(true);
                    this.pfPwd.setVisible(true);
                }
            }
        });
        this.cmbBank.getSelectionModel().select(0);
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbBankErr, (ObservableBooleanValue)this.cmbBank.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbMoneyErr, (ObservableBooleanValue)this.txtMoney.textProperty().isNotEmpty());
    }

    private void queryBankList(ObservableList<Bank> listBank) {
        try {
            FundAccount fund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
            this.seqBank = new Random().nextInt(999999999);
            listBank.clear();
            this.model.queryBanks(this.seqBank, listBank, fund, false);
        }
        catch (MException e) {
            String faild = "query bank list faild";
            logger.error(faild, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(faild) + ":" + e.getMessage());
        }
    }

    private void queryBankBalance() {
        BankPwdDialog pwd = (BankPwdDialog)((Object)this.of.create(BankPwdDialog.class));
        FundAccount fund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
        Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
        this.bankPwdFlag = bank.getPasswordFlag().getRaw();
        if (this.alert.check(bank != null, Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u94f6\u884c\uff01")) {
            pwd.setValue(fund, bank);
            if (BALANCE_PWD_FLAG.contains(this.bankPwdFlag)) {
                double amount = pwd.getBalanceRecord().getAmount();
                this.lbBalance.setText(StringUtils.toThousands((Number)amount, (int)2));
            } else {
                MxDialog dialog = this.df.create((DialogObj)pwd, "\u8bf7\u8f93\u5165\u94f6\u884c\u5361\u5bc6\u7801");
                Button btnOk = dialog.getButton(ButtonType.OK);
                pwd.setbtnOK(btnOk);
                if (dialog.launch() == ButtonType.OK) {
                    double amount = pwd.getBalanceRecord().getAmount();
                    this.lbBalance.setText(StringUtils.toThousands((Number)amount, (int)2));
                }
            }
        }
    }

    private void transfer() {
        if (!this.valid()) {
            return;
        }
        if (!this.pfPwd.isDisable() && this.pfPwd.getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u94f6\u884c\u5bc6\u7801\u3002");
            return;
        }
        Bank bank = (Bank)this.cmbBank.getSelectionModel().getSelectedItem();
        String info = String.valueOf(bank.toString()) + "   \u8fdb\u884c\u94f6\u884c\u8f6c\u8bc1\u5238\uff0c\u8f6c\u5165" + this.txtMoney.getText() + "\u5143";
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
            try {
                FundAccount fund = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
                double amount = StringUtils.parseDouble((String)this.txtMoney.getText());
                String pwd = this.pfPwd.getText();
                int seq = new Random().nextInt(999999999);
                this.transRecord.setSeq(seq);
                this.model.transferBankAccountFund(fund, bank, true, amount, pwd, this.transRecord);
                this.timeline.setCycleCount(1);
                this.timeline.setAutoReverse(false);
                this.timeline.play();
                this.status.set(true);
                this.transferResult.set("\u8d44\u91d1\u6b63\u5728\u8f6c\u5165..");
                this.alert.alert(Alert.AlertType.INFORMATION, (StringProperty)this.transferResult, "\u63d0\u793a", this.status);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }
}

