/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.Bank;
import cms.tmx.entity.trade.BankTransferRecord;
import cms.tmx.trade.models.BankStockTransferModel;
import java.util.Random;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BankPwdDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(BankPwdDialog.class);
    @FXML
    private PasswordField pfPwd;
    @FXML
    private Label lbPrompt;
    @FXML
    private Label lbPwdErr;
    @FXML
    private Label lbResp;
    @Inject
    private BankStockTransferModel model;
    private String prompt = "";
    private FundAccount fund;
    private Bank bank;
    private Button btnOk;
    private boolean isCanClose = false;
    private BankTransferRecord balanceRecord = new BankTransferRecord();
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10000.0), e -> this.faild("\u8d85\u65f6"), new KeyValue[0])});
    private InvalidationListener lstBalance = ob -> Platform.runLater(() -> {
        if (this.balanceRecord.getStatus() == 1) {
            this.btnOk.setDisable(false);
            this.isCanClose = true;
            this.btnOk.fire();
        } else {
            this.faild(this.balanceRecord.getErrorInfo());
            this.timeline.stop();
        }
    });

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.OK};
    }

    @FXML
    private void initialize() {
        this.balanceRecord.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstBalance));
        this.lbPrompt.setText(this.prompt);
        this.pfPwd.setTextFormatter((TextFormatter)new MxFormatter(10));
        this.lbResp.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbResp.setText("");
            }
        });
        this.addCheck();
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)this.pfPwd.textProperty().isNotEmpty());
    }

    public void setPrompt(String card4) {
        this.prompt = "\u8bf7\u8f93\u5165\u5c3e\u53f7\u4e3a\uff08" + card4 + "\uff09\u7684\u94f6\u884c\u5361\u5bc6\u7801\u8fdb\u884c\u67e5\u8be2";
    }

    public void setValue(FundAccount fund, Bank bank) {
        this.fund = fund;
        this.bank = bank;
        this.setPrompt(bank.getCardTail());
    }

    protected boolean isOK(ButtonType bt) {
        this.queryBankBalance();
        this.waitResult();
        this.btnOk.setDisable(true);
        return this.isCanClose;
    }

    private void waitResult() {
        this.lbResp.setText("\u7b49\u5f85\u7ed3\u679c\u4e2d...");
        this.timeline.setCycleCount(1);
        this.timeline.setAutoReverse(false);
        this.timeline.play();
    }

    private void faild(String info) {
        this.lbResp.requestFocus();
        this.lbResp.setText(info);
        this.btnOk.setDisable(false);
    }

    private void queryBankBalance() {
        try {
            String pwd = this.pfPwd.getText();
            int seq = new Random().nextInt(999999999);
            this.balanceRecord.setSeq(seq);
            this.model.queryBankBalance(this.fund, this.bank, pwd, this.balanceRecord);
        }
        catch (MException e) {
            logger.error("get bank list faild", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("get bank list faild", (Throwable)e);
        }
    }

    public void setbtnOK(Button btnOk) {
        this.btnOk = btnOk;
    }

    public BankTransferRecord getBalanceRecord() {
        return this.balanceRecord;
    }
}

