/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.utils;

import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public class TradeBindings
extends MxBindings {
    public static void bindBigNumToInt(StringProperty pText, ObservableNumberValue pNumber) {
        pText.unbind();
        StringBinding binding = Bindings.createStringBinding(() -> StringUtils.bigNumToString((int)((Number)pNumber.getValue()).intValue()), (Observable[])new Observable[]{pNumber});
        pText.bind((ObservableValue)binding);
    }

    public static void bindPerToInt(StringProperty pText, ObservableNumberValue pNumber) {
        pText.unbind();
        StringBinding binding = Bindings.createStringBinding(() -> String.format("1/%d", ((Number)pNumber.getValue()).intValue()), (Observable[])new Observable[]{pNumber});
        pText.bind((ObservableValue)binding);
    }

    public static void bindToDouble(StringProperty pText, ObservableNumberValue pNumber, int scale) {
        pText.unbind();
        StringBinding binding = Bindings.createStringBinding(() -> {
            String format = String.format("%%1$,.%df", scale);
            return String.format(format, ((Number)pNumber.getValue()).doubleValue());
        }, (Observable[])new Observable[]{pNumber});
        pText.bind((ObservableValue)binding);
    }

    public static void bindToMoney(StringProperty pText, ObservableNumberValue pNumber) {
        TradeBindings.bindToDouble(pText, pNumber, 2);
    }

    public static void bindBigNumToDouble(StringProperty pText, ObservableNumberValue pNumber) {
        pText.unbind();
        StringBinding binding = Bindings.createStringBinding(() -> StringUtils.bigDoubleNumToString((double)((Number)pNumber.getValue()).doubleValue()), (Observable[])new Observable[]{pNumber});
        pText.bind((ObservableValue)binding);
    }

    public static void priceBinding(Property<String> text, ObservableNumberValue value, ObservableNumberValue unit) {
        text.unbind();
        StringBinding sb = Bindings.createStringBinding(() -> String.format("%1$,." + DecimalUtils.getScale((double)unit.doubleValue()) + "f", value.doubleValue()), (Observable[])new Observable[]{value, unit});
        text.bind((ObservableValue)sb);
    }

    public static void ctpPriceBinding(Property<String> text, ObservableNumberValue value, ObservableNumberValue unit) {
        text.unbind();
        StringBinding sb = Bindings.createStringBinding(() -> String.format("%1$,." + unit.getValue() + "f", value.doubleValue()), (Observable[])new Observable[]{value, unit});
        text.bind((ObservableValue)sb);
    }
}

