/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.utils;

import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.utils.StringUtils;
import javafx.scene.control.TableCell;

public class ItemPriceCell
extends TableCell<BasketTradeItem, Number> {
    private int scale = 0;
    private boolean isPercent = false;

    public ItemPriceCell(int i, boolean isPercent) {
        this.scale = i;
        this.isPercent = isPercent;
    }

    public ItemPriceCell() {
    }

    public void updateItem(Number value, boolean empty) {
        if (empty || value.doubleValue() == 0.0) {
            this.setText(null);
            return;
        }
        BasketTradeItem item = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
        if (item == null) {
            this.setText(null);
            return;
        }
        double unit = item.getItem().getMktItem() != null ? item.getItem().getMktItem().getRefItem().getPriceUnit() : 2.0;
        String text = this.scale == 0 ? StringUtils.toPriceStr((double)value.doubleValue(), (double)unit) : StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
        this.setText(this.isPercent ? String.valueOf(text) + "%" : text);
    }
}

