/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.AvgQtyQueryParam;
import cms.tmx.entity.trade.DailyAvgQty;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.basket.BasketTrialCalAsset;
import cms.tmx.entity.trade.basket.BasketTrialCalQty;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.history.IDailyAvgQtyService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TrialCalculateModel
extends MxModel {
    @Inject
    private IDailyAvgQtyService avgQtyService;
    private MxList<BasketTradeItem> basketList = new MxList();
    private MxList<BasketTrialCalAsset> minAssetList = new MxList();
    private MxList<BasketTrialCalAsset> filteredMinAssetList = new MxList();
    private MxList<BasketTrialCalQty> minQtyList = new MxList();
    private double totalBuyAmount = 0.0;
    private double totalSellAmount = 0.0;
    private BooleanProperty isBuy = new SimpleBooleanProperty(false);
    private Predicate<BasketTrialCalAsset> pd = en -> {
        if (this.isBuy() && en.isBuy()) {
            return true;
        }
        return !this.isBuy() && !en.isBuy();
    };

    @PostConstruct
    public void init() {
    }

    public void create(List<BasketTradeItem> basketTradeItems) {
        this.basketList.getList().addAll(basketTradeItems);
        this.initResource();
        this.changed();
    }

    private void initResource() {
        this.basketList.getList().stream().forEach(each -> {
            if (!each.isSelected()) {
                return;
            }
            BasketTrialCalAsset calAsset = new BasketTrialCalAsset();
            calAsset.update(each);
            this.minAssetList.getList().add((Object)calAsset);
            BasketTrialCalQty calQty = new BasketTrialCalQty();
            calQty.update(each);
            this.minQtyList.getList().add((Object)calQty);
        });
    }

    public ObservableList<BasketTrialCalAsset> getCalAssetBySide() {
        this.filteredMinAssetList.clear();
        this.minAssetList.getList().stream().forEach(item -> {
            if (this.isBuy() == item.isBuy() && item.getWeight() > 0.0) {
                this.filteredMinAssetList.getList().add(item);
            }
        });
        return this.filteredMinAssetList.getList();
    }

    public void trialAsset() {
        BasketTrialCalAsset minCalAsset = null;
        double minScale = 0.0;
        ObservableList<BasketTrialCalAsset> filteredList = this.getCalAssetBySide();
        for (BasketTrialCalAsset item : filteredList) {
            double itemScale = item.isXshgBond() || item.isXsheBond() ? item.getWeight() * 10.0 / item.getNowPrice() : item.getWeight() / item.getNowPrice();
            if (minScale != 0.0 && !(minScale > itemScale)) continue;
            minScale = itemScale;
            minCalAsset = item;
        }
        if (minCalAsset == null) {
            return;
        }
        if (this.isBuy()) {
            this.totalBuyAmount = new BigDecimal(String.valueOf(minCalAsset.getNowPrice() * 100.0)).divide(new BigDecimal(String.valueOf(minCalAsset.getWeight() / 100.0)), 5, 2).doubleValue();
            if (minCalAsset.isXshgBond() || minCalAsset.isXsheBond()) {
                this.totalBuyAmount /= 10.0;
            }
            this.reCalQtyAndAmount(filteredList, this.totalBuyAmount);
        } else {
            this.totalSellAmount = new BigDecimal(String.valueOf(minCalAsset.getNowPrice() * 100.0)).divide(new BigDecimal(String.valueOf(minCalAsset.getWeight() / 100.0)), 2, 2).doubleValue();
            if (minCalAsset.isXshgBond() || minCalAsset.isXsheBond()) {
                this.totalBuyAmount /= 10.0;
            }
            this.reCalQtyAndAmount(filteredList, this.totalSellAmount);
        }
        this.changed();
    }

    private void reCalQtyAndAmount(ObservableList<BasketTrialCalAsset> filteredList, double amount) {
        filteredList.stream().forEach(item -> {
            if (item.getNowPrice() == 0.0) {
                return;
            }
            if (item.isXshgBond()) {
                item.setMinQty(new BigDecimal(String.valueOf(amount)).multiply(new BigDecimal(String.valueOf(item.getWeight() / 100.0))).divide(new BigDecimal(String.valueOf(item.getNowPrice() * 10.0)), 1).longValue());
                item.setOrdAmount(new BigDecimal(String.valueOf(item.getNowPrice())).multiply(new BigDecimal(String.valueOf(item.getMinQty() * 10L))).setScale(2, 4).doubleValue());
            } else if (item.isXsheBond()) {
                item.setMinQty(new BigDecimal(String.valueOf(amount)).multiply(new BigDecimal(String.valueOf(item.getWeight() / 100.0))).divide(new BigDecimal(String.valueOf(item.getNowPrice() * 10.0)), 1).longValue() * 10L);
                item.setOrdAmount(new BigDecimal(String.valueOf(item.getNowPrice())).multiply(new BigDecimal(String.valueOf(item.getMinQty()))).setScale(2, 4).doubleValue());
            } else {
                item.setMinQty(new BigDecimal(String.valueOf(amount)).multiply(new BigDecimal(String.valueOf(item.getWeight() / 100.0))).divide(new BigDecimal(String.valueOf(item.getNowPrice() * 100.0)), 1).longValue() * 100L);
                item.setOrdAmount(new BigDecimal(String.valueOf(item.getNowPrice())).multiply(new BigDecimal(String.valueOf(item.getMinQty()))).setScale(2, 4).doubleValue());
            }
        });
    }

    public Map<String, DailyAvgQty> trialQty(AvgQtyQueryParam avgParam) throws MException {
        return this.avgQtyService.query(avgParam);
    }

    public MxList<BasketTradeItem> getBasketList() {
        return this.basketList;
    }

    public void setBasketList(MxList<BasketTradeItem> basketList) {
        this.basketList = basketList;
    }

    public ObservableList<BasketTrialCalAsset> getMinAssetList() {
        return this.minAssetList.getList();
    }

    public void setMinAssetList(MxList<BasketTrialCalAsset> minAssetList) {
        this.minAssetList = minAssetList;
    }

    public ObservableList<BasketTrialCalQty> getMinQtyList() {
        return this.minQtyList.getList();
    }

    public void setMinQtyList(MxList<BasketTrialCalQty> minQtyList) {
        this.minQtyList = minQtyList;
    }

    public BooleanProperty buyProperty() {
        return this.isBuy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setIsBuy(boolean isBuy) {
        this.buyProperty().set(isBuy);
    }

    public double getTotalBuyAmount() {
        return this.totalBuyAmount;
    }

    public void setTotalBuyAmount(double totalBuyAmount) {
        this.totalBuyAmount = totalBuyAmount;
    }

    public double getTotalSellAmount() {
        return this.totalSellAmount;
    }

    public void setTotalSellAmount(double totalSellAmount) {
        this.totalSellAmount = totalSellAmount;
    }
}

