/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.factory.BasketTradeItemFactory;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IPostService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.trade.entrust.BatchEntrust;
import cms.tmx.trade.models.basket.BasketAccSetModel;
import cms.tmx.trade.models.basket.BasketGearPriceModel;
import cms.tmx.trade.models.basket.BasketInfo;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.MathUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketTradeModel
extends MxModel {
    @Inject
    private CcsAccountMap accMng;
    private static final Logger logger = LogManager.getLogger(BasketTradeModel.class);
    private ObservableList<CcsFundAccount> listAccount = FxUtils.newList();
    protected ObservableList<BasketTradeItem> listItem = FxUtils.newList();
    private Map<CcsFundAccount, ObservableList<BasketTradeItem>> mapItem = new HashMap<CcsFundAccount, ObservableList<BasketTradeItem>>(500);
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private BooleanProperty sell = new SimpleBooleanProperty(false);
    private BooleanProperty buySell = new SimpleBooleanProperty(false);
    protected ObjectProperty<MxNode> gear = new SimpleObjectProperty();
    private DoubleProperty floating = new SimpleDoubleProperty();
    protected ObjectProperty<MxNode> stg = new SimpleObjectProperty();
    private DoubleProperty countBsk = new SimpleDoubleProperty(1.0);
    private DoubleProperty countBskForAdgust = new SimpleDoubleProperty(0.0);
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty assetPct = new SimpleDoubleProperty();
    private DoubleProperty canBuyPct = new SimpleDoubleProperty();
    private DoubleProperty canSellPct = new SimpleDoubleProperty();
    private DoubleProperty amount = new SimpleDoubleProperty();
    private LongProperty totalQuantity = new SimpleLongProperty();
    private BooleanProperty pctUnit = new SimpleBooleanProperty(true);
    private IntegerProperty num = new SimpleIntegerProperty();
    private BooleanProperty filterUp = new SimpleBooleanProperty(false);
    private BooleanProperty filterDown = new SimpleBooleanProperty(false);
    private BooleanProperty smartSell = new SimpleBooleanProperty(false);
    private BooleanProperty useInventory = new SimpleBooleanProperty(false);
    private static final int REFRESH_MARKET_INTERVAL = 500;
    private static final int REFRESH_INTERVAL = 500;
    @Inject
    private CcsPositionModel ccsPosModel;
    @Inject
    private BasketAccSetModel basketAccSetModel;
    @Inject
    private BasketInfo bi;
    @Inject
    private MObjFactory of;
    @Inject
    private BasketGearPriceModel priceModel;
    @Inject
    private BatchEntrust batchEntrust;
    @Inject
    private MScheduler sdUpdate;
    @Inject
    private MScheduler sdUpdateMkt;
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    protected IFundAccountService fundAccMng;
    @Inject
    protected IPostService postMng;
    @Inject
    protected BasketTradeItemFactory bskTradeItemFactory;
    private InvalidationListener lstMkt = ob -> this.getSdUpdateMkt().schedule(event -> Platform.runLater(() -> {
        this.onFilterChange();
        for (BasketTradeItem item : this.getItems()) {
            if (!item.isSelected()) continue;
            this.calPrice(item);
        }
        if (!this.getStg().is("1")) {
            this.calCount();
        }
        this.calTotal();
        this.getBi().calInfo();
    }));
    private InvalidationListener lstPosition = ob -> {
        for (BasketTradeItem item : this.getItems().filtered(pd -> !pd.isPositionExisted())) {
            CcsPosition pos = null;
            Position position = this.getPostModel().getPositionInMap(item.getSecAcc(), item.getItem().getSecurityId());
            if (position instanceof CcsPosition) {
                pos = (CcsPosition)CcsPosition.class.cast(position);
            }
            if (pos == null) continue;
            item.canSellProperty().bind((ObservableValue)pos.canVolProperty());
            item.positionProperty().bind((ObservableValue)pos.totalVolProperty());
            item.setPositionExisted(true);
        }
        this.calSecs();
    };

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"basket_strategy_type", (String)"1");
        this.stgProperty().set((Object)node);
        node = MxNodeFactory.create((String)"bsk_handicap", (String)"-1");
        this.initPriceGear(node);
        this.gearProperty().set((Object)node);
        this.buyProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.sellProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.buySellProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.filterUpProperty().addListener(ob -> this.onFilterChange());
        this.filterDownProperty().addListener(ob -> this.onFilterChange());
        this.gearProperty().addListener(data -> this.onPriceChange());
        this.floatingProperty().addListener(data -> this.onPriceChange());
        this.pctUnitProperty().addListener(ob -> this.onPriceChange());
        this.countBskProperty().addListener(data -> this.calSecs());
        this.countBskForAdgustProperty().addListener(data -> this.reloadSecs());
        this.moneyProperty().addListener(data -> this.calSecs());
        this.assetPctProperty().addListener(data -> this.calSecs());
        this.canBuyPctProperty().addListener(data -> this.calSecs());
        this.canSellPctProperty().addListener(data -> this.calSecs());
        this.stgProperty().addListener(data -> this.calSecs());
        this.smartSellProperty().addListener((ob, old, newV) -> this.onSmartSellChange((boolean)newV));
        this.useInventoryProperty().addListener((ob, old, newV) -> this.onUseInventoryChange((boolean)newV));
        this.getBi().changedProperty().addListener(ob -> {
            this.filterStg();
            this.reloadSecs();
        });
        this.getBi().mktChangedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.getLstMkt()));
        this.getSdUpdate().setInterval(500);
        this.getSdUpdateMkt().setInterval(500);
        this.getItems().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded() && !change.wasRemoved()) continue;
                this.calSecs();
            }
        });
        this.getPostModel().changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.getLstPosition()));
        this.getPostModel().initQuery();
    }

    private void onPriceChange() {
        this.getSdUpdateMkt().schedule(event -> Platform.runLater(() -> {
            for (BasketTradeItem item : this.getItems()) {
                if (!item.isSelected()) continue;
                this.calPrice(item);
            }
            if (!this.getStg().is("1")) {
                this.calCount();
            }
            this.calTotal();
        }));
    }

    public void onSecAccChange() {
    }

    public void onFilterChange() {
        for (BasketTradeItem item : this.getItems()) {
            this.checkItemDisable(item);
        }
    }

    protected void reloadSecs() {
        this.getMapItem().clear();
        this.getItems().clear();
        for (CcsFundAccount acc : this.getAccList()) {
            this.addAccSecs(acc);
        }
    }

    public void addAccSecs(CcsFundAccount acc) {
        LinkedList<BasketTradeItem> listTmp = new LinkedList<BasketTradeItem>();
        if (this.getBi().getItemShowList() == null) {
            return;
        }
        if (this.getMapItem().get(acc) != null && !this.getMapItem().get(acc).isEmpty()) {
            return;
        }
        for (BasketItem info : this.getBi().getItemShowList()) {
            if (info.getRefItem() == null) continue;
            BasketTradeItem item = this.bskTradeItemFactory.create();
            item.setAcc(acc);
            try {
                ObservableList secList = null;
                List<SecAccount> selectList = this.getBasketAccSetModel().getSelectedMap().get(acc);
                if (this.getBasketAccSetModel().getSelectedMap() != null && selectList != null) {
                    secList = FXCollections.observableList(selectList);
                }
                if (secList == null) {
                    secList = FXCollections.observableList((List)((List)this.accMng.getAccountMap().get(acc)));
                }
                if (!secList.isEmpty()) {
                    FilteredList validSecs = secList.filtered(fd -> fd.getExchange().getRaw().equals(info.getMarket().getRaw()));
                    if (validSecs.isEmpty()) continue;
                    item.setSecAcc((SecAccount)validSecs.get(0));
                }
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
            item.setItem(info);
            item.getBsTrade().setRaw(this.isBuyItem(item) ? "49" : "50");
            listTmp.add(item);
            this.checkItemDisable(item);
            CcsPosition pos = null;
            Position position = this.getPostModel().getPositionInMap(item.getSecAcc(), item.getItem().getSecurityId());
            if (position instanceof CcsPosition) {
                pos = (CcsPosition)CcsPosition.class.cast(position);
            }
            if (pos != null) {
                item.canSellProperty().bind((ObservableValue)pos.canVolProperty());
                item.positionProperty().bind((ObservableValue)pos.totalVolProperty());
                item.setPositionExisted(true);
            }
            item.selectedProperty().addListener(ob -> this.calSecs());
        }
        this.getItems().addAll(listTmp);
        this.getMapItem().put(acc, (ObservableList<BasketTradeItem>)FXCollections.observableList(listTmp));
        this.calSecs();
    }

    public void removeAccSecs(CcsFundAccount acc) {
        List accItemList = (List)this.getMapItem().get(acc);
        if (accItemList != null) {
            this.getItems().removeAll((Collection)accItemList);
            this.getMapItem().remove(acc);
        }
    }

    private void queryPostition() {
        this.exe.execute(() -> this.getPostModel().query());
    }

    private void onUseInventoryChange(boolean newV) {
        if (this.getStg().is("6")) {
            return;
        }
        if (newV) {
            for (BasketTradeItem item : this.getItems().filtered(pd -> pd.getBsTrade().getRaw().equals("49"))) {
                this.setEntrustCount(item, item.getBuyCount());
            }
            this.calSpecialCount();
            this.calTotal();
        } else {
            this.calSecs();
        }
    }

    private void onSmartSellChange(boolean newV) {
        if (newV) {
            for (BasketTradeItem item : this.getItems().filtered(pd -> pd.getBsTrade().getRaw().equals("50"))) {
                this.setEntrustCount(item, item.getSellCount());
            }
            this.calSpecialCount();
            this.calTotal();
        } else {
            this.calSecs();
        }
    }

    public void refresh() {
        this.fundAccMng.queryFundAccountList();
        this.queryPostition();
        this.bi.refresh();
    }

    protected void calSecs() {
        this.getSdUpdate().schedule(event -> Platform.runLater(() -> {
            for (BasketTradeItem item : this.getItems()) {
                item.clear();
                if (!item.isSelected()) continue;
                this.calPrice(item);
            }
            this.calAbWeight();
            this.calCount();
            this.calTotal();
        }));
    }

    private void calAbWeight() {
        this.getMapItem().values().forEach(each -> {
            double weight;
            double undefineWeight = 0.0;
            double buyWeight = 0.0;
            double sellWeight = 0.0;
            for (BasketTradeItem item : each.filtered(pd -> pd.isSelected())) {
                weight = item.getItem().getWeight();
                switch (item.getBsTrade().getRaw()) {
                    case "49": {
                        buyWeight += weight;
                        break;
                    }
                    case "50": {
                        sellWeight += weight;
                        break;
                    }
                    default: {
                        undefineWeight += weight;
                    }
                }
            }
            for (BasketTradeItem item : each) {
                weight = item.getItem().getWeight();
                switch (item.getBsTrade().getRaw()) {
                    case "49": {
                        if (buyWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / buyWeight * 100.0), (int)2) : 0.0);
                        break;
                    }
                    case "50": {
                        if (sellWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / sellWeight * 100.0), (int)2) : 0.0);
                        break;
                    }
                    default: {
                        if (undefineWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / undefineWeight * 100.0), (int)2) : 0.0);
                    }
                }
            }
        });
    }

    private void calPrice(BasketTradeItem item) {
        double price = this.getPriceModel().getPrice(item, this.getGear(), this.getFloating(), this.isPctUnit());
        if (this.isBuy()) {
            item.setBuyPrice(price);
            return;
        }
        if (this.isSell()) {
            item.setSellPrice(price);
            return;
        }
        if (item.getBsTrade().getRaw().equals("49")) {
            item.setBuyPrice(price);
        } else {
            item.setSellPrice(price);
        }
    }

    private void calTotal() {
        HashSet<String> setSecs = new HashSet<String>();
        double total = 0.0;
        long totalQty = 0L;
        for (BasketTradeItem item : this.getItems().filtered(i -> i.isSelected())) {
            boolean isBuy = this.isBuySell() ? item.getBsTrade().getRaw().equals("49") : this.isBuy();
            total += item.getAmt(isBuy);
            totalQty += item.getCount(isBuy);
            if (item.getCount(isBuy) <= 0L) continue;
            setSecs.add(item.getItem().getSecurityId());
        }
        this.setAmount(total);
        this.setNum(setSecs.size());
        this.setTotalQuantity(totalQty);
    }

    private void calCount() {
        if (this.getStg().is("1")) {
            this.allocateCount();
        } else if (this.getStg().is("2")) {
            this.allocateMoney();
        } else if (this.getStg().is("5")) {
            this.allocateByPos();
        } else if (this.getStg().is("6")) {
            this.allocateByPosAdjust();
        } else {
            this.allocateByPer();
        }
        this.calSpecialCount();
    }

    private void allocateByPosAdjust() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected())) {
            this.allocateByPosAdjust(item2);
        }
    }

    private void allocateByPosAdjust(BasketTradeItem item) {
        double count = this.getCountBskForAdgust();
        long number = item.getItem().getCount();
        if (count == 0.0 || number == 0L || !this.isBuySell()) {
            return;
        }
        Double target = count * (double)number;
        long pos = item.getPosition();
        double value = target - (double)pos;
        if (value < 0.0) {
            item.getBsTrade().setRaw("50");
        } else {
            item.getBsTrade().setRaw("49");
        }
        long actual = MathUtils.calCount((Double)Math.abs(value), (int)this.getUnit(item));
        this.setEntrustCount(item, actual);
    }

    private void calSpecialCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected())) {
            double per = this.getCanSellPct() / 100.0;
            long count = item2.getCount(this.isBuy());
            if (this.isBuy()) {
                if (this.isUseInventory()) {
                    count -= (long)item2.getPosition();
                }
                item2.setBuyCount((count = MathUtils.calCount((long)count, (int)this.getUnit(item2))) < 0L ? 0L : count);
                continue;
            }
            if (this.isSell()) {
                boolean canSellSmaller = (long)item2.getCanSell() <= count;
                count = this.isSmartSell() ? Math.min((long)item2.getCanSell(), count) : count;
                count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 || canSellSmaller && this.isSmartSell() ? 1 : this.getUnit(item2)));
                item2.setSellCount(count);
                continue;
            }
            if (item2.getBsTrade().getRaw().equals("49")) {
                count = item2.getCount(true);
                if (this.isUseInventory()) {
                    count -= (long)item2.getPosition();
                }
                item2.setBuyCount((count = MathUtils.calCount((long)count, (int)this.getUnit(item2))) < 0L ? 0L : count);
                continue;
            }
            count = item2.getCount(false);
            count = this.isSmartSell() ? Math.min((long)item2.getCanSell(), count) : count;
            count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item2)));
            item2.setSellCount(count);
        }
    }

    private void allocateCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected())) {
            this.allocateItemCount(item2);
        }
    }

    private void allocateItemCount(BasketTradeItem item) {
        double count = this.getCountBsk();
        long number = item.getItem().getCount();
        if (count == 0.0 || number == 0L) {
            return;
        }
        Double target = count * (double)number;
        long actual = MathUtils.calCount((Double)target, (int)this.getUnit(item));
        this.setEntrustCount(item, actual);
    }

    private long setEntrustCount(BasketTradeItem item, long count) {
        double per = this.getCanSellPct() / 100.0;
        if (this.isBuy()) {
            item.setBuyCount((count = MathUtils.calCount((long)count, (int)this.getUnit(item))) < 0L ? 0L : count);
            return count;
        }
        if (this.isSell()) {
            count = this.isSmartSell() ? Math.min((long)item.getCanSell(), count) : count;
            count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item)));
            item.setSellCount(count);
            return count;
        }
        if (item.getBsTrade().getRaw().equals("49")) {
            item.setBuyCount((count = MathUtils.calCount((long)count, (int)this.getUnit(item))) < 0L ? 0L : count);
            return count;
        }
        count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item)));
        item.setSellCount(count);
        return count;
    }

    protected boolean isBuyItem(BasketTradeItem item) {
        if (!this.getBi().getBasket().hasDirection()) {
            return !this.isSell();
        }
        return item.getItem().getBs().is("49");
    }

    private void allocateMoney() {
        for (CcsFundAccount acc : this.getAccList()) {
            this.allcateAccountMoney(acc);
        }
    }

    private void allcateAccountMoney(CcsFundAccount acc, double money) {
        if (this.getMapItem().get(acc) == null) {
            return;
        }
        ObservableList list = FXCollections.observableList((List)((List)this.getMapItem().get(acc)));
        if (list == null) {
            return;
        }
        if (money <= 0.0) {
            return;
        }
        boolean bBuy = this.isBuy();
        for (BasketTradeItem item : list.filtered(pd -> pd.isSelected())) {
            double price;
            double abWeight = item.getAbWeight();
            if (abWeight <= 0.0 || (price = item.getPrice(bBuy)) <= 0.0) continue;
            double moneyItem = money * abWeight / 100.0;
            long count = MathUtils.calCount((double)moneyItem, (double)(price * (double)item.getUnitWeight()), (int)this.getUnit(item));
            count = this.setEntrustCount(item, count);
        }
    }

    private void allcateAccountMoney(CcsFundAccount acc) {
        double money = this.getMoney();
        this.allcateAccountMoney(acc, money);
    }

    private void allocateByPos() {
        for (CcsFundAccount acc : this.getAccList()) {
            this.allocateByPos(acc);
        }
    }

    private void allocateByPos(CcsFundAccount acc) {
        double per = this.getCanSellPct() / 100.0;
        if (per <= 0.0) {
            return;
        }
        List listBasketTradeItem = (List)this.getMapItem().get(acc);
        if (listBasketTradeItem == null || listBasketTradeItem.isEmpty()) {
            return;
        }
        for (BasketTradeItem item : listBasketTradeItem) {
            int canSell = item.getCanSell();
            if (!item.isSelected() || canSell <= 0) {
                item.setSellCount(0L);
                continue;
            }
            long count = new Double((double)canSell * per).longValue();
            count = this.setEntrustCount(item, count);
        }
    }

    private void allocateByPer() {
        for (CcsFundAccount model : this.getAccList()) {
            this.allocateByPer(model);
        }
    }

    private void allocateByPer(CcsFundAccount model) {
        double base = model.getAvailable();
        if (this.getStg().is("3")) {
            base = model.getAssetAmt();
        }
        double per = this.getPct() / 100.0;
        double money = base * per;
        this.allcateAccountMoney(model, money);
    }

    private double getPct() {
        if (this.getStg().is("3")) {
            return this.getAssetPct();
        }
        if (this.getStg().is("4")) {
            return this.getCanBuyPct();
        }
        if (this.getStg().is("5")) {
            return this.getCanSellPct();
        }
        return 0.0;
    }

    protected void checkItemDisable(BasketTradeItem item) {
        BasketItem info = item.getItem();
        if (info == null || info.getMktItem() == null) {
            return;
        }
        if (info.getMktItem().getStop().getValue().booleanValue()) {
            item.setSelected(false);
            item.setDisabled(true);
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitUp().getValue().booleanValue()) {
            item.setSelected(!this.isFilterUp());
            item.setDisabled(this.isFilterUp());
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitDown().getValue().booleanValue()) {
            item.setSelected(!this.isFilterDown());
            item.setDisabled(this.isFilterDown());
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        item.setSelected(item.isManuallySelected());
        item.setDisable(false);
    }

    public ObservableList<BasketTradeItem> getItems() {
        return this.listItem;
    }

    private void onBsChange(boolean newV) {
        if (!newV) {
            return;
        }
        if (this.isBuy()) {
            this.buyStg(this.getStg());
        } else if (this.isSell()) {
            this.sellStg(this.getStg());
        } else {
            this.buySellStg(this.getStg());
        }
        this.getBi().filterBasketItem();
    }

    private void filterStg() {
        if (this.isBuy()) {
            this.buyStg(this.getStg());
        } else if (this.isSell()) {
            this.sellStg(this.getStg());
        } else {
            this.buySellStg(this.getStg());
        }
    }

    public void entrust() throws MException {
        BasketSubmitResult result = this.getBatchEntrust().submit(null, (List<BasketTradeItem>)this.getEntrustList(), this.getBi().getBasket(), "");
        for (String successId : result.getSuccessedIds()) {
            MEvent event = new MEvent();
            event.put((Object)"listId", (Object)successId);
            event.put((Object)"isPortfolio", (Object)false);
            this.es.postEvent("basket.submit", event);
        }
        throw new MException(0, "\u7bee\u5b50\u63d0\u4ea4\u6210\u529f");
    }

    public ObservableList<BasketTradeItem> getEntrustList() {
        return this.getItems().filtered(pd -> pd.isSelected() && pd.getAmt(pd.getBsTrade().getRaw().equals("49")) != 0.0);
    }

    public ObservableList<BasketTradeItem> getSelectedList() {
        return this.getItems().filtered(pd -> pd.isSelected());
    }

    public void setAccList(ObservableList<CcsFundAccount> list) {
        this.listAccount = list;
    }

    public ObservableList<CcsFundAccount> getAccList() {
        return this.listAccount;
    }

    private void initPriceGear(MxNode node) {
        this.removeOthers(node, "-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
        node.addNode("11");
    }

    private void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    private void buyStg(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.setRaw(oldNodeRaw.equals("5") ? "4" : oldNodeRaw);
        node.setRaw(oldNodeRaw.equals("6") ? "1" : oldNodeRaw);
        this.setStg(node);
    }

    private void sellStg(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("5");
        node.setRaw(oldNodeRaw.equals("4") ? "5" : oldNodeRaw);
        node.setRaw(oldNodeRaw.equals("6") ? "1" : oldNodeRaw);
        this.setStg(node);
    }

    private void buySellStg(MxNode node) {
        this.removeOthers(node, "1");
        if (this.getBi().getBasket() != null && !this.getBi().getBasket().hasDirection()) {
            node.addNode("6");
        }
    }

    public final BooleanProperty buyProperty() {
        return this.getBuy();
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public BasketInfo getBasketInfo() {
        return this.getBi();
    }

    public final DoubleProperty floatingProperty() {
        return this.floating;
    }

    public final double getFloating() {
        return this.floatingProperty().get();
    }

    public final void setFloating(double floating) {
        this.floatingProperty().set(floating);
    }

    public final DoubleProperty amountProperty() {
        return this.amount;
    }

    public final double getAmount() {
        return this.amountProperty().get();
    }

    public void setAmount(double amount) {
        this.amountProperty().set(amount);
    }

    public final ObjectProperty<MxNode> gearProperty() {
        return this.gear;
    }

    public final MxNode getGear() {
        return (MxNode)this.gearProperty().get();
    }

    public final void setGear(MxNode gear) {
        this.gearProperty().set((Object)gear);
    }

    public ObjectProperty<MxNode> stgProperty() {
        return this.stg;
    }

    public MxNode getStg() {
        return (MxNode)this.stgProperty().get();
    }

    public void setStg(MxNode stg) {
        this.stgProperty().set((Object)stg);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public BooleanProperty pctUnitProperty() {
        return this.pctUnit;
    }

    public boolean isPctUnit() {
        return this.pctUnitProperty().get();
    }

    public void setPctUnit(boolean pctUnit) {
        this.pctUnitProperty().set(pctUnit);
    }

    public IntegerProperty numProperty() {
        return this.num;
    }

    public int getNum() {
        return this.numProperty().get();
    }

    public void setNum(int num) {
        this.numProperty().set(num);
    }

    public BooleanProperty filterUpProperty() {
        return this.filterUp;
    }

    public boolean isFilterUp() {
        return this.filterUpProperty().get();
    }

    public void setFilterUp(boolean filterUp) {
        this.filterUpProperty().set(filterUp);
    }

    public BooleanProperty filterDownProperty() {
        return this.filterDown;
    }

    public boolean isFilterDown() {
        return this.filterDownProperty().get();
    }

    public void setFilterDown(boolean filterDown) {
        this.filterDownProperty().set(filterDown);
    }

    public final BooleanProperty sellProperty() {
        return this.getSell();
    }

    public final boolean isSell() {
        return this.sellProperty().get();
    }

    public final void setSell(boolean sell) {
        this.sellProperty().set(sell);
    }

    public final BooleanProperty buySellProperty() {
        return this.getBuySell();
    }

    public final boolean isBuySell() {
        return this.buySellProperty().get();
    }

    public final void setBuySell(boolean buySell) {
        this.buySellProperty().set(buySell);
    }

    public final BooleanProperty smartSellProperty() {
        return this.smartSell;
    }

    public final boolean isSmartSell() {
        return this.smartSellProperty().get();
    }

    public final void setSmartSell(boolean smartSell) {
        this.smartSellProperty().set(smartSell);
    }

    public final BooleanProperty useInventoryProperty() {
        return this.useInventory;
    }

    public final boolean isUseInventory() {
        return this.useInventoryProperty().get() && !this.getStg().is("6");
    }

    public final void setUseInventory(boolean useInventory) {
        this.useInventoryProperty().set(useInventory);
    }

    public final DoubleProperty assetPctProperty() {
        return this.assetPct;
    }

    public final double getAssetPct() {
        return this.assetPctProperty().get();
    }

    public final void setAssetPct(double assetPct) {
        this.assetPctProperty().set(assetPct);
    }

    public final DoubleProperty canBuyPctProperty() {
        return this.canBuyPct;
    }

    public final double getCanBuyPct() {
        return this.canBuyPctProperty().get();
    }

    public final void setCanBuyPct(double canBuyPct) {
        this.canBuyPctProperty().set(canBuyPct);
    }

    public final DoubleProperty canSellPctProperty() {
        return this.canSellPct;
    }

    public final double getCanSellPct() {
        return this.canSellPctProperty().get();
    }

    public final void setCanSellPct(double canSellPct) {
        this.canSellPctProperty().set(canSellPct);
    }

    private int getUnit(BasketTradeItem item) {
        if (item.getItem().getRefItem() == null) {
            return 1;
        }
        return item.getItem().getRefItem().getBuyUnit();
    }

    public LongProperty totalQuantityProperty() {
        return this.totalQuantity;
    }

    public long getTotalQuantity() {
        return this.totalQuantityProperty().get();
    }

    public void setTotalQuantity(long totalQuantity) {
        this.totalQuantityProperty().set(totalQuantity);
    }

    public BasketGearPriceModel getPriceModel() {
        return this.priceModel;
    }

    public BatchEntrust getBatchEntrust() {
        return this.batchEntrust;
    }

    public PositionModel<? extends Position> getPostModel() {
        return this.ccsPosModel;
    }

    public Map<CcsFundAccount, ObservableList<BasketTradeItem>> getMapItem() {
        return this.mapItem;
    }

    public void setMapItem(Map<CcsFundAccount, ObservableList<BasketTradeItem>> mapItem) {
        this.mapItem = mapItem;
    }

    public BasketInfo getBi() {
        return this.bi;
    }

    public void setBi(BasketInfo bi) {
        this.bi = bi;
    }

    public MScheduler getSdUpdate() {
        return this.sdUpdate;
    }

    public void setSdUpdate(MScheduler sdUpdate) {
        this.sdUpdate = sdUpdate;
    }

    public MScheduler getSdUpdateMkt() {
        return this.sdUpdateMkt;
    }

    public void setSdUpdateMkt(MScheduler sdUpdateMkt) {
        this.sdUpdateMkt = sdUpdateMkt;
    }

    public InvalidationListener getLstPosition() {
        return this.lstPosition;
    }

    public void setLstPosition(InvalidationListener lstPosition) {
        this.lstPosition = lstPosition;
    }

    public BooleanProperty getBuy() {
        return this.buy;
    }

    public void setBuy(BooleanProperty buy) {
        this.buy = buy;
    }

    public BooleanProperty getSell() {
        return this.sell;
    }

    public void setSell(BooleanProperty sell) {
        this.sell = sell;
    }

    public BooleanProperty getBuySell() {
        return this.buySell;
    }

    public void setBuySell(BooleanProperty buySell) {
        this.buySell = buySell;
    }

    public void setBatchEntrust(BatchEntrust batchEntrust) {
        this.batchEntrust = batchEntrust;
    }

    public MObjFactory getOf() {
        return this.of;
    }

    public void setOf(MObjFactory of) {
        this.of = of;
    }

    public InvalidationListener getLstMkt() {
        return this.lstMkt;
    }

    public void setLstMkt(InvalidationListener lstMkt) {
        this.lstMkt = lstMkt;
    }

    public BasketAccSetModel getBasketAccSetModel() {
        return this.basketAccSetModel;
    }

    public void setBasketAccSetModel(BasketAccSetModel basketAccSetModel) {
        this.basketAccSetModel = basketAccSetModel;
    }

    public DoubleProperty countBskProperty() {
        return this.countBsk;
    }

    public double getCountBsk() {
        return this.countBskProperty().get();
    }

    public void setCountBsk(double countBsk) {
        this.countBskProperty().set(countBsk);
    }

    public DoubleProperty countBskForAdgustProperty() {
        return this.countBskForAdgust;
    }

    public double getCountBskForAdgust() {
        return this.countBskForAdgustProperty().get();
    }

    public void setCountBskForAdgust(double countBskForAdgust) {
        this.countBskForAdgustProperty().set(countBskForAdgust);
    }
}

