/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.api.basket.IBasketMngApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PBasketService;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.trade.models.basket.BasketItemModel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketMngModel
extends MxModel {
    @Inject
    private IBasketMngApi basketMngApi;
    @Inject
    private BasketItemModel itemModel;
    private ObservableList<Basket> bskList = FxUtils.newList();
    private AtomicBoolean bInit = new AtomicBoolean(false);
    private Basket temporaryBasket = null;
    @Inject
    private MEventService es;
    private static final Logger logger = LogManager.getLogger(BasketMngModel.class);

    @PostConstruct
    private void init() {
        this.es.subscribe("add.temp.basket", mEvent -> this.addTempBasket(mEvent));
    }

    private void addTempBasket(MEvent mEvent) {
        Basket basket = (Basket)mEvent.getObj(Basket.class);
        this.bskList.remove((Object)this.temporaryBasket);
        this.temporaryBasket = basket;
        if (!this.bskList.contains((Object)this.temporaryBasket)) {
            this.bskList.add((Object)this.temporaryBasket);
        }
        this.changed();
    }

    public synchronized void query() throws MException {
        this.bskList.clear();
        List list = this.basketMngApi.queryBaskets("CCS");
        for (PBasketService.Basket item : list) {
            Basket basket = new Basket();
            basket.update((Object)item);
            this.itemModel.queryItems(basket);
            this.bskList.add((Object)basket);
        }
        if (this.temporaryBasket != null) {
            this.bskList.add((Object)this.temporaryBasket);
        }
        this.bInit.set(true);
        this.changed();
    }

    public synchronized Basket createBasket(Basket basket) throws MException {
        PBasketService.Basket bsk = this.basketMngApi.addBasket("CCS", basket.getName());
        basket.update((Object)bsk);
        this.bskList.add((Object)basket);
        this.changed();
        return basket;
    }

    public synchronized void delete(String bskId) throws MException {
        if (this.temporaryBasket == null || !bskId.equals(this.temporaryBasket.getId())) {
            this.basketMngApi.deleteBasket("CCS", bskId);
        }
    }

    public synchronized void update(Basket basket) throws MException {
        if (this.temporaryBasket != basket) {
            this.basketMngApi.updateBasket("CCS", basket.getId(), basket.getName());
        }
        this.changed();
    }

    public ObservableList<Basket> getList() {
        logger.info("\u83b7\u53d6\u7bee\u5b50\u5217\u8868\uff0c" + this.bInit.get() + "size," + this.bskList.size());
        if (this.bskList.size() == 0 && !this.bInit.get()) {
            try {
                this.query();
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u7bee\u5b50\u6216\u6210\u5206\u80a1\u5931\u8d25", (Throwable)e);
            }
        }
        return this.bskList;
    }

    public Basket getTemporaryBasket() {
        return this.temporaryBasket;
    }

    public void setTemporaryBasket(Basket temporaryBasket) {
        this.temporaryBasket = temporaryBasket;
    }
}

