/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.api.basket.IBasketStockApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PBasketService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.MxModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketItemModel
extends MxModel {
    @Inject
    private IBasketStockApi basketStockApi;
    private List<BasketItem> bskItemList = new LinkedList<BasketItem>();
    private List<BasketItem> bskSecList = new LinkedList<BasketItem>();
    private double noWeight;
    private double buyWeight;
    private double sellWeight;
    private int num = 1;

    public synchronized void queryItems(Basket basket) throws MException {
        basket.setUnModified(true);
        this.bskItemList = new LinkedList<BasketItem>();
        this.bskSecList.clear();
        this.noWeight = 0.0;
        this.buyWeight = 0.0;
        this.sellWeight = 0.0;
        String uuid = UUID.randomUUID().toString();
        List list = this.basketStockApi.queryStocks("CCS", basket.getId(), uuid);
        list.forEach(item -> {
            BasketItem basketItem = new BasketItem();
            basketItem.update(item);
            basketItem.setUnit(this.getUnit(basketItem.getSecurityType(), basketItem.getMarket().getRaw()));
            switch (basketItem.getBs().getRaw()) {
                case "49": {
                    this.buyWeight += basketItem.getWeight();
                    break;
                }
                case "50": {
                    this.sellWeight += basketItem.getWeight();
                    break;
                }
                default: {
                    this.noWeight += basketItem.getWeight();
                }
            }
            this.bskItemList.add(basketItem);
        });
        this.bskSecList.addAll(this.bskItemList);
        this.bskSecList.forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    if (this.buyWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.buyWeight * 100.0);
                    item.setAbsWeight(abs);
                    break;
                }
                case "50": {
                    if (this.sellWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.sellWeight * 100.0);
                    item.setAbsWeight(abs);
                    break;
                }
                default: {
                    if (this.noWeight == 0.0) break;
                    double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.noWeight * 100.0);
                    item.setAbsWeight(abs);
                }
            }
            item.weightProperty().addListener(ob -> this.changeWeight(this.bskSecList));
            item.bsProperty().addListener(ob -> this.changeWeight(this.bskSecList));
        });
        basket.setList(this.bskItemList);
        this.changed();
    }

    public List<BasketItem> getSecList() {
        return this.bskSecList;
    }

    public void updateItems(Basket bsk, List<BasketItem> list) throws MException {
        int totalNum = list.size() % 150 == 0 ? list.size() / 150 : list.size() / 150 + 1;
        PBase.Fragment.Builder fra = PBase.Fragment.newBuilder();
        fra.setIndex(1);
        fra.setTotalFragNum(totalNum);
        fra.setTotalDataNum(list.size());
        this.num = 1;
        ArrayList bskSecList = new ArrayList();
        list.forEach(item -> {
            PBasketService.BasketSecurity.Builder builder = PBasketService.BasketSecurity.newBuilder();
            builder.setSequence(this.num++);
            builder.setSecurityId(item.getSecurityId());
            builder.setSymbol(item.getSecurityName());
            builder.setMarket(item.getMarket().getRaw());
            builder.setRelativeWeight(item.getWeight());
            builder.setSampleQty((double)item.getCount());
            builder.setPrice(item.getPrice());
            builder.setSideValue(Integer.parseInt(item.getBs().getRaw()));
            builder.setSecurityType(item.getSecurityType());
            bskSecList.add(builder.build());
        });
        int i = 1;
        String uuid = UUID.randomUUID().toString();
        this.basketStockApi.updateStock("CCS", bsk.getId(), bskSecList, fra.build(), i, uuid);
    }

    private void changeWeight(List<BasketItem> list) {
        this.noWeight = 0.0;
        this.buyWeight = 0.0;
        this.sellWeight = 0.0;
        list.forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    this.buyWeight += item.getWeight();
                    break;
                }
                case "50": {
                    this.sellWeight += item.getWeight();
                    break;
                }
                default: {
                    this.noWeight += item.getWeight();
                }
            }
        });
        list.forEach(item -> {
            switch (item.getBs().getRaw()) {
                case "49": {
                    if (this.buyWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.buyWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                    break;
                }
                case "50": {
                    if (this.sellWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.sellWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                    break;
                }
                default: {
                    if (this.noWeight != 0.0) {
                        double abs = (double)Math.round(item.getWeight() * 10000.0) / (this.noWeight * 100.0);
                        item.setAbsWeight(abs);
                        break;
                    }
                    item.setAbsWeight(0.0);
                }
            }
        });
    }

    private String getUnit(String secType, String market) {
        if ("STOCK".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return null;
    }
}

