/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.api.data.IRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.INewMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BasketInfo
extends MxModel {
    protected static final Logger logger = LogManager.getLogger(BasketInfo.class);
    protected ObjectProperty<Basket> basket = new SimpleObjectProperty((Object)new Basket());
    protected ObservableList<BasketItem> itemList = FXCollections.observableList(new LinkedList());
    protected ObservableList<BasketItem> itemShowList = FXCollections.observableList(new LinkedList());
    protected BooleanProperty buy = new SimpleBooleanProperty(false);
    protected BooleanProperty sell = new SimpleBooleanProperty(false);
    protected BooleanProperty mktChange = new SimpleBooleanProperty(false);
    protected BooleanProperty phaseChange = new SimpleBooleanProperty(false);
    protected boolean mail = false;
    private IntegerProperty totalCount = new SimpleIntegerProperty();
    private IntegerProperty upCount = new SimpleIntegerProperty();
    private IntegerProperty downCount = new SimpleIntegerProperty();
    private IntegerProperty stopCount = new SimpleIntegerProperty();
    @Inject
    private INewMarketDataMng mktMng;
    @Inject
    private IMarketDataMng oldMktMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private ExecutorService exe;
    private InvalidationListener lstnSearch = ob -> this.mktChanged();

    public ObservableList<BasketItem> getItemList() {
        return this.itemList;
    }

    public void setItemList(ObservableList<BasketItem> itemList) {
        this.itemList = itemList;
    }

    public ObservableList<BasketItem> getItemShowList() {
        return this.itemShowList;
    }

    public void setItemShowList(ObservableList<BasketItem> itemShowList) {
        this.itemShowList = itemShowList;
    }

    @PostConstruct
    public void init() {
        this.basket.addListener((o, old, now) -> {
            if (now != null) {
                this.onBasketChange();
            } else {
                this.itemList = null;
            }
        });
    }

    @PreDestroy
    public void close() {
        this.mktMng.unsub();
    }

    public void refresh() {
        this.onBasketChange();
    }

    public void onBasketChange() {
        this.exe.execute(() -> {
            this.subMarket();
            this.itemList = this.getBasket() == null ? null : this.getBasket().getList();
            Platform.runLater(() -> this.filterBasketItem());
        });
    }

    protected void subMarket() {
        ObservableList list = this.getBasket().getList();
        LinkedList<RefItem> refItemList = new LinkedList<RefItem>();
        for (BasketItem item : list) {
            RefItem refItem = item.getRefItem();
            if (refItem == null) {
                String market = item.getMarket().getRaw();
                refItem = "SHSC".equals(market) || "SZSC".equals(market) ? this.refMng.getItem("STOCK" + market, market, item.getSecurityId()) : this.refMng.getItem(item.getSecurityType(), market, item.getSecurityId());
                item.setRefItem(refItem);
            }
            if (refItem == null) continue;
            refItemList.add(refItem);
        }
        this.mktMng.sub(refItemList);
        for (BasketItem item : list) {
            MarketItem mktItem;
            if (item.getRefItem() == null || (mktItem = this.oldMktMng.getInfo((IRefItem)item.getRefItem())) == null) continue;
            item.setMktItem(mktItem);
            mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
            mktItem.phaseProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        }
    }

    public void filterBasketItem() {
        this.itemShowList.clear();
        try {
            if (this.itemList == null || this.itemList.isEmpty()) {
                this.changed();
                return;
            }
            ((Basket)this.basket.getValue()).setDirection(!((BasketItem)this.itemList.get(0)).getBs().getRaw().equals("0"));
            for (BasketItem info : this.itemList) {
                if (((Basket)this.basket.getValue()).hasDirection() && !this.sameDirection(info.getBs()) || !this.isMail() && ("SHSC".equals(info.getMarket().getRaw()) || "SZSC".equals(info.getMarket().getRaw()))) continue;
                this.itemShowList.add((Object)info);
            }
            Collections.sort(this.itemShowList, (o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
            this.calInfo();
            this.changed();
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u6210\u5206\u80a1\u5931\u8d25", (Throwable)e);
        }
    }

    public BooleanProperty changedProperty() {
        return super.changedProperty();
    }

    protected boolean sameDirection(MxNode mxNode) {
        if (mxNode.getRaw().equals("49") && this.isSell()) {
            return false;
        }
        return !mxNode.getRaw().equals("50") || !this.isBuy();
    }

    public void calInfo() {
        int up = 0;
        int down = 0;
        int stop = 0;
        int total = 0;
        for (BasketItem item : this.itemShowList) {
            MarketItem mktItem = item.getMktItem();
            ++total;
            if (mktItem == null) continue;
            if (mktItem.getLimitUp().getValue().booleanValue()) {
                ++up;
            }
            if (mktItem.getLimitDown().getValue().booleanValue()) {
                ++down;
            }
            if (mktItem.getStop().getValue().booleanValue()) {
                ++stop;
            }
            this.setUpCount(up);
            this.setDownCount(down);
            this.setStopCount(stop);
            this.setTotalCount(total);
        }
    }

    public final ObjectProperty<Basket> basketProperty() {
        return this.basket;
    }

    public final Basket getBasket() {
        return (Basket)this.basketProperty().get();
    }

    public final void setBasket(Basket basket) {
        this.basketProperty().set((Object)basket);
    }

    public final IntegerProperty totalCountProperty() {
        return this.totalCount;
    }

    public final int getTotalCount() {
        return this.totalCountProperty().get();
    }

    public final void setTotalCount(int totalCount) {
        this.totalCountProperty().set(totalCount);
    }

    public final IntegerProperty upCountProperty() {
        return this.upCount;
    }

    public final int getUpCount() {
        return this.upCountProperty().get();
    }

    public final void setUpCount(int upCount) {
        this.upCountProperty().set(upCount);
    }

    public final IntegerProperty downCountProperty() {
        return this.downCount;
    }

    public final int getDownCount() {
        return this.downCountProperty().get();
    }

    public final void setDownCount(int downCount) {
        this.downCountProperty().set(downCount);
    }

    public final IntegerProperty stopCountProperty() {
        return this.stopCount;
    }

    public final int getStopCount() {
        return this.stopCountProperty().get();
    }

    public final void setStopCount(int stopCount) {
        this.stopCountProperty().set(stopCount);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final BooleanProperty sellProperty() {
        return this.sell;
    }

    public final boolean isSell() {
        return this.sellProperty().get();
    }

    public final void setSell(boolean sell) {
        this.sellProperty().set(sell);
    }

    public BooleanProperty mktChangedProperty() {
        return this.mktChange;
    }

    public void mktChanged() {
        this.mktChange.set(!this.mktChange.get());
    }

    public BooleanProperty phaseChangedProperty() {
        return this.phaseChange;
    }

    public void phaseChanged() {
        this.phaseChange.set(!this.phaseChange.get());
    }

    public boolean isMail() {
        return this.mail;
    }

    public void setMail(boolean mail) {
        this.mail = mail;
    }
}

