/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.trade.utils.TradeUtils;
import cms.tmx.utils.DecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketGearPriceModel {
    public double getPrice(BasketTradeItem item, MxNode gear, double floatVal, boolean isPctUnit) {
        MarketItem mktItem = item.getItem().getMktItem();
        RefItem refItem = item.getItem().getRefItem();
        if (mktItem == null) {
            return 0.0;
        }
        int scale = DecimalUtils.getScale((double)mktItem.getRefItem().getPriceUnit());
        double price = 0.0;
        double closePrice = mktItem.getClosePrice();
        double nowPrice = mktItem.getNowPrice();
        double uplimitPrice = mktItem.getUpLimitPrice();
        double downlimitPrice = mktItem.getDownLimitPrice();
        switch (gear.getRaw()) {
            case "11": {
                price = item.getItem().getPrice();
                break;
            }
            case "0": {
                price = nowPrice == 0.0 ? closePrice : nowPrice;
                break;
            }
            case "100": {
                if (refItem.getType().equals("BOND")) {
                    price = nowPrice == 0.0 ? closePrice : nowPrice;
                    break;
                }
                price = uplimitPrice == 0.0 ? (nowPrice == 0.0 ? closePrice : nowPrice) : uplimitPrice;
                break;
            }
            case "-100": {
                if (refItem.getType().equals("BOND")) {
                    price = nowPrice == 0.0 ? closePrice : nowPrice;
                    break;
                }
                price = downlimitPrice == 0.0 ? (nowPrice == 0.0 ? closePrice : nowPrice) : downlimitPrice;
                break;
            }
            default: {
                int raw = Integer.parseInt(gear.getRaw());
                if (raw > 0 && !"11".equals(gear.getRaw())) {
                    while (price <= 0.0 && raw > 0 && raw <= 10) {
                        price = mktItem.getBuyPrice(raw - 1);
                        --raw;
                    }
                    if (price <= 0.0) {
                        double d = price = nowPrice == 0.0 ? closePrice : nowPrice;
                    }
                }
                if (raw >= 0) break;
                raw = Math.abs(raw);
                while (price <= 0.0 && raw > 0 && raw <= 10) {
                    price = mktItem.getSellPrice(raw - 1);
                    --raw;
                }
                if (!(price <= 0.0)) break;
                price = nowPrice == 0.0 ? closePrice : nowPrice;
            }
        }
        BigDecimal bd = new BigDecimal(Double.toString(price));
        price = bd.setScale(scale, RoundingMode.HALF_UP).doubleValue();
        price = TradeUtils.calValueByFloating(price, floatVal, isPctUnit);
        price = DecimalUtils.getValueByScale((double)price, (int)scale, (boolean)item.getBsTrade().is("49"));
        return price < 0.0 ? 0.0 : price;
    }
}

