/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.api.basket.IBasketCancelReplaceApi;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketCancelReplace
extends MxModel {
    @Inject
    private IBasketCancelReplaceApi replaceApi;
    @Inject
    private MEventService es;
    private boolean returnFlag = true;
    private PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
    private static final Logger logger = LogManager.getLogger(BasketCancelReplace.class);
    private MEventHandler replaceOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        BasketCcsOrder baseOrder = (BasketCcsOrder)event.get("basket.base.order", BasketCcsOrder.class);
        try {
            this.submit(list, baseOrder);
            this.returnFlag = true;
        }
        catch (MException e) {
            this.returnFlag = false;
            logger.error("\u6279\u91cf\u64a4\u5355\u91cd\u4e0b\u5931\u8d25", (Throwable)e);
        }
        event.put((Object)"basket_return_boolean", (Object)this.returnFlag);
    };

    public void subscribe() {
        this.es.subscribe("basket.replace.order", this.replaceOrder);
    }

    public void submit(List<?> list, BasketCcsOrder baseOrder) throws MException {
        int totalNum = list.size() % 150 == 0 ? list.size() / 150 : list.size() / 150 + 1;
        PBase.Fragment.Builder fra = PBase.Fragment.newBuilder();
        fra.setIndex(1);
        fra.setTotalFragNum(totalNum);
        fra.setTotalDataNum(list.size());
        ArrayList<PMessage.ListOrdGrpLeg> ordList = new ArrayList<PMessage.ListOrdGrpLeg>();
        for (Object obj : list) {
            if (!(obj instanceof BasketCcsOrder)) continue;
            BasketCcsOrder item = (BasketCcsOrder)BasketCcsOrder.class.cast(obj);
            if (item.getNewPrice() <= 0.0) {
                throw new MException(999997, "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a");
            }
            PMessage.ListOrdGrpLeg.Builder builder = PMessage.ListOrdGrpLeg.newBuilder();
            this.inst.setMarket(item.getInstrument().getMarket().getRaw());
            this.inst.setSecurityId(item.getInstrument().getSecId());
            this.inst.setSecurityType(item.getInstrument().getSecType());
            this.inst.setApplId("010");
            builder.setInstrument(this.inst);
            builder.setSecondaryClOrdId(item.getListId());
            builder.setClOrdLinkId(item.getLegId());
            builder.setSideValue(Integer.parseInt(item.getSide().getRaw()));
            builder.setOrdTypeValue(50);
            builder.setExtAccntId(item.getExtAccntId());
            builder.setExtSecAccntId(item.getExtSecAccntId());
            builder.setPrice(item.getNewPrice());
            builder.setOrderQty((double)(item.getOrderQty() - item.getCumQty()));
            ordList.add(builder.build());
        }
        int i = 1;
        String uuid = UUID.randomUUID().toString();
        this.replaceApi.cancelReplace(ordList, fra.build(), i, uuid, "CCS", baseOrder.getReference(), baseOrder.getResourceId());
    }
}

