/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.api.basket.IBasketCancelOrderApi;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketCancelOrder
extends MxModel {
    @Inject
    private IBasketCancelOrderApi cancelApi;
    private boolean returnFlag = true;
    private static final Logger logger = LogManager.getLogger(BasketCancelOrder.class);
    private PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
    @Inject
    private MEventService es;
    private MEventHandler cancelOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        try {
            this.submit(list);
            this.returnFlag = true;
        }
        catch (MException e) {
            this.returnFlag = false;
            event.put((Object)"data", (Object)e);
            logger.error("\u6279\u91cf\u64a4\u5355\u5931\u8d25", (Throwable)e);
        }
        event.put((Object)"basket_return_boolean", (Object)this.returnFlag);
    };

    public void subscribe() {
        this.es.subscribe("basket.cancel.order", this.cancelOrder);
    }

    public void submit(List<?> list) throws MException {
        int totalNum = list.size() % 150 == 0 ? list.size() / 150 : list.size() / 150 + 1;
        PBase.Fragment.Builder fra = PBase.Fragment.newBuilder();
        fra.setIndex(1);
        fra.setTotalFragNum(totalNum);
        fra.setTotalDataNum(list.size());
        ArrayList<PMessage.ListOrdGrpLeg> ordList = new ArrayList<PMessage.ListOrdGrpLeg>();
        String clListId = "";
        for (Object obj : list) {
            if (!(obj instanceof BasketCcsOrder)) continue;
            BasketCcsOrder item = (BasketCcsOrder)BasketCcsOrder.class.cast(obj);
            if (clListId.isEmpty()) {
                clListId = item.getClListId();
            }
            PMessage.ListOrdGrpLeg.Builder builder = PMessage.ListOrdGrpLeg.newBuilder();
            if (item.getInstrument() != null) {
                this.inst.setMarket(item.getInstrument().getMarket().getRaw());
                this.inst.setSecurityId(item.getInstrument().getSecId());
                this.inst.setSecurityType(item.getInstrument().getSecType());
                builder.setInstrument(this.inst);
            }
            builder.setSecondaryClOrdId(item.getListId());
            builder.setClOrdLinkId(item.getLegId());
            builder.setOrigClOrdId(item.getClOrderId());
            builder.setClOrdId(item.getClOrderId());
            ordList.add(builder.build());
        }
        int i = 1;
        String uuid = UUID.randomUUID().toString();
        this.cancelApi.cancel(ordList, fra.build(), i, uuid, "CCS", clListId);
    }
}

