/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models.basket;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BasketAccSetModel {
    @Inject
    private CcsAccountMap accMng;
    private Map<CcsFundAccount, List<SecAccount>> selectedMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private List<CcsFundAccount> fundList = new ArrayList<CcsFundAccount>();
    private List<CcsFundAccount> selectedFundList = new ArrayList<CcsFundAccount>();
    protected TreeItem<CcsAccountDistribution> root = new TreeItem((Object)new CcsAccountDistribution());
    protected MxTreeList<CcsAccountDistribution> accMxList;
    protected Map<String, MxTreeList<CcsAccountDistribution>> mapSecDisMxList;
    private final int MAP_CAP = 100;
    @Inject
    private MObjFactory of;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>();

    public void setFundList(List<CcsFundAccount> list) {
        this.fundList = list;
    }

    public Map<CcsFundAccount, List<SecAccount>> getSelectedMap() {
        if (!this.selectedMap.isEmpty()) {
            return this.selectedMap;
        }
        this.root.getChildren().forEach(accItem -> {
            if (((CcsAccountDistribution)accItem.getValue()).isSelected()) {
                LinkedList secList = new LinkedList();
                accItem.getChildren().forEach(secItem -> {
                    if (((CcsAccountDistribution)secItem.getValue()).isSelected()) {
                        secList.add(((CcsAccountDistribution)secItem.getValue()).getSecAcc());
                    }
                });
                this.selectedMap.put(((CcsAccountDistribution)accItem.getValue()).getAcc(), secList);
            }
        });
        return this.selectedMap;
    }

    public TreeItem<CcsAccountDistribution> getRoot() {
        return this.root;
    }

    public void createTree() throws MException {
        this.getMapAccount().clear();
        for (CcsFundAccount item : this.fundList) {
            this.getMapAccount().put(item, (List)this.accMng.getAccountMap().get(item));
        }
        ((CcsAccountDistribution)this.root.getValue()).setSelected(true);
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new HashMap<String, MxTreeList<CcsAccountDistribution>>(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, (ObservableList<TreeItem<CcsAccountDistribution>>)this.root.getChildren(), accList);
        for (CcsFundAccount fundAcc : this.getMapAccount().keySet()) {
            CcsAccountDistribution accDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
            accDst.setAcc(fundAcc);
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            if (this.selectedMap.isEmpty()) {
                this.pickTwoDefault(fundAcc, accDst, secAccList);
            } else if (!this.selectedMap.isEmpty() && this.selectedMap.keySet().contains(fundAcc) && this.getSelectedFundList().contains(fundAcc)) {
                this.reSelected(fundAcc, accDst, secAccList);
            } else if (!this.selectedMap.isEmpty() && !this.selectedMap.keySet().contains(fundAcc) && this.getSelectedFundList().contains(fundAcc)) {
                this.pickTwoDefault(fundAcc, accDst, secAccList);
            } else {
                for (SecAccount secAcc : this.getMapAccount().get(fundAcc)) {
                    if (!"XSHE".equals(secAcc.getExchange().getRaw()) && !"XSHG".equals(secAcc.getExchange().getRaw())) continue;
                    CcsAccountDistribution secDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
                    secAccList.add(secDst);
                    secDst.setSecAcc(secAcc);
                }
            }
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem<CcsAccountDistribution>)((TreeItem)this.root.getChildren().get(accList.size() - 1)), (ObservableList<TreeItem<CcsAccountDistribution>>)((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        this.selectedMap.clear();
    }

    private void reSelected(CcsFundAccount fundAcc, CcsAccountDistribution accDst, List<CcsAccountDistribution> secAccList) {
        accDst.setSelected(true);
        List<SecAccount> secList = this.selectedMap.get(fundAcc);
        for (SecAccount secAcc : this.getMapAccount().get(fundAcc)) {
            CcsAccountDistribution secDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
            secAccList.add(secDst);
            secDst.setIsSecAcc(true);
            secDst.setSecAcc(secAcc);
            if (!secList.contains(secAcc)) continue;
            secDst.setSelected(true);
        }
    }

    private void pickTwoDefault(CcsFundAccount fundAcc, CcsAccountDistribution accDst, List<CcsAccountDistribution> secAccList) {
        if (this.getSelectedFundList().contains(fundAcc)) {
            accDst.setSelected(true);
        }
        boolean xshg = true;
        boolean xshe = true;
        for (SecAccount secAcc : this.getMapAccount().get(fundAcc)) {
            CcsAccountDistribution secDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
            secAccList.add(secDst);
            secDst.setIsSecAcc(true);
            secDst.setSecAcc(secAcc);
            if (this.getSelectedFundList().contains(fundAcc) && xshg && "XSHG".equals(secAcc.getExchange().getRaw())) {
                secDst.setSelected(true);
                xshg = false;
            }
            if (!this.getSelectedFundList().contains(fundAcc) || !xshe || !"XSHE".equals(secAcc.getExchange().getRaw())) continue;
            secDst.setSelected(true);
            xshe = false;
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMapAccount() {
        return this.mapAccount;
    }

    public void setMapAccount(Map<CcsFundAccount, List<SecAccount>> mapAccount) {
        this.mapAccount = mapAccount;
    }

    public List<CcsFundAccount> getSelectedFundList() {
        return this.selectedFundList;
    }

    public void setSelectedFundList(List<CcsFundAccount> selectedFundList) {
        this.selectedFundList = selectedFundList;
    }
}

