/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.api.trade.ITradePushApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.notice.NoticeFactory;
import cms.tmx.javafx.MxModel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class SubMng
extends MxModel {
    @Inject
    private MEventService es;
    @Inject
    private ITradePushApi tradePush;
    @Inject
    private NoticeFactory nf;
    @Inject
    private ScheduledExecutorService exe;
    @Inject
    private MxAlert alert;
    private boolean subbed = false;
    private static final int SUB_RETRY_INTERVAL = 3000;

    @PostConstruct
    private void init() {
        this.es.subscribe("stage.after.login", event -> this.afterLogin(event));
        this.es.subscribe(this.tradePush.getItemPushTopic(), event -> this.onNotice(event));
        this.es.subscribe("server.hb.reconnected", event -> this.onReconnected());
        this.es.subscribe("requery_data", event -> this.onReconnected());
    }

    private void afterLogin(MEvent event) {
        this.subTrade();
    }

    private void onReconnected() {
        this.logger.info("[SubMng] server hb reconnected");
        this.subbed = false;
        this.subTrade();
    }

    private synchronized void subTrade() {
        block10: {
            if (this.subbed) {
                return;
            }
            try {
                try {
                    this.tradePush.subscribe();
                    this.logger.info("SubManager: trade sub OK");
                    this.subbed = true;
                }
                catch (MException e) {
                    if (e.getCode() == 3100) {
                        this.logger.error("\u8ba2\u9605\u8fd4\u56de3100\uff0c\u89e6\u53d1\u91cd\u65b0\u767b\u5f55", (Throwable)e);
                        Platform.runLater(() -> {
                            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u91cd\u65b0\u8ba2\u9605\u4ea4\u6613\u63a8\u9001\u5931\u8d25\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\u624d\u80fd\u6b63\u5e38\u4f7f\u7528\u63a8\u9001\u3002")) {
                                Platform.exit();
                            }
                        });
                    }
                    this.logger.error("[SubMng] sub trade push failed", (Throwable)e);
                    if (!this.subbed) {
                        this.exe.schedule(() -> this.subTrade(), 3000L, TimeUnit.MILLISECONDS);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (!this.subbed) {
                    this.exe.schedule(() -> this.subTrade(), 3000L, TimeUnit.MILLISECONDS);
                }
                throw throwable;
            }
            if (!this.subbed) {
                this.exe.schedule(() -> this.subTrade(), 3000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void onNotice(MEvent event) {
        PMisc.Notice pNotice = (PMisc.Notice)event.getObj(PMisc.Notice.class);
        MxNotice notice = this.nf.createNotice(pNotice);
        MEvent ePush = new MEvent();
        if (notice != null) {
            ePush.setId(event.getId());
            ePush.setObj((Object)notice);
        }
        ePush.putStr("push_type", (Object)pNotice.getEventCode());
        this.es.postEvent("server.sub", ePush);
    }
}

