/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SubSecAccount;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IPortfolioService;
import cms.tmx.query.current.models.CcsPortfPositionModel;
import cms.tmx.trade.views.PositionTransferDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PositionTransferModel {
    private static final Logger logger = LogManager.getLogger(PositionTransferDialog.class);
    private ObservableList<String> portfolios = FxUtils.newList();
    private ObservableList<String> portfoliosDest = FxUtils.newList();
    private Map<String, Portfolio> mapPort = new HashMap<String, Portfolio>();
    private ObservableList<String> accounts = FxUtils.newList();
    private ObservableList<String> accountList = FxUtils.newList();
    private Map<String, Account> mapAcc = new HashMap<String, Account>();
    @Inject
    private IPortfolioService portfolioMng;
    @Inject
    private IAccountService accountService;
    @Inject
    private IPortfolioApi portApi;
    @Inject
    private CcsPortfPositionModel posiModel;
    @Inject
    private ISecAccountApi secAcctApi;
    @Inject
    private IFundAccountApi fundAcctApi;
    private Party party;
    private Account accntSelected = null;
    private String mktGrp = null;

    public void queryPortfolio() {
        try {
            List list = this.portfolioMng.getPortfoliosByParty(this.party.getId());
            list.forEach(portf -> {
                Portfolio portfolio = this.mapPort.put(portf.getName(), (Portfolio)portf);
            });
            this.portfolios.addAll(this.mapPort.keySet());
            this.portfoliosDest.addAll(this.mapPort.keySet());
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u673a\u6784\u67e5\u6295\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void queryAccnt() {
        try {
            LinkedList list = new LinkedList();
            list.addAll(this.accountService.getAccountListByParty(this.party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll(this.accountService.getAccountListByParty(this.party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            list.forEach(accnt -> {
                Account account = this.mapAcc.put(accnt.getInvestorId(), (Account)accnt);
            });
            this.accounts.addAll(this.mapAcc.keySet());
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u4e00\u7ea7\u8d26\u6237\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void setFund(String portName, String portNameDest) throws MException {
        this.accountList.clear();
        Portfolio port = this.getMapPort().get(portName);
        if (port == null) {
            return;
        }
        ArrayList<String> listParent = new ArrayList<String>();
        List details = this.portApi.getAccntsByPortfolioIds(port.getId());
        for (PPortfolio.PortAccntAssignDetails detail : details) {
            if (detail.getAccntType() != 2 || detail.getAssignStatus() != 1) continue;
            listParent.add(detail.getParentId());
        }
        Portfolio portDest = this.getMapPort().get(portNameDest);
        if (portDest == null) {
            for (String investorId : this.getAccounts()) {
                Account acc = this.getMapAcc().get(investorId);
                if (!listParent.contains(acc.getId())) continue;
                this.getAccountList().add((Object)investorId);
            }
            return;
        }
        ArrayList<String> listParentDest = new ArrayList<String>();
        List detailsDest = this.portApi.getAccntsByPortfolioIds(portDest.getId());
        for (PPortfolio.PortAccntAssignDetails detail : detailsDest) {
            if (detail.getAccntType() != 2 || detail.getAssignStatus() != 1) continue;
            listParentDest.add(detail.getParentId());
        }
        for (String investorId : this.getAccounts()) {
            Account acc = this.getMapAcc().get(investorId);
            if (!listParent.contains(acc.getId()) || !listParentDest.contains(acc.getId())) continue;
            this.getAccountList().add((Object)investorId);
        }
    }

    public List<SubSecAccount> getSubSecAccounts(Account accnt, String port, String currency) {
        PAccount.SubSecAccnt.Builder newBuilder = PAccount.SubSecAccnt.newBuilder();
        newBuilder.setExtAccntId(String.valueOf(accnt.getInvestorId()) + "_" + currency);
        newBuilder.setIsZeroAccnt(1);
        List listTemp = new ArrayList();
        try {
            listTemp = this.secAcctApi.getSubSecAccounts(this.mktGrp, newBuilder.build());
        }
        catch (MException e3) {
            e3.printStackTrace();
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8bc1\u5238\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        newBuilder = PAccount.SubSecAccnt.newBuilder();
        String portId = this.getMapPort().get(port).getId();
        newBuilder.setPortfolioId(portId);
        newBuilder.setExtAccntId(String.valueOf(accnt.getInvestorId()) + "_" + currency);
        List listPort = new ArrayList();
        try {
            listPort = this.secAcctApi.getSubSecAccounts(this.mktGrp, newBuilder.build());
        }
        catch (MException e3) {
            e3.printStackTrace();
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8bc1\u5238\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        ArrayList<SubSecAccount> listBoth = new ArrayList<SubSecAccount>();
        for (PAccount.SubSecAccnt sub : listTemp) {
            for (PAccount.SubSecAccnt sec : listPort) {
                if (!sub.getInvestorSecId().equals(sec.getInvestorSecId())) continue;
                SubSecAccount s = new SubSecAccount();
                s.update((Object)sec);
                listBoth.add(s);
            }
        }
        return listBoth;
    }

    public List<SubSecAccount> getSubSecAccounts(String portSrc, String portDest, String currency) {
        PAccount.SubSecAccnt.Builder newBuilder = PAccount.SubSecAccnt.newBuilder();
        String portId = this.getMapPort().get(portSrc).getId();
        newBuilder.setPortfolioId(portId);
        newBuilder.setExtAccntId(String.valueOf(this.accntSelected.getInvestorId()) + "_" + currency);
        List listSrc = new ArrayList();
        try {
            listSrc = this.secAcctApi.getSubSecAccounts(this.mktGrp, newBuilder.build());
        }
        catch (MException e3) {
            e3.printStackTrace();
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8bc1\u5238\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        newBuilder = PAccount.SubSecAccnt.newBuilder();
        portId = this.getMapPort().get(portDest).getId();
        newBuilder.setPortfolioId(portId);
        newBuilder.setExtAccntId(String.valueOf(this.accntSelected.getInvestorId()) + "_" + currency);
        List listDest = new ArrayList();
        try {
            listDest = this.secAcctApi.getSubSecAccounts(this.mktGrp, newBuilder.build());
        }
        catch (MException e3) {
            e3.printStackTrace();
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8bc1\u5238\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        ArrayList<SubSecAccount> listBoth = new ArrayList<SubSecAccount>();
        for (PAccount.SubSecAccnt sub : listSrc) {
            for (PAccount.SubSecAccnt sec : listDest) {
                if (!sub.getInvestorSecId().equals(sec.getInvestorSecId())) continue;
                SubSecAccount s = new SubSecAccount();
                s.update((Object)sec);
                listBoth.add(s);
            }
        }
        return listBoth;
    }

    public synchronized List<CcsPortfPosition> getPosition(String portId, List<SubSecAccount> subSecAccounts) {
        ArrayList<CcsPortfPosition> list = new ArrayList<CcsPortfPosition>();
        for (SubSecAccount sec : subSecAccounts) {
            if (sec == null || sec.getInvestorSecId().equals("\u5168\u9009")) continue;
            PAccount.SubSecAccnt.Builder newBuilder = PAccount.SubSecAccnt.newBuilder();
            newBuilder.setExtSecAccntId(sec.getExtSecAccntId());
            if (portId.isEmpty()) {
                newBuilder.setIsZeroAccnt(1);
            } else {
                newBuilder.setPortfolioId(portId);
            }
            List listTemp = new ArrayList();
            try {
                listTemp = this.secAcctApi.getSubSecAccounts(this.mktGrp, newBuilder.build());
            }
            catch (MException e3) {
                e3.printStackTrace();
                logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
            }
            if (listTemp.size() == 0) continue;
            String subSecAccntId = "";
            for (PAccount.SubSecAccnt sub : listTemp) {
                if (!sub.getPortfolioId().equals(portId)) continue;
                subSecAccntId = sub.getSubSecAccntId();
            }
            List listTmp = new ArrayList();
            int i = 0;
            while (i <= 1) {
                listTmp.clear();
                listTmp = i < 1 ? this.posiModel.getPositionByFund("", subSecAccntId, this.mktGrp) : this.posiModel.getPositionByFund("", String.valueOf(subSecAccntId) + "_rs", this.mktGrp);
                list.addAll(listTmp);
                ++i;
            }
        }
        return list;
    }

    public PAccount.ExtFundAccnt getExtFundAccnt(Account account, String mktGrp, String currency) {
        PAccount.ExtFundAccnt accnt = null;
        try {
            accnt = this.fundAcctApi.getFundAccount(account.getId(), mktGrp, currency);
        }
        catch (MException e1) {
            e1.printStackTrace();
            logger.error("\u6839\u636e\u4e00\u7ea7\u8d26\u53f7\u67e5\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
        }
        return accnt;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public ObservableList<String> getPortfolios() {
        return this.portfolios;
    }

    public void setPortfolios(ObservableList<String> portfolios) {
        this.portfolios = portfolios;
    }

    public ObservableList<String> getPortfoliosDest() {
        return this.portfoliosDest;
    }

    public void setPortfoliosDest(ObservableList<String> portfoliosDest) {
        this.portfoliosDest = portfoliosDest;
    }

    public Map<String, Portfolio> getMapPort() {
        return this.mapPort;
    }

    public void setMapPort(Map<String, Portfolio> mapPort) {
        this.mapPort = mapPort;
    }

    public Map<String, Account> getMapAcc() {
        return this.mapAcc;
    }

    public void setMapAcc(Map<String, Account> mapAcc) {
        this.mapAcc = mapAcc;
    }

    public ObservableList<String> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(ObservableList<String> accounts) {
        this.accounts = accounts;
    }

    public ObservableList<String> getAccountList() {
        return this.accountList;
    }

    public void setAccountList(ObservableList<String> accountList) {
        this.accountList = accountList;
    }

    public Account getAccntSelected() {
        return this.accntSelected;
    }

    public void setAccntSelected(Account accntSelected) {
        this.accntSelected = accntSelected;
    }

    public String getMktGrp() {
        return this.mktGrp;
    }

    public void setMktGrp(String mktGrp) {
        this.mktGrp = mktGrp;
    }
}

