/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cmx.tmx.data.IMarketDataMng;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsTradeModel
implements ITradeModel {
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    protected DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private StringProperty tradeType = new SimpleStringProperty();
    private final int INIT_UNIT = 100;
    protected static final Logger logger = LogManager.getLogger(CcsTradeModel.class);
    @Inject
    private MObjFactory of;
    protected MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected CcsAccountDistributionModel accTreeModel;
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;

    protected void create() {
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostConstruct
    public void init() {
        this.create();
        this.getAccDisModel().securityProperty().bind((ObservableValue)this.security);
        this.mktItem = this.mktMng.createItem(10);
        this.getAccDisModel().buyProperty().bind((ObservableValue)this.buy);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = MxNodeFactory.create((String)"trade_count_stg", (String)"1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = MxNodeFactory.createNew((String)"acc_dist_mode", (String)"1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = MxNodeFactory.create((String)"price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.create((String)"acc_count_filter", (String)"1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        ((CcsAccountDistribution)this.getAccDisModel().getRoot().getValue()).countProperty().bind((ObservableValue)this.count);
        this.price.addListener(ob -> this.onPriceChange());
        this.getAccDisModel().priceProperty().bind((ObservableValue)this.price);
        this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public void onSecChange() {
        this.setCount(0L);
        this.setPrice(0.0);
        this.mktItem.setRefItem(this.getValidRef());
        this.mktMng.dye(this.mktItem);
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.getCount() == 0L) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
    }

    private void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (!this.isLimitPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        } else {
            this.setPrice(0.0);
        }
        this.calCountDistribution();
    }

    protected void onPriceChange() {
        this.filterAcc();
        if (this.isCountOrSell()) {
            this.getAccDisModel().calCanBuy();
            return;
        }
        if (this.getPrice() == 0.0) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
            return;
        }
        if (this.getCountStg().getRaw().equals("5")) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            return;
        }
        this.calCountDistribution();
    }

    private void onMoneyChange() {
        if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        long total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    protected void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanBuy();
        this.getAccDisModel().calAccountCanSell();
        this.getAccDisModel().filterAcc();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized ObservableList<Boolean> submit(TreeItem<CcsAccountDistribution> root) {
        ObservableList returnList = FxUtils.newList();
        for (CcsSingleEntrust en : this.getEntrustList()) {
            try {
                en.submit();
                returnList.add((Object)true);
            }
            catch (MException e) {
                returnList.add((Object)false);
                logger.error("submit failed", (Throwable)e);
            }
        }
        return returnList;
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public boolean isLimitPrice() {
        return this.getPriceStg().is(Integer.toString(50));
    }

    public String getLimitOrMarket() {
        return this.isLimitPrice() ? "\u9650\u4ef7" : "\u5e02\u4ef7";
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    protected void changeMarketPriceType() {
        MxNode node = this.getPriceStg();
        if (this.isBond()) {
            this.initPriceType(node);
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initPriceType(node);
        }
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
    }

    private MxNode shMarket(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("SH1");
        node.addNode("SH2");
        return node;
    }

    private MxNode szMarket(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        return node;
    }

    protected void countStgBuy(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            this.removeOthers(node, "1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        if (this.mktItem.getRefItem().getType().isEmpty()) {
            return false;
        }
        if (this.getTradeType().equals("CCS")) {
            return true;
        }
        return this.mktItem.getRefItem().getType().equals(this.getTradeType());
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        if (this.getTradeType().equals("CCS")) {
            return item;
        }
        if (item.getType().equals(this.getTradeType())) {
            return item;
        }
        return null;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    protected int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    protected void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        MxNode nodeDistStg = this.getDistStg();
        if (this.isBuy()) {
            this.countStgBuy(nodeCountStg);
            this.distStgBuy(nodeDistStg);
        } else {
            this.countStgSell(nodeCountStg);
            this.distStgSell(nodeDistStg);
        }
        if (!this.isLimitPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        this.filterAcc();
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    @Override
    public CcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    public CcsAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    @Override
    public final StringProperty securityProperty() {
        return this.security;
    }

    @Override
    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    @Override
    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    @Override
    public final StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public final String getName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    @Override
    public DoubleProperty priceProperty() {
        return this.price;
    }

    @Override
    public double getPrice() {
        return this.priceProperty().get();
    }

    @Override
    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    @Override
    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    @Override
    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    @Override
    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    @Override
    public LongProperty countProperty() {
        return this.count;
    }

    @Override
    public long getCount() {
        return this.countProperty().get();
    }

    @Override
    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().clearSelect();
        this.getAccDisModel().selectSecAcc(secAcc, mkt);
    }

    protected void setAccDistModel(CcsAccountDistributionModel accDistModel) {
        this.accTreeModel = accDistModel;
    }

    public List<CcsSingleEntrust> getEntrustList() {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                CcsSingleEntrust en;
                block29: {
                    block28: {
                        en = this.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                        en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                        en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                        en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                        en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                        en.setSide(this.buy.get() ? 49 : 50);
                        en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                        en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                        en.setMarket(this.mktItem.getRefItem().getMarket());
                        en.setSecType(this.mktItem.getRefItem().getType());
                        en.setSubSecType(this.mktItem.getRefItem().getSubSecurityType());
                        en.setPrice(this.getPrice());
                        if (!this.getPriceStg().getRaw().equals("50")) break block28;
                        en.setOrderType(50);
                        break block29;
                    }
                    en.setOrderType(49);
                    switch (this.getPriceStg().getRaw()) {
                        case "SH1": {
                            en.setMaxLevels(5);
                            en.setTif(48);
                            break;
                        }
                        case "SH2": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SZ1": {
                            en.setTif(48);
                            en.setMaxLevels(1);
                            break;
                        }
                        case "SZ2": {
                            en.setTif(48);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ3": {
                            en.setTif(51);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ4": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SZ5": {
                            en.setTif(52);
                            en.setMaxLevels(0);
                            break;
                        }
                    }
                }
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setSecName(this.mktItem.getRefItem().getName());
                en.setAppID("010");
                if (this.isAutoSlice()) {
                    this.entrustSplit.setRefItem(this.getValidRef());
                    List<CcsSingleEntrust> splitList = this.entrustSplit.split(en, this.getSliceSize());
                    enList.addAll(splitList);
                    continue;
                }
                enList.add(en);
            }
        }
        return enList;
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }
}

