/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cmx.tmx.data.IMarketDataMng;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsTradeDialogMng {
    private static final Logger logger = LogManager.getLogger(CcsTradeDialogMng.class);
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private StringProperty securityBuy = new SimpleStringProperty("");
    private StringProperty nameBuy = new SimpleStringProperty("");
    private DoubleProperty priceBuy = new SimpleDoubleProperty();
    private LongProperty countBuy = new SimpleLongProperty();
    private LongProperty canBuy = new SimpleLongProperty();
    private StringProperty securitySell = new SimpleStringProperty("");
    private StringProperty nameSell = new SimpleStringProperty("");
    private DoubleProperty priceSell = new SimpleDoubleProperty();
    private LongProperty countSell = new SimpleLongProperty();
    private ObjectProperty<CcsFundAccount> fundAcct = new SimpleObjectProperty((Object)new CcsFundAccount());
    private ObjectProperty<CcsPosition> position = new SimpleObjectProperty((Object)new CcsPosition());
    protected MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(10);
        this.priceBuy.addListener(ob -> this.onPriceChange());
        ((CcsFundAccount)this.fundAcct.getValue()).availableProperty().addListener(ob -> this.onMoneyChange());
    }

    private void onMoneyChange() {
        if (this.fundAcct == null) {
            this.setCanBuy(0L);
        }
        if (this.getPriceBuy() != 0.0) {
            this.setCanBuy((int)(((CcsFundAccount)this.fundAcct.getValue()).getAvailable() / this.getPriceBuy() / 100.0) * 100);
        }
    }

    public void onPriceChange() {
        if (this.fundAcct == null) {
            this.setCanBuy(0L);
        }
        if (this.getPriceBuy() != 0.0) {
            this.setCanBuy((long)(((CcsFundAccount)this.fundAcct.getValue()).getAvailable() / this.getPriceBuy() / 100.0) * 100L);
        }
    }

    public void onSecChange() {
        this.mktMng.dye(this.mktItem);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null) {
            return item;
        }
        return null;
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public final StringProperty securityBuyProperty() {
        return this.securityBuy;
    }

    public final String getSecurityBuy() {
        return (String)this.securityBuyProperty().get();
    }

    public final void setSecurityBuy(String securityBuy) {
        this.securityBuyProperty().set((Object)securityBuy);
    }

    public final StringProperty nameBuyProperty() {
        return this.nameBuy;
    }

    public final String getNameBuy() {
        return (String)this.nameBuyProperty().get();
    }

    public final void setNameBuy(String nameBuy) {
        this.nameBuyProperty().set((Object)nameBuy);
    }

    public final DoubleProperty priceBuyProperty() {
        return this.priceBuy;
    }

    public final double getPriceBuy() {
        return this.priceBuyProperty().get();
    }

    public final void setPriceBuy(double priceBuy) {
        this.priceBuyProperty().set(priceBuy);
    }

    public final LongProperty countBuyProperty() {
        return this.countBuy;
    }

    public final long getCountBuy() {
        return this.countBuyProperty().get();
    }

    public final void setCountBuy(long countBuy) {
        this.countBuyProperty().set(countBuy);
    }

    public final StringProperty securitySellProperty() {
        return this.securitySell;
    }

    public final String getSecuritySell() {
        return (String)this.securitySellProperty().get();
    }

    public final void setSecuritySell(String securitySell) {
        this.securitySellProperty().set((Object)securitySell);
    }

    public final StringProperty nameSellProperty() {
        return this.nameSell;
    }

    public final String getNameSell() {
        return (String)this.nameSellProperty().get();
    }

    public final void setNameSell(String nameSell) {
        this.nameSellProperty().set((Object)nameSell);
    }

    public final DoubleProperty priceSellProperty() {
        return this.priceSell;
    }

    public final double getPriceSell() {
        return this.priceSellProperty().get();
    }

    public final void setPriceSell(double priceSell) {
        this.priceSellProperty().set(priceSell);
    }

    public final LongProperty countSellProperty() {
        return this.countSell;
    }

    public final long getCountSell() {
        return this.countSellProperty().get();
    }

    public final void setCountSell(long countSell) {
        this.countSellProperty().set(countSell);
    }

    public final LongProperty canBuyProperty() {
        return this.canBuy;
    }

    public final long getCanBuy() {
        return this.canBuyProperty().get();
    }

    public final void setCanBuy(long canBuy) {
        this.canBuyProperty().set(canBuy);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final ObjectProperty<CcsFundAccount> fundAcctProperty() {
        return this.fundAcct;
    }

    public final CcsFundAccount getFundAcct() {
        return (CcsFundAccount)this.fundAcctProperty().get();
    }

    public final void setFundAcct(CcsFundAccount fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }

    public final ObjectProperty<CcsPosition> positionProperty() {
        return this.position;
    }

    public final CcsPosition getPosition() {
        return (CcsPosition)this.positionProperty().get();
    }

    public final void setPosition(CcsPosition position) {
        this.positionProperty().set((Object)position);
    }
}

