/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IPostService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.HkwolunPositionModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsAccountDistributionModel
extends MxModel {
    @Inject
    protected CcsAccountMap accMng;
    @Inject
    protected IFundAccountService fundAccMng;
    @Inject
    protected IPostService postMng;
    @Inject
    protected CcsPositionModel posModel;
    @Inject
    protected HkwolunPositionModel hkPosModel;
    public MxTreeList<CcsAccountDistribution> accMxList;
    public Map<String, MxTreeList<CcsAccountDistribution>> mapSecDisMxList;
    protected TreeItem<CcsAccountDistribution> root = new TreeItem((Object)new CcsAccountDistribution());
    private final int INIT_UNIT = 100;
    private BooleanProperty showCanBuy = new SimpleBooleanProperty(true);
    private LongProperty canBuy = new SimpleLongProperty();
    protected BooleanProperty buy = new SimpleBooleanProperty(true);
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private StringProperty accFilterStg = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty percent = new SimpleDoubleProperty();
    private IntegerProperty unit = new SimpleIntegerProperty(100);
    private IntegerProperty unitConvert = new SimpleIntegerProperty(1);
    private boolean countValid = true;
    protected Map<CcsFundAccount, List<SecAccount>> mapAccount;
    protected final int MAP_CAP = 100;
    protected IntegerProperty effectiveSecAccCount = new SimpleIntegerProperty();
    protected IntegerProperty customSecAccCount = new SimpleIntegerProperty();
    protected StringProperty searchSec = new SimpleStringProperty("");
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private BooleanProperty repo = new SimpleBooleanProperty(false);
    private boolean hkwolun = false;
    private boolean hk = false;
    protected RefItem refItem;
    private BooleanProperty single = new SimpleBooleanProperty(false);
    private BooleanProperty normal = new SimpleBooleanProperty(true);
    protected Map<String, Long> mapQuantiy = new HashMap<String, Long>();
    protected Map<String, Integer> mapWeight = new HashMap<String, Integer>();
    private IntegerProperty num = new SimpleIntegerProperty(0);
    private DoubleProperty buyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty capital = new SimpleDoubleProperty(0.0);
    private DoubleProperty floatPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty realPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalPl = new SimpleDoubleProperty(0.0);
    @Inject
    protected ExecutorService exe;
    protected InvalidationListener lstFund = ob -> this.onFundChange();
    protected InvalidationListener lstPosition = ob -> Platform.runLater(() -> {
        this.calAccountCanSell();
        this.filterAcc();
        this.calCanBuy();
    });
    protected Predicate<CcsAccountDistribution> pdShow = dist -> dist.isShow();

    public void setRefItem(RefItem item) {
        this.refItem = item;
    }

    public RefItem getRefItem() {
        return this.refItem;
    }

    public TreeItem<CcsAccountDistribution> getRoot() {
        return this.root;
    }

    public synchronized TreeItem<CcsAccountDistribution> create() throws MException {
        this.getPosModel().changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstPosition));
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.queryPostition();
        this.buy.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    protected void createTree() throws MException {
        ((CcsAccountDistribution)this.root.getValue()).setSelected(this.isSelected());
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new ConcurrentHashMap<String, MxTreeList<CcsAccountDistribution>>(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, (ObservableList<TreeItem<CcsAccountDistribution>>)this.root.getChildren(), accList);
        if (this.getAccountMap() == null) {
            return;
        }
        this.mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(this.getAccountMap());
        HashSet<CcsFundAccount> accSet = new HashSet<CcsFundAccount>(this.mapAccount.keySet());
        for (FundAccount fundAccount : accSet) {
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            CcsAccountDistribution accDst = new CcsAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.setWeight(this.mapWeight.get(fundAcc.getExtAccntId()) == null ? 0 : this.mapWeight.get(fundAcc.getExtAccntId()));
            accDst.setCount(this.mapQuantiy.get(fundAcc.getExtAccntId()) == null ? 0L : this.mapQuantiy.get(fundAcc.getExtAccntId()));
            accDst.setAccntName(fundAcc.getAccountName());
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : this.mapAccount.get(fundAccount)) {
                boolean isHkAccnt;
                if ("NEEQ".equals(secAcc.getExchange().getRaw()) || "XOTC".equals(secAcc.getExchange().getRaw())) continue;
                CcsAccountDistribution secDst = new CcsAccountDistribution();
                boolean bl = isHkAccnt = "SHSC".equals(secAcc.getExchange().getRaw()) || "SZSC".equals(secAcc.getExchange().getRaw());
                if (this.isHkwolun() && isHkAccnt) {
                    secAccList.add(secDst);
                } else if (!this.isHkwolun() && !isHkAccnt) {
                    secAccList.add(secDst);
                }
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setAccParentId(fundAcc.getParentId());
                secDst.setWeight(this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 1 : this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()));
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setSelected(this.isSelected());
                secDst.selectedProperty().addListener(ob -> this.calCount());
                secDst.setCount(this.mapQuantiy.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 0L : this.mapQuantiy.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()));
            }
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem<CcsAccountDistribution>)((TreeItem)this.root.getChildren().get(accList.size() - 1)), (ObservableList<TreeItem<CcsAccountDistribution>>)((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.checkSingle();
    }

    protected void checkSingle() {
        this.setSingle(this.accMxList.getObList().size() == 1);
        if (!this.isSingle()) {
            return;
        }
        for (MxTreeList<CcsAccountDistribution> secMxList : this.mapSecDisMxList.values()) {
            int sh = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHG")).size();
            int sz = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHE")).size();
            this.setSingle(sh < 2);
            if (!this.isSingle()) {
                return;
            }
            this.setSingle(sz < 2);
            if (this.isSingle()) continue;
            return;
        }
        this.mapSecDisMxList.values().forEach(each -> each.getOrList().forEach(sec -> sec.setSelected(true)));
        this.accMxList.getObList().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(true));
    }

    public synchronized void filterAcc() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        if (this.refItem == null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
            this.showAll(this.accMxList);
        } else {
            this.filterSecAcc();
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.selectSingle();
        this.calCount();
    }

    private void selectSingle() {
        try {
            int accShow = 0;
            CcsAccountDistribution acc = null;
            for (CcsAccountDistribution dist : this.accMxList.getOrList()) {
                if (!dist.isShow()) continue;
                ++accShow;
                acc = dist;
            }
            if (accShow != 1) {
                return;
            }
            CcsAccountDistribution lastShowSecDist = null;
            int secShow = 0;
            for (CcsAccountDistribution secDist : this.mapSecDisMxList.get(acc.getAcc().getExtAccntId()).getOrList()) {
                if (!secDist.isShow()) continue;
                if (++secShow >= 1) {
                    return;
                }
                lastShowSecDist = secDist;
            }
            if (secShow == 1) {
                acc.setSelected(true);
                lastShowSecDist.setSelected(true);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u8d26\u53f7\u65f6\u9ed8\u8ba4\u52fe\u9009\u51fa\u9519:", (Throwable)e);
        }
    }

    protected void filterSecAcc() {
        String exchange = this.refItem.getMarket();
        if ("".equals(exchange)) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
        } else {
            this.mapSecDisMxList.keySet().forEach(each -> this.showSec(this.mapSecDisMxList.get(each), exchange));
        }
    }

    protected void filterFundAcc() {
        this.showAll(this.accMxList);
        this.mapSecDisMxList.keySet().forEach(each -> {
            if (this.mapSecDisMxList.get(each).getObList().size() == 0) {
                this.accMxList.getOrList().forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        accEach.setShow(false);
                    }
                });
            }
        });
        this.accMxList.filter(this.pdShow);
    }

    protected void calEffectiveSecAccCount() {
        int count = 0;
        for (TreeItem item : this.root.getChildren()) {
            count += item.getChildren().size();
        }
        this.setEffectiveSecAccCount(count);
    }

    protected void onCtmSecAccCountChange() {
        this.filterAcc();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.calCount();
    }

    protected void filterCtmSec() {
        int count = this.getCustomSecAccCount();
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (CcsAccountDistribution dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getExtAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                int size = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow()).size();
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                if (count <= 0) {
                    showList.forEach(each -> each.setShow(false));
                } else if (count - size < 0) {
                    int i = count;
                    while (i < size) {
                        ((CcsAccountDistribution)showList.get(i)).setShow(false);
                        ++i;
                    }
                }
                count -= size;
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    protected void filterSearchSec() {
        String search = this.getSearchSec();
        if (StringUtils.isEmpty((String)search)) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (CcsAccountDistribution dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getExtAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                showList.forEach(each -> {
                    if (!each.getSecAcc().getInverstorSecId().contains(search)) {
                        each.setShow(false);
                    }
                });
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    protected void onEfSecAccCountChange() {
        if (this.getAccFilterStg().equals("1")) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
            return;
        }
        if (this.getEffectiveSecAccCount() < this.getCustomSecAccCount()) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
        }
    }

    protected void showSec(MxTreeList<CcsAccountDistribution> distList, String market) {
        for (CcsAccountDistribution dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals(market)) {
                dist.setShow(false);
                continue;
            }
            if (!this.isBuy() && dist.getCanSell() == 0L && !this.isRepo()) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    protected void showAll(MxTreeList<CcsAccountDistribution> distList) {
        if (distList.getOrList() == null) {
            return;
        }
        distList.getOrList().forEach(each -> each.setShow(true));
        distList.filter(this.pdShow);
    }

    protected void updateFund() {
        int num = 0;
        double buyCostAmt = 0.0;
        double capital = 0.0;
        double floatPL = 0.0;
        double realPl = 0.0;
        double totalPl = 0.0;
        for (CcsAccountDistribution each : this.accMxList.getOrList()) {
            FundAccount acc = this.fundAccMng.getFundAccount(each.getAcc().getExtAccntId(), "CCS");
            if (acc == null) continue;
            each.getAcc().update(CcsFundAccount.class.cast(acc));
            if (this.getPrice() > 0.0 && this.getUnit() != 0) {
                long canBuy = (long)(this.getAvailable(each) / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                each.setCanBuy(canBuy);
            } else {
                each.setCanBuy(0L);
            }
            each.setBuyCostAmt(acc.getBuyCostAmt());
            each.setCapitalization(acc.getCapitalization());
            each.setFloatPl(acc.getFloatPl());
            each.setRealPl(acc.getRealPl());
            each.setTotalPl(acc.getTotalPl());
            if (!each.isSelected()) continue;
            capital += acc.getCapitalization();
            buyCostAmt += acc.getBuyCostAmt();
            floatPL += acc.getFloatPl();
            realPl += acc.getRealPl();
            totalPl += acc.getTotalPl();
            ++num;
        }
        int numP = num;
        double buyCostAmtP = buyCostAmt;
        double capitalP = capital;
        double floatPLP = floatPL;
        double realPlP = realPl;
        double totalPlP = totalPl;
        Platform.runLater(() -> {
            this.setNum(numP);
            this.setBuyCostAmt(buyCostAmtP);
            this.setCapital(capitalP);
            this.setFloatPL(floatPLP);
            this.setRealPl(realPlP);
            this.setTotalPl(totalPlP);
        });
    }

    public void refresh() {
        this.fundAccMng.queryFundAccountList();
        this.getPosModel().query();
    }

    protected void queryPostition() {
        this.exe.execute(() -> this.getPosModel().initQuery());
    }

    public void onFundChange() {
        if (this.accMxList == null || this.accMxList.getOrList() == null) {
            return;
        }
        try {
            this.updateFund();
            Platform.runLater(() -> this.calCanBuy());
        }
        catch (Exception e) {
            this.logger.error("\u5237\u65b0\u73b0\u8d27\u8d44\u91d1\u8d26\u53f7\u53ca\u8ba1\u7b97\u53ef\u4e70\u51fa\u9519", (Throwable)e);
        }
    }

    public int getSelectedNum() {
        int i = 0;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem subItem : item.getChildren()) {
                if (!((CcsAccountDistribution)subItem.getValue()).isSelected()) continue;
                ++i;
            }
        }
        return i;
    }

    public List<CcsAccountDistribution> getValidSecAcc() {
        LinkedList<CcsAccountDistribution> list = new LinkedList<CcsAccountDistribution>();
        int totalcount = 0;
        this.countValid = true;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem each : item.getChildren()) {
                if (!((CcsAccountDistribution)each.getValue()).isSelected() || ((CcsAccountDistribution)each.getValue()).getCount() == 0L) continue;
                list.add((CcsAccountDistribution)each.getValue());
                totalcount = (int)((long)totalcount + ((CcsAccountDistribution)each.getValue()).getCount());
            }
        }
        if (totalcount == 0) {
            this.countValid = false;
        }
        return list;
    }

    protected void onAccSelectChange() {
        this.calSelectedFundAcc();
        this.calCount();
        this.calCanBuy();
    }

    protected int calSelectedFundAcc() {
        int num = this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).size();
        if (num != 1) {
            this.setShowCanBuy(false);
        } else if (this.isRepo() && !this.isBuy() || !this.isRepo() && this.isBuy()) {
            this.setShowCanBuy(true);
        } else if (this.isRepo() && this.isBuy() || !this.isRepo() && !this.isBuy()) {
            int secNum = ((TreeItem)this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).get(0)).getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).size();
            this.setShowCanBuy(secNum == 1);
        } else {
            this.setShowCanBuy(false);
        }
        return num;
    }

    public void calCanBuy() {
        if (this.calSelectedFundAcc() != 1 && !"6".equals(this.getDistStg())) {
            this.setCanBuy(0L);
            return;
        }
        if (this.calSelectedFundAcc() == 0) {
            this.setCanBuy(0L);
            return;
        }
        TreeItem item = (TreeItem)this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).get(0);
        if (item == null) {
            return;
        }
        if (this.isBuy()) {
            if (this.getRefItem() != null && this.isRepo()) {
                this.calCanBuyByCanStandard((TreeItem<CcsAccountDistribution>)item);
            } else {
                this.calCanBuyByAvailable((TreeItem<CcsAccountDistribution>)item);
            }
        } else if (this.getRefItem() != null && this.isRepo()) {
            this.calCanBuyRepoByAvailable((TreeItem<CcsAccountDistribution>)item);
        } else {
            this.calCanBuyByPosition((TreeItem<CcsAccountDistribution>)item);
        }
    }

    private void calCanBuyByAvailable(TreeItem<CcsAccountDistribution> item) {
        if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
            this.setCanBuy(0L);
            return;
        }
        double availble = this.getAvailable((CcsAccountDistribution)item.getValue());
        long canBuy = (long)(availble / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
        this.setCanBuy(canBuy);
    }

    protected void calCanBuyRepoByAvailable(TreeItem<CcsAccountDistribution> item) {
        double availble = this.getAvailable((CcsAccountDistribution)item.getValue());
        int base = this.refItem.getMarket().equals("XSHG") ? 1000 : 100;
        long canBuy = (long)(availble / (double)base);
        canBuy = this.refItem.getMarket().equals("XSHG") ? canBuy / 100L * 100L : canBuy / 10L * 10L;
        this.setCanBuy(canBuy);
    }

    protected void calCanBuyByPosition(TreeItem<CcsAccountDistribution> item) {
        FilteredList subItemList = item.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
        if (subItemList.size() == 1) {
            long cansell = new Double(this.getPosModel().getCanSell(((CcsAccountDistribution)((TreeItem)subItemList.get(0)).getValue()).getSecAcc(), this.getSecurity())).longValue();
            this.setCanBuy(cansell);
        } else {
            this.setCanBuy(0L);
        }
    }

    private void calCanBuyByCanStandard(TreeItem<CcsAccountDistribution> item) {
        String extAccntId = ((CcsAccountDistribution)item.getValue()).getAcc().getExtAccntId();
        long standerSum = 0L;
        for (CcsAccountDistribution accItem : this.mapSecDisMxList.get(extAccntId).getOrList()) {
            int standerNum = this.getStandard(accItem.getSecAcc());
            accItem.setCanBuy((long)standerNum);
            standerSum += (long)standerNum;
        }
        this.setCanBuy(standerSum);
    }

    private int getStandard(SecAccount secAccount) {
        int count = 0;
        if (this.refItem == null) {
            return count;
        }
        this.getPosModel().getList();
        RepoRefItem item = (RepoRefItem)RepoRefItem.class.cast(this.refItem);
        double canSell = this.getPosModel().getCanSell(secAccount, item.getStdSecId());
        return new Double(canSell).intValue();
    }

    public void calAccountCanSell() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (CcsAccountDistribution subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                long canSell = new Double(this.getPosModel().getCanSell(subItem.getSecAcc(), this.getSecurity())).longValue();
                subItem.setCanSell(canSell);
                if (!subItem.isShow()) continue;
                canSellTotal += canSell;
            }
            for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanSell(canSellTotal);
            }
        }
    }

    public void calAccountCanBuy() {
        for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
            if (this.getPrice() > 0.0 && this.getUnit() > 0) {
                long canBuy = (long)(this.getAvailable(accItem) / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                accItem.setCanBuy(canBuy);
                continue;
            }
            accItem.setCanBuy(0L);
        }
    }

    protected void calCount() {
        for (TreeItem accItem : this.root.getChildren()) {
            int weight = 0;
            for (TreeItem secAccItem : accItem.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                weight += ((CcsAccountDistribution)secAccItem.getValue()).getWeight();
            }
            ((CcsAccountDistribution)accItem.getValue()).setWeight(weight);
        }
        this.changed();
    }

    public long allocateCount() {
        this.clearCount(this.root);
        this.calCanBuy();
        long totalCount = 0L;
        if (this.getCountStg() == null) {
            return 0L;
        }
        if (!this.isNormal()) {
            totalCount = this.calByCount(totalCount);
            return totalCount;
        }
        switch (this.getCountStg()) {
            case "1": {
                totalCount = this.calByCount(totalCount);
                break;
            }
            case "5": {
                totalCount = this.calByMoney(totalCount);
                break;
            }
            case "2": {
                totalCount = this.calByAsset(totalCount);
                break;
            }
            case "3": {
                totalCount = this.calByCanBuy(totalCount);
                break;
            }
            case "4": {
                totalCount = this.calByCanSell(totalCount);
                break;
            }
            default: {
                this.clearCount(this.root);
            }
        }
        if (this.getDistStg().equals("6")) {
            totalCount = this.calByCanSellMax(totalCount);
        }
        return totalCount;
    }

    private long calByCount(long totalCount) {
        totalCount = this.doQuantityAllocate(this.root);
        if (this.getDistStg().equals("3")) {
            return totalCount;
        }
        this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).forEach(each -> this.doQuantityAllocate((TreeItem<CcsAccountDistribution>)each));
        return totalCount;
    }

    private long calByMoney(long totalCount) {
        if (this.getPrice() <= 0.0) {
            this.clearCount(this.root);
            return 0L;
        }
        long count = (long)(this.getMoney() / this.getPrice());
        totalCount = count / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
        totalCount = this.doQuantityAllocate(this.root, totalCount);
        if (this.getDistStg().equals("3")) {
            return totalCount;
        }
        this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false).forEach(each -> this.doQuantityAllocate((TreeItem<CcsAccountDistribution>)each));
        return totalCount;
    }

    private long calByAsset(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false)) {
            CcsAccountDistribution item = (CcsAccountDistribution)each.getValue();
            long count = (long)(item.getAcc().getAssetAmt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            ((CcsAccountDistribution)each.getValue()).setCount(count);
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<CcsAccountDistribution>)each);
        }
        return totalCount;
    }

    protected long calByCanBuy(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false)) {
            CcsAccountDistribution item = (CcsAccountDistribution)each.getValue();
            long count = (long)(item.getAcc().getAvailable() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            ((CcsAccountDistribution)each.getValue()).setCount(count);
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<CcsAccountDistribution>)each);
        }
        return totalCount;
    }

    protected long calByCanSellMax(long totalCount) {
        return 0L;
    }

    protected long calByCanSell(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                CcsAccountDistribution secAccItem = (CcsAccountDistribution)eachSub.getValue();
                long cansell = new Double(this.getPosModel().getCanSell(secAccItem.getSecAcc(), this.getSecurity())).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((CcsAccountDistribution)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    private long doQuantityAllocate(TreeItem<CcsAccountDistribution> parent, long pTotal) {
        int totalWeight = 0;
        long totalCount = pTotal;
        this.clearCount(parent);
        int countAcc = this.getCalChildren(parent).size();
        for (TreeItem ad : this.getCalChildren(parent)) {
            totalWeight += 100 * ((CcsAccountDistribution)ad.getValue()).getWeight();
        }
        long assigned = 0L;
        if (this.getDistStg().equals("3")) {
            return this.doAllocateByMin(parent, totalCount);
        }
        Iterator it = this.getCalChildren(parent).iterator();
        while (it.hasNext()) {
            TreeItem ad = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((CcsAccountDistribution)ad.getValue()).setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (this.getDistStg().equals("1")) {
                target = totalCount / (long)countAcc;
            } else if (this.getDistStg().equals("2") && totalWeight != 0) {
                target = totalCount * (long)((CcsAccountDistribution)ad.getValue()).getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.getUnit());
            if (((String)this.security.get()).startsWith("688") && count < 200L) {
                count = 0L;
            }
            assigned += count;
            ((CcsAccountDistribution)ad.getValue()).setCount(count);
        }
        return assigned;
    }

    protected long doQuantityAllocate(TreeItem<CcsAccountDistribution> parent) {
        return this.doQuantityAllocate(parent, ((CcsAccountDistribution)parent.getValue()).getCount());
    }

    protected long doAllocateByMin(TreeItem<CcsAccountDistribution> parent, long totalCount) {
        long assigned = 0L;
        LinkedList<TreeItem<CcsAccountDistribution>> list = new LinkedList<TreeItem<CcsAccountDistribution>>();
        parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false).forEach(each -> each.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).forEach(subEach -> list.add((TreeItem<CcsAccountDistribution>)subEach)));
        list.sort(new CanSellComparator());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeItem ad2 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((CcsAccountDistribution)ad2.getValue()).setCount(count);
                assigned += count;
                long prCount = ((CcsAccountDistribution)ad2.getParent().getValue()).getCount() + ((CcsAccountDistribution)ad2.getValue()).getCount();
                ((CcsAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
                break;
            }
            if (totalCount - assigned >= ((CcsAccountDistribution)ad2.getValue()).getCanSell()) {
                ((CcsAccountDistribution)ad2.getValue()).setCount(((CcsAccountDistribution)ad2.getValue()).getCanSell());
            } else {
                ((CcsAccountDistribution)ad2.getValue()).setCount(totalCount - assigned);
            }
            long prCount = ((CcsAccountDistribution)ad2.getParent().getValue()).getCount() + ((CcsAccountDistribution)ad2.getValue()).getCount();
            ((CcsAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
            if ((assigned += ((CcsAccountDistribution)ad2.getValue()).getCount()) == totalCount) break;
        }
        return assigned;
    }

    public void clearCount(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setCount(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setCount(0L);
            }
        });
    }

    public void clearCanBuySell(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setCanBuy(0L);
            ((CcsAccountDistribution)each.getValue()).setCanSell(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setCanBuy(0L);
                ((CcsAccountDistribution)sub.getValue()).setCanSell(0L);
            }
        });
    }

    public void clearCanBuy(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setCanBuy(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setCanBuy(0L);
            }
        });
    }

    public void clearSelect() {
        if (this.accMxList != null) {
            this.accMxList.getOrList().forEach(each -> each.setSelected(false));
        }
        if (this.mapSecDisMxList != null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.mapSecDisMxList.get(each).getOrList().forEach(subEach -> subEach.setSelected(false)));
        }
    }

    public void selectSecAcc(String secAcc, String mkt) {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (CcsAccountDistribution sub : this.mapSecDisMxList.get(each).getOrList()) {
                if (!sub.getSecAcc().getExtSecAccntId().equals(secAcc) || !sub.getSecAcc().getExchange().getRaw().equals(mkt)) continue;
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    public void selectAllSecAcc() {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (CcsAccountDistribution sub : this.mapSecDisMxList.get(each).getOrList()) {
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
            }
        });
    }

    protected Boolean hasSelectedChd(TreeItem<CcsAccountDistribution> parent) {
        if (!((CcsAccountDistribution)parent.getValue()).isIsSecAcc() && parent.isLeaf()) {
            return false;
        }
        if (!parent.isLeaf() && parent.getChildren().filtered(each -> ((CcsAccountDistribution)each.getValue()).isSelected()).size() == 0) {
            return false;
        }
        return true;
    }

    private ObservableList<TreeItem<CcsAccountDistribution>> getCalChildren(TreeItem<CcsAccountDistribution> parent) {
        if (this.getDistStg().equals("2")) {
            return parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false && ((CcsAccountDistribution)ad.getValue()).getWeight() != 0);
        }
        return parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<CcsAccountDistribution>)ad) != false);
    }

    public final StringProperty distStgProperty() {
        return this.distStg;
    }

    public final String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public final void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final StringProperty countStgProperty() {
        return this.countStg;
    }

    public final String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public final void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final DoubleProperty moneyProperty() {
        return this.money;
    }

    public final double getMoney() {
        return this.moneyProperty().get();
    }

    public final void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty unitProperty() {
        return this.unit;
    }

    public final int getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final LongProperty canBuyProperty() {
        return this.canBuy;
    }

    public final long getCanBuy() {
        return this.canBuyProperty().get();
    }

    public final void setCanBuy(long canBuy) {
        this.canBuyProperty().set(canBuy);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public Boolean isCountValid() {
        return this.countValid;
    }

    public final BooleanProperty showCanBuyProperty() {
        return this.showCanBuy;
    }

    public final boolean isShowCanBuy() {
        return this.showCanBuyProperty().get();
    }

    public final void setShowCanBuy(boolean showCanBuy) {
        this.showCanBuyProperty().set(showCanBuy);
    }

    public final IntegerProperty unitConvertProperty() {
        return this.unitConvert;
    }

    public final int getUnitConvert() {
        return this.unitConvertProperty().get();
    }

    public final void setUnitConvert(int unitConvert) {
        this.unitConvertProperty().set(unitConvert);
    }

    public final IntegerProperty effectiveSecAccCountProperty() {
        return this.effectiveSecAccCount;
    }

    public final int getEffectiveSecAccCount() {
        return this.effectiveSecAccCountProperty().get();
    }

    public final void setEffectiveSecAccCount(int effectiveSecAccCount) {
        this.effectiveSecAccCountProperty().set(effectiveSecAccCount);
    }

    public final IntegerProperty customSecAccCountProperty() {
        return this.customSecAccCount;
    }

    public final int getCustomSecAccCount() {
        return this.customSecAccCountProperty().get();
    }

    public final void setCustomSecAccCount(int customSecAccCount) {
        this.customSecAccCountProperty().set(customSecAccCount);
    }

    public final StringProperty accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final String getAccFilterStg() {
        return (String)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(String accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    protected Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        return this.accMng.getAccountMap();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public boolean isSelected() {
        return this.selectedProperty().get();
    }

    public void setSelected(boolean selected) {
        this.selectedProperty().set(selected);
    }

    public BooleanProperty repoProperty() {
        return this.repo;
    }

    public boolean isRepo() {
        return this.repoProperty().get();
    }

    public void setRepo(boolean repo) {
        this.repoProperty().set(repo);
    }

    public final BooleanProperty singleProperty() {
        return this.single;
    }

    public final boolean isSingle() {
        return this.singleProperty().get();
    }

    public final void setSingle(boolean single) {
        this.singleProperty().set(single);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public final StringProperty searchSecProperty() {
        return this.searchSec;
    }

    public final String getSearchSec() {
        return (String)this.searchSecProperty().get();
    }

    public final void setSearchSec(String searchSec) {
        this.searchSecProperty().set((Object)searchSec);
    }

    public final IntegerProperty numProperty() {
        return this.num;
    }

    public final int getNum() {
        return this.numProperty().get();
    }

    public final void setNum(int num) {
        this.numProperty().set(num);
    }

    public final DoubleProperty capitalProperty() {
        return this.capital;
    }

    public final double getCapital() {
        return this.capitalProperty().get();
    }

    public final void setCapital(double capital) {
        this.capitalProperty().set(capital);
    }

    public final DoubleProperty floatPlProperty() {
        return this.floatPl;
    }

    public final double getFloatPl() {
        return this.floatPlProperty().get();
    }

    public final void setFloatPL(double floatPl) {
        this.floatPlProperty().set(floatPl);
    }

    public final DoubleProperty realPlProperty() {
        return this.realPl;
    }

    public final double getRealPl() {
        return this.realPlProperty().get();
    }

    public final void setRealPl(double realPl) {
        this.realPlProperty().set(realPl);
    }

    public final DoubleProperty totalPlProperty() {
        return this.totalPl;
    }

    public final double getTotalPl() {
        return this.totalPlProperty().get();
    }

    public final void setTotalPl(double totalPl) {
        this.totalPlProperty().set(totalPl);
    }

    public final DoubleProperty buyCostAmtProperty() {
        return this.buyCostAmt;
    }

    public final double getBuyCostAmt() {
        return this.buyCostAmtProperty().get();
    }

    public final void setBuyCostAmt(double buyCostAmt) {
        this.buyCostAmtProperty().set(buyCostAmt);
    }

    public PositionModel<?> getPosModel() {
        if (this.hkwolun) {
            return this.hkPosModel;
        }
        return this.posModel;
    }

    public boolean isHkwolun() {
        return this.hkwolun;
    }

    public void setHkwolun(boolean hkwolun) {
        this.hkwolun = hkwolun;
    }

    public double getAvailable(CcsAccountDistribution item) {
        double hkAvailble = item.getAcc().getHkAvailable();
        double availble = item.getAcc().getAvailable();
        return this.isHkwolun() ? hkAvailble : availble;
    }

    public boolean isHk() {
        return this.hk;
    }

    public void setHk(boolean hk) {
        this.hk = hk;
    }

    public MxTreeList<CcsAccountDistribution> getAccMxList() {
        return this.accMxList;
    }

    public Map<String, MxTreeList<CcsAccountDistribution>> getMapSecDisMxList() {
        return this.mapSecDisMxList;
    }

    protected class CanSellComparator
    implements Comparator<TreeItem<CcsAccountDistribution>> {
        protected CanSellComparator() {
        }

        @Override
        public int compare(TreeItem<CcsAccountDistribution> o1, TreeItem<CcsAccountDistribution> o2) {
            if (((CcsAccountDistribution)o1.getValue()).getCanSell() == ((CcsAccountDistribution)o2.getValue()).getCanSell()) {
                return 0;
            }
            return ((CcsAccountDistribution)o1.getValue()).getCanSell() > ((CcsAccountDistribution)o2.getValue()).getCanSell() ? 1 : -1;
        }
    }
}

